local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local thisObj, thisLevel, sonActor, elevatorRef
local bDescending = false
local boolGodOfPeacePlayed = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 400 <= cineNum and cineNum < 430 and not boolGodOfPeacePlayed then
    BuildGodOfPeaceSequence()
  end
end
function ElevatorDescending()
  bDescending = true
end
function BuildGodOfPeaceSequence()
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "GOD OF PEACE: Son Actor")
  seq:WaitForFunctionTrue(function()
    return bDescending
  end)
  seq:WaitForActorInZone(sonActor, "BtrZone_GodOfPeace_00")
  seq:Do(function()
    game.Audio.PlayBanter("030_GodOfPeace_00", GOP01)
  end)
  seq:WaitForActorInZone(sonActor, "BtrZone_GodOfPeace_01")
  seq:Do(function()
    GameObjects.RunToPOI_GOP.LuaObjectScript.Interrupt()
    GameObjects.RunToPOI_GOP.LuaObjectScript.Disable()
  end)
  seq:ActorSync(sonActor, {
    Branch = "BRA_GodOfPeace_Mural1Enter",
    ReferenceJoint = "GodOfPeace_SynchJoint"
  })
  seq:WaitForActorPuppeteerComplete(sonActor)
  seq:Do(function()
    boolGodOfPeacePlayed = true
  end)
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.boolGodOfPeacePlayed = boolGodOfPeacePlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolGodOfPeacePlayed = savedInfo.boolGodOfPeacePlayed
end
function GOP01()
  timers.StartLevelTimer(0.5, function()
    game.Audio.PlayBanter("030_GodOfPeace_01", GOP02)
  end)
end
function GOP02()
  timers.StartLevelTimer(3, function()
    game.Audio.PlayBanter("030_GodOfPeace_02", GOP03)
  end)
end
function GOP03()
  timers.StartLevelTimer(3, function()
    game.Audio.PlayBanter("030_GodOfPeace_03")
  end)
end
