local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local player, son, UH_chain, UH_crank
local bDownstairsComplete = false
local bCrystalLit = false
local bTempleHidden = false
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.Statue_2:Hide()
  ShowInterior()
end
function FirstCheckPoint()
  game.World.StoreCheckpoint()
end
function OnStart(level)
  ShowInterior()
end
function OnSaveCheckpoint(level)
  return {bCrystalLit = bCrystalLit}
end
function OnRestoreCheckpoint(level, savedInfo)
  bCrystalLit = savedInfo.bCrystalLit
end
function HideInterior()
  bTempleHidden = true
  game.EvaluateLoadZones()
end
function ShowInterior()
  bTempleHidden = false
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_TempleInterior()
  if bTempleHidden then
    return "TempleInteriorHidden"
  else
    return "TempleInteriorVisible"
  end
end
function EnterHall()
  uiCalls.UI_Event_DiscoverLocation("TheHallofTyr")
end
function SwitchTrollCollision()
  GameObjects.Statue_1:Hide()
  GameObjects.Statue_2:Show()
end
function DropChandelier()
  GameObjects.chandelier.LuaObjectScript.Break()
end
function WarpBehind()
  local OneMeterBehindKratos = player.WorldPosition - player:GetWorldForward()
  son:Warp(OneMeterBehindKratos, player:GetWorldForward())
end
function CrystalLit()
  if not bCrystalLit then
    GameObjects.chandelier.LuaObjectScript.InnerLit()
    bCrystalLit = true
  end
end
local SNDDoorRight, SNDDoorLeft
function SoundInit()
  SNDDoorRight = GameObjects.SNDDoorRightGrp.SoundEmitters[1]
  SNDDoorLeft = GameObjects.SNDDoorLeftGrp.SoundEmitters[1]
end
function PlaySoundDoors()
  LD.PlaySound(SNDDoorRight, "SND_BRK_Ship_Puzzle_Wall_Break_Cal700")
  LD.PlaySound(SNDDoorLeft, "SND_BRK_Ship_Puzzle_Wall_Break_Cal700")
end
function TapestriesMusic()
  game.Audio.StartMusic("SND_MX_CAL_temple_flip_room_intro")
end
