local LD = require("design.LevelDesignLibrary")
local thisObj, postFirstChainPlayed, firstChainPlayed
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.postFirstChainPlayed = postFirstChainPlayed
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    postFirstChainPlayed = savedInfo.postFirstChainPlayed
    banterPlayed = savedInfo.banterPlayed
  end
end
function DeathTrapsBanterA()
  game.Audio.PlayBanter("110_DeathTrapsA")
end
function DeathTrapsBanterB()
  game.Audio.PlayBanter("110_DeathTrapsB")
end
function BrokenBoat_CrystalLit_Banter()
  if not banterPlayed.BrokenBoat_CrystalLit then
    game.Audio.PlayBanterNonCritical("080_BrokenBoat_CrystalLit")
    banterPlayed.BrokenBoat_CrystalLit = true
  end
end
function BrokenBoat_MuralAligned_Banter()
  if not banterPlayed.BrokenBoat_MuralAligned then
    game.Audio.PlayBanterNonCritical("080_BrokenBoat_MuralAligned")
    banterPlayed.BrokenBoat_MuralAligned = true
  end
end
