local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
LD = require("design.LevelDesignLibrary")
local thisLevel, player, son
local bInnerLit = false
local rotationMonitorCW, rotationMonitorCCW, flipper
local bFinished = false
local numberOfSpins = 0
function OnScriptLoaded(level, obj)
  SoundInit()
  flipper = obj:FindSingleGOByName("FlipperModule")
  flipper.LuaObjectScript.RegisterOnRotateCallback(CalculateRotation)
end
function OnFirstStart()
  GameObjects.runes_whole:Hide()
  GameObjects.alfheimLight:Hide()
end
function OnStart()
  if not bFinished then
    CalculateRotation(flipper.LuaObjectScript.GetCurrentState())
  end
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {bInnerLit = bInnerLit, bFinished = bFinished}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bInnerLit = savedInfo.bInnerLit
  bFinished = savedInfo.bFinished
end
function SpinChandelier()
  numberOfSpins = numberOfSpins + 1
  PlaySoundChandelierSpin()
end
function Break()
  GameObjects.chandelier_breakAnim:PlayAnimToEnd()
  GameObjects.crystalChainAnim:PlayAnimToEnd()
  GameObjects.ChandelierLightCrystal1.LuaObjectScript.Enable()
  PlaySoundDropImpact()
end
function CalculateRotation(state)
  timers.StartLevelTimer(2, function()
    if state == 3 and bInnerLit and not bFinished then
      SpinFloor()
    end
  end)
end
function SpinFloor()
  bFinished = true
  PlaySoundFloorRotate()
  PlaySoundDropDoors()
  GameObjects.Cal700_Banter.LuaObjectScript.BrokenBoat_MuralAligned_Banter()
  GameObjects.runes_partial:Hide()
  GameObjects.runes_whole:Show()
  GameObjects.dropDoors:PlayAnimToEnd(0.05)
  GameObjects.outerRuneRing:PlayAnimToFrame(180, 0.25)
  GameObjects.runeObjects:PlayAnimToFrame(180, 0.25)
end
function InnerLit()
  if not bInnerLit then
    GameObjects.alfheimLight:Show()
    bInnerLit = true
    CalculateRotation(flipper.LuaObjectScript.GetCurrentState())
    PlaySoundRuneRevealed()
    GameObjects.Cal700_Banter.LuaObjectScript.BrokenBoat_CrystalLit_Banter()
  end
end
local SNDChandelier, SNDFloor, SNDLatch, SNDEndTrack
function SoundInit()
  SNDChandelier = GameObjects.chandelier_breakAnim:FindSingleSoundEmitterByName("SNDChandelier")
  SNDFloor = GameObjects.outerRuneRing.SoundEmitters[1]
  SNDLatch = GameObjects.SNDLatchGrp.SoundEmitters[1]
  SNDEndTrack = GameObjects.SNDEndTrackGrp.SoundEmitters[1]
end
function PlaySoundChandelierSpin()
  LD.PlaySound(SNDChandelier, "SND_MECH_Ship_Puzzle_Hit_Rotate")
end
function PlaySoundChandelierDown()
  LD.PlaySound(SNDChandelier, "SND_MECH_Ship_Puzzle_Track_Move_Down_LP")
end
function PlaySoundFloorRotate()
  LD.PlayLoopingSoundToAnimFrame(SNDFloor, GameObjects.outerRuneRing, "SND_MECH_Ship_Puzzle_Floor_Rotate_LP", 0, 180)
  LD.PlaySoundOnFrame(SNDFloor, GameObjects.outerRuneRing, "SND_MECH_Ship_Puzzle_Floor_Rotate_Solved", 179, "forward")
end
function PlaySoundRuneRevealed()
  LD.PlaySound(SNDFloor, "SND_MECH_Ship_Puzzle_Floor_Illuminates")
end
function PlaySoundLatch()
  LD.PlaySound(SNDLatch, "SND_MECH_Ship_Puzzle_Ship_Release_Latch_Break")
end
function PlaySoundDropImpact()
  LD.PlaySound(SNDEndTrack, "SND_MECH_Ship_Puzzle_Ship_Release_Impact")
end
function PlaySoundDropDoors()
  local leftDoorEmitter = GameObjects.SNDDoorLeftGrp.SoundEmitters[1]
  local rightDoorEmitter = GameObjects.SNDDoorRightGrp.SoundEmitters[1]
  LD.PlaySound(leftDoorEmitter, "SND_MECH_Ship_Puzzle_Track_Move_Down_LP")
  LD.PlaySound(rightDoorEmitter, "SND_MECH_Ship_Puzzle_Track_Move_Down_LP")
  LD.PlayLoopingSoundToAnimFrame(leftDoorEmitter, GameObjects.dropDoors, "SND_MECH_Ship_Puzzle_Track_Move_Down_LP", 1, 15)
  LD.PlayLoopingSoundToAnimFrame(rightDoorEmitter, GameObjects.dropDoors, "SND_MECH_Ship_Puzzle_Track_Move_Down_LP", 1, 15)
  LD.PlaySoundOnFrame(leftDoorEmitter, GameObjects.dropDoors, "SND_MECH_Ship_Puzzle_Ship_Release_Latch_Break", 15, "forward")
  LD.PlaySoundOnFrame(rightDoorEmitter, GameObjects.dropDoors, "SND_MECH_Ship_Puzzle_Ship_Release_Latch_Break", 15, "forward")
end
