local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
thisObj = nil
thisLevel = nil
local player
son = nil
local roomL2_fire, encounter3_hallway, Jotun_Reinforcements, encounter1, encounter3, encounter4, doorControlWad
local bChainsPulled = false
local bEncounter3Started = false
local bEncounter3Complete = false
local bEncounter4Started = false
local bEncounter4Complete = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Area_2_Fight_2()
  Area_2_Fight_3()
  Area_1_Fight_2()
end
function OnStart(level, obj)
  player = game.Player:FindPlayer()
  if encounter3:WasRunning() then
    encounter3:Start()
  elseif encounter4:WasRunning() then
    encounter4:Start()
  end
end
function OnUpdate(level, obj)
  if player:IsPlayingMove("MOV_CSRageGrabJotunnEnter") then
    encounter3:StartWave(4)
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save(),
    bEncounter3Complete = bEncounter3Complete,
    bEncounter3Started = bEncounter3Started,
    bEncounter4Complete = bEncounter4Complete,
    bEncounter4Started = bEncounter4Started,
    bChainsPulled = bChainsPulled
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bEncounter3Complete = savedInfo.bEncounter3Complete
  bEncounter3Started = savedInfo.bEncounter3Started
  bEncounter4Complete = savedInfo.bEncounter4Complete
  bEncounter4Started = savedInfo.bEncounter4Started
  bChainsPulled = savedInfo.bChainsPulled
  checkpoint.Restore(savedInfo.levelstate)
end
function StartEncounter3()
  bChainsPulled = true
  if not bEncounter3Complete then
    SpawnEncounter3Enemies()
  end
end
function SpawnEncounter3Enemies()
  encounter3:Start()
end
function Encounter3Complete()
  bEncounter3Complete = true
  GameObjects.EntZn_LW_Encounter_H_Start:ShowEntityVolume()
  game.Compass.SetDesignerForcedHide(false)
  game.FindLevel("Cal740_LeftWing"):CallScript("LW_Door_down")
  doorControlWad = game.FindLevel("Cal740_LeftWing")
  if doorControlWad then
    doorControlWad:CallScript("LW_Encounter3Done")
  end
  timers.StartLevelTimer(2, Checkpoint3)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ogre_Charger")
end
function StartEncounter4()
  if bChainsPulled and not bEncounter4Started and not bEncounter4Complete then
    bEncounter4Started = true
    encounter4:Start()
    doorControlWad = game.FindLevel("Cal740_LeftWing")
    if doorControlWad then
      doorControlWad:CallScript("LW_Encounter4Started")
    end
  end
end
function Encounter4Complete()
  bEncounter4Complete = true
  doorControlWad = game.FindLevel("Cal740_LeftWing")
  if doorControlWad then
    doorControlWad:CallScript("LW_Encounter4Done")
  end
  timers.StartLevelTimer(2, Checkpoint4)
  local cal720 = game.FindLevel("Cal720_LowerCenterRoom")
  local cal720_Banter = cal720:GetGameObject("Cal720_Banter"):CallScript("PostChainBreakBanter")
  DownstairsBookmark()
end
function Checkpoint3()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.LW_CheckpointOverride_3.Child
  })
end
function Checkpoint4()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.LW_CheckpointOverride_4.Child
  })
end
function Area_2_Fight_2()
  encounter3 = EC.NewEncounter(thisLevel, "TempleFlip, Left Wing, Third Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "LW_LshZn_Cal740"
  })
  encounter3:AddWave({
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "LW_A2_O_Loc_01*",
      useSpawnLocatorsOnly = true,
      markerID = "SpawnedFromRift_LW_A2_PocketRiftSpawn_1",
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = {1, 2}
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "LW_A2_O_Loc_06",
      useSpawnLocatorsOnly = true,
      markerID = "SpawnedFromRift_LW_A2_PocketRiftSpawn_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "LW_A2_O_Loc_05",
      useSpawnLocatorsOnly = true,
      markerID = "SpawnedFromRift_LW_A2_PocketRiftSpawn_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.5
    },
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "LW_A2_E_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13.2
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "LW_A2_E_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 22.1
    }
  })
  encounter3:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "LW_A2_E_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15.2
    },
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "LW_A2_E_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 22.1
    }
  })
  encounter3:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Jotunn_C_SFG",
      spawnLocators = "LW_A2_E_Loc_1",
      markerID = "Jotunn",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  encounter3:AddWave({
    powerLevel = 3,
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "LW_A2_E_Loc",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 0.51
    },
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "LW_A2_O_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = 1.2
    }
  })
  encounter3:OnEnemyDeath(function()
    encounter3:StartWave(2)
    encounter3:StartWave(3)
  end, {count = 4})
  encounter3:OnStart(function()
    StartAmuletObjective()
    GameObjects.LW_A2_PocketRiftSpawn_1.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A2_PocketRiftSpawn_2.LuaObjectScript.StartCombatState()
    end, 2.5)
    Checkpoint3()
  end)
  encounter3:OnEnemySpawn(function()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A2_PocketRiftSpawn_1.LuaObjectScript.SpawningDone()
    end, 6)
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A2_PocketRiftSpawn_2.LuaObjectScript.SpawningDone()
    end, 6.2)
  end, {count = 4})
  encounter3:OnEnemySpawn(function()
    GameObjects.LW_A2_PocketRiftSpawn_1.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {
    markerID = "SpawnedFromRift_LW_A2_PocketRiftSpawn_1"
  })
  encounter3:OnEnemySpawn(function()
    GameObjects.LW_A2_PocketRiftSpawn_2.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {
    markerID = "SpawnedFromRift_LW_A2_PocketRiftSpawn_2"
  })
  encounter3:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  encounter3:OnComplete(Encounter3Complete)
end
function Area_2_Fight_3()
  encounter3_hallway = EC.NewEncounter(thisLevel, "TempleFlip, Left Wing, Third Encounter Hallway", {
    CheckpointOnComplete = false,
    LeashZone = "LW_LshZn_Cal740"
  })
  encounter3_hallway:AddWave({
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "LW_A1_H_Loc_1*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  GameObjects.EntZn_LW_Encounter_H_Start:HideEntityVolume()
  encounter3_hallway:SetStartZone(GameObjects.EntZn_LW_Encounter_H_Start)
  encounter3_hallway:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_3.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end)
  encounter3_hallway:OnStart(function()
    GameObjects.LW_A1_PocketRiftSpawn_3.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A1_PocketRiftSpawn_3.LuaObjectScript.SpawningDone()
    end, 5.5)
  end)
end
function Area_1_Fight_2()
  encounter4 = EC.NewEncounter(thisLevel, "TempleFlip, Left Wing, Encounter 2 ", {
    CheckpointOnComplete = false,
    LeashZone = "LW_LshZn_Cal740"
  })
  encounter4:AddWave({
    timeBeforeNextWave = 8,
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "LW_A1_O_Loc_01",
      useSpawnLocatorsOnly = true,
      markerID = "SpawnedFromRift_LW_A1_PocketRiftSpawn_1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "LW_A1_H_Loc_1",
      useSpawnLocatorsOnly = true,
      markerID = "SpawnedFromRift_LW_A1_PocketRiftSpawn_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.1
    }
  })
  encounter4:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "LW_A1_O_Loc_02",
      useSpawnLocatorsOnly = true,
      markerID = "SpawnedFromRift_LW_A1_PocketRiftSpawn_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.1
    }
  })
  encounter4:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_1.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A1_PocketRiftSpawn_1.LuaObjectScript.SpawningDone()
    end, 5)
  end, {count = 1, wave = 1})
  encounter4:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_3.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A1_PocketRiftSpawn_3.LuaObjectScript.SpawningDone()
    end, 5.2)
  end, {count = 2, wave = 1})
  encounter4:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_2.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A1_PocketRiftSpawn_2.LuaObjectScript.SpawningDone()
    end, 5.5)
  end, {count = 3, wave = 1})
  encounter4:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_2.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.LW_A1_PocketRiftSpawn_2.LuaObjectScript.SpawningDone()
    end, 5)
  end, {count = 1, wave = 2})
  encounter4:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_1.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {
    markerID = "SpawnedFromRift_LW_A1_PocketRiftSpawn_1"
  })
  encounter4:OnEnemySpawn(function()
    GameObjects.LW_A1_PocketRiftSpawn_2.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {
    markerID = "SpawnedFromRift_LW_A1_PocketRiftSpawn_2"
  })
  encounter4:OnComplete(Encounter4Complete)
end
function DownstairsBookmark()
  if LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled") and LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled") then
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "31_TempleFlip_040_DownStairsComplete"]
    tableEntry.OverrideObject = GameObjects.LW_CheckpointOverride_4.Child
    game.World.StoreCheckpointAndBookmark(tableEntry)
  else
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.LW_CheckpointOverride_4.Child
    })
  end
end
function StartAmuletObjective()
  if LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled") then
    LD.CompleteQuest("Quest_Caldera_Objective710")
    game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x", true)
  end
end
