local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
thisObj = nil
thisLevel = nil
local player
son = nil
local encounter3, encounter3_hallway, encounter4, doorControlWad
local bChainsPulled = false
local bEncounter3Complete = false
local bEncounter3Started = false
local bEncounter4Complete = false
local bEncounter4Started = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  Area_1_Fight_2()
  Area_2_Fight_2()
  Area_1_Fight_1()
end
function OnStart(level, obj)
  if encounter3:WasRunning() then
    encounter3:Start()
  elseif encounter4:WasRunning() then
    encounter4:Start()
  elseif encounter3_hallway:WasRunning() then
    encounter3_hallway:Start()
  end
  GameObjects.EntZn_RW_Encounter_H_Start:HideEntityVolume()
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save(),
    bEncounter3Complete = bEncounter3Complete,
    bEncounter3Started = bEncounter3Started,
    bEncounter4Complete = bEncounter4Complete,
    bEncounter4Started = bEncounter4Started,
    bChainsPulled = bChainsPulled
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bEncounter3Complete = savedInfo.bEncounter3Complete
  bEncounter3Started = savedInfo.bEncounter3Started
  bEncounter4Complete = savedInfo.bEncounter4Complete
  bEncounter4Started = savedInfo.bEncounter4Started
  bChainsPulled = savedInfo.bChainsPulled
  checkpoint.Restore(savedInfo.levelstate)
end
function StartEncounter3()
  bChainsPulled = true
  if not bEncounter3Complete then
    SpawnEncounter3Enemies()
  end
end
function SpawnEncounter3Enemies()
  encounter3:Start()
end
function Encounter3Complete()
  bEncounter3Complete = true
  doorControlWad = game.FindLevel("Cal750_RightWing")
  if doorControlWad then
    doorControlWad:CallScript("RW_Encounter3Done")
  end
  timers.StartLevelTimer(2, Checkpoint3)
end
function StartEncounter4()
  if bChainsPulled and not bEncounter4Started and not bEncounter4Complete then
    timers.StartLevelTimer(1, function()
      encounter4:Start()
    end)
    bEncounter4Started = true
    doorControlWad = game.FindLevel("Cal750_RightWing")
    if doorControlWad then
      doorControlWad:CallScript("RW_Encounter4Started")
    end
  end
end
function Encounter4Complete()
  bEncounter4Complete = true
  doorControlWad = game.FindLevel("Cal750_RightWing")
  if doorControlWad then
    doorControlWad:CallScript("RW_Encounter4Done")
    doorControlWad:CallScript("RW_Submerge_turretA")
  end
  timers.StartLevelTimer(2, Checkpoint4)
  local cal720 = game.FindLevel("Cal720_LowerCenterRoom")
  local cal720_Banter = cal720:GetGameObject("Cal720_Banter"):CallScript("PostChainBreakBanter")
  DownstairsBookmark()
end
function Checkpoint3()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.RW_CheckpointOverride_3.Child
  })
end
function Checkpoint4()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.RW_CheckpointOverride_4.Child
  })
end
function Area_1_Fight_1()
  encounter3_hallway = EC.NewEncounter(thisLevel, "TempleFlip, Right Wing Hallway Encounter ", {
    CheckpointOnComplete = false,
    AutoResetOnReload = true,
    LeashZone = "RW_LshZn_Cal750"
  })
  encounter3_hallway:AddWave({
    timeBeforeNextWave = 2,
    {
      spawners = "Fanatic_AT_SFG",
      spawnLocators = "RW_A2_H_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.3
    },
    {
      spawners = "SH_Helwalker_B_SFG",
      spawnLocators = "RW_A2_H_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.9
    },
    {
      spawners = "SH_Helwalker_B_SFG",
      spawnLocators = "RW_A2_H_Loc_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.6
    },
    {
      spawners = "Fanatic_AT_SFG",
      spawnLocators = "RW_A2_H_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.5
    }
  })
  encounter3_hallway:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Helwalker_SS",
      spawnLocators = "RW_A2_H_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 2.3,
      powerLevel = 4
    }
  })
  encounter3_hallway:SetStartZone(GameObjects.EntZn_RW_Encounter_H_Start)
  encounter3_hallway:OnEnemySpawn(function(enemy)
    GameObjects.RW_A1_PocketRiftSpawn_03.LuaObjectScript.StartCombatState()
    timers.StartLevelTimer(5, function()
      GameObjects.RW_A1_PocketRiftSpawn_03.LuaObjectScript.SpawningDone()
    end)
  end, {wave = 2})
end
function Area_2_Fight_2()
  encounter3 = EC.NewEncounter(thisLevel, "TempleFlip, Right Wing, Two Travelers Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "RW_LshZn_Cal750"
  })
  encounter3:AddWave({
    {
      spawners = "Traveler_B_SFG",
      spawnLocators = "RW__A2_Loc_6",
      useSpawnLocatorsOnly = true,
      markerID = "TB",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = 4
    },
    {
      spawners = "Traveler_S_SFG",
      spawnLocators = "RW__A2_Loc_7",
      useSpawnLocatorsOnly = true,
      markerID = "TS",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.2,
      powerLevel = 5
    }
  })
  encounter3:OnStart(StartAmuletObjective)
  encounter3:OnStart(Checkpoint3)
  encounter3:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  encounter3:OnStart(function()
    timers.StartLevelTimer(0.25, function()
      GameObjects.RW_A2_PocketRiftSpawn_01.LuaObjectScript.StartCombatState()
    end)
    timers.StartLevelTimer(0.8, function()
      GameObjects.RW_A2_PocketRiftSpawn_02.LuaObjectScript.StartCombatState()
    end)
  end)
  encounter3:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(5, function()
      GameObjects.RW_A2_PocketRiftSpawn_01.LuaObjectScript.SpawningDone()
    end)
  end, {markerID = "TS"})
  encounter3:OnEnemySpawn(function(enemy)
    timers.StartLevelTimer(5, function()
      GameObjects.RW_A2_PocketRiftSpawn_02.LuaObjectScript.SpawningDone()
    end)
  end, {markerID = "TB"})
  encounter3:OnComplete(function()
    game.Compass.SetDesignerForcedHide(false)
    Encounter3Complete()
  end)
  encounter3:OnComplete(function()
    GameObjects.EntZn_RW_Encounter_H_Start:ShowEntityVolume()
    encounter3_hallway:Start()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Traveler")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Traveler_Champion")
    game.FindLevel("Cal750_RightWing"):CallScript("RW2_Door_down")
  end, 1)
end
function Area_1_Fight_2()
  encounter4 = EC.NewEncounter(thisLevel, "TempleFlip, Right Wing, --- Encounter", {
    CheckpointOnComplete = false,
    AutoResetOnReload = true,
    LeashZone = "RW_LshZn_Cal750"
  })
  encounter4:AddWave({
    requiredWaveCompletion = 50,
    {
      spawners = "Helwalker_SFG",
      spawnLocators = "RW__A1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 0.5
    },
    {
      spawners = "Helwalker_SFG",
      spawnLocators = "RW__A1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 2
    }
  })
  encounter4:AddWave({
    {
      spawners = "SH_Helwalker_SFG",
      spawnLocators = "RW__A1_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "SH_Helwalker_SFG",
      spawnLocators = "RW__A1_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.2
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "RW__A1_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.62,
      spawnCooldown = 5
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "RW__A1_Loc_",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2.2,
      spawnCooldown = 5
    },
    {
      spawners = "Fanatic_B_SFG",
      spawnLocators = "RW__A1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5.2,
      spawnCooldown = 5
    }
  })
  encounter4:AddWave({
    {
      spawners = "Brawler_N_SFG",
      spawnLocators = "RW__A1_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.7
    },
    {
      spawners = "Brawler_5_SFG",
      spawnLocators = "RW__A1_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  encounter4:OnStart(function()
  end)
  encounter4:OnComplete(function()
    Encounter4Complete()
    doorControlWad:CallScript("RW1_Door_up")
  end)
  encounter4:OnEnemySpawn(function()
    GameObjects.RW_A1_PocketRiftSpawn_01.LuaObjectScript.StartCombatState()
    GameObjects.RW_A1_PocketRiftSpawn_02.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.RW_A1_PocketRiftSpawn_01.LuaObjectScript.SpawningDone()
      GameObjects.RW_A1_PocketRiftSpawn_02.LuaObjectScript.SpawningDone()
    end, 6)
  end, {count = 1, wave = 3})
end
function DownstairsBookmark()
  if LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled") and LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled") then
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "31_TempleFlip_040_DownStairsComplete"]
    tableEntry.OverrideObject = GameObjects.RW_CheckpointOverride_4.Child
    game.World.StoreCheckpointAndBookmark(tableEntry)
  else
    game.World.StoreCheckpoint({
      OverrideObject = GameObjects.RW_CheckpointOverride_4.Child
    })
  end
end
function StartAmuletObjective()
  if LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled") then
    LD.CompleteQuest("Quest_Caldera_Objective710")
    game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x", true)
  end
end
