local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisLevel
local bLeftChainPullTrapsStarted = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart()
  if LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled") then
    OpenAllTraps()
    timers.StartLevelTimer(1, RestartAllTraps)
  end
  timers.StartLevelTimer(1, PlayObstructedTrapSound)
end
function SpinTrap1()
  GameObjects.ObserveSaw.LuaObjectScript.Disable()
  GameObjects.drainSawBladeTrap1.LuaObjectScript.StartRotator()
  PlayObstructedTrapSound()
end
function StopTrap1()
  GameObjects.drainSawBladeTrap1.LuaObjectScript.StopRotator_KeepSpinning()
end
function SpinTrap2()
  GameObjects.drainSawBladeTrap2.LuaObjectScript.StartRotator()
  GameObjects.drainSawBladeTrap3.LuaObjectScript.StartRotator()
end
function StopTrap2()
  GameObjects.drainSawBladeTrap2.LuaObjectScript.StopRotator()
  GameObjects.drainSawBladeTrap3.LuaObjectScript.StopRotator()
end
function OpenAllTraps()
  local traps = thisLevel:FindGameObjects("*SawBladeTrap_Rotating*")
  for _, trap in ipairs(traps) do
    trap.LuaObjectScript.GoToSafeState()
  end
  GameObjects.drainSawBladeTrap1.LuaObjectScript.GoToSafeState(180)
  GameObjects.drainSawBladeTrap2.LuaObjectScript.GoToSafeState(180)
  GameObjects.drainSawBladeTrap3.LuaObjectScript.GoToSafeState(270)
  GameObjects.drainSawBladeTrap4.LuaObjectScript.GoToSafeState(90)
  StopObstructedTrapSound()
end
function RestartAllTraps()
  local traps = thisLevel:FindGameObjects("SawBladeTrap_Rotating*")
  for _, trap in ipairs(traps) do
    trap.LuaObjectScript.StartRotator()
  end
  if not bLeftChainPullTrapsStarted then
    bLeftChainPullTrapsStarted = true
    GameObjects.drainSawBladeTrap1:FindSingleGOByName("drain").LuaObjectScript.SetActive(true)
    GameObjects.drainSawBladeTrap2:FindSingleGOByName("drain").LuaObjectScript.SetActive(true)
  end
  GameObjects.drainSawBladeTrap3:FindSingleGOByName("drain").LuaObjectScript.SetActive(false)
  GameObjects.drainSawBladeTrap4:FindSingleGOByName("drain").LuaObjectScript.SetActive(false)
  GameObjects.drainSawBladeTrap3:Hide()
  GameObjects.drainSawBladeTrap4:Hide()
  PlayObstructedTrapSound()
end
function OnSaveCheckpoint(level, obj)
  return {bLeftChainPullTrapsStarted = bLeftChainPullTrapsStarted}
end
function OnRestoreCheckpoint(level, obj, p)
  bLeftChainPullTrapsStarted = p.bLeftChainPullTrapsStarted
end
local obstructedTrapEmitters = {}
local soundEvents = {
  SNDBlades = "SND_TRAP_Saw_Blades_Inside_Cal720_LP"
}
function OverrideTrapSounds(emitters)
  obstructedTrapEmitters = emitters
  local traps = thisLevel:FindGameObjects("*SawBladeTrap*")
  for _, trap in ipairs(traps) do
    trap.LuaObjectScript.SoundSetup(soundEvents)
  end
end
function PlayObstructedTrapSound()
  for i = 1, #obstructedTrapEmitters do
    LD.PlayRestartableSoundLoop(obstructedTrapEmitters[i], "SND_TRAP_Saw_Blades_Outside_Cal720_LP")
  end
end
function StopObstructedTrapSound()
  for i = 1, #obstructedTrapEmitters do
    LD.StopRestartableSoundLoop(obstructedTrapEmitters[i], "SND_TRAP_Saw_Blades_Outside_Cal720_LP")
  end
end
