local LD = require("design.LevelDesignLibrary")
local thisObj, currentFrameAngVel, angularVelocity, lastFrameAngVel
function OnScriptLoaded(level, obj)
  thisObj = obj
  lastFrameAngVel = engine.Vector.New(0, 0, 0)
  currentFrameAngVel = lastFrameAngVel
end
function OnUpdate(level, obj)
  SoundDebugTable()
end
function GetFloorAngularVelocityRTPC()
  currentFrameAngVel = thisObj:GetWorldJointForward(thisObj:GetJointIndex("JOrotatingFloor"))
  angularVelocity = (lastFrameAngVel - currentFrameAngVel):Length() * 1000
  lastFrameAngVel = currentFrameAngVel
  return angularVelocity
end
function SoundDebugTable()
  local debugTable = {}
  debugTable.Title = "Rotating Floor Sound Info"
  debugTable.X = 5
  debugTable.Y = 25
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  table.insert(debugTable, {
    "angularVelocity: ",
    GetFloorAngularVelocityRTPC()
  })
  engine.DrawDebugTable(debugTable)
end
