local thisObj, side, runeInteract
function OnScriptLoaded(level, obj)
  thisObj = obj
  side = thisObj:FindLuaTableAttribute("Side")
  runeInteract = level:FindGameObject(thisObj:FindLuaTableAttribute("RuneInteract"))
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  if side == "Right" then
    thisObj:PlayAnimationToFrame(0, {
      Animation = "poiCalTempleFlip010Scene"
    })
  else
    thisObj:PlayAnimationToFrame(0, {
      Animation = "poiCalTempleFlip010Scene1"
    })
  end
end
function OnStart(level, obj)
  local runeInteractZone = runeInteract:FindSingleGOByName("pSonInteract").LuaObjectScript.GetInteractZone()
  runeInteractZone:SetInteractFrontAngle(120)
  runeInteractZone:SetHintAngle(120)
  runeInteractZone:SetXZRange(30)
  runeInteractZone:SetYRange(30)
  runeInteractZone:SetHintXZRange(40)
end
function TurnComplete()
  runeInteract.LuaObjectScript.Enable()
end
function ShowDebugTable()
  local debugTable = GetDebugTable()
  debugTable.X = 120
  debugTable.Y = 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  engine.DrawDebugTable(GetDebugTable())
end
function GetDebugTable()
  local debugTable = {}
  debugTable.Title = "Troll_" .. side .. " Info"
  table.insert(debugTable, {
    "Troll_" .. side .. "> animName: ",
    thisObj:GetAnimationName()
  })
  table.insert(debugTable, {
    "animPercent : ",
    tostring(thisObj.AnimPercent)
  })
  table.insert(debugTable, {
    "animFrame : ",
    tostring(thisObj.AnimFrame)
  })
  return debugTable
end
