local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local CSL = require("camera.shakelibrary")
local thisLevel, son, elevatorManager, elevatorSwitch, cal740, cal750
local bElevatorRevealed = false
local bSonHasSeenArmy = false
local bElevatorRevealedComplete = false
local isSonAvailabilitySet = false
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
  elevatorManager = GameObjects.BasicElevator_Manager
  elevatorSwitch = GameObjects.elevatorSwitch
end
function OnFirstStart(level)
  GameObjects.navObjects:Hide()
  GameObjects.navHelper:Hide()
  GameObjects.CAl720_DynamicNavMesh:Hide()
  GameObjects.LoadGauntletsLeft:HideEntityVolume()
  GameObjects.LoadGauntletsRight:HideEntityVolume()
end
function OnStart(level)
  cal740 = game.FindLevel("Cal740_LeftWing")
  cal750 = game.FindLevel("Cal750_RightWing")
  if elevatorManager.LuaObjectScript.IsEnabled() == false and not bElevatorRevealed then
    elevatorSwitch.LuaObjectScript.Disable()
  elseif bElevatorRevealed then
    elevatorSwitch.LuaObjectScript.Enable()
  end
  if bElevatorRevealed and not bElevatorRevealedComplete then
    GameObjects.switchAnim:PlayAnimationToEnd({Rate = 0.35})
    GameObjects.turnElevatorAnim:PlayAnimationToEnd({Rate = 0.35})
    GameObjects.switchAnim:OnAnimationDone(thisLevel, "ElevatorRevealComplete")
  end
  elevatorSwitch.LuaObjectScript.RemoveInteract(3)
  elevatorSwitch.LuaObjectScript.RemoveInteract(2)
  local interactZone = elevatorSwitch.LuaObjectScript.GetInteractZoneTable()
  interactZone[1]:SetInteractFrontAngleWeight(0.5)
  interactZone[1]:SetCameraFrontAngle(0, 60)
  interactZone[1]:SetCameraFrontAngleWeight(1)
  elevatorSwitch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_Elevator_TempleFlip")
  elevatorManager.LuaObjectScript.SetUseCollisionCheckForWarp(true)
  elevatorManager.LuaObjectScript.SetOverrideCA_Facing(true)
end
function OnWadLoaded(level, newLevel)
  if cal740 == nil and newLevel.Name == "WAD_Cal740_LeftWing" then
    cal740 = newLevel
  end
  if cal750 == nil and newLevel.Name == "WAD_Cal750_RightWing" then
    cal750 = newLevel
  end
end
function OnWadUnloaded(level, newLevel)
  if cal740 and newLevel.Name == "WAD_Cal740_LeftWing" then
    cal740 = nil
  end
  if cal750 and newLevel.Name == "WAD_Cal750_RightWing" then
    cal750 = nil
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    bElevatorRevealed = bElevatorRevealed,
    bSonHasSeenArmy = bSonHasSeenArmy,
    bElevatorRevealedComplete = bElevatorRevealedComplete
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  bElevatorRevealed = savedInfo.bElevatorRevealed
  bSonHasSeenArmy = savedInfo.bSonHasSeenArmy
  bElevatorRevealedComplete = savedInfo.bElevatorRevealedComplete
end
function MoveElevatorDown()
  GameObjects.LoadGauntletsLeft:HideEntityVolume()
  GameObjects.LoadGauntletsRight:HideEntityVolume()
  GameObjects.LoadGauntlets:ShowEntityVolume()
  local cal140 = game.FindLevel("Cal140_TempleExt")
  if cal140 then
    cal140:CallScript("DisableSpline1")
  end
  DisableElevatorCA()
end
function MovingUp()
  GameObjects.LoadGauntletsLeft:HideEntityVolume()
  GameObjects.LoadGauntletsRight:HideEntityVolume()
  GameObjects.LoadGauntlets:ShowEntityVolume()
  DisablePointAtArmyCA()
  GameObjects.RightWingDoor.LuaObjectScript.ForceDoorClose()
  GameObjects.LeftWingDoor.LuaObjectScript.ForceDoorClose()
  DisableElevatorCA()
  game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
  local cal750 = game.FindLevel("Cal750_RightWing")
  if cal750 then
    cal750:CallScript("DisableAllCA")
  end
  local cal740 = game.FindLevel("Cal740_LeftWing")
  if cal740 then
    cal740:CallScript("DisableAllCA")
  end
end
function AtTop()
  local cal140 = game.FindLevel("Cal140_TempleExt")
  if cal140 then
    cal140:CallScript("EnableSpline1")
  end
  EnableElevatorCA()
end
function AtBottom()
  if not bSonHasSeenArmy then
    elevatorManager.LuaObjectScript.DisableElevator()
    GameObjects.PointAtArmy.LuaObjectScript.Enable()
  end
  EnableElevatorCA()
end
function ApproachUpstairsBalcony()
  GameObjects.SonOnElevator.LuaObjectScript.Disable()
end
function LeaveUpstairsBalcony()
  if bElevatorRevealed then
    GameObjects.SonOnElevator.LuaObjectScript.Enable()
  end
end
function CheckpointLeft()
  game.World.StoreCheckpoint(GameObjects.CheckpointOverride_LeftWing)
end
function CheckpointRight()
  game.World.StoreCheckpoint(GameObjects.CheckpointOverride_RightWing)
end
function EnableElevator()
  elevatorManager.LuaObjectScript.EnableElevator()
  local switchInteractZones = elevatorSwitch.LuaObjectScript.GetInteractZoneTable()
  for i = 1, #switchInteractZones do
    switchInteractZones[i]:SetXZRange(0)
  end
  bElevatorRevealed = true
  GameObjects.Reaction_Threat_Low_Into_Alert_Idle.LuaObjectScript.Trigger()
  timers.StartLevelTimer(3, function()
    GameObjects.switchAnim:PlayAnimationToEnd({Rate = 0.35})
    GameObjects.turnElevatorAnim:PlayAnimationToEnd({Rate = 0.35})
    GameObjects.switchAnim:OnAnimationDone(thisLevel, "ElevatorRevealComplete")
  end)
end
function ElevatorRevealComplete()
  bElevatorRevealedComplete = true
  CSL.PlayShake("FFB_GENERIC_RUMBLE_MEDIUM", 0.1, 0, 1)
  GameObjects.tempHoleCollision:HideCollision()
  local switchInteractZones = elevatorSwitch.LuaObjectScript.GetInteractZoneTable()
  for i = 1, #switchInteractZones do
    switchInteractZones[i]:SetXZRange(2)
  end
  GameObjects.switchAnim:ClearAllAnimationCallbacks()
  GameObjects.SonOnElevator.LuaObjectScript.Enable()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "31_TempleFlip_030_UpstairsComplete"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function SonOnEnter_ElevatorCheck()
  if bSonHasSeenArmy and elevatorManager.LuaObjectScript.GetState() == "Bottom" then
    elevatorManager.LuaObjectScript.EnableElevator()
  end
end
function KratosOnEnter_ElevatorCheck()
  if bSonHasSeenArmy and elevatorManager.LuaObjectScript.GetState() == "Bottom" and not son:IsInsideEntityZone(GameObjects.Son_ElevatorCheck) then
    elevatorManager.LuaObjectScript.DisableElevator()
  end
end
function RightDoorOpen()
  local cal750 = game.FindLevel("Cal750_RightWing")
  cal750:CallScript("EnableCrawls")
  local cal740 = game.FindLevel("Cal740_LeftWing")
  cal740:CallScript("DisableAllCA")
  GameObjects.LeftWingDoor.LuaObjectScript.ForceDoorClose()
  GameObjects.LoadGauntletsLeft:HideEntityVolume()
  GameObjects.LoadGauntletsRight:ShowEntityVolume()
  GameObjects.LoadGauntlets:HideEntityVolume()
end
function LeftDoorOpen()
  GameObjects.RightWingDoor.LuaObjectScript.ForceDoorClose()
  local cal740 = game.FindLevel("Cal740_LeftWing")
  cal740:CallScript("EnableCrawls")
  local cal750 = game.FindLevel("Cal750_RightWing")
  cal750:CallScript("DisableAllCA")
  GameObjects.LoadGauntletsLeft:ShowEntityVolume()
  GameObjects.LoadGauntletsRight:HideEntityVolume()
  GameObjects.LoadGauntlets:HideEntityVolume()
end
function SonLookingAtArmy()
  bSonHasSeenArmy = true
  elevatorManager.LuaObjectScript.DisableElevator()
end
function EnableElevatorCA()
  if bElevatorRevealed then
    GameObjects.SonOnElevator.LuaObjectScript.Enable()
  end
end
function DisableElevatorCA()
  GameObjects.SonOnElevator.LuaObjectScript.Disable()
end
function DisablePointAtArmyCA()
  if not elevatorManager.LuaObjectScript.IsEnabled() then
    elevatorManager.LuaObjectScript.EnableElevator()
  end
  GameObjects.PointAtArmy.LuaObjectScript.Disable()
end
function HallLoadCheck()
  DisableTryptich()
  game.UI.LoadCheck("Cal750_RightWing", "Cal740_LeftWing")
end
function UpstairsLoadCheck()
  game.UI.LoadCheck("Cal700_TempleFlip", "Cal130_TempleInt")
end
function IsLeftChainNotPulled()
  return not LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
end
function IsRightChainNotPulled()
  return not LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
end
function StartOpeningRightDoor()
  GameObjects.RunRight.LuaObjectScript.Enable()
  GameObjects.PointAtArmy.LuaObjectScript.Disable()
  elevatorManager.LuaObjectScript.EnableElevator()
end
function StartOpeningLeftDoor()
  GameObjects.RunLeft.LuaObjectScript.Enable()
  GameObjects.PointAtArmy.LuaObjectScript.Disable()
  elevatorManager.LuaObjectScript.EnableElevator()
end
function DisableTryptich()
  GameObjects.TriptychBasic.LuaObjectScript.Abort()
end
function FinalSonCheck()
  local elevatorState = elevatorManager.LuaObjectScript.GetState()
  if elevatorState == "MovingDown" or elevatorState == "MovingUp" then
    return
  end
  local cal740 = game.FindLevel("Cal740_LeftWing")
  if cal740 ~= nil then
    cal740:CallScript("FinalCheck")
  end
  local cal750 = game.FindLevel("Cal750_RightWing")
  if cal750 ~= nil then
    cal750:CallScript("FinalCheck")
  end
end
function CloseDoors()
  GameObjects.RightWingDoor.LuaObjectScript.ForceDoorClose()
  GameObjects.LeftWingDoor.LuaObjectScript.ForceDoorClose()
end
