local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, postFirstChainPlayed, firstChainPlayed
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {banterPlayed = banterPlayed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo then
    banterPlayed = savedInfo.banterPlayed
  end
end
function TyrsArmy_Intro_Banter()
  if not banterPlayed.TyrsArmy_Intro then
    game.Audio.PlayBanter("105_TyrsArmy_Intro")
    banterPlayed.TyrsArmy_Intro = true
  end
end
function TyrsArmy_HeyLook_Banter()
  if not banterPlayed.TyrsArmy_HeyLook and not banterPlayed.TyrsArmy_Intro then
    timers.StartLevelTimer(3, function()
      game.Audio.PlayBanter("105_TyrsArmy_HeyLook")
    end)
    banterPlayed.TyrsArmy_HeyLook = true
  end
end
function TyrsArmy_Observe_Banter()
  if not banterPlayed.TyrsArmy_Observe then
    game.Audio.PlayBanter("105_TyrsArmy_Observe", TyrsArmyChains_Show)
    banterPlayed.TyrsArmy_Observe = true
  end
end
function TyrsArmyChains_Show()
  GameObjects.BtrLook_TyrsArmyChainsA:Show()
  GameObjects.BtrLook_TyrsArmyChainsB:Show()
  _G.DisablePointAtArmyCA()
end
function TyrsArmyChains_Hide()
  GameObjects.BtrLook_TyrsArmyChainsA:Hide()
  GameObjects.BtrLook_TyrsArmyChainsB:Hide()
end
function ChainBreakBanter(callbackFn)
  if not banterPlayed.FirstChain then
    game.Audio.PlayBanter("140_FirstChain", callbackFn)
    banterPlayed.FirstChain = true
  elseif not banterPlayed.SecondChain then
    game.Audio.PlayBanter("200_SecondChain", callbackFn)
    banterPlayed.SecondChain = true
  end
end
function ChainBreakBanterLeft()
  ChainBreakBanter(EnableRuneReadLeft)
end
function ChainBreakBanterRight()
  ChainBreakBanter(EnableRuneReadRight)
end
function EnableRuneReadLeft()
  local left = game.FindLevel("Cal740_LeftWing")
  local cal140 = game.FindLevel("Cal140_TempleExt")
  left:CallScript("EnableRoomAfterBanter")
  cal140:CallScript("EnableChainPullLeft")
end
function EnableRuneReadRight()
  local right = game.FindLevel("Cal750_RightWing")
  local cal140 = game.FindLevel("Cal140_TempleExt")
  right:CallScript("EnableRoomAfterBanter")
  cal140:CallScript("EnableChainPullRight")
end
function PostChainBreakBanter()
  if not LD.GetEntityVariable("CAL_TempleFlipped") then
    if not banterPlayed.PostFirstChain then
      game.Audio.PlayBanter("150_PostFirstChain")
      banterPlayed.PostFirstChain = true
    elseif not banterPlayed.PostSecondChain then
      game.Audio.PlayBanter("210_PostSecondChain")
      banterPlayed.PostSecondChain = true
    end
  end
end
function PostFirstChainBrokenBanter()
  local rightChainBroken = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  local leftChainBroken = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  if not banterPlayed.PostFirstChain and (rightChainBroken or leftChainBroken) then
    game.Audio.PlayBanter("150_PostFirstChain")
    banterPlayed.PostFirstChain = true
  end
end
function DeathTraps_Notice()
  if not banterPlayed.DeathTraps1_Notice then
    game.Audio.PlayBanter("110_DeathTraps1_Notice")
    banterPlayed.DeathTraps1_Notice = true
  elseif not banterPlayed.DeathTraps2_Notice then
    game.Audio.PlayBanter("180_DeathTraps2_Notice")
    banterPlayed.DeathTraps2_Notice = true
  end
end
function DeathTraps_Crawl()
  if not banterPlayed.DeathTraps1_Crawl then
    game.Audio.PlayBanter("110_DeathTraps1_Crawl")
    banterPlayed.DeathTraps1_Crawl = true
  elseif banterPlayed.DeathTraps2_Notice and not banterPlayed.DeathTraps2_Crawl then
    game.Audio.PlayBanter("180_DeathTraps2_Crawl")
    banterPlayed.DeathTraps2_Crawl = true
  end
end
function NotJustPeace_Banter()
  local rightChainBroken = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  local leftChainBroken = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  if rightChainBroken and leftChainBroken and not banterPlayed.NotJustPeace then
    game.Audio.PlayBanterNonCritical("220_NotJustPeace")
    banterPlayed.NotJustPeace = true
  end
end
