local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local player, son, thisLevel
local hasLootedBody = false
local bIsInSnake = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  thisLevel = level
  GameObjects.BoatSpeed:Hide()
  SnakeMouthSoundZone()
end
function OnStart()
  if not LD.GetEntityVariable("CAL_MimirEyeAcquired") then
    DisableExit()
  else
    EnableExit()
  end
  GameObjects.BoatSpeed:Show()
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Stn980_BossShoulder" then
    timers.StartLevelTimer(4, WarpFromSnakeBelly)
  end
end
function OnUpdate(level)
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamBoat_Hit_020") or game.World.IsInsideCameraZone(player.WorldPosition, "CamBoat_Hit_030") then
    game.Camera.SubmitCameraByName("PLYR_Boat_Forward_Near_HalfClose_Left")
  end
end
function OnUseWorld(level)
end
function WarpToBeginning()
  if not bIsInSnake then
    local boat = game.Boat.GetPlayerBoat()
    if boat then
      boat:Warp(GameObjects.boatEnterPoint.WorldPosition, GameObjects.boatEnterPoint:GetWorldForward())
      GameObjects.POI_SnakesBellyEnter.LuaObjectScript.EnterSnakeSettleStart()
      timers.StartLevelTimer(0.5, function()
        FadeIn()
        game.Boat.EnableBoatControl(boat, true)
      end)
      timers.StartLevelTimer(15, function()
        uiCalls.UI_Event_DiscoverLocation("Belly of the Beast")
      end)
      timers.StartLevelTimer(18, function()
        LD.CompleteQuest("Quest_Caldera_Objective835", game.Compass.SetDesignerForcedHide(false))
        BOOKMARK_33_SnakeBelly_020_AtHive()
      end)
      bIsInSnake = true
      SetBoatSpeed(boat, 7)
    end
  end
end
function FadeIn()
  uiCalls.UI_Event_Fade_In(1)
end
function FirstShake()
  GameObjects.POI_BellyExitL.Child.LuaObjectScript.Start()
  timers.StartLevelTimer(2.75, function()
    GameObjects.POI_ExitBelly_L.LuaObjectScript.SnakesBellyExitLSequence()
  end)
end
function SecondShake()
  GameObjects.POI_ExitBelly_L.LuaObjectScript.SnakesBellyExitRSequence()
  timers.StartLevelTimer(0.05, function()
    GameObjects.POI_BellyExitR.Child.LuaObjectScript.Start()
  end)
end
function OpenSnakeMouth()
  if LD.GetEntityVariable("CAL_MimirEyeAcquired") then
    local boat = game.Boat.GetPlayerBoat()
    if boat then
      ClearBoatSpeedOverride(boat)
      game.Boat.EnableBoatControl(boat, false)
    end
  end
end
function FadeToBlack()
  timers.StartLevelTimer(1, PrepareForFightLoading)
end
function Cal820LoadCheck()
  game.UI.LoadCheck("Cal820_SnakeBellyMid")
end
function WarpFromSnakeBelly()
  print("Calling Warp")
  local stn910 = game.FindLevel("Stn910_BossEntrance")
  if stn910 then
    stn910:CallScript("WarpFromSnakeBelly")
    local boat = game.Boat.GetPlayerBoat()
    if boat then
      game.Boat.EnableBoatControl(boat, true)
      son:CallScript("ClearBehaviorContext")
    end
  end
end
function ArriveAtDock()
  son:CallScript("ClearBehaviorContext")
end
function LeaveDock()
  son:CallScript("EnterBehaviorContext", "BOAT_CONTEXT_CONFIG_LEFT")
end
function PrepareForFightLoading()
  GameObjects.LoadFight:ShowEntityVolume()
  GameObjects.LoadStoneMason:HideEntityVolume()
  GameObjects.HideOutside:HideEntityVolume()
  GameObjects.LoadInside:HideEntityVolume()
end
function EnableExit()
  GameObjects.LoadFight:HideEntityVolume()
  GameObjects.LoadStoneMason:ShowEntityVolume()
  GameObjects.HideOutside:HideEntityVolume()
  GameObjects.LoadInside:HideEntityVolume()
  GameObjects.Lights_Chest:PlayAnimToEnd()
  GameObjects.Cal800Fade:Show()
  local camBoatZoneSnakeBellyExit010 = thisLevel:GetGameObject("CamBoat_Hit_010")
  camBoatZoneSnakeBellyExit010:ShowCameraVolume()
  local camBoatZoneSnakeBellyExit020 = thisLevel:GetGameObject("CamBoat_Hit_020")
  camBoatZoneSnakeBellyExit020:ShowCameraVolume()
  local camBoatZoneSnakeBellyExit030 = thisLevel:GetGameObject("CamBoat_Hit_030")
  camBoatZoneSnakeBellyExit030:ShowCameraVolume()
end
function DisableExit()
  GameObjects.LoadFight:HideEntityVolume()
  GameObjects.LoadStoneMason:HideEntityVolume()
  GameObjects.HideOutside:ShowEntityVolume()
  GameObjects.LoadInside:ShowEntityVolume()
  local camBoatZoneSnakeBellyExit010 = thisLevel:GetGameObject("CamBoat_Hit_010")
  camBoatZoneSnakeBellyExit010:HideCameraVolume()
  local camBoatZoneSnakeBellyExit020 = thisLevel:GetGameObject("CamBoat_Hit_020")
  camBoatZoneSnakeBellyExit020:HideCameraVolume()
  local camBoatZoneSnakeBellyExit030 = thisLevel:GetGameObject("CamBoat_Hit_030")
  camBoatZoneSnakeBellyExit030:HideCameraVolume()
end
function SetBoatSpeed(boat, speed)
  local data = {}
  data.TargetMaxSpeed = speed
  data.TargetMaxRotationSpeed = 160
  data.TargetAcceleration = 25
  data.TargetAngularAcceleration = 230
  data.MaxSpeedChangeRate = 1
  data.MaxRotationSpeedChangeRate = 100
  data.AccelerationChangeRate = 1
  data.AngularAccelerationChangeRate = 1
  game.Boat.SetOverrideSpeedControlData(boat, data)
end
function ClearBoatSpeedOverride(boat)
  game.Boat.ClearOverrideSpeedControlData(boat)
end
function Cal800_Bookmark_AtHive()
end
function Cal800_Bookmark_End()
  LD.SetEntityVariable("CAL_MimirEyeAcquired", true)
  GameObjects.LoadStoneMason:ShowEntityVolume()
end
function Cal800_Bookmark_AtHammer()
  local tendrils = thisLevel:FindGameObjects("hiveTendril*")
  for _, tendril in ipairs(tendrils) do
    tendril.Child.LuaObjectScript.HitTendril()
  end
end
function BOOKMARK_33_SnakeBelly_020_AtHive()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "33_SnakeBelly_020_AtHive"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function OnSaveCheckpoint(level)
  return {bIsInSnake = bIsInSnake}
end
function OnRestoreCheckpoint(level, savedInfo)
  bIsInSnake = savedInfo.bIsInSnake
end
function OnLootedBody()
  hasLootedBody = true
  DisableInspectBody()
end
function EnableInspectBody()
  if not hasLootedBody then
    GameObjects.InspectBody.LuaObjectScript.Enable()
  end
end
function DisableInspectBody()
  GameObjects.InspectBody.LuaObjectScript.Disable()
end
function PlaySnakeBellyExitSound()
  player:CallScript("PlaySoundOnKratos", "SND_CINE_Caldera_Serpent_BellyExit_01")
  local cal805 = game.FindLevel("Cal805_SnakeBellySound")
  if cal805 ~= nil then
    cal805:CallScript("StopSnakeInteriorSounds")
  end
end
function SnakeMouthSoundZone()
  if game.FindLevel("Cal050_Sound") ~= nil then
    game.FindLevel("Cal050_Sound"):CallScript("ShowSnakeMouthZone")
  end
end
