local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timer = require("level.timer")
local thisObj, player, son, kraPuppeteer, sonPuppeteer, boatPuppeteer, kraActor, sonActor, boatActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
end
function PlayShake(nameofeffect, duration, tweenin, tweenout)
  local effect = {
    EffectName = nameofeffect,
    Duration = duration,
    TweenInTime = tweenin,
    TweenOutTime = tweenout
  }
  game.FX.SubmitEffect(effect)
end
function PlayShake_Waves(name, length)
  PlayShake(name, length, 0.1, 0)
end
function CanExitBelly()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return 520 <= cineNum and cineNum < 540 and LD.GetEntityVariable("CAL_MimirEyeAcquired")
end
function DoBellyExitL()
  kraPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitL_Kra", player)
  sonPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitL_Son", son)
  boatPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitL_Boat", game.Boat.GetPlayerBoat())
  kraPuppeteer:Clear()
  kraPuppeteer:AcceptSync()
  if son ~= nil then
    sonPuppeteer:AcceptSync()
    boatPuppeteer:Sync("BRA_SnakeBellyExit_L", false, {
      {
        Slave = sonPuppeteer,
        Branch = "BRA_SnakeBellyExit_L"
      },
      {
        Slave = kraPuppeteer,
        Branch = "BRA_SnakeBellyExit_L"
      }
    })
  else
    boatPuppeteer:Sync("BRA_SnakeBellyExit_L", false, {
      {
        Slave = kraPuppeteer,
        Branch = "BRA_SnakeBellyExit_L"
      }
    })
  end
  kraPuppeteer:OnComplete(function()
    kraPuppeteer = nil
  end)
  sonPuppeteer:OnComplete(function()
    sonPuppeteer = nil
  end)
end
function SnakesBellyExitLSequence()
  PlayShake_Waves("FSE_SHAKE_WATERWAKE_DRIFT_RIGHT", 3.9)
  timer.StartLevelTimer(0.07, DoBellyExitL)
  game.Audio.PlaySound("SND_CINE_Caldera_Serpent_BellyShake_01")
end
function DoBellyExitR()
  kraPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitR_Kra", player)
  sonPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitR_Son", son)
  boatPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitR_Boat", game.Boat.GetPlayerBoat())
  kraPuppeteer:Clear()
  kraPuppeteer:AcceptSync()
  if son ~= nil then
    sonPuppeteer:AcceptSync()
    boatPuppeteer:Sync("BRA_SnakeBellyExit_R", false, {
      {
        Slave = sonPuppeteer,
        Branch = "BRA_SnakeBellyExit_R"
      },
      {
        Slave = kraPuppeteer,
        Branch = "BRA_SnakeBellyExit_R"
      }
    })
  else
    boatPuppeteer:Sync("BRA_SnakeBellyExit_R", false, {
      {
        Slave = kraPuppeteer,
        Branch = "BRA_SnakeBellyExit_R"
      }
    })
  end
  kraPuppeteer:OnComplete(function()
    kraPuppeteer = nil
  end)
  sonPuppeteer:OnComplete(function()
    sonPuppeteer = nil
  end)
end
function SnakesBellyExitRSequence()
  PlayShake_Waves("FSE_SHAKE_WATERWAKE_DRIFT_LEFT", 3.9)
  timer.StartLevelTimer(1, function()
    game.Blender.Trigger({
      Name = "FSE_SWAY_WATERWAKE_BOUNCE_HEAVY",
      Duration = 0.5,
      TweenIn = {Time = 0.5},
      TweenOut = {Time = 4.5}
    })
  end)
  timer.StartLevelTimer(0.07, DoBellyExitR)
  game.Audio.PlaySound("SND_CINE_Caldera_Serpent_BellyShake_02")
end
function SnakesBellyExitBackSequence()
  _G.PlaySnakeBellyExitSound()
  LD.CallFunctionAfterDelay(BuildSequence, 3)
end
function BuildSequence()
  son:CallScript("ClearBehaviorContext")
  GameObjects.Cal800_Black:PlayAnimToEnd()
  kraPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitBack_Kra", player)
  sonPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitBack_Son", son)
  boatPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SnakesBellyExitBack_Boat", game.Boat.GetPlayerBoat())
  kraPuppeteer:Clear()
  kraPuppeteer:AcceptSync()
  if son ~= nil then
    sonPuppeteer:AcceptSync()
    boatPuppeteer:Sync("BRA_SnakeBellyExit_Back", false, {
      {
        Slave = sonPuppeteer,
        Branch = "BRA_SnakeBellyExit_Back"
      },
      {
        Slave = kraPuppeteer,
        Branch = "BRA_SnakeBellyExit_Back"
      }
    })
  else
    boatPuppeteer:Sync("BRA_SnakeBellyExit_Back", false, {
      {
        Slave = kraPuppeteer,
        Branch = "BRA_SnakeBellyExit_Back"
      }
    })
  end
  PlayShake_Waves("FSE_SHAKE_STONEMASON_HANDMOVE_START", 2)
  local rumbleEffect = {
    Name = "FFB_GENERIC_RUMBLE_EXTREME",
    Duration = 0.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.5}
  }
  timer.StartLevelTimer(9, function()
    game.Blender.Trigger(rumbleEffect)
  end)
  timer.StartLevelTimer(11.3, function()
    game.Blender.Trigger(rumbleEffect)
  end)
  timer.StartLevelTimer(13.5, function()
    game.Blender.Trigger(rumbleEffect)
  end)
  timer.StartLevelTimer(15.8, function()
    game.Blender.Trigger(rumbleEffect)
  end)
  kraPuppeteer:OnComplete(function()
    kraPuppeteer = nil
  end)
  sonPuppeteer:OnComplete(function()
    sonPuppeteer = nil
  end)
  timer.StartLevelTimer(1, function()
    GameObjects.POI_BellyExitBack.Child.LuaObjectScript.Start()
  end)
  game.Audio.PlaySound("SND_CINE_Caldera_Serpent_BellyShake_03")
end
