local LD = require("design.LevelDesignLibrary")
function OnScriptLoaded(level)
  SoundInit()
end
function OnStart(level)
  LD.CallFunctionAfterDelay(PlaySnakeInteriorSounds, 1)
end
local snakeInterior
function SoundInit()
  snakeInterior = GameObjects.SNDGrpSnakeInterior:FindSingleSoundEmitterByName("SNDSnakeInterior")
end
function PlaySnakeInteriorSounds()
  LD.PlaySound(snakeInterior, "SND_CHR_World_Serpent_Heart_Beat_Interior_LP")
  LD.PlaySound(snakeInterior, "SND_CHR_World_Serpent_Interior_Chortle_Oneshot_LP")
  LD.PlaySound(snakeInterior, "SND_CHR_World_Serpent_Breath_Interior_LP")
end
function StopSnakeInteriorSounds()
  LD.StopSound(snakeInterior, "SND_CHR_World_Serpent_Heart_Beat_Interior_LP")
  LD.StopSound(snakeInterior, "SND_CHR_World_Serpent_Interior_Chortle_Oneshot_LP")
  LD.StopSound(snakeInterior, "SND_CHR_World_Serpent_Breath_Interior_LP")
end
