local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local monitors = require("level.MonitorLibrary")
local TUT = require("game.GlobalTutorials")
local thisLevel
local bEyeAcquired = false
function OnScriptLoaded(level)
  GameObjects.zipline_Cal850:SetZiplineStartAndEnd(GameObjects.ZiplineStartPos:GetWorldPosition(), GameObjects.ZiplineStopPos:GetWorldPosition())
end
function CantJumpHint()
  if not LD.GetEntityVariable("CAL_MimirEyeAcquired") then
    game.Audio.PlayBanter("SnakePuzzleA")
  end
end
function OnSaveCheckpoint(level)
  return {bEyeAcquired = bEyeAcquired}
end
function OnRestoreCheckpoint(level, savedInfo)
  bEyeAcquired = savedInfo.bEyeAcquired
end
function BoatDocked()
  GameObjects.PointAtCrane.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_Docked.LuaObjectScript.Enable()
  GameObjects.CA_syncexithelper_Docked.LuaObjectScript.Enable()
end
function BoatBeached()
  GameObjects.CA_SyncExit_Beached.LuaObjectScript.Enable()
end
function DisableLTWSpline()
  GameObjects.LeadTheWay_Docked.LuaObjectScript.Disable()
end
function OnCraneReachEnd()
  if not LD.GetEntityVariable("CAL_MimirEyeAcquired") then
    LD.CallFunctionAfterDelay(function()
      GameObjects.PointAtCrane.LuaObjectScript.Disable()
    end, 2)
    GameObjects.ObserveClimb.LuaObjectScript.Enable()
    game.Audio.PlayBanter("SnakePuzzleC", nil, nil, false)
  end
end
function acquireMimirEye()
  LD.CompleteQuest("Quest_Caldera_Objective840")
  LD.SetEntityVariable("CAL_MimirEyeAcquired", true)
  local cal800 = game.FindLevel("Cal800_SnakeBelly")
  cal800:CallScript("EnableExit")
  GameObjects.LookAtChest.LuaObjectScript.Disable()
  GameObjects.Cal820_Banter.LuaObjectScript.OnMimirEyeAcquired()
  GameObjects.LookAtChest.LuaObjectScript.Disable()
end
function OnExitClimbToPlatform()
  if not LD.GetEntityVariable("CAL_MimirEyeAcquired") then
    GameObjects.LookAtChest.LuaObjectScript.Enable()
  else
    GameObjects.SyncExitRevisit.LuaObjectScript.Enable()
  end
  GameObjects.crackClimb_column_thor:HideTraversePath()
  GameObjects.ContextAction_CraneLookUp.LuaObjectScript.Disable()
  GameObjects.spinCraneMechanism.LuaObjectScript.SetKratosOffPlatform()
end
function OnZiplineDown()
  if not LD.GetEntityVariable("CAL_MimirEyeAcquired") then
    GameObjects.LookAtChest.LuaObjectScript.Disable()
  end
  GameObjects.crackClimb_column_thor:ShowTraversePath()
end
function OnJumpOntoCrane()
  GameObjects.ObserveClimb.LuaObjectScript.Disable()
  GameObjects.ContextAction_CraneLookDown.LuaObjectScript.Enable()
  GameObjects.spinCraneMechanism.LuaObjectScript.SetKratosOnPlatform()
end
function Cal820_Bookmark_AtHammer()
  GameObjects.snakeBellyBoat1.LuaObjectScript.SpawnVehicle()
end
function CheckpointAfterZipline()
  if LD.GetEntityVariable("CAL_MimirEyeAcquired") and not bEyeAcquired then
    bEyeAcquired = true
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "33_SnakeBelly_040_MimirEyeAcquired"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end
end
function SonAskMimir()
  game.Audio.PlayBanter("050_RidePlatform")
end
function ArrivedAtPlatform()
  GameObjects.ContextAction_CraneLookDown.LuaObjectScript.Disable()
  GameObjects.ContextAction_CraneLookUp.LuaObjectScript.Enable()
end
function JumpToPlatform()
  GameObjects.LookAtChest.LuaObjectScript.Disable()
end
function JumpFromPlatform()
  GameObjects.LookAtChest.LuaObjectScript.Enable()
end
function Objective835Failsafe()
  LD.CompleteQuest("Quest_Caldera_Objective835")
end
