local LD = require("design.LevelDesignLibrary")
local thisObj
local waterLevels = {4189, 4589}
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
end
function OnFirstPreStart(level, obj)
  thisObj:PauseAnim()
end
function HideWater()
  thisObj:Hide()
  thisObj:HideCollision()
end
function ShowWater()
  thisObj:Show()
  thisObj:ShowCollision()
  GameObjects.waterLakeMirror:Show()
end
function LowerWater_Level01(immediate)
  if immediate then
    thisObj:JumpAnimToFrame(waterLevels[1])
    thisObj:PauseAnim()
  else
    thisObj:PlayAnimationToFrame(waterLevels[1])
  end
end
function LowerWater_Level02(immediate)
  if immediate then
    thisObj:JumpAnimToFrame(waterLevels[2])
    thisObj:PauseAnim()
  else
    LD.PlayAnimToEndAfterDelay(thisObj, 33, 0.75)
  end
end
