local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local delayTimers = require("level.timer")
local thisLevel, player, Q3_Door_Alert, Enc_Ext_QOne_Bandit_01, Enc_Ext_QOne_Bandit_02, Enc_Ext_QOne_BanditAmbusher_01, Enc_Ext_QOne_Bandit_03, Enc_Ext_QOne_Bandit_04, Enc_Ext_QOne_Bandit01_Repop, Enc_Ext_QTwo_Bandit_Paths, Enc_Ext_QTwo_Bandit_Ambush, Enc_Ext_QTwo_BanditPath_Spawn_02, Enc_Ext_QTwo_BanditPaths_Repop, enc_Ext_QTwo_Bridge_Ambush, Enc_Ext_QThree_DoorSpawn, Enc_Ext_QThree_Bandit_Ambush, Wulver_HealthMonitor, Enc_Ext_QFour_Bandit_Pather01, Enc_Ext_QFour_TreasureChestFight, Q4_ZM_Treasure, Enc_Ext_QFive_Jotunn_MiniBoss, Enc_Ext_QFive_Jotunn_Support, Enc_Ext_QSix_CaveR_Gate, Enc_Ext_QSix_TreasureChest_Ambush, enc_Ext_QSix_SeidrePrayFight_01, enc_Ext_QSix_SeidrePrayFight_03, Enc_Ext_QSix_CaveR_GateRepop, Enc_Ext_QSev_Traveler, enc_Ext_QEight_LootRift, TempleWulver_HealthMonitor, ZM_A1_E1_Attack, Enc_LC_GateA_Ambush, Enc_LC_Entrance_Ambush, Enc_LC_DarkOne_Ambush, Enc_LC_Golem_Spawn, Enc_LC_Bridge_Spawn, Enc_LC_CrystalCarry_A, Enc_LC_CrystalCarry_B, Enc_LC_CrystalCarry_C, Enc_LC_CrystalCarry_D, Enc_RC_Encounter_A, Enc_TMPL_Traveler, Traveler_HealthMonitor, beenToVikingFuneral
local Rift_Challenge_Duration = 10
local Challenge_Started = false
local ecTimer, ec_TimeRequirement, hudTimeRemaining
local delayDestruction = false
local delayDestruction_T = {}
function OnScriptLoaded(level, obj)
  thisLevel = level
  Fnc_Ext_QOne_BanditPath_Spawn_01()
  Fnc_Ext_QOne_BanditPath_Spawn_02()
  Fnc_Ext_QOne_BanditAmbushers_Spawn()
  Fnc_Ext_QOne_Bandit_Spawn_04()
  Fnc_Ext_QOne_BanditPath01_Repop()
  Fnc_Ext_QTwo_BanditPath_Spawns()
  Fnc_Ext_QTwo_BanditAmbush_Spawn()
  Fnc_Ext_QTwo_BanditPath_Spawn_02()
  Fnc_Ext_QTwo_BanditPath_Repop()
  FNC_Ext_QTwo_Bridge_Ambush()
  Fnc_Ext_QThree_Bandit_Ambush()
  Fnc_Ext_QThree_TempleDoor_Spawn()
  Fnc_Ext_QFour_BanditPath_Spawn()
  Fnc_Ext_QFour_TreasureChest_Ambush()
  Fnc_Ext_QFive_Jotunn_Fight()
  Fnc_Ext_QFive_Jotunn_Support()
  Fnc_Ext_QSix_CaveR_Gate()
  Fnc_Ext_QSix_TreasureChest_Ambush()
  FNC_Ext_QSix_SeidrPray_01()
  FNC_Ext_QSix_SeidrPray_03()
  Fnc_Ext_QSix_CaveR_Gate_Repop()
  Fnc_Ext_QSev_Traveler()
  if game.GetNewGamePlus() then
    New_Game_Plus_Fnc_Ext_QEight_LootRift()
  else
    Fnc_Ext_QEight_LootRift()
  end
  Fnc_LC_Entrance_Ambush()
  Fnc_LC_DarkOne_Ambush()
  Fnc_LC_Golem_Spawn()
  Fnc_LC_Bridge_Spawn()
  Fnc_LC_CrystalCarry_C()
  Fnc_LC_CrystalCarry_D()
  Fnc_RC_Encounter_A()
  Fnc_TMPL_Traveler()
end
function OnStart(level, obj)
  if Enc_Ext_QFive_Jotunn_MiniBoss:WasRunning() then
    Enc_Ext_QFive_Jotunn_MiniBoss:Start()
  end
  if Enc_Ext_QThree_DoorSpawn:WasRunning() then
    Enc_Ext_QThree_DoorSpawn:Start()
  end
  if Enc_LC_Golem_Spawn:WasRunning() then
    Enc_LC_Golem_Spawn:Start()
  end
  if enc_Ext_QSix_SeidrePrayFight_01:WasRunning() then
    enc_Ext_QSix_SeidrePrayFight_01:Start()
  end
  if Enc_Ext_QSev_Traveler:WasRunning() then
    Enc_Ext_QSev_Traveler:Start()
  end
  if enc_Ext_QSix_SeidrePrayFight_03:WasRunning() then
    enc_Ext_QSix_SeidrePrayFight_03:Start()
  end
  if Enc_Ext_QSev_Traveler:WasRunning() then
    Enc_Ext_QSev_Traveler:Start()
  end
  if enc_Ext_QEight_LootRift:WasRunning() then
    enc_Ext_QEight_LootRift:Start()
  end
  if Enc_Ext_QFour_Bandit_Pather01:WasRunning() then
    Enc_Ext_QFour_Bandit_Pather01:Start()
  end
  if Enc_Ext_QSix_CaveR_Gate:WasRunning() then
    Enc_Ext_QSix_CaveR_Gate:Start()
  end
end
function OnUpdate(level)
  UpdateCreatureDestruction()
  if Challenge_Started then
    Encounter_Timer()
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Fnc_Ext_QOne_BanditPath_Spawn_01()
  Enc_Ext_QOne_Bandit_01 = EC.NewEncounter(thisLevel, "XPL100:Q1: Path_Bandit01", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  Enc_Ext_QOne_Bandit_01:AddWave({
    {
      spawners = "S_Bandit00_SUP_Q1_Path_Bandit01",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0},
      markerID = "PATHTEST"
    }
  })
  Enc_Ext_QOne_Bandit_01:SetStartZone(GameObjects.EntZnGrp_Ext_QOne_SpawnBandits_01)
end
function Fnc_Ext_QOne_BanditPath01_Repop()
  Enc_Ext_QOne_Bandit01_Repop = EC.NewEncounter(thisLevel, "XPL100:Q1: Path_Bandit01 Repop", {
    LeashZone = "LshZn_Ext_A1_01",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "XPL100:Q1: Path_Bandit01"
    }
  })
  Enc_Ext_QOne_Bandit01_Repop:AddWave({
    {
      spawners = "SiedreBandit_Q1_Path_Bandit01_Repop",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
  Enc_Ext_QOne_Bandit01_Repop:SetStartZone(GameObjects.EntZnGrp_Ext_QOne_SpawnBandits_01)
end
function Fnc_Ext_QOne_BanditPath_Spawn_02()
  Enc_Ext_QOne_Bandit_02 = EC.NewEncounter(thisLevel, "XPL100:Q1: Path_Bandit02", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  Enc_Ext_QOne_Bandit_02:AddWave({
    {
      spawners = "S_Bandit00_SUP_Q1_Path_Bandit04",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QOne_Bandit_02:SetStartZone(GameObjects.EntZnGrp_Ext_QOne_SpawnBandits_01)
end
function BanditPath_Q1_ChkPnt()
  if Enc_Ext_QOne_Bandit_01:IsComplete() and Enc_Ext_QOne_Bandit_02:IsComplete() then
    game.World.StoreCheckpoint()
  end
end
function Fnc_Ext_QOne_BanditAmbushers_Spawn()
  Enc_Ext_QOne_BanditAmbusher_01 = EC.NewEncounter(thisLevel, "XPL100:Q3: Bandit Ambush", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  Enc_Ext_QOne_BanditAmbusher_01:AddWave({
    {
      spawners = "S_Bandit00_SDR1",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_BanditAmbush_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "SH_Bandit00_SFA",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_BanditAmbush_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QOne_BanditAmbusher_01:SetAlertZone(GameObjects.EntZn_Ext_QThree_AlertBandit_01)
  Enc_Ext_QOne_BanditAmbusher_01:OnStart(function()
    Enc_Ext_QOne_BanditAmbusher_01:AlertEnemies()
  end)
end
function Start_ExtQ1_BanditAmbush()
  Enc_Ext_QOne_BanditAmbusher_01:Start()
  LD.CallFunctionAfterDelay(function()
    Enc_Ext_QOne_BanditAmbusher_01:AlertEnemies()
  end, 1)
end
function Fnc_Ext_QOne_Bandit_Spawn_03()
  Enc_Ext_QOne_Bandit_03 = EC.NewEncounter(thisLevel, "XPL100:Q1: Bandit03", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  Enc_Ext_QOne_Bandit_03:AddWave({
    {
      spawners = "S_Bandit00_Sprint",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_06",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "S_Bandit00_Sprint",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_07",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
end
function Fnc_Ext_QOne_Bandit_Spawn_04()
  Enc_Ext_QOne_Bandit_04 = EC.NewEncounter(thisLevel, "XPL100:Q1: Bandit04", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  Enc_Ext_QOne_Bandit_04:AddWave({
    {
      spawners = "Fanatic_Bomb_PT",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QOne_Bandit_04:SetStartZone(GameObjects.EntZn_Ext_QTwo_SpawnBandits_03)
end
function Fnc_Ext_QTwo_BanditPath_Spawns()
  Enc_Ext_QTwo_Bandit_Paths = EC.NewEncounter(thisLevel, "XPL100:Q2: Bandit Pathers", {
    LeashZone = "LshZn_Ext_A3_01"
  })
  Enc_Ext_QTwo_Bandit_Paths:AddWave({
    {
      spawners = "S_Bandit00_SUP_Q2_Path_Bandit01",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QTwo_Bandit01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "S_Bandit00_SUP_Q2_Path_Bandit02",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QTwo_Bandit02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QTwo_Bandit_Paths:SetStartZone(GameObjects.EntZnGrp_Ext_QTwo_SpawnBandits_02)
end
function Fnc_Ext_QTwo_BanditPath_Repop()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 6
  end
  Enc_Ext_QTwo_BanditPaths_Repop = EC.NewEncounter(thisLevel, "XPL100:Q2: Bandit Pathers Repop", {
    LeashZone = "LshZn_Ext_A3_01",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "XPL100:Q2: Bandit Pathers"
    }
  })
  Enc_Ext_QTwo_BanditPaths_Repop:AddWave({
    {
      spawners = "SiedreBandit_Q2_Path_Bandit01_Repop",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QTwo_Bandit01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6},
      markerID = "Siedre_Bandit_Q2",
      powerLevel = powerLevel
    },
    {
      spawners = "SiedreBandit_Q2_Path_Bandit02_Repop",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QTwo_Bandit02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QTwo_BanditPaths_Repop:SetStartZone(GameObjects.EntZnGrp_Ext_QTwo_SpawnBandits_01)
end
function Fnc_Ext_QTwo_BanditAmbush_Spawn()
  Enc_Ext_QTwo_Bandit_Ambush = EC.NewEncounter(thisLevel, "XPL100:Q2: Bandit Ambush", {
    LeashZone = "LshZn_Ext_A2_01"
  })
  Enc_Ext_QTwo_Bandit_Ambush:AddWave({
    {
      spawners = "SH_Bandit00_RDD",
      spawnLocators = "Loc_Ext_QTwo_Bandit03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_Archer_PT",
      spawnLocators = "Loc_Ext_QTwo_Bandit04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      spawnCooldown = 2.5
    }
  })
  Enc_Ext_QTwo_Bandit_Ambush:SetStartZone(GameObjects.EntZn_Ext_QTwo_SpawnBandits_02)
  Enc_Ext_QTwo_Bandit_Ambush:OnStart(function()
    Enc_Ext_QTwo_Bandit_Ambush:AlertEnemies()
  end)
  Enc_Ext_QTwo_Bandit_Ambush:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Archer")
  end)
end
function Fnc_Ext_QTwo_BanditPath_Spawn_02()
  Enc_Ext_QTwo_BanditPath_Spawn_02 = EC.NewEncounter(thisLevel, "XPL100:Q1: Bandit Ambush", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  Enc_Ext_QTwo_BanditPath_Spawn_02:AddWave({
    {
      spawners = "S_Bandit00_SUP_Q1_Path_Bandit02",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QOne_Bandit_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QTwo_BanditPath_Spawn_02:SetStartZone(GameObjects.EntZn_Ext_QTwo_SpawnBandits_03)
end
function FNC_Ext_QTwo_Bridge_Ambush()
  enc_Ext_QTwo_Bridge_Ambush = EC.NewEncounter(thisLevel, "XPL100:Q2: Bridge Ambush", {
    LeashZone = "LshZn_Ext_A1_01"
  })
  enc_Ext_QTwo_Bridge_Ambush:AddWave({
    {
      spawners = "SH_Bandit00_STEL",
      initialSpawnAmount = 1,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  enc_Ext_QTwo_Bridge_Ambush:SetStartZone(GameObjects.EntZn_Ext_QTwo_BridgeAmbush)
end
function Fnc_Ext_QThree_Bandit_Ambush()
  Enc_Ext_QThree_Bandit_Ambush = EC.NewEncounter(thisLevel, "XPL100:Q3: Brawler Ambush", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Ext_A3_01"
  })
  Enc_Ext_QThree_Bandit_Ambush:AddWave({
    {
      spawners = "Fanatic_Bomb_PT",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QThree_Bandit_Turret_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "Fanatic_Bomb_PT",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QThree_Bandit_Turret_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {1, 1},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "SH_Bandit00_PL3_SDR1",
      initialSpawnAmount = 1,
      spawnLocators = "Loc_Ext_QThree_Brawler_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QThree_Bandit_Ambush:SetStartZone(GameObjects.EntZnGrp_Ext_QThree_SpawnBandit_01)
  Enc_Ext_QThree_Bandit_Ambush:OnStart(function()
    timers.StartLevelTimer(1, function()
      Enc_Ext_QThree_Bandit_Ambush:AlertEnemies()
    end)
  end)
  Enc_Ext_QThree_Bandit_Ambush:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Bomber")
  end)
end
function Fnc_Ext_QThree_TempleDoor_Spawn()
  Enc_Ext_QThree_DoorSpawn = EC.NewEncounter(thisLevel, "XPL100:Q3: Temple Door Fight", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Ext_A3_02",
    StartMusic = "SND_MX_XPL100_temple_entrance_fight_in",
    StopMusic = "SND_MX_XPL100_temple_entrance_fight_out"
  })
  Enc_Ext_QThree_DoorSpawn:AddWave({
    timeBeforeNextWave = 6,
    {
      spawners = "S_Bandit00_Sprint",
      spawnLocators = "Loc_Ext_QThree_PortalSpawn_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 2,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = {1, 3.75},
      spawnCooldown = {3, 5}
    }
  })
  Enc_Ext_QThree_DoorSpawn:AddWave({
    {
      spawners = "S_Bandit00_Health_Sprint",
      spawnLocators = "Loc_Ext_QThree_PortalSpawn_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2.35, 2.7},
      spawnCooldown = {1, 2.5}
    },
    {
      spawners = "S_Bandit00_Sprint",
      spawnLocators = "Loc_Ext_QThree_PortalSpawn_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2.5, 2.9},
      spawnCooldown = {2, 3.5}
    }
  })
  Enc_Ext_QThree_DoorSpawn:AddWave({
    {
      spawners = "Brawler00_PL5_SRFC",
      spawnLocators = "Loc_Ext_QThree_PortalSpawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2.25, 2.5},
      spawnCooldown = {0.15, 0.25}
    },
    {
      spawners = "S_Bandit00_Health_Sprint",
      spawnLocators = "Loc_Ext_QThree_PortalSpawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = 3,
      spawnCooldown = 1
    }
  })
  Enc_Ext_QThree_DoorSpawn:OnComplete(PostExteriorFightBanter)
  Enc_Ext_QThree_DoorSpawn:OnStart(function()
    GameObjects.PktRft_Q3_TempleDoor_Spawns_02.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Q3_TempleDoor_Spawns_02.LuaObjectScript.SpawningDone()
    end, 5)
  end, 1)
  Enc_Ext_QThree_DoorSpawn:OnStart(function()
    GameObjects.PktRft_Q3_TempleDoor_Spawns_03.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Q3_TempleDoor_Spawns_03.LuaObjectScript.SpawningDone()
    end, 5)
  end, 2)
  Enc_Ext_QThree_DoorSpawn:OnStart(function()
    GameObjects.PktRft_Q3_TempleDoor_Spawns_01.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Q3_TempleDoor_Spawns_01.LuaObjectScript.SpawningDone()
    end, 5)
  end, 3)
  Enc_Ext_QThree_DoorSpawn:OnEnemySpawn(function()
    GameObjects.PktRft_Q3_TempleDoor_Spawns_02.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
  Enc_Ext_QThree_DoorSpawn:OnEnemySpawn(function()
    GameObjects.PktRft_Q3_TempleDoor_Spawns_03.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 2})
  Enc_Ext_QThree_DoorSpawn:OnEnemySpawn(function()
    GameObjects.PktRft_Q3_TempleDoor_Spawns_01.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 3})
end
function PostExteriorFightBanter()
  beenToVikingFuneral = game.Level.GetVariable("QST_FuneralCompleted")
  game.Audio.PlayBanter("HTTK_ShowTheDoor_PostFight", FollowupBanter)
  GameObjects.CA_Observe_TempleDoor.LuaObjectScript.Enable()
end
function FollowupBanter()
  local questState = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Parent")
  if beenToVikingFuneral == true and questState == "Active" then
    game.Audio.PlayBanter("HTTK_ShowTheDoor_PostFight_Funeral")
  end
end
function Fnc_Ext_QFour_BanditPath_Spawn()
  Enc_Ext_QFour_Bandit_Pather01 = EC.NewEncounter(thisLevel, "XPL100:Q4: Bandit Path 01", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Ext_A3_03"
  })
  Enc_Ext_QFour_Bandit_Pather01:AddWave({
    {
      spawners = "S_Bandit00_SUP_Q4_Path_Bandit01",
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QFour_Bandit_Pather01:SetStartZone(GameObjects.EntZn_Ext_QFour_Spawn_BanditPather_01)
end
function Fnc_Ext_QFour_TreasureChest_Ambush()
  Enc_Ext_QFour_TreasureChestFight = EC.NewEncounter(thisLevel, "XPL100:Q4: Treasure Chest Attack", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Ext_A3_03"
  })
  Enc_Ext_QFour_TreasureChestFight:AddWave({
    {
      spawners = "S_Bandit00_SDR1",
      spawnLocators = "Loc_Ext_QFour_TreasureSpawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "S_Bandit00_SDR2",
      spawnLocators = "Loc_Ext_QFour_TreasureSpawn_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    }
  })
end
function Fnc_Ext_QFive_Jotunn_Fight()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 6
  end
  Enc_Ext_QFive_Jotunn_MiniBoss = EC.NewEncounter(thisLevel, "XPL100:Q5: Jotunn Attack", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Ext_A3_04"
  })
  Enc_Ext_QFive_Jotunn_MiniBoss:AddWave({
    {
      spawners = "Jotunn10_Eating",
      spawnWad = "Xpl100_AI_Exterior01",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = {3, 6},
      markerID = "miniboss_Jo10",
      powerLevel = powerLevel
    }
  })
  Enc_Ext_QFive_Jotunn_MiniBoss:SetStartZone(GameObjects.EntZn_Ext_QFive_Jotunn_MiniBoss_Spawn)
  Enc_Ext_QFive_Jotunn_MiniBoss:SetAlertZone(GameObjects.EntZn_Ext_QFive_Jotunn_Support_Spawn)
end
function Fnc_Ext_QFive_Jotunn_Support()
  Enc_Ext_QFive_Jotunn_Support = EC.NewEncounter(thisLevel, "XPL100:Q5: Jotunn Support Ambush", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Ext_A3_03"
  })
  Enc_Ext_QFive_Jotunn_Support:AddWave({
    {
      spawners = "Fanatic_Bomb_PT",
      spawnLocators = "Loc_Ext_QFive_BanditTurret_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_Bomb_PT",
      spawnLocators = "Loc_Ext_QFive_BanditTurret_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Enc_Ext_QFive_Jotunn_Support:SetStartZone(GameObjects.EntZn_Ext_QFive_Jotunn_Support_Spawn)
end
function Fnc_Ext_QSix_CaveR_Gate()
  Enc_Ext_QSix_CaveR_Gate = EC.NewEncounter(thisLevel, "XPL100:Q6: CaveR Ext Encounter", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Ext_Dragon_01"
  })
  Enc_Ext_QSix_CaveR_Gate:AddWave({
    timeBeforeNextWave = 25,
    {
      spawners = "Siedr_Fanatic_Bomb_PT",
      spawnLocators = "Loc_Ext_QSix_BanditTurret_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Crawler00_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Enc_Ext_QSix_CaveR_Gate:AddWave({
    timeBeforeNextWave = 20,
    {
      spawners = "Crawler00_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Crawler10_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Enc_Ext_QSix_CaveR_Gate:AddWave({
    {
      spawners = "Siedr_Fanatic_Bomb_PT",
      spawnLocators = "Loc_Ext_QSix_BanditTurret_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Crawler00_PL3_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Crawler10_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  Enc_Ext_QSix_CaveR_Gate:SetStartZone(GameObjects.EntZn_Ext_QSix_EncStart)
  Enc_Ext_QSix_CaveR_Gate:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Spitter")
  end)
end
function Fnc_Ext_QSix_TreasureChest_Ambush()
  Enc_Ext_QSix_TreasureChest_Ambush = EC.NewEncounter(thisLevel, "XPL100:Q6: Treasure Chest Ambush", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Ext_Dragon_01"
  })
  Enc_Ext_QSix_TreasureChest_Ambush:AddWave({
    {
      spawners = "Siedr_SH_Bandit00_SHW",
      spawnLocators = "Loc_Ext_QSix_TreasureChestSpawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
  Enc_Ext_QSix_TreasureChest_Ambush:SetStartZone(GameObjects.EntZn_Ext_QSix_TreasureChest_Ambush)
end
function FNC_Ext_QSix_SeidrPray_01()
  enc_Ext_QSix_SeidrePrayFight_01 = EC.NewEncounter(thisLevel, "XPL100:Q6 - Siedr Pray 01", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Ext_Dragon_01"
  })
  enc_Ext_QSix_SeidrePrayFight_01:AddWave({
    {
      spawners = "Siedr_Fanatic_Bomb_PT",
      spawnLocators = "Loc_Ext_QSix_BanditPray_07",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Siedr_Fanatic_Bomb_Pray",
      spawnLocators = "Loc_Ext_QSix_BanditPray_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Siedr_Fanatic_Bomb_Pray",
      spawnLocators = "Loc_Ext_QSix_BanditPray_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  enc_Ext_QSix_SeidrePrayFight_01:SetStartZone(GameObjects.EntZn_Vista_Dragon02)
  enc_Ext_QSix_SeidrePrayFight_01:SetAlertZone(GameObjects.EntZn_Ext_QSix_Fanatic_01)
end
function FNC_Ext_QSix_SeidrPray_03()
  enc_Ext_QSix_SeidrePrayFight_03 = EC.NewEncounter(thisLevel, "XPL100:Q6 - Siedr Pray 03", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Ext_Dragon_01"
  })
  enc_Ext_QSix_SeidrePrayFight_03:AddWave({
    {
      spawners = "Siedr_Fanatic_Bomb_Pray",
      spawnLocators = "Loc_Ext_QSix_BanditPray_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  enc_Ext_QSix_SeidrePrayFight_03:SetStartZone(GameObjects.EntZn_Ext_QSix_TreasureChest_Ambush)
  enc_Ext_QSix_SeidrePrayFight_03:SetAlertZone(GameObjects.EntZn_Ext_QSix_Fanatic_03)
end
function Fnc_Ext_QSix_CaveR_Gate_Repop()
  Enc_Ext_QSix_CaveR_GateRepop = EC.NewEncounter(thisLevel, "XPL100:Q6: CaveR Ext Repop", {
    CheckpointOnComplete = false,
    RepopulationEncounter = true,
    LeashZone = "LshZn_Ext_Dragon_01",
    MustHaveCompletedList = {
      "XPL100:Q6: CaveR Ext Encounter"
    }
  })
  Enc_Ext_QSix_CaveR_GateRepop:AddWave({
    timeBeforeNextWave = 20,
    {
      spawners = "Crawler10_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "Crawler10_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {3, 6}
    }
  })
  Enc_Ext_QSix_CaveR_GateRepop:AddWave({
    {
      spawners = "Crawler00_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {2, 3}
    },
    {
      spawners = "Crawler10_PL5_SFG",
      spawnLocators = "Loc_Ext_QSix_CrawlerSpawn_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {1, 2},
      spawnCooldown = {2, 6}
    }
  })
  Enc_Ext_QSix_CaveR_GateRepop:SetStartZone(GameObjects.EntZnGrp_Ext_QSix_RCGate_Repop)
end
function Fnc_Ext_QSev_Traveler()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 6
  end
  Enc_Ext_QSev_Traveler = EC.NewEncounter(thisLevel, "XPL170:Q7: Traveler - Boss - Basic", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_RC_DarkOne_01",
    StartMusic = "SND_MX_XPL100_darkelf_fight_in",
    StopMusic = "SND_MX_XPL100_darkelf_fight_out"
  })
  Enc_Ext_QSev_Traveler:AddWave({
    {
      spawners = "HS_DarkOne_Elite_Boss",
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0},
      markerID = "DarkOneElite",
      powerLevel = powerLevel
    },
    {
      spawners = "Crawler00_SFG",
      spawnLocators = "Loc_Ext_QSix_BanditPray_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Crawler00_SFG",
      spawnLocators = "Loc_Ext_QSix_BanditPray_06",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Enc_Ext_QSev_Traveler:SetStartZone(GameObjects.EntZn_Ext_QSev_Traveler_Spawn)
  Enc_Ext_QSev_Traveler:OnComplete(function()
    game.Audio.SetCheckpointedMusic("SND_MX_XPL100_explore1_in")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Elite")
  end)
end
function PocketRift_Cbt_CallBack_01()
  timers.StartLevelTimer(2, function()
    enc_Ext_QEight_LootRift:Start()
  end)
  timers.StartLevelTimer(20, function()
    GameObjects.misc_legendary_tier5_xpl100_1.LuaObjectScript.SpawningDone()
  end)
end
function Stop_Q8_FightRift()
  GameObjects.misc_legendary_tier5_xpl100_1.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawn_Q8_FightRight()
  GameObjects.misc_legendary_tier5_xpl100_1.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function TurnOn100RiftMarker()
  LD.SetMarkerState("XPL_100_RiftFight", 1)
end
function Fnc_Ext_QEight_LootRift()
  enc_Ext_QEight_LootRift = EC.NewEncounter(thisLevel, "[Q8]EC: Loot Rift", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_LC_Rift_01",
    StartMusic = "SND_MX_XPL100_rift_fight_in",
    StopMusic = "SND_MX_XPL100_rift_fight_out"
  })
  enc_Ext_QEight_LootRift:AddWave({
    {
      spawners = "Brawler00_PL7_SRFC",
      spawnLocators = "Loc_Ext_QEight_Spawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 3,
      totalSpawns = 3,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {5, 6}
    }
  })
  enc_Ext_QEight_LootRift:OnComplete(Stop_Q8_FightRift)
  enc_Ext_QEight_LootRift:OnComplete(function()
    game.Audio.SetCheckpointedMusic("SND_MX_XPL100_explore1_in")
    LD.SetMarkerState("XPL_100_RiftFight", 0)
  end)
  enc_Ext_QEight_LootRift:OnEnemySpawn(PlaySoundEnemySpawn_Q8_FightRight)
end
function New_Game_Plus_Fnc_Ext_QEight_LootRift()
  enc_Ext_QEight_LootRift = EC.NewEncounter(thisLevel, "[Q8]EC: NPlus Loot Rift", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_LC_Rift_01",
    StartMusic = "SND_MX_XPL100_rift_fight_in",
    StopMusic = "SND_MX_XPL100_rift_fight_out"
  })
  enc_Ext_QEight_LootRift:AddWave({
    {
      spawners = "Brawler00_PL7_SRFC",
      spawnLocators = "Loc_Ext_QEight_Spawn_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl100_AI_Persist",
      initialSpawnAmount = 1,
      maxActive = 3,
      totalSpawns = 3,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {5, 6}
    }
  })
  enc_Ext_QEight_LootRift:OnStart(function()
    Set_Encounter_Timer(60, enc_Ext_QEight_LootRift)
    Start_Timer()
  end)
  enc_Ext_QEight_LootRift:OnEnemySpawn(function(enemy)
    enemy:ForceMove("MOV_SetDontDropLootFlag_On")
  end)
  enc_Ext_QEight_LootRift:OnComplete(Event_Complete)
  enc_Ext_QEight_LootRift:OnComplete(Stop_Q8_FightRift)
  enc_Ext_QEight_LootRift:OnComplete(function()
    game.Audio.SetCheckpointedMusic("SND_MX_XPL100_explore1_in")
    LD.SetMarkerState("XPL_100_RiftFight", 0)
  end)
  enc_Ext_QEight_LootRift:OnEnemySpawn(PlaySoundEnemySpawn_Q8_FightRight)
end
function Fnc_LC_Entrance_Ambush()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 5
  end
  Enc_LC_Entrance_Ambush = EC.NewEncounter(thisLevel, "XPL160: LC Entrance Wolf Ambush", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_LC_DarkOneSum_01"
  })
  Enc_LC_Entrance_Ambush:AddWave({
    {
      spawners = "Wulver_PL3_Pwr_EAT",
      spawnLocators = "Loc_LC_Bridge_Wulver_Eat_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      markerID = "Wulver_Intro",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Enc_LC_Entrance_Ambush:SetStartZone(GameObjects.EntZn_LC_Entrance_Ambush)
  Enc_LC_Entrance_Ambush:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Power")
  end)
  ZM_A1_E1_Attack = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_LC_DarkOne_Ambush"))
  ZM_A1_E1_Attack:OnEnter(function()
    local wulverIntro = LD.FindSingleAIByMarker("Wulver_Intro")
    if wulverIntro ~= nil then
      wulverIntro:TriggerMoveEvent("LE_WulverSpawnEatingAggro")
    end
  end)
  ZM_A1_E1_Attack:SetTriggerCountLimit(1)
end
function Fnc_LC_DarkOne_Ambush()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 6
  end
  Enc_LC_DarkOne_Ambush = EC.NewEncounter(thisLevel, "XPL160: LC Dark One Ambush", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_LC_DarkOneSum_01"
  })
  Enc_LC_DarkOne_Ambush:AddWave({
    {
      spawners = "Wulver_PL3_Spd_SFA",
      spawnLocators = "Loc_LC_Bridge_Wulver_Jump_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      markerID = "WulverPL3",
      powerLevel = powerLevel
    }
  })
  Enc_LC_DarkOne_Ambush:SetStartZone(GameObjects.EntZn_LC_DarkOne_Ambush)
end
function Fnc_LC_Golem_Spawn()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 6
  end
  Enc_LC_Golem_Spawn = EC.NewEncounter(thisLevel, "XPL160: LC Golem Spawn", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_LC_Golem_01",
    StartMusic = "SND_MX_XPL100_souleater_fight_in",
    StopMusic = "SND_MX_XPL100_souleater_fight_out"
  })
  Enc_LC_Golem_Spawn:AddWave({
    {
      spawners = "Golem_Rock_SUL",
      spawnWad = "Xpl160_AI_CaveL",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0},
      markerID = "RockGolem",
      powerLevel = powerLevel
    }
  })
  Enc_LC_Golem_Spawn:SetStartZone(GameObjects.EntZn_LC_Golem_Spawn)
  Enc_LC_Golem_Spawn:OnStart(function()
    LD.SetMarkerState("XPL_100_SoulDevourer", 1)
  end)
  Enc_LC_Golem_Spawn:OnComplete(function()
    game.Audio.SetCheckpointedMusic("SND_MX_XPL100_explore2_in")
    LD.SetMarkerState("XPL_100_SoulDevourer", 0)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_DarkSoulEater")
  end)
end
function Fnc_LC_Bridge_Spawn()
  Enc_LC_Bridge_Spawn = EC.NewEncounter(thisLevel, "XPL160:LC Bridge Wolves Ambush", {CheckpointOnComplete = true})
  Enc_LC_Bridge_Spawn:AddWave({
    {
      spawners = "Wolf_Brwn_SRFC",
      spawnLocators = "Loc_LC_Bridge_Wolf3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    },
    {
      spawners = "Wolf_Blck_SRFC",
      spawnLocators = "Loc_LC_Bridge_Wolf4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
  Enc_LC_Bridge_Spawn:SetStartZone(GameObjects.EntZn_LC_Bridge_Spawn)
end
function Fnc_LC_CrystalCarry_A()
  Enc_LC_CrystalCarry_A = EC.NewEncounter(thisLevel, "XPL160:LC Crystal Carry Attack A", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_LC_DarkOneSum_01"
  })
  Enc_LC_CrystalCarry_A:AddWave({
    {
      spawners = "Wolf_Blck_SRFC",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushA_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    },
    {
      spawners = "Wulver_PL1_SFA",
      spawnLocators = "Loc_LC_Bridge_JumpDown",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
end
function Fnc_LC_CrystalCarry_B()
  Enc_LC_CrystalCarry_B = EC.NewEncounter(thisLevel, "XPL160:LC Crystal Carry Attack B", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_LC_DarkOneSum_01"
  })
  Enc_LC_CrystalCarry_B:AddWave({
    {
      spawners = "Wolf_Blck_SRFC",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushB_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
end
function Fnc_LC_CrystalCarry_C()
  Enc_LC_CrystalCarry_C = EC.NewEncounter(thisLevel, "XPL160:LC Crystal Carry Attack C", {
    LeashZone = "LshZn_LC_DarkOneSum_01"
  })
  Enc_LC_CrystalCarry_C:AddWave({
    {
      spawners = "Wolf_Brwn_SRFC",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushC_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_Blck_SRFC",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushC_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Enc_LC_CrystalCarry_C:SetStartZone(GameObjects.EntZn_LC_CrystalCarry_Ambush_C)
end
function Fnc_LC_CrystalCarry_D()
  Enc_LC_CrystalCarry_D = EC.NewEncounter(thisLevel, "XPL160:LC Crystal Carry Attack D", {
    LeashZone = "LshZn_LC_DarkOneSum_01"
  })
  Enc_LC_CrystalCarry_D:AddWave({
    {
      spawners = "Wulver_PL3_Pwr_SFA",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushD_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_Blck_SRFC",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushD_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Wolf_Blck_SRFC",
      spawnLocators = "Loc_LC_CrystalCarry_AmbushD_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl160_AI_CaveL",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Enc_LC_CrystalCarry_D:SetStartZone(GameObjects.EntZn_LC_CrystalCarry_Ambush_D)
end
function Fnc_RC_Encounter_A()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 5
  end
  Enc_RC_Encounter_A = EC.NewEncounter(thisLevel, "XPL170:RC Encounter A", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_RC_Crawl_01"
  })
  Enc_RC_Encounter_A:AddWave({
    {
      spawners = "Crawler00_IDLE",
      spawnLocators = "Loc_RC_Encounter_A_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0},
      markerID = "DarkOne",
      powerLevel = powerLevel
    }
  })
  Enc_RC_Encounter_A:AddWave({
    {
      spawners = "Crawler00_SFG",
      spawnLocators = "Loc_RC_Encounter_A_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {1, 5},
      spawnCooldown = {0, 0},
      powerLevel = powerLevel
    },
    {
      spawners = "Crawler10_SFG",
      spawnLocators = "Loc_RC_Encounter_A_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl170_AI_CaveR",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2, 6},
      spawnCooldown = {0, 0},
      powerLevel = powerLevel
    }
  })
  Enc_RC_Encounter_A:SetStartZone(GameObjects.EntZn_RC_Encounter_A)
end
function Enc_RC_Encounter_A_Complete()
  local Xpl170 = game.FindLevel("Xpl170_HTTKcaveR")
  local CA_CaveR = Xpl170:FindSingleGameObject("CA_CaveR_Post_Idle")
  CA_CaveR:CallScript("Enable")
end
function Fnc_TMPL_Traveler()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 6
  end
  Enc_TMPL_Traveler = EC.NewEncounter(thisLevel, "XPL150: Temple Traveler Boss", {CheckpointOnComplete = true, LoadCheck = true})
  Enc_TMPL_Traveler:AddWave({
    {
      spawners = "Traveler_Berserker_TauntRally",
      spawnWad = "Xpl150_AI_Temple",
      markerID = "XPL150_Traveler_Boss",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5,
      powerLevel = powerLevel
    }
  })
  Enc_TMPL_Traveler:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "S_Bandit00_SDR3",
      spawnLocators = "Loc_TMPL_Spawn_HelWalker_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl150_AI_Temple",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 0,
      markerID = "SDR3_w2"
    }
  })
  Enc_TMPL_Traveler:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "S_Bandit00_SDR3",
      spawnLocators = "Loc_TMPL_Spawn_HelWalker_06",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl150_AI_Temple",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 0,
      markerID = "SDR3_w3"
    },
    {
      spawners = "S_Bandit00_SDR3",
      spawnLocators = "Loc_TMPL_Spawn_HelWalker_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl150_AI_Temple",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 0,
      markerID = "SDR3_w3"
    }
  })
  Enc_TMPL_Traveler:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "S_Bandit00_SDR3",
      spawnLocators = "Loc_TMPL_Spawn_HelWalker_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl150_AI_Temple",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 0,
      markerID = "SDR3_w4"
    }
  })
  Enc_TMPL_Traveler:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "S_Bandit00_SDR3",
      spawnLocators = "Loc_TMPL_Spawn_HelWalker_06",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl150_AI_Temple",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 0,
      markerID = "SDR3_w5"
    },
    {
      spawners = "S_Bandit00_SDR3",
      spawnLocators = "Loc_TMPL_Spawn_HelWalker_07",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl150_AI_Temple",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 0,
      markerID = "SDR3_w5"
    }
  })
  Enc_TMPL_Traveler:OnEnemySpawn(Traveler_Health_Encounter, {
    markerID = "XPL150_Traveler_Boss"
  })
  Enc_TMPL_Traveler:SetAlertZone(GameObjects.EntZn_TMPL_Alert_Boss)
  Enc_TMPL_Traveler:OnEnemySpawn(function()
    AlertHelwalker_w2()
  end, {markerID = "SDR3_w2"})
  Enc_TMPL_Traveler:OnEnemySpawn(function()
    AlertHelwalker_w3()
  end, {markerID = "SDR3_w3"})
  Enc_TMPL_Traveler:OnEnemySpawn(function()
    AlertHelwalker_w4()
  end, {markerID = "SDR3_w4"})
  Enc_TMPL_Traveler:OnEnemySpawn(function()
    AlertHelwalker_w5()
  end, {markerID = "SDR3_w5"})
  Enc_TMPL_Traveler:OnComplete(function()
    GameObjects.Helwakers_Spawn_Group:PauseAnim()
  end)
  Enc_TMPL_Traveler:OnComplete(function()
    GameObjects.Helwakers_Spawn_Group.Child:Hide()
  end)
  Enc_TMPL_Traveler:OnComplete(EnablePostFightContext)
  Enc_TMPL_Traveler:OnComplete(function()
    game.Audio.StartMusic("SND_MX_XPL100_throne_fight_out")
  end)
  Enc_TMPL_Traveler:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Traveler")
  end)
end
function AlertHelwalker_w2()
  LD.CallFunctionAfterDelay(function()
    Enc_TMPL_Traveler:AlertEnemies(2)
  end, 1)
end
function AlertHelwalker_w3()
  LD.CallFunctionAfterDelay(function()
    Enc_TMPL_Traveler:AlertEnemies(3)
  end, 0.55)
end
function AlertHelwalker_w4()
  LD.CallFunctionAfterDelay(function()
    Enc_TMPL_Traveler:AlertEnemies(4)
  end, 0.55)
end
function AlertHelwalker_w5()
  LD.CallFunctionAfterDelay(function()
    Enc_TMPL_Traveler:AlertEnemies(5)
  end, 0.55)
end
function StartBossFight()
  Enc_TMPL_Traveler:Start()
end
function Traveler_Health_Encounter(Enemy)
  if Enemy ~= nil then
    LD.CallFunctionAfterDelay(function()
      Enemy:TriggerMoveEvent("LE_RuneChargeUpLoop")
    end, 0.2)
    local Traveler_Health = Enemy:GetHitPoints()
    Traveler_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Traveler_Health * 0.9
    local Health_Phase_2 = Traveler_Health * 0.7
    local Health_Phase_3 = Traveler_Health * 0.5
    local Health_Phase_4 = Traveler_Health * 0.3
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Enc_TMPL_Traveler:StartWave(2)
      timers.StartLevelTimer(1, function()
        Enc_TMPL_Traveler:AlertEnemies()
      end)
    end)
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Enc_TMPL_Traveler:StartWave(3)
      timers.StartLevelTimer(1, function()
        Enc_TMPL_Traveler:AlertEnemies()
      end)
    end)
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_3, function()
      Enc_TMPL_Traveler:StartWave(4)
      timers.StartLevelTimer(1, function()
        Enc_TMPL_Traveler:AlertEnemies()
      end)
    end)
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_4, function()
      Enc_TMPL_Traveler:StartWave(5)
      timers.StartLevelTimer(1, function()
        Enc_TMPL_Traveler:AlertEnemies()
      end)
    end)
  end
end
function EnablePostFightContext()
  local xpl150 = game.FindLevel("Xpl150_HTTKtemple")
  if xpl150 ~= nil then
    xpl150:CallScript("ActivateThroneCA")
  end
end
function ForceEnableCineOnReload()
  if Enc_TMPL_Traveler:IsComplete() then
    local xpl150 = game.FindLevel("Xpl150_HTTKtemple")
    if xpl150 ~= nil then
      xpl150:CallScript("ActivateCineInteract")
    end
  end
end
function FT_JumpElevator()
  local For255 = game.FindLevel("For255_ChiselEntrance")
  if For255 ~= nil then
    For255:CallScript("JumpElevator")
  end
end
function Q4_WaterDrop_Ambush()
  Enc_Ext_QFour_TreasureChestFight:Start()
  LD.CallFunctionAfterDelay(function()
    Enc_Ext_QFour_TreasureChestFight:AlertEnemies()
  end, 4)
end
function HTTK_EXT_TempleDoor_Callback()
  Enc_Ext_QThree_DoorSpawn:Start()
end
function Set_Encounter_Timer(timeRequirement, encounter)
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, function()
    EventFailed_TimeElapsed(encounter)
  end)
  ecTimer:Stop()
end
function Start_Timer()
  local startDelay = 1
  Challenge_Started = true
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = ec_TimeRequirement % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function Encounter_Timer()
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = hudTimeRemaining % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37906, {minutes, seconds})
end
function EventFailed_TimeElapsed(encounter)
  local seconds = Rift_Challenge_Duration % 60
  local minutes = Rift_Challenge_Duration / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.DisableMechanicText()
  Despawn_Enemy_VFX(encounter)
  encounter:Reset()
  encounter:Stop()
  ResetRift_Callback(encounter)
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Event_Complete()
  uiCalls.DisableMechanicText()
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Despawn_Enemy_VFX(encounter)
  local minTime = 0.01
  local maxTime = 0.3
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies = encounter:GetActiveEnemies()
  for _, enemy in pairs(enemies) do
    if enemy ~= nil and enemy:IsDoingSyncMove() == false then
      timers.StartLevelTimer(randomFn(), function()
        if enemy ~= nil then
          SpawnFXAtCreatureLocation(enemy)
          enemy:Destroy()
        end
      end)
      CreatureInSyncMove_DelayDestruction(enemy)
    end
  end
  encounter:ResetLivingEnemiesCount()
  encounter:ReportWaveDespawned(nil)
end
function SpawnFXAtCreatureLocation(creature)
  local fx = game.FX.Spawn("Body_Fire_Explode", nil, {
    AutoDelete = true,
    EffectCreator = creature,
    Scale = 1.5
  })
  local lastEnemyPos = creature:GetWorldJointPosition(creature:GetJointIndex("JOPelvis1"))
  fx:SetWorldPosition(lastEnemyPos)
end
function CreatureInSyncMove_DelayDestruction(creature)
  delayDestruction = true
  delayDestruction_T[creature] = true
end
function UpdateCreatureDestruction()
  if delayDestruction == true then
    local remaining = 0
    for creature, _ in pairs(delayDestruction_T) do
      if creature ~= nil and delayDestruction_T[creature] == true then
        if creature:IsDoingSyncMove() == false then
          SpawnFXAtCreatureLocation(creature)
          creature:Destroy()
          delayDestruction_T[creature] = nil
        else
          remaining = remaining + 1
        end
      end
    end
    if remaining == 0 then
      delayDestruction = false
      delayDestruction_T = {}
    end
  end
end
function ResetRift_Callback(encounter)
  GameObjects.misc_legendary_tier5_xpl100_1.LuaObjectScript.ResetCombatState()
end
