local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local PupLib = require("design.PuppeteerLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local player, thisLevel
local throneRoomBanterPlayed = false
local musicState = 0
local SpikeGate, bellTarget_03, LakeWater, TempleMainDoor, LakeIC
local LakeLowered = false
local dragonShrinesBroken = 0
local ZiplineGuide, bucket
local bucketDropped = false
local bucketCrane
local noKeysBanterPlayed = false
local attackZoneMortar, attackZoneBreath, TakeOffWhoosh, caveR_Wallpress
local ExitDropped = false
local ExitDropCol
local HengeShortcutUnlocked = false
local ZiplineGatewayActive = false
local dragonBeamZone
local rightKeyRetrieved = false
local leftKeyRetrieved = false
local bucketAnimDone = false
local caveBifrostBridgeOn = false
local buddyDropDone = false
local crystalPickedUpOnce = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  LakeWater = level:GetGameObject("LakeWater")
  LakeIC = level:GetGameObject("LakeIC")
  TempleMainDoor = level:GetGameObject("TempleMainDoor")
  ZiplineGuide = level:GetGameObject("ZiplineGuide")
  bucket = level:GetGameObject("bucket")
  bucketCrane = level:GetGameObject("xpl160_crystal_drop_break"):FindSingleGOByName("breakable")
  attackZoneMortar = level:GetGameObject("dragonMortarZone")
  attackZoneBreath = level:GetGameObject("dragonBeamZone")
  TakeOffWhoosh = level:GetGameObject("TakeOffWhoosh_Xpl100_HTTK")
  caveR_Wallpress = level:GetGameObject("TP_WallPress")
  ExitDropCol = level:GetGameObject("ExitDropCol")
  dragonBeamZone = level:GetGameObject("dragonBeamZone")
  game.Audio.StartMusicMaster("SND_MX_XPL100_start_master")
  SoundInit()
end
function OnFirstStart(level)
  TempleMainDoor:JumpAnimToFrame(0)
  TempleMainDoor:PauseAnim()
  LD.HideFX(TakeOffWhoosh)
  LakeWater:JumpAnimToFrame(0)
  LakeWater:PauseAnim()
  game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper43", false)
end
function OnStart(level)
  SetGatewayMarker()
  GameObjects.DragonDispel:FindSingleGOByName("SonDispell").LuaObjectScript.GetSonInteractZone():SetInteractFrontAngle(110)
  GameObjects.EntZn_LC_CrystalCarry_Ambush_A:HideEntityVolume()
  GameObjects.EntZn_LC_CrystalCarry_Ambush_B:HideEntityVolume()
  GameObjects.EntZn_LC_CrystalCarry_Ambush_C:HideEntityVolume()
  GameObjects.EntZn_LC_CrystalCarry_Ambush_D:HideEntityVolume()
  local Zipline_TopPOS = GameObjects.Xpl100_Zip_Locator_Top
  local Zipline_BottomPOS = GameObjects.Xpl100_Zip_Locator_Bottom
  local zipline_Xpl100 = GameObjects.zipline_Xpl100.Child
  zipline_Xpl100:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    LakeLowered = LakeLowered,
    dragonShrinesBroken = dragonShrinesBroken,
    bucketDropped = bucketDropped,
    ExitDropped = ExitDropped,
    HengeShortcutUnlocked = HengeShortcutUnlocked,
    ZiplineGatewayActive = ZiplineGatewayActive,
    rightKeyRetrieved = rightKeyRetrieved,
    leftKeyRetrieved = leftKeyRetrieved,
    bucketAnimDone = bucketAnimDone,
    caveBifrostBridgeOn = caveBifrostBridgeOn,
    crystalPickedUpOnce = crystalPickedUpOnce,
    buddyDropDone = buddyDropDone
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  LakeLowered = savedInfo.LakeLowered
  dragonShrinesBroken = savedInfo.dragonShrinesBroken
  bucketDropped = savedInfo.bucketDropped
  ExitDropped = savedInfo.ExitDropped
  HengeShortcutUnlocked = savedInfo.HengeShortcutUnlocked
  ZiplineGatewayActive = savedInfo.ZiplineGatewayActive
  rightKeyRetrieved = savedInfo.rightKeyRetrieved
  leftKeyRetrieved = savedInfo.leftKeyRetrieved
  bucketAnimDone = savedInfo.bucketAnimDone
  caveBifrostBridgeOn = savedInfo.caveBifrostBridgeOn
  crystalPickedUpOnce = false
  if savedInfo.crystalPickedUpOnce ~= nil then
    crystalPickedUpOnce = savedInfo.crystalPickedUpOnce
  end
  buddyDropDone = false
  if savedInfo.buddyDropDone ~= nil then
    buddyDropDone = savedInfo.buddyDropDone
  end
end
function SetGatewayMarker()
  if HengeShortcutUnlocked then
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper23", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper23", false)
  end
  if ZiplineGatewayActive then
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper53", true)
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper32", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper32", false)
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper53", false)
  end
  if leftKeyRetrieved then
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper36", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper36", false)
  end
  if bucketDropped then
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper42", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper42", false)
  end
end
function ToggleZiplineGateway()
  ZiplineGatewayActive = true
  SetGatewayMarker()
  LD.CallFunctionAfterDelay(function()
    ZiplineGatewayActive = false
  end, 2)
  LD.CallFunctionAfterDelay(function()
    SetGatewayMarker()
  end, 2.5)
end
function EnableZiplineActive()
  ZiplineGatewayActive = true
end
function DisableZiplineActive()
  ZiplineGatewayActive = false
end
function Dropbucket()
  bucket:FindSingleGOByName("CarryBifrostLight_Top1").LuaObjectScript.DisableInteract()
  bucketCrane:PlayAnimToEnd()
  bucket:PlayAnimToEnd(1.65)
  LD.CallFunctionAfterDelay(function()
    bucket:FindSingleGOByName("CarryBifrostLight_Top1").LuaObjectScript.EnableInteract()
  end, 13.5)
  bucketDropped = true
  SetGatewayMarker()
  PlaySoundBreakCrystalBucket()
  bucket:OnAnimDone(thisLevel, "setBucketAnimDone")
end
function BucketPoint()
  buddyDropDone = true
  if bucketDropped == false then
    GameObjects.CA_Bucket_Observe.LuaObjectScript.Enable()
  elseif bucketAnimDone == true and crystalPickedUpOnce == false then
    GameObjects.CA_LookDown_Crystal.LuaObjectScript.Enable()
  end
end
function setBucketAnimDone()
  bucketAnimDone = true
  if buddyDropDone == true and crystalPickedUpOnce == false then
    GameObjects.CA_LookDown_Crystal.LuaObjectScript.Enable()
  end
end
function CrystalPickUpCheck()
  if crystalPickedUpOnce == false then
    crystalPickedUpOnce = true
  end
end
function EnableAwarenessCrystal()
  GameObjects.Awareness_Crystal.LuaObjectScript.EnableAwarenessRemotely()
end
function DisableAwarenessCrystal()
  GameObjects.Awareness_Crystal.LuaObjectScript.DisableEventEmitter()
end
function caveL_ShowBridge()
  if caveBifrostBridgeOn == false then
    caveBifrostBridgeOn = true
    GameObjects.BlockGap:HideCollision()
  end
end
function Enable_Ledge_Bifrost()
  if caveBifrostBridgeOn == false then
    GameObjects.CA_Ledge_BifrostGap.LuaObjectScript.Enable()
  end
end
function caveL_HideBridge()
  if caveBifrostBridgeOn == true then
    GameObjects.BlockGap:ShowCollision()
    caveBifrostBridgeOn = false
  end
end
function hideCaveWallPress()
  caveR_Wallpress:Hide()
end
function showCaveWallPress()
  caveR_Wallpress:Show()
end
function LoadCheckInterior()
  game.UI.LoadCheck("Xpl150_HTTKtemple")
end
function LoadCheck_CaveR()
  game.UI.LoadCheck("Xpl170_HTTKcaveR")
end
function LoadCheck_CaveL()
  game.UI.LoadCheck("Xpl160_HTTKcaveL")
end
function UnlockHengeShortcut()
  GameObjects.CA_HengeClimbTopIdle02.LuaObjectScript.Enable()
  HengeShortcutUnlocked = true
end
function UnlockGateShortcut()
  GameObjects.CA_ShortcutDoorIdle.LuaObjectScript.Enable()
  game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper52", true)
end
function DropGate()
  SpikeGate:PlayAnimToEnd()
end
function LowerLakeWater()
  LakeWater:PlayAnimToEnd()
  LD.CallFunctionAfterDelay(function()
    LakeIC:HideCollision()
  end, 4)
  LakeLowered = true
end
function XPL160_Kratos_CrystalCarry(level, obj)
  Kratos_CrystalCarry_callback()
end
function Kratos_CrystalCarry_callback(level, obj)
  GameObjects.EntZn_LC_CrystalCarry_Ambush_A:ShowEntityVolume()
  GameObjects.EntZn_LC_CrystalCarry_Ambush_B:ShowEntityVolume()
  GameObjects.EntZn_LC_CrystalCarry_Ambush_C:ShowEntityVolume()
  GameObjects.EntZn_LC_CrystalCarry_Ambush_D:ShowEntityVolume()
end
function Enable_PointBucket_CA()
  if bucketDropped == false then
    GameObjects.CA_Point_Bucket.LuaObjectScript.Enable()
  end
end
function TriggerDragonStim()
  GameObjects.Stim_InterestHigh_Dragon.LuaObjectScript.Trigger()
end
function LuaHook_PlayTakeOffWhoosh()
  if TakeOffWhoosh ~= nil then
    LD.ShowFX(TakeOffWhoosh)
  end
end
function DragonDispelStarted()
  local dragon = LD.FindSingleAIByMarker("DragonMarker")
  if dragon ~= nil then
    GameObjects.dragon_AttackZone.LuaObjectScript.SetDispelInProgress()
  end
end
function DragonRelease()
  local dragon = LD.FindSingleAIByMarker("DragonMarker")
  if dragon ~= nil then
    LD.HideFX(GameObjects.dragon_fx_chain)
    GameObjects.dragon_AttackZone.LuaObjectScript.SetDragonFree()
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("HTTK_DragonRelease")
    end, 15)
    game.Audio.StartMusic("SND_MX_XPL100_free_dragon")
    game.Audio.SetCheckpointedMusic("SND_MX_XPL100_explore2_in")
  end
end
function DisableDragonZones()
  attackZoneMortar:HideEntityVolume()
  attackZoneBreath:HideEntityVolume()
end
function CheckZoneLocalDragonQuest()
  if dragonShrinesBroken == 0 then
    LD.ActivateQuest("Quest_WorldDragon_Reginn_Parent")
    game.Audio.SetBanterFact("Seen1Dragon", "True")
  end
end
function DisableBeamZone()
  if dragonShrinesBroken == 3 then
    dragonBeamZone:Hide()
  end
end
function CheckBreakableLocalDragonQuest()
  dragonShrinesBroken = dragonShrinesBroken + 1
  if dragonShrinesBroken == 1 then
    LD.ActivateQuest("Quest_WorldDragon_Reginn_Parent")
  end
  game.QuestManager.IncrementQuestProgress("Quest_WorldDragon_Reginn_Objective_01", 1)
  game.Audio.PlayBanterNonCritical("HTTK_DragonShrine" .. tostring(dragonShrinesBroken))
  LD.CallFunctionAfterDelay(function()
    game.World.StoreCheckpoint()
  end, 2)
end
function OpenTempleDoor()
  TempleMainDoor:PlayAnimToEnd()
  PlaySoundOnOpenTempleDoor()
end
function UnlockLiftGate()
  GameObjects.VibrateLiftGate.LuaObjectScript.Enable()
end
function DisableZiplineCol()
  ZiplineGuide:HideCollision()
  LD.CallFunctionAfterDelay(function()
    ZiplineGuide:ShowCollision()
  end, 3.25)
end
function HTTKZoneReport()
  uiCalls.UI_Event_DiscoverLocation("HTTK")
end
function DisableExitDropCollision()
  ExitDropCol:HideCollision()
  ExitDropped = true
end
function BckPathRopeDropOn()
  GameObjects.BckPathRope01.LuaObjectScript.EnableSonInteract()
end
function caveL_RopeDropOn()
  GameObjects.caveL_Rope01.LuaObjectScript.EnableSonInteract()
end
function EnableLakeInvestigateCA()
  if LakeLowered == false then
    GameObjects.CA_LakeInvestigate.LuaObjectScript.Enable()
  end
end
function HTTK_Visited()
  game.Level.SetVariable("QST_HTTKVisited", "True")
  game.Audio.SetBanterFact("AlreadyBeenToHTTK", "True")
end
function CompleteObjective01()
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01")
  game.Audio.PlayBanter("HTTK_QuestDiscuss")
  game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper52", false)
end
function StrongholdIntroBanterCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Objective_01")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function EnableFrontDoorEncounter()
  GameObjects.Cbt_Xpl100_HTTK_Script.LuaObjectScript.HTTK_EXT_TempleDoor_Callback()
  LD.CallFunctionAfterDelay(function()
    GameObjects.StonePedestal.LuaObjectScript.Enable()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end, 3.5)
end
function KeyCollectedBanter()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_Brothers_Epic_03_Objective_01a")
  if progress == 1 then
    game.Audio.PlayBanterNonCritical("HTTK_FirstKey")
  elseif progress == 2 then
    game.Audio.PlayBanter("HTTK_SecondKey", FirstKeyCollected_QuestActive)
  elseif progress == 3 then
    game.Audio.PlayBanter("HTTK_SecondKey_QuestActive")
  end
end
function RightKeyAcquired()
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01")
  game.QuestManager.IncrementQuestProgress("Quest_Brothers_Epic_03_Objective_01a", 1)
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01_Right")
  game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper53", true)
  game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper52", true)
  game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper32", true)
  KeyCollectedBanter()
  rightKeyRetrieved = true
  SetGatewayMarker()
  game.World.StoreCheckpoint()
end
function LeftKeyAcquired()
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01")
  game.QuestManager.IncrementQuestProgress("Quest_Brothers_Epic_03_Objective_01a", 1)
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01_Left")
  KeyCollectedBanter()
  leftKeyRetrieved = true
  SetGatewayMarker()
  game.World.StoreCheckpoint()
end
function CenterKeyAcquired()
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01")
  game.QuestManager.IncrementQuestProgress("Quest_Brothers_Epic_03_Objective_01a", 1)
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_01_Center")
  KeyCollectedBanter()
  game.World.StoreCheckpoint()
end
function FirstKeyCollected_QuestActive()
  game.Audio.PlayBanter("HTTK_FirstKey_QuestActive")
end
function OneKeyUsedBanter()
  game.Audio.PlayBanterNonCritical("HTTK_FirstKeyUsed")
end
function TwoKeysUsedBanter()
  game.Audio.PlayBanter("HTTK_SecondKeyUsed")
end
function ThreeKeyUsedBanter()
  game.Audio.PlayBanter("HTTK_ThreeKeysPlease_ThreeKeys", CompleteObjective02)
end
function CompleteObjective02()
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_02")
  GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
end
function StrongholdEnterBanterCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Parent")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function StrongholdInsideBanterCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Parent")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function StrongholdThroneRoomBanterCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Parent")
  if questState == "Active" and throneRoomBanterPlayed == false then
    throneRoomBanterPlayed = true
    game.Audio.PlayBanter("HTTK_EnterTheThroneRoom_PreFight", EnableThroneRoomEncounter)
  end
end
function EnableThroneRoomEncounter()
  print("throne room combat OK to fire")
end
function CompleteHuldraEpic()
  LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_Return")
end
function StrongholdExitBanter()
  game.Audio.PlayBanter("HTTK_BehindTheStronghold")
end
function PlayExitBanter02()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("HTTK_BehindTheStronghold_02")
  end, 9)
end
function DragonSeenCheck()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_WorldDragon_Objective_01")
  return 1 < progress
end
function VistaShotCheck()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_WorldDragon_Objective_01")
  return progress < 1
end
function DragonStartBanter()
  game.Audio.PlayBanter("HTTK_DragonStart")
end
function EnableDragonLook01()
  local dragon = LD.FindSingleAIByMarker("DragonMarker")
  if dragon ~= nil then
    GameObjects.DragonLook01.LuaObjectScript.EnableEventEmitter()
  end
end
function DisableDragonLook01()
  local dragon = LD.FindSingleAIByMarker("DragonMarker")
  if dragon ~= nil then
    GameObjects.DragonLook01.LuaObjectScript.DisableEventEmitter()
  end
end
function EnableDragonLook02()
  local dragon = LD.FindSingleAIByMarker("DragonMarker")
  if dragon ~= nil then
    GameObjects.DragonLook02.LuaObjectScript.EnableEventEmitter()
  end
end
function DisableDragonLook02()
  local dragon = LD.FindSingleAIByMarker("DragonMarker")
  if dragon ~= nil then
    GameObjects.DragonLook02.LuaObjectScript.DisableEventEmitter()
  end
end
local templeDoorLeftEmitter, templeDoorRightEmitter, crystalBucketEmitter
function SoundInit()
  templeDoorLeftEmitter = TempleMainDoor:FindSingleSoundEmitterByName("SNDTempleDoor_L")
  templeDoorRightEmitter = TempleMainDoor:FindSingleSoundEmitterByName("SNDTempleDoor_R")
  crystalBucketEmitter = bucket:FindSingleGOByName("CarryBifrostLight_Top1").Child:FindSingleSoundEmitterByName("SNDBifrostTemporalCrystal")
end
function PlaySoundOnOpenTempleDoor()
  LD.PlaySound(templeDoorLeftEmitter, "SND_DOOR_HTTK_StoneKey_Puzzle_Opening_L")
  LD.PlaySound(templeDoorRightEmitter, "SND_DOOR_HTTK_StoneKey_Puzzle_Opening_R")
end
function PlaySoundBreakCrystalBucket()
  LD.PlaySound(crystalBucketEmitter, "SND_BRK_Stone_Bifrost_Crystal_Float_Down_Stream")
end
function EnterXpl100Music()
  if musicState ~= 1 then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL100_explore1_in")
    musicState = 1
  end
end
function ExitXpl100Music()
  if 0 < musicState then
    game.Audio.StartMusic("SND_MX_XPL100_idle")
    musicState = 0
  end
end
function xpl100FastTravelMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL100_explore1_in")
  musicState = 1
end
function EnterXpl160Music()
  if musicState ~= 2 then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL100_explore2_in")
    musicState = 2
  end
end
function EnterTempleXpl100()
  if musicState ~= 3 then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL100_explore3_in")
    musicState = 3
  end
end
function ExitTempleXpl100()
  if musicState ~= 4 then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL100_explore4_in")
    musicState = 4
  end
end
function Trigger_Out_Of_Bounds()
  player:AddMarker("Out_Of_Bounds")
end
function Trigger_In_Bounds()
  player:RemoveMarker("Out_Of_Bounds")
end
