local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local son
function OnScriptLoaded(level)
  SoundInit()
end
function NoKeyBanter()
  if game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHTTK_LH") == -1 then
    game.Audio.PlayBanterNonCritical("Son_NoKey_Banter")
  end
end
function GloryAndPeaceRuneRead()
  game.Audio.PlayBanter("HTTK_GloryAndPeace_RR")
  game.Audio.PlayBanter("HTTK_GloryAndPeace_RR", function()
    _G.StartLevelTimer(4, GloryAndPeaceRuneRead02)
  end)
end
function GloryAndPeaceRuneRead02()
  if game.Level.GetVariable("DwarfKingMarkerFound") == true then
    game.Audio.PlayBanter("HTTK_GloryAndPeace_RR02")
  elseif game.Level.GetVariable("DwarfKingMarkerFound") == false then
    game.Audio.PlayBanter("HTTK_GloryAndPeace_RR02_Alternate")
  end
end
function UnlockHuldraEntDoor()
  GameObjects.HTTK_Huldra_Door.Child:PlayAnimToEnd()
  HuldraDoorShakeRumble()
  PlaySoundDoorUnlock()
  LD.CallFunctionAfterDelay(function()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end, 6)
end
function LoadCheckHTTK()
  game.UI.LoadCheck("Xpl100_HTTK")
end
function LoadCheckCaldera()
  game.UI.LoadCheck("Cal200_Shore")
end
function HuldraDoorShakeRumble()
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_SMALL",
    Duration = 8,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 1}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 9,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5}
  })
  timers.StartLevelTimer(1.66, function()
    RumbleShakeHit(2)
  end)
  timers.StartLevelTimer(3.2, function()
    RumbleShakeHit(4)
  end)
  timers.StartLevelTimer(9, function()
    RumbleShakeHit(9)
  end)
end
function RumbleShakeHit(effectPriority)
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_SMALL",
    Duration = 1.2,
    TweenIn = {Time = 0.1},
    Priority = effectPriority
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_STRONG",
    Duration = 0.5,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5},
    Priority = effectPriority
  })
end
local SNDHuldraDoor, SNDDoorLeft, SNDDoorRight
function SoundInit()
  SNDHuldraDoor = GameObjects.HTTK_Huldra_Door.Child:FindSingleSoundEmitterByName("SNDHuldra_Mine_Door")
  SNDDoorLeft = GameObjects.HTTK_Huldra_Door.Child:FindSingleSoundEmitterByName("SNDDoorLeft")
  SNDDoorRight = GameObjects.HTTK_Huldra_Door.Child:FindSingleSoundEmitterByName("SNDDoorRight")
end
function PlaySoundDoorUnlock()
  LD.PlaySound(SNDHuldraDoor, "SND_DOOR_Stone_HuldraMine_Double_Door_Unlock")
  LD.PlaySoundOnFrame(SNDDoorLeft, GameObjects.HTTK_Huldra_Door.Child, "SND_DOOR_HTTK_StoneKey_Puzzle_Opening_L", 120)
  LD.PlaySoundOnFrame(SNDDoorRight, GameObjects.HTTK_Huldra_Door.Child, "SND_DOOR_HTTK_StoneKey_Puzzle_Opening_R", 120)
end
