local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, throneProp, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Objective_03") ~= "Complete" then
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper43", true)
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("HAIL TO THE KING: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("HAIL TO THE KING: Son Actor", game.AI.FindSon)
  throneProp = GameObjects.Throne01:FindSingleGOByName("BanditThrone01").Child
end
function SetupSeq()
  if kraActor == nil or sonActor == nil or throneProp == nil then
    SetupActors()
    game.Compass.SetGatewayMarkerIsOpen("HTTK_100_Helper43", true)
  end
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "HailToTheKing")
  local slaveTab = {
    {Actor = sonActor},
    {
      Obj = throneProp,
      Anim = "narExpHailToTheKing000CineScene"
    }
  }
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_XPL100_start_master")
  seq:MarkAbleToSkip()
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(StartCineEnter_HailToTheKing)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_HailToTheKing",
    ReferenceJoint = "HailToTheKing_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_HailToTheKing",
    ReferenceJoint = "HailToTheKing_SynchJoint"
  })
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(function()
    LD.CompleteQuest("Quest_Brothers_Epic_03_Objective_03")
  end)
  seq:Do(GiveLoot)
  seq:Do(EnableTreasureMap)
  seq:Do(UnlockBestiaryEntry)
  seq:StartSequence()
end
function GiveLoot()
  game.Wallets.AddResource("HERO", "HuldraArmorToken_Chest", 1, nil, "Quest")
  game.Wallets.AddResource("HERO", "HuldraArmorToken_Wrist", 1, nil, "Quest")
  game.Wallets.AddResource("HERO", "HuldraArmorToken_Legs", 1, nil, "Quest")
end
function EnableTreasureMap()
  _G.TreasureMapOn()
end
function UnlockBestiaryEntry()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Motsognir")
  game.World.StoreCheckpoint()
end
function StartCineEnter_HailToTheKing()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_HailToTheKing", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_HailToTheKing)
  cameraCineEnter:Start()
end
function DestroyCineEnter_HailToTheKing()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
