local uiCalls = require("ui.uicalls")
local Journal
local throneRoomBanterPlayed = false
local mus150DoorOpened = false
local cineStarted = false
function OnScriptLoaded(level)
  SoundOnStart()
  Journal = level:GetGameObject("MostognirJournal").Child
end
function OnFirstStart(level)
  HideMapGlow()
end
function OnStart(level)
  local xpl100 = game.FindLevel("Xpl100_HTTK")
  if xpl100 ~= nil and game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Objective_03") ~= "Complete" then
    xpl100:GetGameObject("Cbt_Xpl100_HTTK_Script"):CallScript("ForceEnableCineOnReload")
  end
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Xpl100_HTTK" and game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Objective_03") ~= "Complete" then
    newLevel:GetGameObject("Cbt_Xpl100_HTTK_Script"):CallScript("ForceEnableCineOnReload")
  end
end
function OnSaveCheckpoint(level)
  return {mus150DoorOpened = mus150DoorOpened}
end
function OnRestoreCheckpoint(level, savedInfo)
  mus150DoorOpened = savedInfo.mus150DoorOpened
end
function HideMapGlow()
  Journal:FindSingleGOByName("PickUp_Glow_LRG"):Hide()
end
function ActivateThroneCA()
  game.Audio.PlayBanter("HTTK_EnterTheThroneRoom_PostFight", ActivateCineInteract)
  GameObjects.CA_ObserveDown_Throne01.LuaObjectScript.Enable()
  GameObjects.CA_ObserveDown_Throne02.LuaObjectScript.Enable()
end
function ActivateCineInteract()
  if not cineStarted then
    GameObjects.Interact_HailToTheKing.LuaObjectScript.Enable()
  end
end
function OnCineStart()
  GameObjects.CA_ObserveDown_Throne01.LuaObjectScript.Disable()
  GameObjects.CA_ObserveDown_Throne02.LuaObjectScript.Disable()
  cineStarted = true
end
function TreasureMapOn()
  Journal:FindSingleGOByName("PickUp_Glow_LRG"):Show()
  Journal:FindSingleGOByName("GenericSonInteract").LuaObjectScript.Enable()
end
function StrongholdThroneRoomBanterCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Brothers_Epic_03_Parent")
  if questState == "Active" and throneRoomBanterPlayed == false then
    throneRoomBanterPlayed = true
    game.Audio.PlayBanter("HTTK_EnterTheThroneRoom_PreFight", EnableThroneRoomEncounter)
  end
end
function EnableThroneRoomEncounter()
  print("throne room combat OK to fire")
end
function XPL150_TMPL_InnerDoorOpen_Callback(level, obj)
  local XPL100_TMPL_InnerDoor = game.FindLevel("Xpl100_HTTK")
  local XPL100_FindCBT_Script = XPL100_TMPL_InnerDoor:FindSingleGameObject("Cbt_Xpl100_HTTK_Script")
  XPL100_FindCBT_Script:CallScript("StartBossFight")
  if mus150DoorOpened == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL100_throne_fight_in")
    mus150DoorOpened = true
  end
end
local doorEvents = {
  OnInteractForward_Center = "",
  OnInteractForward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractForward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractBackward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R"
}
function SoundOnStart()
  GameObjects.SpreadDoor_PeakEntrance.LuaObjectScript.SoundSetup(doorEvents)
end
