local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local caveL_HelDoor, BladeBurnChest01, BladeBurnChest02
function OnScriptLoaded(level)
  caveL_HelDoor = level:GetGameObject("caveL_HelDoor")
  SoundInit()
end
function OnStart(level)
end
function OnFirstStart(level, obj)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function caveL_ShowBridge()
  GameObjects.TP_WallPress:Hide()
  GameObjects.BlockGap:HideCollision()
end
function caveL_HideBridge()
  GameObjects.TP_WallPress:Show()
  GameObjects.BlockGap:ShowCollision()
end
function caveL_HelDoorOpen()
  PlaySoundHelDoor_Open()
  caveL_HelDoor:PlayAnimToEnd()
end
function caveL_HelDoorClose()
  PlaySoundHelDoor_Close()
  caveL_HelDoor:PlayAnimToEnd(-1)
end
function EnableBladeBurnChest01()
  GameObjects.BladeBurnChest01.LuaObjectScript.Enable()
end
function EnableBladeBurnChest02()
  GameObjects.BladeBurnChest02.LuaObjectScript.Enable()
end
function TriggerGolemStim()
  GameObjects.Stim_Golem_Threat.LuaObjectScript.Trigger()
end
local helDoorSoundTable = {
  L_Emitter = nil,
  L_OpenEvent = "SND_DOOR_Stone_Double_Pry_Apart_Push_Open_L",
  L_CloseEvent = "SND_DOOR_Stone_Double_Pry_Apart_Push_Close_L",
  R_Emitter = nil,
  R_OpenEvent = "SND_DOOR_Stone_Double_Pry_Apart_Push_Open_R",
  R_CloseEvent = "SND_DOOR_Stone_Double_Pry_Apart_Push_Close_R"
}
function SoundInit()
  helDoorSoundTable.L_Emitter = caveL_HelDoor:FindSingleSoundEmitterByName("SNDHelDoor_L")
  helDoorSoundTable.R_Emitter = caveL_HelDoor:FindSingleSoundEmitterByName("SNDHelDoor_R")
end
function PlaySoundHelDoor_Open()
  LD.PlaySound(helDoorSoundTable.L_Emitter, helDoorSoundTable.L_OpenEvent)
  LD.PlaySound(helDoorSoundTable.R_Emitter, helDoorSoundTable.R_OpenEvent)
end
function PlaySoundHelDoor_Close()
  LD.PlaySound(helDoorSoundTable.L_Emitter, helDoorSoundTable.L_OpenEvent)
  LD.PlaySound(helDoorSoundTable.R_Emitter, helDoorSoundTable.R_OpenEvent)
end
