LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local TUT = require("game.GlobalTutorials")
local thisLevel, player, FF_HealthMonitor, Trav_HealthMonitor, CrawlerFried, DragonEncounter_First, DragonEncounter_Sleep, DragonEncounter_Turret, DragonEncounter_Surprise, GravesEncounter, DragonEncounter_RightPath, BanditEncounter1, BanditEncounter2, ObeliskEncounter, ObeliskSneak_Encounter, PrayEncounter1, PrayEncounter2, PrayEncounter3, Area_5_Encounter_1, CrawlerEncounter_Beach, DraugrEncounter_Beach, BeachPatrol_Encounter, BeachPatrol_Repop, DockEncounter_Beach, IslandEncounter_First, PuzzleArea_Encounter, JumpDownSurprise, bBridgeEncounterComplete, Bandit1AlertZoneMonitor, Bandit2AlertZoneMonitor, DraugrHiddenEnemyAttackZoneMonitor, GravesEncounterZoneMonitor, DraugrAlertEnemyAttackZoneMonitor, PrayEncounter1ZoneMonitor, PrayEncounter2ZoneMonitor, PrayEncounter3RespawnZoneMonitor, DraugrAlertObeliskZoneMonitor, PuzzleAreaZoneMonitor, DragonSleepDespawnZoneMonitor, DraugrHiddenEnemyZoneMonitor, JumpDownSurpriseZoneMonitor, GravesDespawnZoneMonitor, BeachPatrolAttackZoneMonitor, PuzzleAreaAlertZoneMonitor
Area_1_Encounter_1 = nil
Area_1_Encounter_2 = nil
Area_2_Encounter_1 = nil
Area_2_Encounter_2 = nil
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  Area_0_Fight_1()
  Area_1_Fight_1()
  Area_1_Fight_2()
  Area_1_Fight_3()
  Area_1_Fight_5()
  Area_1_Fight_6()
  Area_1_Fight_6_Repop()
  Area_1_Fight_7()
  Area_1_Fight_8()
  Area_1_Surprise_1()
  Area_2_Fight_1()
  Pray_Fight_1()
  Pray_Fight_2()
  Area_3_Fight_1()
  Area_3_Fight_2()
  Area_4_Fight_1()
  Area_4_Fight_2()
  Area_5_Fight_1()
end
function OnFirstStart(level, obj)
  GameObjects.DraugrXpl200.Child:SetCharacterConfig("light1")
  GameObjects.DraugrXpl200.Child:StartAnim("navIdle01")
  GameObjects.DraugrXpl200.Child:JumpAnimToFrame(10)
  GameObjects.DraugrXpl200.Child:PlayAnimCycle(1)
end
function OnStart(level, obj)
  if BeachPatrol_Encounter:WasRunning() then
    BeachPatrol_Encounter:Start()
  end
  if BanditEncounter1:WasRunning() then
    BanditEncounter1:Start()
  end
  if BanditEncounter2:WasRunning() then
    BanditEncounter2:Start()
  end
  if DragonEncounter_Sleep:WasRunning() then
    DragonEncounter_Sleep:Start()
  end
  if ObeliskEncounter:WasRunning() then
    ObeliskEncounter:Start()
  end
  if PuzzleArea_Encounter:WasRunning() then
    PuzzleArea_Encounter:Start()
  end
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function Area_0_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 5
    powerLevel02 = 6
  elseif 600 <= cineNumber then
    powerLevel01 = 6
    powerLevel02 = 7
  end
  IslandEncounter_First = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Draugr on Tiny Island Thor Statue", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Island",
    LodLow = 50,
    LodHigh = 60
  })
  IslandEncounter_First:AddWave({
    {
      spawners = "Draugr_L4_H_SUSL",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A1_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Draugr_L5_DW_SUSL",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A1_06",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = powerLevel02
    }
  })
  IslandEncounter_First:SetStartZone(GameObjects.SpawnAIZone_IslandDraugr)
end
function Area_1_Fight_1()
  DragonEncounter_First = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Crawler Fight Viking Dragon Beach", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Beach",
    LodLow = 50,
    LodHigh = 60
  })
  DragonEncounter_First:AddWave({
    {
      spawners = "Crawler_P_S",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A1_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  DragonEncounter_First:SetStartZone(GameObjects.SpawnAIZone_BeachCrawler)
  DragonEncounter_First:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Spitter")
  end)
end
function Area_1_Fight_2()
  DragonEncounter_Sleep = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Sleeping Draugr Viking Dragon", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Beach",
    LodLow = 35,
    LodHigh = 40
  })
  DragonEncounter_Sleep:AddWave({
    {
      spawners = "Draugr_N_SUSL",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A2_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  DragonEncounter_Sleep:SetStartZone(GameObjects.SpawnAIZone_SleepDraugrs)
  DragonEncounter_Sleep:OnEnemyDeath(function()
    DragonEncounter_Sleep:AlertEnemies()
  end)
  DraugrAlertEnemyAttackZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Alert_Draugr_Zone"))
  DraugrAlertEnemyAttackZoneMonitor:OnEnter(function()
    DragonEncounter_Sleep:AlertEnemies()
  end)
  DraugrAlertEnemyAttackZoneMonitor:SetTriggerCountLimit(1)
  DragonSleepDespawnZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("DespawnDraugr_Zone"))
  DragonSleepDespawnZoneMonitor:OnEnter(function()
    DragonEncounter_Sleep:DespawnEnemies()
  end)
end
function Area_1_Fight_3()
  DragonEncounter_Turret = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Turret Viking Funeral Dragon", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Surprise",
    LodLow = 50,
    LodHigh = 60
  })
  DragonEncounter_Turret:AddWave({
    {
      spawners = "Fanatic_PT_SFG",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A3_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  DragonEncounter_Turret:SetStartZone(GameObjects.Spawn_Turrets_Zone)
end
function SurpriseBreak()
  DragonEncounter_Surprise:Start()
  timer.StartLevelTimer(0.3, function()
    DragonEncounter_Surprise:AlertEnemies()
  end)
end
function Area_1_Surprise_1()
  DragonEncounter_Surprise = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Spawn Hidden Enemy Viking Dragon ", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Surprise",
    LodLow = 30,
    LodHigh = 40
  })
  DragonEncounter_Surprise:AddWave({
    {
      spawners = "HiddenDraugr_L3_Surprise_1",
      spawnWad = "Xpl200_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "HiddenDraugr_L2_Surprise_2",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A2_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  DragonEncounter_Surprise:SetStartZone(GameObjects.SpawnAIZone_SleepDraugrs)
  DraugrHiddenEnemyAttackZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Alert_Hidden_Draugr_Zone"))
  DraugrHiddenEnemyAttackZoneMonitor:OnEnter(function()
    DragonEncounter_Surprise:AlertEnemies()
  end)
  DraugrHiddenEnemyAttackZoneMonitor:SetTriggerCountLimit(1)
  DraugrHiddenEnemyZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("DespawnDraugr_Zone"))
  DraugrHiddenEnemyZoneMonitor:OnEnter(function()
    DragonEncounter_Surprise:DespawnEnemies()
  end)
end
function Area_1_Fight_5()
  DraugrEncounter_Beach = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Draugr Surprise Fight Beach Climb Area", {CheckpointOnComplete = false})
  DraugrEncounter_Beach:AddWave({
    {
      spawners = "Draugr_L2_T_SGAMBSH",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  DraugrEncounter_Beach:SetStartZone(GameObjects.SpawnAIZone_BeachDraugr)
end
function Area_1_Fight_6()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 4
    powerLevel02 = 6
  end
  BeachPatrol_Encounter = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Patrolling Draugrs On Beach", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Beach",
    LodLow = 55,
    LodHigh = 65,
    StartMusic = "SND_MX_XPL200_shore_fight_in",
    StopMusic = "SND_MX_XPL200_shore_fight_out"
  })
  BeachPatrol_Encounter:AddWave({
    {
      spawners = "Draugr_L3_Leg_PATROL1",
      spawnWad = "Xpl200_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "Draugr_L2_H_PATROL2",
      spawnWad = "Xpl200_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Draugr_L2_H_SUSL",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Draugr_L2_PATROL3",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Draugr_L3_Leg_Idle",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_06",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    }
  })
  BeachPatrol_Encounter:SetStartZone(GameObjects.SpawnAIZone_BeachPatrol)
  BeachPatrol_Encounter:SetAlertZone(GameObjects.SpawnAIZone_BeachAlert)
  BeachPatrol_Encounter:OnComplete(function()
    GameObjects.CA_DragonSpot.LuaObjectScript.Enable()
  end)
  BeachPatrolAttackZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SpawnAIZone_BeachAlert"))
  BeachPatrolAttackZoneMonitor:OnEnter(function()
    BeachPatrol_Encounter:AlertEnemies()
  end)
  BeachPatrolAttackZoneMonitor:SetTriggerCountLimit(1)
end
function GetBeachPatrol_Encounter()
  return BeachPatrol_Encounter
end
function Area_1_Fight_6_Repop()
  BeachPatrol_Repop = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Patrolling Draugrs On Beach Repopulation", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Beach",
    LodLow = 55,
    LodHigh = 65,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]XPL200 Patrolling Draugrs On Beach",
      "[Area 2]XPL200 Praying Fight 1 Encounter",
      "[Area 2]XPL200 Praying Fight 2 Encounter",
      "[Area 1]XPL200 Fight outside puzzle area"
    }
  })
  BeachPatrol_Repop:AddWave({
    {
      spawners = "Draugr_L6_Leg_PATROL1",
      spawnWad = "Xpl200_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L8_H_PATROL2",
      spawnWad = "Xpl200_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L8_PATROL3",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L7_Leg_Idle",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_06",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  BeachPatrol_Repop:SetStartZone(GameObjects.SpawnAIZone_BeachPatrol, {
    cineRequirement = {439, 990}
  })
  BeachPatrol_Repop:SetAlertZone(GameObjects.SpawnAIZone_BeachAlert)
end
function Area_1_Fight_7()
  DockEncounter_Beach = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Draugr Dock Area", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Beach",
    LodLow = 55,
    LodHigh = 65
  })
  DockEncounter_Beach:AddWave({
    {
      spawners = "Draugr_L2_T_SGAMBSH",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A4_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  DockEncounter_Beach:SetStartZone(GameObjects.SpawnAIZone_DockDraugr)
end
function TriggerJumpDownSurprise()
  GameObjects.DraugrXpl200.Child:Hide()
  JumpDownSurprise:Start()
end
function Area_1_Fight_8()
  JumpDownSurprise = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Draugr Surprise Jump Down", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Surprise",
    LodLow = 40,
    LodHigh = 50
  })
  JumpDownSurprise:AddWave({
    {
      spawners = "Draugr_L3_DW_JUMP",
      spawnWad = "Xpl200_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  JumpDownSurpriseZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("DespawnDraugr_Zone"))
  JumpDownSurpriseZoneMonitor:OnEnter(function()
    JumpDownSurprise:DespawnEnemies()
  end)
end
function Area_2_Fight_1()
  GravesEncounter = EC.NewEncounter(thisLevel, "[Area 2]XPL200 Gravesite Helwalker Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Graves_01",
    LodLow = 45,
    LodHigh = 55
  })
  GravesEncounter:AddWave({
    {
      spawners = "H_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "B1_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "H_Bandit_SDBR3",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "B1_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  GravesEncounter:SetStartZone(GameObjects.SpawnAIZone_Tombstones)
  GravesEncounterZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Spawn_Grave_Surprise_Zone"))
  GravesEncounterZoneMonitor:OnEnter(function()
    GravesEncounter:AlertEnemies()
  end)
  GravesEncounterZoneMonitor:SetTriggerCountLimit(1)
  GravesDespawnZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("DespawnDraugr_Zone"))
  GravesDespawnZoneMonitor:OnEnter(function()
    GravesEncounter:DespawnEnemies()
  end)
end
function Pray_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  PrayEncounter1 = EC.NewEncounter(thisLevel, "[Area 2]XPL200 Praying Fight 1 Encounter", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Pray_01",
    LodLow = 42,
    LodHigh = 52
  })
  PrayEncounter1:AddWave({
    {
      spawners = "E_Bandit_SPRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "B2_01",
      markerID = "PrayFanatic01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "H_Bandit_SDBR2",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "B2_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "H_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "B2_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    }
  })
  PrayEncounter1:SetStartZone(GameObjects.SpawnAIZone_Gravesite_2)
  PrayEncounter1ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SpawnAIZone_Gravesite_Alert_2"))
  PrayEncounter1:OnEnemySpawn(Health_Encounter1, {
    markerID = "PrayFanatic01"
  })
  PrayEncounter1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Bandit")
  end)
  PrayEncounter1ZoneMonitor:OnEnter(function()
    PrayEncounter1:AlertEnemies()
  end)
  PrayEncounter1ZoneMonitor:SetTriggerCountLimit(1)
end
function Health_Encounter1(Enemy)
  if Enemy ~= nil then
    FF_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local EnemyHealth = Enemy:GetHitPoints()
    FF_HealthMonitor:OnHealthLessThan(EnemyHealth, AlertPrayingSite01)
  end
end
function AlertPrayingSite01()
  PrayEncounter1:AlertEnemies()
end
function Pray_Fight_2()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  PrayEncounter2 = EC.NewEncounter(thisLevel, "[Area 2]XPL200 Praying Fight 2 Encounter", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Graves_01",
    LodLow = 35,
    LodHigh = 45
  })
  PrayEncounter2:AddWave({
    {
      spawners = "E_Bandit_SPRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      markerID = "PrayFanatic02",
      spawnLocators = "C1_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "H_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "C1_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "H_Bandit_SDBR3",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "C1_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    }
  })
  PrayEncounter2:SetStartZone(GameObjects.SpawnAIZone_Gravesite_1)
  PrayEncounter2ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SpawnAIZone_Gravesite_Alert_1"))
  PrayEncounter2:OnEnemySpawn(Health_Encounter2, {
    markerID = "PrayFanatic02"
  })
  PrayEncounter2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Bandit")
  end)
  PrayEncounter2ZoneMonitor:OnEnter(function()
    PrayEncounter2:AlertEnemies()
  end)
  PrayEncounter2ZoneMonitor:SetTriggerCountLimit(1)
end
function Health_Encounter2(Enemy)
  if Enemy ~= nil then
    FF_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local EnemyHealth = Enemy:GetHitPoints()
    FF_HealthMonitor:OnHealthLessThan(EnemyHealth, AlertPrayingSite02)
  end
end
function AlertPrayingSite02()
  PrayEncounter2:AlertEnemies()
end
function Area_3_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  BanditEncounter1 = EC.NewEncounter(thisLevel, "[Area 2]XPL200 Fanatic on Wooden Bridge Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Graves_01",
    LodLow = 45,
    LodHigh = 55
  })
  BanditEncounter1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Fanatic_PT_SFG",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "C2_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "H_Bandit_SDBR2",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "C1_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  BanditEncounter1:OnStart(function()
    GameObjects.SpawnAIZone_Area_3_2:HideEntityVolume()
  end)
  BanditEncounter1:SetStartZone(GameObjects.SpawnAIZone_Area_3_1)
  Bandit1AlertZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("AlertAIZone_Area_3_1"))
  Bandit1AlertZoneMonitor:OnEnter(function()
    BanditEncounter1:AlertEnemies()
  end)
end
function Area_3_Fight_2()
  BanditEncounter2 = EC.NewEncounter(thisLevel, "[Area 2]XPL200 Bandit Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Graves_01",
    LodLow = 40,
    LodHigh = 50
  })
  BanditEncounter2:AddWave({
    {
      spawners = "H_Bandit_SDBR2",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "C2_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  BanditEncounter2:OnStart(function()
    GameObjects.SpawnAIZone_Area_3_1:HideEntityVolume()
  end)
  BanditEncounter2:SetStartZone(GameObjects.SpawnAIZone_Area_3_2)
  Bandit2AlertZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("AlertAIZone_Area_3_2"))
  Bandit2AlertZoneMonitor:OnEnter(function()
    BanditEncounter2:AlertEnemies()
  end)
end
function Area_4_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  ObeliskEncounter = EC.NewEncounter(thisLevel, "[Area 4]XPL200 Obelisk Traveler fight", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Obelisk_01",
    LodLow = 50,
    LodHigh = 60
  })
  ObeliskEncounter:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Fanatic_L3_PRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D1_011",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_L3_PRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D1_09",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "Fanatic_L3_PRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D1_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.6
    },
    {
      spawners = "Fanatic_L3_PRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D1_010",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  ObeliskEncounter:AddWave({
    {
      spawners = "Fanatic_PT_SFG",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D1_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_PT_SFG",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D1_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  ObeliskEncounter:SetStartZone(thisLevel:GetGameObject("SpawnAIZone_Area_4"))
  ObeliskEncounter:OnEnemySpawn(Brawler_Health_Monitor, {
    markerID = "Brawler_Obelisk"
  })
  ObeliskEncounter:OnEnemyDeath(function()
    ObeliskEncounter:StartWave(2)
  end, {count = 2})
  ObeliskEncounter:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Fanatic")
  end)
end
function Brawler_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Trav_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.6
    local Health_Phase_2 = EnemyHealth * 0.35
    Trav_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      ObeliskEncounter:StartWave(2)
    end)
    Trav_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      ObeliskEncounter:StartWave(3)
    end)
  end
end
function Area_4_Fight_2()
  ObeliskSneak_Encounter = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Sleeping Draugr Near Chest", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Obelisk_01",
    LodLow = 30,
    LodHigh = 35
  })
  ObeliskSneak_Encounter:AddWave({
    {
      spawners = "Draugr_N_SURPRISE",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "D2_012",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  ObeliskSneak_Encounter:SetStartZone(GameObjects.SneakDraugrAIZone_Area_4)
  DraugrAlertObeliskZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SneakDraugrObelisk_Alert_Zone"))
  DraugrAlertObeliskZoneMonitor:OnEnter(function()
    ObeliskSneak_Encounter:AlertEnemies()
  end)
  DraugrAlertObeliskZoneMonitor:SetTriggerCountLimit(1)
end
function Pray_Fight_3()
  PrayEncounter3 = EC.NewEncounter(thisLevel, "[Area 5]EC:Fake Praying Fanatic for Pray 03 XPL200", {
    CheckpointOnComplete = false,
    LodLow = 25,
    LodHigh = 35
  })
  PrayEncounter3:AddWave({
    {
      spawners = "E_Bandit_FAKE_SPRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A5_F_Loc_1",
      markerID = "PrayFanatic03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  PrayEncounter3:SetStartZone(GameObjects.SpawnAIZone_Gravesite_3_Fake)
end
function Area_5_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 5
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  PuzzleArea_Encounter = EC.NewEncounter(thisLevel, "[Area 1]XPL200 Fight outside puzzle area", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_MainDoor_01",
    LodLow = 40,
    LodHigh = 50
  })
  PuzzleArea_Encounter:AddWave({
    {
      spawners = "BRAWLER_CAUTIOUS",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A5_U_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel01
    },
    {
      spawners = "BRAWLER_IDLE",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A5_U_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      powerLevel = powerLevel02
    }
  })
  PuzzleArea_Encounter:SetStartZone(GameObjects.SpawnAIZone_BrawlerPatrol)
  PuzzleArea_Encounter:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Brawler")
  end)
  PuzzleAreaAlertZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SpawnAIZone_BrawlerAlert"))
  PuzzleAreaAlertZoneMonitor:OnEnter(function()
    local brawlerInspect = LD.FindSingleAIByMarker("BrawlerInspect01")
    if brawlerInspect ~= nil then
      brawlerInspect:TriggerMoveEvent("kLEAggroF")
    end
  end)
  PuzzleAreaAlertZoneMonitor:SetTriggerCountLimit(1)
  PuzzleArea_Encounter:OnComplete(PuzzleEncounterComplete)
end
function PuzzleEncounterComplete()
  game.World.StoreCheckpoint()
  GameObjects.CA_DoorObserve01.LuaObjectScript.Enable()
end
function GetPuzzleAreaEncounter()
  return PuzzleArea_Encounter
end
