local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, DraugrBeach220_1, DraugrBeach220_2
BrokBanterDone = false
function OnScriptLoaded(level)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_1_Beach_1()
    Area_1_Beach_2()
  end
end
function OnFirstStart(level)
  GameObjects.CrackClimb225:HideTraversePath()
  GameObjects.WaterLvl01_ToggleWall:Show()
end
function OnStart(level)
  SoundOnStart()
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      GameObjects.CrackClimb225:ShowTraversePath()
      GameObjects.WaterLvl01_ToggleWall:Hide()
    end,
    fn = function()
      GameObjects.CrackClimb225:ShowTraversePath()
      GameObjects.WaterLvl01_ToggleWall:Hide()
    end
  })
  if game.Level.GetVariable("CompletedCineNumber") >= 340 then
    if DraugrBeach220_1:WasRunning() then
      DraugrBeach220_1:Start()
    end
    if DraugrBeach220_2:WasRunning() then
      DraugrBeach220_2:Start()
    end
  end
  local sonInteract = GameObjects.QuestLoreMarker1:FindSingleGOByName("pSonInteractRune").LuaObjectScript.GetInteractZone()
  sonInteract:SetXZRange(4)
end
function LoadCheck225()
  game.UI.LoadCheck("Xpl225_FuneralLH")
end
function Area_1_Beach_1()
  local powerLevel01
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel01 = 6
  end
  DraugrBeach220_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Xpl225 LoadHall Draugr", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl220",
    StartMusic = "SND_MX_XPL985_fight1_in",
    StopMusic = "SND_MX_XPL985_fight1_out"
  })
  DraugrBeach220_1:AddWave({
    {
      spawners = "Draugr_T_SUSL",
      spawnWad = "Xpl220_FuneralLH",
      spawnLocators = "A3_01",
      useSpawnLocatorsOnly = true,
      markerID = "TurretSleep",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_M_SUSL",
      spawnWad = "Xpl220_FuneralLH",
      spawnLocators = "A2_01",
      useSpawnLocatorsOnly = true,
      markerID = "MediumSleep",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_Loop_Walk_1",
      spawnWad = "Xpl220_FuneralLH",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Draugr_Loop_Walk_2",
      spawnWad = "Xpl220_FuneralLH",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    }
  })
  DraugrBeach220_1:SetStartZone(GameObjects.SpawnAIZone_Beach220)
end
function Area_1_Beach_2()
  local powerLevel01
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel01 = 6
  end
  DraugrBeach220_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Xpl225 LoadHall Golem", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl220"
  })
  DraugrBeach220_2:AddWave({
    {
      spawners = "GOLEM_SLEEP",
      spawnWad = "Xpl220_FuneralLH",
      spawnLocators = "A2_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    }
  })
  DraugrBeach220_2:SetStartZone(GameObjects.SpawnAIZone_Beach220)
  DraugrBeach220_2:OnStart(function()
    LD.SetMarkerState("CAL_100_VikingLoadHallFight", 1)
  end)
  DraugrBeach220_2:OnComplete(function()
    LD.SetMarkerState("CAL_100_VikingLoadHallFight", 0)
  end)
  DraugrBeach220_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_Lava")
  end)
end
function AlertDraugr_1()
  local draugrTurret = LD.FindSingleAIByMarker("TurretSleep")
  local draugrMedium = LD.FindSingleAIByMarker("MediumSleep")
  draugrTurret:TriggerMoveEvent("kLEAlert")
  draugrMedium:TriggerMoveEvent("kLEAlert")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    BrokBanterDone = BrokBanterDone
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  BrokBanterDone = savedInfo.BrokBanterDone
end
function VF_LH_MarkerRead()
  game.Audio.SetBanterFact("DwarfKingLoreMarker", "True")
end
function SoundOnStart()
  GameObjects.QuestLoreMarker1:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
end
function xpl200ClimbMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL985_explore1_in")
end
