local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
thisLevel = nil
player = nil
son = nil
local BeachPatrol_Encounter, PuzzleArea_Encounter, bBridgeEncounterComplete, DraugrAmbush_1_ZoneMonitor, DraugrAlertAmbushZoneMonitor, DraugrAmbush_1, WolfAmbush_1, WolfAmbush_2, FallenBoatSpawner, Xpl225_fakeboat_fall, SNDBoatRoot
local BoatFallen = false
local AxeDoor
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Xpl225_fakeboat_fall = level:GetGameObject("Xpl225_fakeboat_fall")
  SNDBoatRoot = GameObjects.Xpl225_fakeboat_fall.Child:FindSingleSoundEmitterByName("SNDBoatRoot")
  AxeDoor = level:GetGameObject("spikepanelright03")
  Area_1_Fight_1()
  Area_1_Fight_3()
  Area_1_Fight_4()
end
function OnStart(level)
  SoundOnStart()
  HideDragRock()
  if BoatFallen == true then
    Xpl225_fakeboat_fall:Hide()
  end
end
function Area_1_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  DraugrAmbush_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Xpl225 LoadHall fight ambush 1", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone225"
  })
  DraugrAmbush_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Draugr_N_IDLE",
      spawnWad = "Xpl220_FuneralLH",
      spawnLocators = "A2_02",
      useSpawnLocatorsOnly = true,
      markerID = "KillTarget",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "WOLF_L2_PACING",
      spawnWad = "Xpl225_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "WOLF_L2_EATING_1",
      spawnWad = "Xpl225_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  DraugrAmbush_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "WOLF_L1_JUMP_2",
      spawnWad = "Xpl225_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  DraugrAmbush_1:SetStartZone(GameObjects.SpawnAIZone_Beach225)
  DraugrAmbush_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Feral")
    GameObjects.SpawnAIZone_Ambush225:HideEntityVolume()
  end)
  DraugrAmbush_1_ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SpawnAIZone_Ambush225"))
  DraugrAmbush_1_ZoneMonitor:OnEnter(function()
    timer.StartLevelTimer(3, function()
      DraugrAmbush_1:StartWave(2)
    end)
    timer.StartLevelTimer(0.5, function()
      DraugrAmbush_1:AlertEnemies()
      game.AI.FindSon():TriggerMoveEvent("kLE_TripEnemySetup")
    end)
  end)
  DraugrAmbush_1_ZoneMonitor:SetTriggerCountLimit(1)
end
function Area_1_Fight_3()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  WolfAmbush_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Xpl225 LoadHall fight Wolves", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone226"
  })
  WolfAmbush_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "WOLF_L2_EATING_2",
      spawnWad = "Xpl225_AI_01",
      spawnLocators = "A3_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "WOLF_L2_Unaware",
      spawnWad = "Xpl225_AI_01",
      spawnLocators = "A3_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  WolfAmbush_1:SetStartZone(GameObjects.SpawnAIZone_Wolf225)
  WolfAmbush_1:SetAlertZone(GameObjects.SpawnAIZone_AlertWolf225)
  WolfAmbush_1:OnComplete(WolvesCombatCheckpoint)
  WolfAmbush_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Feral")
  end)
end
function Area_1_Fight_4()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber then
    powerLevel = 3
  elseif 600 <= cineNumber then
    powerLevel = 4
  end
  WolfAmbush_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:3 Xpl225 LoadHall CS Wolf", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone226"
  })
  WolfAmbush_2:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "WOLF_L1_CS",
      spawnWad = "Xpl225_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  WolfAmbush_2:SetStartZone(GameObjects.SpawnAIZone_WolfCS)
  WolfAmbush_2:OnComplete(WolvesCombatCheckpoint)
end
function EnableHiddenCoffin()
  GameObjects.coffin_tier1_xpl225_1.Child.LuaObjectScript.Enable()
end
function WolvesCombatCheckpoint()
  if WolfAmbush_1:IsComplete() and WolfAmbush_2:IsComplete() then
    game.World.StoreCheckpoint()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    BoatFallen = BoatFallen
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  BoatFallen = savedInfo.BoatFallen
end
function EnableBoatObserve()
  if BoatFallen == false then
    GameObjects.CA_Observe_Boat.LuaObjectScript.Enable()
  end
  local beachPoint = GameObjects.Xpl225_Beach:FindSingleGOByName("dockpoint_Beach")
  beachPoint.LuaObjectScript.RepopulateDock()
end
function BoatFall()
  GameObjects.CA_Observe_Boat.LuaObjectScript.Disable()
  Xpl225_fakeboat_fall:FindSingleGOByName("FakeBoat"):PlayAnimToFrame(90, 2)
  Xpl225_fakeboat_fall:FindSingleGOByName("FakeBoat"):OnAnimDone(thisLevel, "BoatAnimComplete")
  LD.PlaySoundOnFrame(SNDBoatRoot, GameObjects.Xpl225_fakeboat_fall.Child, "SND_VEH_Boat_Hit", 42, "forward")
  BoatFallen = true
end
function BoatAnimComplete()
  local spawnPosition = GameObjects.Xpl225_fakeboat_fall:FindSingleGOByName("boat00_Midgard"):GetWorldPosition()
  local spawnRotation = GameObjects.Xpl225_fakeboat_fall:FindSingleGOByName("boat00_Midgard"):GetWorldForward()
  GameObjects.Xpl225_Beach:FindSingleGOByName("dockpoint_Beach").LuaObjectScript.OverrideDefaultSpawnLocation(spawnPosition)
  local beachPoint = GameObjects.Xpl225_Beach:FindSingleGOByName("dockpoint_Beach")
  beachPoint.LuaObjectScript.Enable()
  if beachPoint.LuaObjectScript.IsPlayerInZone() then
    beachPoint.LuaObjectScript.SpawnVehicle(spawnPosition, spawnRotation)
  else
    beachPoint.LuaObjectScript.DisplayBoatVisual()
  end
  LD.CallFunctionAfterDelay(function()
    Xpl225_fakeboat_fall:Hide()
  end, 0.75)
end
function SyncExit_SonTutorial()
  if game.Level.GetVariable("TUT_ShowSonAggression") == true then
    LD.CallFunctionAfterDelay(function()
      TUT.SonTrip_Tutorial()
    end, 0.8)
    game.AI.FindSon():CallScript("LuaHook_EnableAutonomousSon")
    game.Level.SetVariable("TUT_ShowSonAggression", false)
  end
end
function HideDragRock()
  local DragObject = AxeDoor:FindSingleGOByName("DragObject")
  DragObject:Hide()
end
function LoadCheckFuneral()
  game.UI.LoadCheck("Xpl200_Funeral")
end
function LoadCheckCaldera()
  game.UI.LoadCheck("Cal200_Shore")
end
function LoadCheckXpl220()
  game.UI.LoadCheck("Xpl220_FuneralLH")
end
function SoundOnStart()
  GameObjects.SonReadRune:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
end
function xpl225MusicExit()
  game.Audio.StartMusic("SND_MX_XPL985_idle")
end
function PlayScorchMarks()
  game.Audio.PlayBanter("VFuneral_ScorchMarks")
end
