local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
checkpoint = require("level.checkpoint")
local CSL = require("camera.shakelibrary")
local thisLevel, player, son
CTroll_HealthMonitor = nil
Encounter_Catacombs1 = nil
local FF_HealthMonitor, PrayEncounter3, Area_1_Encounter_1, Area_1_Encounter_2, Area_6_Encounter_1, Area_6_Encounter_2, Area_6_Encounter_3, Area_6_Encounter_4, Area_6_Encounter_5, Area_6_Encounter_6, Area_7_Encounter_0, Area_7_Encounter_1, GuardianEncounterZoneMonitor, TrollEncounterZoneMonitor, PrayEncounter3ZoneMonitor, Troll_HealthMonitor, troll
local TrollFound = false
local TrollDoor = false
local SecretBomb
local SecretBombActive = false
caveRubbleCleared = false
Flood = nil
FloodGate = nil
CrankRight = nil
IntSecretGate = nil
ArenaPlatform = nil
pedestalUnlocked = false
LowerWaterMantle = nil
LowerWaterGuide = nil
LowerWaterGuide02 = nil
ExplodingPotSecret = nil
CrankBlocked = nil
SecretGateRaised = false
ArenaPlatformRaised = false
WaterLowered = false
SecretBoulderDestroyed = false
WaterCollisionDisabled = false
local crankRecenter = {
  TimeStart = 0,
  TimeDuration = 2.4,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 30,
  ReturnLeft = 24.5,
  ReturnRight = 23.5,
  TriggerRight = 2,
  PitchRange = -1,
  TriggerUp = 8,
  ReturnUp = -5.5,
  ReturnDown = -6.5,
  TriggerDown = -14
}
local secretGateRecenter = {
  TimeStart = 0,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  RotationSpace = 1,
  YawRange = -1,
  TriggerLeft = 19,
  ReturnLeft = 16,
  ReturnRight = 16,
  TriggerRight = 12,
  PitchRange = -1,
  TriggerUp = 14,
  ReturnUp = 10,
  ReturnDown = 10,
  TriggerDown = 8
}
function OnScriptLoaded(level)
  thisLevel = level
  Pray_Fight_3()
  Area_6_Fight_1()
  Area_6_Fight_2()
  Area_6_Fight_3()
  Area_6_Fight_4()
  Area_6_Fight_5()
  Area_6_Fight_6()
  Area_7_Fight_0()
  Area_7_Fight_1()
  Flood = level:GetGameObject("Flood")
  FloodGate = level:GetGameObject("FloodGate")
  SecretBomb = level:GetGameObject("TogglePot")
  CrankRight = level:GetGameObject("CrankRight")
  ArenaPlatform = level:GetGameObject("ArenaPlatform")
  TrollDoor = level:GetGameObject("TrollDoor")
  LowerWaterMantle = level:GetGameObject("LowerWaterMantle")
  LowerWaterGuide = level:GetGameObject("LowerWaterGuide")
  LowerWaterGuide02 = level:GetGameObject("LowerWaterGuide02")
  ExplodingPotSecret = level:GetGameObject("ExplodingPotSecret")
  local waterFloorSwitch = GameObjects.SwitchFloor1
  if waterFloorSwitch ~= nil and waterFloorSwitch.LuaObjectScript ~= nil then
    waterFloorSwitch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_FloorSwitch_WaterArea_Xpl250")
    waterFloorSwitch.LuaObjectScript.OverideInteractApproachYaw(true)
    waterFloorSwitch.LuaObjectScript.OverrideCameraSubmissionTime(1.8)
  end
  local trollCrank = GameObjects.SwitchFloor
  if trollCrank ~= nil and trollCrank.LuaObjectScript ~= nil then
    trollCrank.LuaObjectScript.OverrideDefaultCameraYaw(true, -163)
    trollCrank.LuaObjectScript.SetCameraApproachPitch(12)
  end
  local secretPullCrank = GameObjects.CrankBlocked
  if secretPullCrank ~= nil and secretPullCrank.LuaObjectScript ~= nil then
    secretPullCrank.LuaObjectScript.OverrideDefaultCameraRecenter(true, secretGateRecenter)
    secretPullCrank.LuaObjectScript.OverrideDefaultCameraYaw(true, 16)
    secretPullCrank.LuaObjectScript.OverrideDefaultCameraPitch(true, 10)
  end
end
function OnStart(level)
  EnableWaterGuide()
  SoundOnStart()
  if PrayEncounter3:WasRunning() then
    PrayEncounter3:Start()
  end
  if Area_6_Encounter_1:WasRunning() then
    Area_6_Encounter_1:Start()
  end
  if Area_6_Encounter_2:WasRunning() then
    Area_6_Encounter_2:Start()
  end
  if Area_6_Encounter_3:WasRunning() then
    Area_6_Encounter_3:Start()
  end
  if Area_6_Encounter_4:WasRunning() then
    Area_6_Encounter_4:Start()
  end
  if Area_6_Encounter_5:WasRunning() then
    Area_6_Encounter_5:Start()
  end
  if Area_6_Encounter_6:WasRunning() then
    Area_6_Encounter_6:Start()
  end
  if Area_7_Encounter_0:WasRunning() then
    Area_7_Encounter_0:Start()
  end
  if game.Wallets.GetResourceValue("HERO", "EntryStoneVikingFuneral") > 0 and 0 >= game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneVikingFuneral") then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneVikingFuneral", 1, "NO_TELEMETRY", "", true)
  end
  local heroStoneCount = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneVikingFuneral")
  local lostStoneCount = game.Wallets.GetResourceValue("LOST_ITEMS", "EntryStoneVikingFuneral")
  if 0 < heroStoneCount then
    GameObjects.keyorb_backup.LuaObjectScript.DisableInteraction()
    GameObjects.keyorb_backup:Hide()
    if 0 < lostStoneCount then
      game.Wallets.RemoveResource("LOST_ITEMS", "EntryStoneVikingFuneral", lostStoneCount)
    end
  elseif 0 < lostStoneCount and Area_7_Encounter_0:IsComplete() then
    GameObjects.keyorb_backup:Show()
    game.Wallets.RemoveResource("LOST_ITEMS", "EntryStoneVikingFuneral", 1)
    GameObjects.keyorb_backup.LuaObjectScript.LuaHook_SpawnLootObject(thisLevel, GameObjects.keyorb_backup, 70)
  else
    GameObjects.keyorb_backup.LuaObjectScript.DisableInteraction()
    GameObjects.keyorb_backup:Hide()
  end
  if GameObjects.CrankBlocked.LuaObjectScript.GetCurrentCycle() == 0 then
    GameObjects.coffin_tier2_xpl250_1.LuaObjectScript.Enable()
  end
  if Area_7_Encounter_0:IsComplete() then
    GameObjects.CA_InvestigateCage.LuaObjectScript.Disable()
  end
  if GameObjects.CrankBlocked.LuaObjectScript.CrankIsEnabled() or GameObjects.CrankBlocked.LuaObjectScript.CrankIsSolved() then
    LD.BreakObject(GameObjects.BoulderBlocker)
    LD.BreakObject(GameObjects.BoulderBlocker1)
    LD.BreakObject(GameObjects.BoulderBlocker2)
  end
  if TrollFound == true then
    GameObjects.CA_InvestigateCage.LuaObjectScript.Disable()
  end
end
function OnFirstStart(level)
  GameObjects.coffin_tier2_xpl250_1.LuaObjectScript.Disable()
end
function KeyOrbSpawned(level, go, spawnedObj)
  print("Spawned new key orb")
  game.Wallets.RemoveResource("LOST_ITEMS", "EntryStoneVikingFuneral", 1)
  spawnedObj:CallScript("LuaHook_SpawnLootObject", 70)
end
function OnUpdate(level)
  if ArenaPlatformRaised == false then
    GameObjects.SwitchFloor.Child.LuaObjectScript.Enable()
  elseif ArenaPlatformRaised == true then
    GameObjects.SwitchFloor.Child.LuaObjectScript.Disable()
    OnUpdate = nil
  end
end
function OnUseWorld(level)
end
function CheckEntryStones()
  if game.Wallets.GetResourceValue("HERO", "EntryStoneVikingFuneral") > 0 then
    game.Wallets.RemoveResource("HERO", "EntryStoneVikingFuneral", 1)
  end
end
function OnSaveCheckpoint(level)
  CheckEntryStones()
  return {
    levelstate = checkpoint.Save(),
    SecretGateRaised = SecretGateRaised,
    ArenaPlatformRaised = ArenaPlatformRaised,
    WaterLowered = WaterLowered,
    WaterCollisionDisabled = WaterCollisionDisabled,
    pedestalUnlocked = pedestalUnlocked,
    caveRubbleCleared = caveRubbleCleared,
    TrollFound = TrollFound,
    SecretBombActive = SecretBombActive
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  SecretGateRaised = savedInfo.SecretGateRaised
  ArenaPlatformRaised = savedInfo.ArenaPlatformRaised
  WaterLowered = savedInfo.WaterLowered
  WaterCollisionDisabled = savedInfo.WaterCollisionDisabled
  pedestalUnlocked = savedInfo.pedestalUnlocked
  caveRubbleCleared = savedInfo.caveRubbleCleared
  SecretBombActive = savedInfo.SecretBombActive
  TrollFound = savedInfo.TrollFound
end
function StoreCheckPoint()
  game.World.StoreCheckpoint()
end
function ToggleEnterObserve()
  if Area_6_Encounter_1:IsRunning() then
    GameObjects.CA_Enter_OnAlert.LuaObjectScript.Enable()
  elseif Area_6_Encounter_1:IsComplete() then
    GameObjects.CA_Observe_Entrance.LuaObjectScript.Enable()
  end
end
function AwardTrophy()
  print("Award Trophy: Death Happened Here")
  game.UnlockTrophy(13)
end
function EnableWaterGuide()
  if WaterLowered == false then
    LowerWaterGuide:ShowCollision()
    LowerWaterGuide02:ShowCollision()
    LowerWaterMantle:HideTraverseLink()
  end
end
function DisableWaterGuide()
  LD.CallFunctionAfterDelay(function()
    LowerWaterGuide:HideCollision()
  end, 2.5)
  LD.CallFunctionAfterDelay(function()
    LowerWaterGuide02:HideCollision()
  end, 7)
  LowerWaterMantle:ShowTraverseLink()
  WaterCollisionDisabled = true
  LD.CallFunctionAfterDelay(function()
    game.World.StoreCheckpoint()
  end, 7.25)
end
function RaiseSecretGate01()
  IntSecretGate:PlayAnimToEnd()
  SecretGateRaised = true
end
function LowerWaterLevel()
  CSL.PlayDefaultShake("GateMovement_Light", 1.2)
  CSL.PlayDefaultShake("WaterMovement", 4.6, 1.2, 0.5)
  timers.StartLevelTimer(6.57, function()
    CSL.PlayDefaultShake("GateLeveled", 0.6, 0.3)
  end)
  Flood:PlayAnimToEnd()
  FloodGate:PlayAnimToEnd()
  PlaySoundFloodGate()
  DisableWaterGuide()
  PlaySoundWaterDrain()
  StopSoundDrainRoomWater()
  WaterLowered = true
  GameObjects.CA_Observe_FloodGate.LuaObjectScript.Enable()
  GameObjects.FloodLead.LuaObjectScript.Enable()
end
function RaiseArenaPlatform()
  CSL.PlayDefaultShake("ElevatorMovementFU_Light", 4.09)
  ArenaPlatform:PlayAnimToEnd()
  Area_7_Encounter_0:AlertEnemies()
  CrankRight:PlayAnimToEnd()
  PlaySoundPlatformLift()
  GameObjects.CA_InvestigateCage.LuaObjectScript.Disable()
  GameObjects.TrollEntranceDoor.LuaObjectScript.Disable()
  ArenaPlatformRaised = true
  timers.StartLevelTimer(4.8, function()
    CSL.PlayDefaultShake("Roar", 2.2, 0.2, 0.5)
  end)
end
function EnableBomb()
  if SecretBoulderDestroyed == false then
    GameObjects.ExplodingPotSecret:FindSingleGOByName("bombBag"):ShowCollision()
  end
end
function DestroySecretBoulder()
  if SecretBoulderDestroyed == false then
    LD.BreakObject(GameObjects.BoulderBlocker)
    LD.BreakObject(GameObjects.BoulderBlocker1)
    LD.BreakObject(GameObjects.BoulderBlocker2)
    GameObjects.CrankBlocked.LuaObjectScript.Enable()
    GameObjects.ToggleWall:HideCollision()
    SecretBoulderDestroyed = true
  end
end
function UnlockTrollDoor()
  GameObjects.TrollExitDoor.LuaObjectScript.Enable()
end
function UnlockSecretCoffin()
  GameObjects.coffin_tier2_xpl250_1.LuaObjectScript.Enable()
  GameObjects.CA_Observe_HiddenGate.LuaObjectScript.Disable()
  CSL.PlayDefaultShake("GateLeveled", 0.6, 0.3)
end
function CaveRubbleCleared()
  caveRubbleCleared = true
end
function EnableCaveLead()
  if caveRubbleCleared == true then
    GameObjects.CaveLead.LuaObjectScript.Enable()
  end
end
function DisableCaveLead()
  GameObjects.CaveLead.LuaObjectScript.Disable()
end
function DisableFloodLead()
  GameObjects.FloodLead.LuaObjectScript.Disable()
end
function TriggerStonePedestalFinished()
  PlaySoundOnTrollExitDoorsOpen()
  TrollDoor:PlayAnimToEnd()
  LD.CallFunctionAfterDelay(function()
    CheckEntryStones()
    GameObjects.TrollExitPedestal.LuaObjectScript.FinishPedestalInteraction()
  end, 3)
end
function EnableSecretBomb()
  if SecretBombActive == false and SecretBoulderDestroyed == false then
    SecretBomb:JumpAnimToFrame(1)
    SecretBombActive = true
  end
end
function DisableSecretBomb()
  if SecretBombActive == true and SecretBoulderDestroyed == false then
    SecretBomb:PlayAnimToEnd(-1)
    SecretBombActive = false
  end
end
function Pray_Fight_3()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  PrayEncounter3 = EC.NewEncounter(thisLevel, "[Area 5]EC:1 Praying Dragon Fight 03 XPL250", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Temple_03"
  })
  PrayEncounter3:AddWave({
    {
      spawners = "E_Fanatic_SPRAY",
      spawnWad = "Xpl200_AI_Exterior01",
      spawnLocators = "A5_U_Loc_1",
      markerID = "PrayFanatic03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "E_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A5_U_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "E_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A5_U_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    }
  })
  PrayEncounter3:SetStartZone(GameObjects.SpawnAIZone_Gravesite_3)
  PrayEncounter3:SetAlertZone(GameObjects.SpawnAIZone_Gravesite_Alert_3)
  PrayEncounter3ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("SpawnAIZone_Gravesite_Alert_3"))
  PrayEncounter3:OnEnemySpawn(Health_Encounter3, {
    markerID = "PrayFanatic03"
  })
  PrayEncounter3ZoneMonitor:OnEnter(function()
    PrayEncounter3:AlertEnemies()
  end)
  PrayEncounter3ZoneMonitor:SetTriggerCountLimit(1)
end
function DespawnPray3Encounter()
  if PrayEncounter3 ~= nil and not PrayEncounter3:IsComplete() then
    PrayEncounter3:DespawnEnemies()
    PrayEncounter3:Reset()
    PrayEncounter3:Stop()
  end
end
function Health_Encounter3(Enemy)
  if Enemy ~= nil then
    FF_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local EnemyHealth = Enemy:GetHitPoints()
    FF_HealthMonitor:OnHealthLessThan(EnemyHealth, AlertPrayingSite03)
  end
end
function AlertPrayingSite03()
  PrayEncounter3:AlertEnemies()
end
function TempleHelwalkersCheckpoint()
  if Area_6_Encounter_1:IsComplete() and Area_6_Encounter_2:IsComplete() and Area_6_Encounter_3:IsComplete() and Area_6_Encounter_4:IsComplete() then
    game.World.StoreCheckpoint()
  end
end
function Area_6_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  Area_6_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 Helwalker Ambush inside Temple 01 XPL250", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Temple_01"
  })
  Area_6_Encounter_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Bandit_L3_SH_BARR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A6_O_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_L3_SH_BARR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A6_O_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Area_6_Encounter_1:SetStartZone(GameObjects.EntZn_Ambush_Spawn_1)
  Area_6_Encounter_1:OnComplete(TempleHelwalkersCheckpoint)
end
function Area_6_Fight_2()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  Area_6_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 Helwalker Ambush inside Temple 02 XPL250", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Temple_01"
  })
  Area_6_Encounter_2:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Bandit_S_AMBSH2",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A6_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_UNAWARE",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A6_O_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_6_Encounter_2:SetStartZone(GameObjects.EntZn_Ambush_Spawn_2)
  Area_6_Encounter_2:OnComplete(TempleHelwalkersCheckpoint)
end
function Area_6_Fight_3()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  Area_6_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 Helwalker Patrol inside Temple 03 XPL250", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Temple_01"
  })
  Area_6_Encounter_3:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Bandit_S_PATROL",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A6_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_6_Encounter_3:SetStartZone(GameObjects.EntZn_Patrol_Spawn)
  Area_6_Encounter_3:OnComplete(TempleHelwalkersCheckpoint)
  Area_6_Encounter_3:OnComplete(Area_6_Encounter_3_Complete)
end
function Area_6_Encounter_3_Complete()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("VFuneral_CastleImpressed")
  end, 5)
end
function Area_6_Fight_4()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  Area_6_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 Helwalker Ambush 2 Temple 04 XPL250", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Temple_01"
  })
  Area_6_Encounter_4:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Bandit_S_AMBSH1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A6_O_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_6_Encounter_4:SetStartZone(GameObjects.EntZn_Jump_Spawn)
  Area_6_Encounter_4:OnComplete(TempleHelwalkersCheckpoint)
end
function Area_6_Fight_5()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  Area_6_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 CRAWLER FIGHT", {
    CheckpointOnComplete = false,
    LeashZone = "NavLeashing_Temple_02"
  })
  Area_6_Encounter_5:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Crawler_N_S",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A7_O_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Crawler_N_S",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A7_O_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_6_Encounter_5:SetStartZone(GameObjects.EntZn_Crawlers_Spawn)
  Area_6_Encounter_5:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Spitter")
  end)
end
function Area_6_Fight_6()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_6_Encounter_6 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 Shield Fight Front Door XPL200", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeashing_Temple_04"
  })
  Area_6_Encounter_6:AddWave({
    {
      spawners = "Bandit_SS_DEFP",
      spawnWad = "Xpl250_AI_Interior01",
      spawnLocators = "A7_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Bandit_SS_DEFP",
      spawnWad = "Xpl250_AI_Interior01",
      spawnLocators = "A7_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4,
      powerLevel = powerLevel02
    },
    {
      spawners = "Fanatic_Turret",
      spawnWad = "Xpl250_AI_Interior01",
      spawnLocators = "A7_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    }
  })
  Area_6_Encounter_6:SetStartZone(GameObjects.EntZn_DoorGuardians_Spawn)
  GuardianEncounterZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_DoorGuardians_Alert"))
  GuardianEncounterZoneMonitor:OnEnter(function()
    Area_6_Encounter_6:AlertEnemies()
  end)
  GuardianEncounterZoneMonitor:SetTriggerCountLimit(1)
end
function Area_7_Fight_0()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber then
    powerLevel = 5
  end
  Area_7_Encounter_0 = EC.NewEncounter(thisLevel, "[Area 7]EC:1 Caged Troll XPL250", {CheckpointOnComplete = true})
  Area_7_Encounter_0:AddWave({
    {
      spawners = "Troll_F_PRAY",
      spawnWad = "Xpl250_AI_Interior01",
      markerID = "Troll_Catacomb",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Area_7_Encounter_0:SetStartZone(thisLevel:GetGameObject("EntZn_Catacombs_Enc_Spawn"))
  Area_7_Encounter_0:OnEnemySpawn(audioTrollVariation, {
    markerID = "Troll_Catacomb"
  })
  Area_7_Encounter_0:OnCombatStart(function()
    LD.StartCombatMusic("SND_MX_XPL200_troll_fight_in", "SND_MX_XPL200_troll_fight_out")
  end)
  Area_7_Encounter_0:OnEnemyDeath(trollDeathMus, {
    markerID = "Troll_Catacomb"
  })
  Area_7_Encounter_0:OnComplete(Area_7_Encounter_1_Complete)
end
function Area_7_Fight_1()
  Area_7_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 7]EC:1 Caged Helwalkers XPL250", {CheckpointOnComplete = false})
  Area_7_Encounter_1:AddWave({
    {
      spawners = "H_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A8_O_Loc_0",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "H_Bandit_SDBR1",
      spawnWad = "Xpl200_AI_Persist",
      spawnLocators = "A8_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_7_Encounter_1:OnComplete(Area_7_Encounter_1_Complete)
end
function Area_7_Encounter_1_Complete()
  GameObjects.TrollEntranceDoor.LuaObjectScript.Enable()
  pedestalUnlocked = true
  local ProgressValue = LD.GetEntityVariable("FUNERAL_ProgressCounter")
  game.Level.SetVariable("FUNERAL_TrollKilled", true)
  game.Audio.PlayBanter("VFuneral_CastleTrollKilled")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Daudi_Hamarr")
end
function Banter_CastleImpressed()
  game.Audio.PlayBanter("VFuneral_CastleImpressed")
end
function PlayTrollFound()
  if TrollFound == false then
    GameObjects.CA_InvestigateCage.LuaObjectScript.Enable()
    game.Audio.PlayBanter("VFuneral_CastleTrollFound", EnableTrollSwitch)
    TrollFound = true
  end
end
function EnableTrollSwitch()
  GameObjects.CA_InvestigateCage.LuaObjectScript.Disable()
end
local SNDWaterDrain, SNDPlatform, SNDGrate, SNDFloodGate
local floodGateOverrides = {
  OnForward = "SND_MECH_Water_Door_Xpl200_Door_Lift_Up_LP",
  OnBackward = "SND_MECH_Water_Door_Xpl200_Door_Lift_Down_LP",
  OnFastForward = "SND_MECH_Water_Door_Xpl200_Door_Lift_Up_LP",
  OnRewind = "SND_MECH_Water_Door_Xpl200_Door_Lift_Down_LP",
  OnEnd = "SND_MECH_Water_Door_Xpl200_Door_Stop_Top"
}
local crankGate_LineCrankOverrides = {
  OnForward = "SND_MECH_Block_Push_Crystal_Cart_LP",
  OnBackward = "SND_MECH_Block_Push_Crystal_Cart_LP",
  OnFastForward = "SND_MECH_Block_Push_Crystal_Cart_LP"
}
local crankGate_GateDrivenObjectOverrides = {
  SoundEmitter = nil,
  UseExplicitSoundMotion = true,
  OnStart = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Down",
  OnStartFrame = 1,
  OnReturnToStart = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling",
  OnForward = "SND_DOOR_Metal_Lift_Gate_Forest_LP",
  OnBackward = "SND_DOOR_Metal_Lift_Gate_Forest_LP",
  OnFastForward = "SND_DOOR_Metal_Lift_Gate_Forest_LP",
  OnStartFromEnd = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up",
  OnEnd = "SND_MECH_Metal_Gate_Lift_Stop_Ground"
}
local OverrideWoodDoorEvents = {
  isLooping = false,
  OnInteractForward_Center = "",
  OnInteractForward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractForward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractBackward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R"
}
function SoundOnStart()
  GameObjects.SpreadDoor_Rock6m.LuaObjectScript.SoundSetup(OverrideWoodDoorEvents)
  SNDWaterDrain = GameObjects.SNDWaterDrainGrp.SoundEmitters[1]
  SNDPlatform = GameObjects.ArenaPlatform.SoundEmitters[1]
  SNDGrate = GameObjects.SNDGrate.SoundEmitters[1]
  GameObjects.QuestLoreMarker:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
  SNDFloodGate = GameObjects.FloodGate:FindSingleSoundEmitterByName("SNDFloodGate")
  crankGate_GateDrivenObjectOverrides.SoundEmitter = GameObjects.IntSecretGate:FindSingleSoundEmitterByName("SNDCrankGate")
  GameObjects.IntSecretGate:FindSingleGOByName("CrankBlocked").Child.LuaObjectScript.CrankSoundSetup(crankGate_LineCrankOverrides)
  GameObjects.IntSecretGate:FindSingleGOByName("CrankBlocked").Child.LuaObjectScript.DrivenObjectSoundSetup(crankGate_GateDrivenObjectOverrides)
  if WaterLowered then
    StopSoundDrainRoomWater()
    if FloodGate.AnimFrame > 0 and FloodGate.AnimFrame < FloodGate.AnimLengthFrames then
      PlaySoundFloodGate()
      LD.CallFunctionAfterDelay(PlaySoundWaterDrain, 0.1)
    end
  end
end
function PlayPauseSoundOnGate()
  LD.PlaySound(crankGate_GateDrivenObjectOverrides.SoundEmitter, "SND_MECH_Metal_Gate_Lift_Stop_Midway")
end
function PlaySoundWaterDrain()
  LD.PlaySound(SNDWaterDrain, "SND_MECH_Water_Door_Xpl200_Drain_Water")
end
function PlaySoundOnTrollExitDoorsOpen()
  LD.PlaySound(GameObjects.TrollDoor:FindSingleSoundEmitterByName("SNDTrollExitDoor_Left"), "SND_DOOR_HTTK_StoneKey_Puzzle_Opening_L")
  LD.PlaySound(GameObjects.TrollDoor:FindSingleSoundEmitterByName("SNDTrollExitDoor_Right"), "SND_DOOR_HTTK_StoneKey_Puzzle_Opening_R")
end
function PlaySoundFloodGate()
  LD.PlaySound(SNDFloodGate, floodGateOverrides.OnForward)
  LD.StopSoundOnFrame(SNDFloodGate, GameObjects.FloodGate, floodGateOverrides.OnForward, 210)
  LD.PlaySoundOnFrame(SNDFloodGate, GameObjects.FloodGate, floodGateOverrides.OnEnd, 205)
end
function PlaySoundPlatformLift()
  LD.PlaySoundOnFrame(SNDGrate, CrankRight, "SND_MECH_Center_Room_Lift_Drop_LP_Xpl200", 0)
  LD.StopSoundOnFrame(SNDGrate, CrankRight, "SND_MECH_Center_Room_Lift_Drop_LP_Xpl200", 90)
  LD.PlaySoundOnFrame(SNDPlatform, ArenaPlatform, "SND_MECH_Center_Room_Lift_Stone_LP_Xpl200", 0)
  LD.StopSoundOnFrame(SNDPlatform, ArenaPlatform, "SND_MECH_Center_Room_Lift_Stone_LP_Xpl200", 120)
end
function StopSoundDrainRoomWater()
  GameObjects.SNDGrpDrainRoomWater:Hide()
end
function TrollDoorMusic()
  if TrollFound == false then
    game.Audio.StartMusic("SND_MX_XPL200_troll_arena")
  end
end
function audioTrollVariation(Enemy)
  game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_08")
end
local xpl250TrollDead = false
function trollDeathMus()
  if xpl250TrollDead == false then
    LD.StopCombatMusic()
    xpl250TrollDead = true
  end
end
