local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, player, kraActor, sonActor, whetstoneProp
local playedCine = false
local seq
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if not playedCine then
    SetupActors()
    local cineObj = GameObjects.Cine_SindriQuest2
    cineObj:ShowEntityVolume()
    local entityZoneScript = cineObj:FindSingleGOByName("EntityZoneEvents").Child.LuaObjectScript
    entityZoneScript.SetEntryTriggerLimit(-1)
    entityZoneScript.EnableEntryTriggers()
  end
  SetupProps()
end
function CompleteObjective()
  game.QuestManager.ProposeQuestState("Quest_Sindri_Epic_02_Objective_04", "Complete")
end
function TempAudio()
end
function OnSaveCheckpoint(level, obj)
  return {playedCine = playedCine}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedCine = savedInfo.playedCine
end
function SetupActors()
  kraActor = actor.Actor.New("SINDRI QUEST II: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SINDRI QUEST II: Son Actor", game.AI.FindSon)
end
function SetupProps()
  whetstoneProp = GameObjects.whetstoneProp.Child
  whetstoneProp:StartAnimation({
    Animation = "narCalSindriQuest2000CineScene"
  })
  whetstoneProp:JumpAnimationToFrame(0)
  whetstoneProp:PauseAnimation()
  HideProps()
end
function HideProps()
  whetstoneProp:Hide()
end
function ShowProps()
  whetstoneProp:Show()
end
function SetupSeq()
  seq = LD.CreateCineSequence(thisLevel, thisObj, "SindriQuest2")
  local slaveTab = {
    {Actor = sonActor},
    {
      Obj = whetstoneProp,
      Anim = "narCalSindriQuest2000CineScene"
    }
  }
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_XPL850_start_master")
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Buddy_Drop_5m_1Way")
  end)
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_XPL300_start_master")
  seq:Do(function()
    seq:MarkAbleToSkip()
  end)
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(ShowProps)
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_SindriQuest2",
    ReferenceJoint = "SindriQuest2_SynchJoint"
  })
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:Do(HideProps)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(function()
    playedCine = true
  end)
  seq:Do(CompleteObjective)
  seq:Do(StoreCineCheckpoint)
  seq:StartSequence()
end
function TravellerAttackStart()
  if seq ~= nil then
    seq:EndSkipIfActive()
  end
end
function StoreCineCheckpoint()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.CheckpointOverride_SindriQuest2.Child
  })
end
