local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisObj, TP_climb, collisionManager, animMonitor, breakable, soundEmitter, ropeEmitter, tempHookEmitter
local hookSounds = {
  OnBreak = "SND_MECH_Pulley_Hoist_BRK_Link_Break"
}
local blockSounds = {
  Idle = "SND_MECH_Pulley_Hoist_Rope_Creak_LP_Xpl300",
  OnImpact = "SND_MECH_Pulley_Hoist_BRK_Ground_Impact",
  OnImpactAnimFrame = 15
}
function OnScriptLoaded(level, obj)
  thisObj = obj
  TP_climb = thisObj:FindSingleGOByName("TL_Climb")
  breakable = thisObj:FindSingleGOByName("Breakable")
  collisionManager = thisObj:FindSingleGOByName("CombatCollisionManager2")
  collisionManager.LuaObjectScript.ChangeCombatCollisionType("XPL300_Drop_Block")
  SoundInit()
  game.SubObject.Sleep(thisObj)
end
function OnFirstStart(level, obj)
  TP_climb:HideTraverseLink()
  collisionManager.LuaObjectScript.Disable()
end
function OnStart()
  SoundOnStart()
  LD.PlaySound(ropeEmitter, blockSounds.Idle)
end
function BreakBlock()
  breakable:GetBreakable():Break()
  thisObj:PlayAnimToEnd()
  collisionManager.LuaObjectScript.Enable()
  animMonitor = monitors.CreateAnimFrameMonitor(thisObj)
  animMonitor:OnFrameForward(15, GroundImpact)
  LD.PlaySound(tempHookEmitter, hookSounds.OnBreak)
  LD.StopSound(ropeEmitter, blockSounds.Idle)
end
function GroundImpact()
  animMonitor = nil
  TP_climb:ShowTraverseLink()
  collisionManager.LuaObjectScript.Disable()
  LD.PlaySound(soundEmitter, blockSounds.OnImpact)
  game.World.StoreCheckpoint()
end
function SoundInit()
  ropeEmitter = thisObj:FindSingleSoundEmitterByName("SNDRope")
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDBlock")
  tempHookEmitter = thisObj:FindSingleSoundEmitterByName("SNDHook")
end
function SoundOnStart()
  local hookObj = thisObj:FindSingleGOByName("sHook")
  if hookObj ~= nil and hookObj.LuaObjectScript ~= nil then
    hookObj.LuaObjectScript.SoundSetup(hookSounds)
  end
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(blockSounds) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          blockSounds[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(blockSounds[key]))
    end
  end
end
