local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local son
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  SoundInit()
end
function OnPreStart(level, obj)
  QuestStoneFixUp()
end
function QuestStoneFixUp()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_02_Objective_01")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra3")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra3", 1)
  end
end
function OpenHuldra3Door()
  GameObjects.huldraDoor_mossFrame1.Child:PlayAnimToEnd()
  PlaySoundDoorUnlock()
  HuldraDoorShakeRumble()
  LD.CallFunctionAfterDelay(function()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end, 6)
end
function NoKeyBanter()
  if game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra3") == -1 then
    game.Audio.PlayBanterNonCritical("Son_NoKey_Banter")
  end
end
function HuldraDoorShakeRumble()
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_SMALL",
    Duration = 8,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 1}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 9,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5}
  })
  timers.StartLevelTimer(1.66, function()
    RumbleShakeHit(2)
  end)
  timers.StartLevelTimer(3.2, function()
    RumbleShakeHit(4)
  end)
  timers.StartLevelTimer(9, function()
    RumbleShakeHit(9)
  end)
end
function RumbleShakeHit(effectPriority)
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_STRONG",
    Duration = 0.5,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5},
    Priority = effectPriority
  })
end
function SetBoatContext()
  son:CallScript("EnterBehaviorContext", "BOAT_CONTEXT_CONFIG_RIGHT")
end
function LoadCheck_xpl300()
  game.UI.LoadCheck("xpl300_Stronghold")
end
function LoadCheck_cal200()
  game.UI.LoadCheck("Cal200_Shore")
end
function LoadCheck_cal100()
  game.UI.LoadCheck("Cal100_Hub")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
local SNDHuldraDoor, SNDDoorLeft, SNDDoorRight, SNDDoorWtrSplsh
function SoundInit()
  SNDHuldraDoor = GameObjects.huldraDoor_mossFrame1.Child:FindSingleSoundEmitterByName("SNDHuldra_Mine_Door")
  SNDDoorLeft = GameObjects.huldraDoor_mossFrame1.Child:FindSingleSoundEmitterByName("SNDHuldraDoorLeft")
  SNDDoorRight = GameObjects.huldraDoor_mossFrame1.Child:FindSingleSoundEmitterByName("SNDHuldraDoorRight")
  SNDDoorWtrSplsh = GameObjects.huldraDoor_mossFrame1.Child:FindSingleSoundEmitterByName("SNDHuldra_Mine_Door_WtrSplsh")
end
function PlaySoundDoorUnlock()
  LD.PlaySound(SNDHuldraDoor, "SND_DOOR_Stone_HuldraMine_Double_Door_Unlock")
  LD.PlaySoundOnFrame(SNDDoorLeft, GameObjects.huldraDoor_mossFrame1.Child, "SND_DOOR_Stone_HuldraMine_Double_Door_Open_Seq_L", 120)
  LD.PlaySoundOnFrame(SNDDoorRight, GameObjects.huldraDoor_mossFrame1.Child, "SND_DOOR_Stone_HuldraMine_Double_Door_Open_Seq_R", 120)
  LD.PlaySoundOnFrame(SNDDoorWtrSplsh, GameObjects.huldraDoor_mossFrame1.Child, "SND_AMB_EMIT_WTR_Stream_Fast_LP_Xpl300", 124)
  LD.StopSoundOnFrame(SNDDoorWtrSplsh, GameObjects.huldraDoor_mossFrame1.Child, "SND_AMB_EMIT_WTR_Stream_Fast_LP_Xpl300", 270)
end
