local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, golActor, golObj, gateProp
local playedCine = false
local cine_lights_900, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_900_BrokQuest1", 6, nil)
  cameraCineEnter:SetObjectToSleep(obj)
end
function OnStart(level, obj)
  cine_lights_900 = GameObjects.Cine_Start_900
  if not playedCine then
    SpawnGolem()
    SetupActors()
    SetupGolemIdle()
    SetupCineLights()
  else
    HideNoGoZone()
    HideCineLights()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  return {played = playedCine}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedCine = savedInfo.played
end
function SpawnGolem()
  local jointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex("Golem_StartJoint"))
  local jointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("Golem_StartJoint"))
  if golObj == nil then
    golObj = game.AI.Spawn(thisLevel, jointPos, jointFace, "CRT_Golem10", "BRA_BrokQuest1Idle", {
      BodyType = "Woodland_v1"
    }, "woodland_moderate")
  end
end
function GetGolem()
  return golObj
end
function SetupActors()
  kraActor = actor.Actor.New("KRATOS ACTOR: BROK QUEST 1", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SON ACTOR: BROK QUEST 1", game.AI.FindSon)
  golActor = actor.Actor.New("GOLEM ACTOR: BROK QUEST 1", GetGolem)
  gateProp = GameObjects.Transport_LiftGate.Child
end
function SetupGolemIdle()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "BrokQuest1 Idle")
  seq:ActorSync(golActor, {
    Branch = "BRA_BrokQuest1Idle",
    ReferenceJoint = "BrokQuest1_SynchJoint"
  })
  seq:StartSequence()
end
function SetupSequence()
  if not playedCine then
    local cineSeq = ND.CreateCineSequence(thisLevel, thisObj, "BrokQuest1 Sequence")
    local slaveTab = {
      {Actor = sonActor},
      {Actor = golActor},
      {
        Obj = gateProp,
        Anim = "900_BrokQuest1"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_xpl400_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:Do(StartPreCineCamera)
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_BrokQuest1",
      ReferenceJoint = "BrokQuest1_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.ArrivalRadius,
      weapon_state = "axe"
    })
    cineSeq:Do(HideNoGoZone)
    cineSeq:Do(PlayCineLights)
    cineSeq:ActorSync(kraActor, {
      Slaves = slaveTab,
      Branch = "BRA_BrokQuest1",
      ReferenceJoint = "BrokQuest1_SynchJoint"
    })
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.9)
    cineSeq:Do(function()
      cineSeq:SetMaxSkipSpeedup(2)
    end)
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:DespawnActor(golActor)
    cineSeq:Do(HideCineLights)
    cineSeq:Do(function()
      playedCine = true
    end)
    cineSeq:Do(SetBanterFact)
    cineSeq:Do(game.World.StoreCheckpoint)
    cineSeq:StartSequence()
  end
end
function SetBanterFact()
  game.Audio.SetBanterFact("SoulEaterIntroComplete", "True")
end
function StartPreCineCamera()
  cameraCineEnter:Start()
end
function HideNoGoZone()
  thisObj:FindSingleGOByName("NoGoZone"):Hide()
end
function SetupCineLights()
  cine_lights_900:Show()
  cine_lights_900:JumpAnimToFrame(0)
  cine_lights_900:PauseAnim()
end
function PlayCineLights()
  cine_lights_900:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_900:Hide()
  cine_lights_900:HideLights()
end
