LD = require("design.LevelDesignLibrary")
timers = require("level.timer")
local EC = require("design.Encounter")
monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
thisLevel = nil
player = nil
son = nil
UpperMinesMonitor = nil
LowerMinesMonitor = nil
TransportMonitor = nil
QuestRoomMonitor = nil
ZM_A1_E1_AlertA = nil
ZM_A1_E1_AlertB = nil
Draugr_HealthMonitor = nil
EnemyLookatMonitor = nil
EntranceEncounter01 = nil
TransportEncounter01 = nil
TransportEncounter02 = nil
UpperMinesEncounter01 = nil
LowerMinesEncounter01 = nil
QuestRoomEncounter01 = nil
QuestRoomEncounter02 = nil
QuestRoomEncounter03 = nil
UpperMinesEncounterZone = nil
LowerMinesEncounterZone = nil
TransportEncounterZone = nil
QuestRoomEncounterZone = nil
EntranceEncounter01Started = false
EntranceEncounter01Complete = false
TransportEncounter01Complete = false
UpperMinesEncounter01Complete = false
LowerMinesEncounter01Complete = false
QuestRoomEncounter01Complete = false
Area_3_Encounter_1_Complete = false
TrollArmDestroyed = false
TrollLegDestroyed = false
TrollPhase02Check = false
local trollGO
GolemSeen = false
enemiesKilled = 0
QuestRoom_TraverseLinks = nil
Entrance_DraugrSpawn = nil
Entrance_ChestDraugrZone = nil
E_HealthMonitor = nil
ZM_A1_E2_Spawn = nil
local Area_0_Encounter_1, Area_1_Encounter_1, Area_1_Encounter_2, Repop_A1E1, Area_2_Encounter_1, Area_3_Encounter_1, Area_3_Encounter_2, Repop_A3E1, Area_4_Encounter_1, Fake_Golem_Encounter_1, Area_5_Encounter_1, Area_5_Encounter_2, Area_6_Encounter_1, Area_7_Encounter_1, ZM_A7_E1_Start2
function OnFirstStart(level)
  GameObjects.EntZnArea3Encounter1:Hide()
end
function OnStart(level)
  if Fake_Golem_Encounter_1:WasRunning() then
    Fake_Golem_Encounter_1:Start()
  end
  if Area_1_Encounter_1:WasRunning() then
    Area_1_Encounter_1:Start()
  end
  if Area_3_Encounter_1:WasRunning() then
    Area_3_Encounter_1:Start()
  end
end
local Area_0_Fight_1 = function()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC:1 Gate Way Fight XPL400", {CheckpointOnComplete = true, spawnWad = "Xpl400_AI"})
  Area_0_Encounter_1:AddWave({
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "A0_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "A0_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3
    },
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "A0_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3.5
    }
  })
  Area_0_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_0_Encounter_Attack"))
end
local Area_1_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Fight XPL400", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_FirstFight"
  })
  Area_1_Encounter_1:AddWave({
    timeBeforeNextWave = 2,
    powerLevel = powerLevel,
    {
      spawners = "T2_Flyer_POS_Imm_SFG",
      spawnLocators = "B1_Loc_O_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "L_Draugr_N_SFG",
      spawnLocators = "A1_Loc_O_10",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_1_Encounter_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Draugr_PT_SFG",
      spawnLocators = "A1_Loc_O_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "T2_Flyer_POS_Imm_SFG",
      spawnLocators = "A1_Loc_O_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "L_Draugr_N_SFG",
      spawnLocators = "A1_Loc_O_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  Area_1_Encounter_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "T2_Flyer_POS_Imm_SFG",
      spawnLocators = "B1_Loc_O_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "LVL2_Draugr_SW_SRFE",
      spawnLocators = "A1_Loc_PT_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "LVL2_Draugr_SW_SRFE",
      spawnLocators = "A1_Loc_PT_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_AlertA1E1A"))
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(3)
  end, {count = 4})
  Area_1_Encounter_1:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl400_HuldraMines")
    thisLevel:CallScript("SetRoom1EncounterComplete")
  end)
end
local Area_1_Fight_2 = function()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Return Fight XPL400", {CheckpointOnComplete = true, spawnWad = "Xpl400_AI"})
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Witch_N_S",
      spawnLocators = "A1_Loc_O_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Witch_N_S",
      spawnLocators = "A1_Loc_O_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.1
    },
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "A1_Loc_O_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 6
    }
  })
  GameObjects.EntZn_Arena_1_Encounter_Spawn_2:HideEntityVolume()
  ZM_A1_E2_Spawn = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Arena_1_Encounter_Spawn_2"))
  ZM_A1_E2_Spawn:OnEnter(function()
    GameObjects.EntZn_Arena_1_Encounter_Spawn_2:ShowEntityVolume()
  end)
  Area_1_Encounter_2:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_1_Encounter_Attack_2"))
end
function Alert_Area_2()
  Area_2_Encounter_1:AlertEnemies()
end
local Area_2_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 5
  elseif 600 <= cineNumber then
    powerLevel = 6
  end
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Cave Exit Fight XPL400", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_Main"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Witch_N_S",
      spawnLocators = "A2_Loc_C_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.3, 0.5},
      powerLevel = powerLevel
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZnA2EncounterSpawn"))
  Area_2_Encounter_1:OnStart(function()
    GameObjects.UpperCrawler01.LuaObjectScript:Disable()
  end)
  Area_2_Encounter_1:OnComplete(function()
    _G.Brok1_BodyBanterReminder()
    local thisLevel = game.FindLevel("Xpl400_HuldraMines")
    thisLevel:CallScript("SetWitchEncounterComplete")
  end)
end
function Alert_Area_3()
  Area_3_Encounter_1:AlertEnemies()
end
function Start_Area_3()
  Area_3_Encounter_1:Start()
end
local Area_3_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:1 Pit Fight", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_Main"
  })
  Area_3_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    timeBeforeNextWave = 0.1,
    powerLevel = powerLevel,
    {
      spawners = "Flyer_POS_Imm_SFG",
      spawnLocators = "A3_Loc_O_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_POS_Imm_SFG",
      spawnLocators = "A3_Loc_O_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.6
    }
  })
  Area_3_Encounter_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "A3_Loc_O_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "LVL2_Draugr_N_SFG",
      spawnLocators = "A3_Loc_O_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 6
    }
  })
  Area_3_Encounter_1:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "LVL2_Draugr_PT_SFG",
      spawnLocators = "A3_Loc_AP_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Area_3_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {3, 25},
    powerLevel = powerLevel,
    {
      spawners = "LVL2_DW_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "LVL2_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Area_3_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {3, 25},
    powerLevel = powerLevel,
    {
      spawners = "LVL2_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "LVL2_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    }
  })
  Area_3_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZnArea3Encounter1"))
  Area_3_Encounter_1:OnEnemyDeath(function()
    Area_3_Encounter_1:StartWave(3)
  end, {count = 3})
  Area_3_Encounter_1:OnEnemyDeath(function()
    Area_3_Encounter_1:StartWave(5)
  end, {count = 6})
  Area_3_Encounter_1:OnStart(function()
    GameObjects.EntZn_Arena_3_Encounter2:Show()
  end)
  Area_3_Encounter_1:OnComplete(function()
    Area_3_Encounter_1_Complete = true
  end)
end
local Area_4_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Cave Exit Flyers", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_Main"
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Flyer_POS_SFG",
      spawnLocators = "A4_Loc_O_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.5,
      powerLevel = powerLevel
    }
  })
  Area_4_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_4_Encounter_Attack"))
end
function Spawm_Area_5()
  Fake_Golem_Encounter_1:Start()
end
local Area_5_Health_Encounter = function(Enemy)
  if Enemy ~= nil then
    local Enemy_Health = Enemy:GetHitPoints()
    E_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Phase_1 = Enemy_Health * 0.6
    local Phase_2 = Enemy_Health * 0.25
    E_HealthMonitor:OnHealthLessThan(Phase_1, function()
      Area_5_Encounter_2:Start()
    end)
    E_HealthMonitor:OnHealthLessThan(Phase_2, function()
      Area_5_Encounter_2:StartWave()
    end)
  end
end
local Fake_Golem_Spawn = function()
  Fake_Golem_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 5]Fake Golem Encounter", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl400_HuldraMines"
  })
  Fake_Golem_Encounter_1:AddWave({
    {
      spawners = "Golem_Fake",
      markerID = "FakeGolem",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Fake_Golem_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZnA5_EncounterSpawn"))
  Fake_Golem_Encounter_1:OnEnemySpawn(StartPatrol, {markerID = "FakeGolem"})
end
function StartPatrol(enemy)
  if GolemSeen == true then
    LD.CallFunctionAfterDelay(function()
      enemy:ForceMove("BRA_SpawnToPatrol")
    end, 1)
  end
end
local Area_5_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 5
  elseif 600 <= cineNumber then
    powerLevel = 6
  end
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 5]EC:1 Fight XPL400", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_XPL400_miniboss_fight_in",
    StopMusic = "SND_MX_XPL400_miniboss_fight_out"
  })
  Area_5_Encounter_1:AddWave({
    {
      spawners = "Golem_S",
      markerID = "Golem",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Area_5_Encounter_1:OnEnemySpawn(Area_5_Health_Encounter, {markerID = "Golem"})
  Area_5_Encounter_1:OnStart(function()
    Fake_Golem_Encounter_1:DespawnEnemies(1)
  end)
  Area_5_Encounter_1:SetStartZone(GameObjects.EntZn_SwapGolem)
  Area_5_Encounter_1:OnEnemyDeath(CompleteQuestEarly, {markerID = "Golem"})
  Area_5_Encounter_1:OnComplete(CompleteObjective)
  Area_5_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_SoulEater")
    local thisLevel = game.FindLevel("Xpl400_HuldraMines")
    thisLevel:CallScript("SetGolemEncounterComplete")
  end)
end
local Area_5_Fight_2 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 4
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 5
  elseif 600 <= cineNumber then
    powerLevel = 6
  end
  Area_5_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 5]EC:2 Fight XPL400", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_XPL400_miniboss_fight_in",
    StopMusic = "SND_MX_XPL400_miniboss_fight_out"
  })
  Area_5_Encounter_2:AddWave({
    {
      spawners = "L_Draugr_N_SFG",
      spawnWad = "Xpl400_AI",
      spawnLocators = "A5_Loc_B_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Area_5_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "LVL2_L_Draugr_N_SFG",
      spawnWad = "Xpl400_AI",
      spawnLocators = "A5_Loc_O_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
end
local Area_6_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  Area_6_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 6]EC:1 Zipline Fight XPL400", {CheckpointOnComplete = true, spawnWad = "Xpl400_AI"})
  Area_6_Encounter_1:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "LVL2_Draugr_L_SFG",
      spawnLocators = "A6_Loc_O_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_POS_Imm_SFG",
      spawnLocators = "A6_Loc_O_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.4
    },
    {
      spawners = "Flyer_POS_Imm_SFG",
      spawnLocators = "A6_Loc_O_4",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1
    }
  })
  Area_6_Encounter_1:AddWave({
    {
      spawners = "LVL2_Draugr_L_SFG",
      spawnLocators = "A6_Loc_O_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.1,
      powerLevel = powerLevel
    }
  })
  Area_6_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_6_Encounter_Spawn"))
end
local Area_7_Fight_1 = function()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  Area_7_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 7]EC:1 Exit Fight XPL400", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_LastFight"
  })
  Area_7_Encounter_1:AddWave({
    {
      spawners = "LVL2_Draugr_SH_Patrol",
      spawnLocators = "A7_Loc_O_3",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Area_7_Encounter_1:AddWave({
    {
      spawners = "LVL2_Draugr_PT_SFG",
      spawnLocators = "A7_Loc_O_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0,
      powerLevel = powerLevel
    },
    {
      spawners = "LVL2_Draugr_PT_SFG",
      spawnLocators = "A7_Loc_O_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.8,
      powerLevel = powerLevel
    }
  })
  Area_7_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_7_Encounter_Spawn1"))
  ZM_A7_E1_Start2 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Arena_7_Encounter_Spawn2)
  ZM_A7_E1_Start2:OnEnter(function()
    Area_7_Encounter_1:StartWave(2)
  end)
end
local Repop_Area_1_Fight_1 = function()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 5
    powerLevel02 = 6
  elseif 600 <= cineNumber then
    powerLevel01 = 6
    powerLevel02 = 7
  end
  Repop_A1E1 = EC.NewEncounter(thisLevel, "[Repop Area 1]EC:1 Fight XPL400", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_FirstFight",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:1 Fight XPL400",
      "[Area 5]EC:1 Fight XPL400"
    }
  })
  Repop_A1E1:AddWave({
    timeBeforeNextWave = 2,
    {
      spawners = "LVL4_L_Draugr_N_SFG",
      spawnLocators = "B1_Loc_O_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "LVL4_L_Draugr_N_SFG",
      spawnLocators = "A1_Loc_O_10",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = powerLevel01
    }
  })
  Repop_A1E1:AddWave({
    {
      spawners = "T4_Flyer_POS_Imm_SFG",
      spawnLocators = "A1_Loc_O_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "LVL4_L_Draugr_N_SFG",
      spawnLocators = "A1_Loc_O_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4,
      powerLevel = powerLevel01
    }
  })
  Repop_A1E1:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "T4_Flyer_POS_Imm_SFG",
      spawnLocators = "B1_Loc_O_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "LVL4_Draugr_SW_SRFE",
      spawnLocators = "A1_Loc_E_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "LVL4_Draugr_SW_SRFE",
      spawnLocators = "A1_Loc_PT_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = powerLevel02
    }
  })
  Repop_A1E1:SetStartZone(thisLevel:GetGameObject("EntZn_AlertA1E1A"))
  Repop_A1E1:OnEnemyDeath(function()
    Repop_A1E1:StartWave(3)
  end, {count = 3})
end
local Repop_Area_3_Fight_1 = function()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 5
    powerLevel02 = 6
  elseif 600 <= cineNumber then
    powerLevel01 = 6
    powerLevel02 = 7
  end
  Repop_A3E1 = EC.NewEncounter(thisLevel, "[Repop Area 3]EC:1 Pit Fight", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl400_AI",
    LeashZone = "NavLeash_Main",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 3]EC:1 Pit Fight",
      "[Area 5]EC:1 Fight XPL400"
    }
  })
  Repop_A3E1:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "T4_Flyer_POS_Imm_SFG",
      spawnLocators = "A3_Loc_P_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "T4_Flyer_POS_Imm_SFG",
      spawnLocators = "A3_Loc_P_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.6,
      powerLevel = powerLevel02
    }
  })
  Repop_A3E1:AddWave({
    {
      spawners = "T4_Witch_N_S",
      spawnLocators = "A3_Loc_T",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      powerLevel = powerLevel01
    },
    {
      spawners = "LVL4_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 6,
      powerLevel = powerLevel01
    }
  })
  Repop_A3E1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {3, 25},
    triggerWaveFromScript = true,
    {
      spawners = "LVL4_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "LVL4_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.4,
      powerLevel = powerLevel01
    },
    {
      spawners = "LVL4_Draugr_N_SFG",
      spawnLocators = "A3_Loc_P_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10,
      powerLevel = powerLevel02
    }
  })
  Repop_A3E1:SetStartZone(thisLevel:GetGameObject("EntZnRepopArea3"))
  Repop_A3E1:OnEnemyDeath(function()
    Repop_A3E1:StartWave(3)
  end, {count = 3})
end
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Entrance_DraugrSpawn = level:GetGameObject("Entrance_DraugrSpawn")
  Entrance_ChestDraugrZone = level:GetGameObject("Entrance_ChestDraugrZone")
  Area_1_Fight_1()
  Area_2_Fight_1()
  Area_3_Fight_1()
  Area_4_Fight_1()
  Fake_Golem_Spawn()
  Area_5_Fight_1()
  Area_5_Fight_2()
  Area_6_Fight_1()
  Area_7_Fight_1()
  Repop_Area_1_Fight_1()
  Repop_Area_3_Fight_1()
  GameObjects.EntZn_Arena_3_Encounter2:Hide()
end
function XPL400_Encounters()
  Entrance_DraugrSpawn = thisLevel:GetGameObject("Entrance_DraugrSpawn")
  Entrance_ChestDraugrZone = thisLevel:GetGameObject("Entrance_ChestDraugrZone")
  QuestRoom_TraverseLinks = thisLevel:GetGameObject("QuestRoom_TraverseLinks")
  TransportEncounterZone = thisLevel:GetGameObject("TransportEncounterZone")
  TransportMonitor = monitors.CreateEntityZoneMonitor(player, TransportEncounterZone)
  TransportMonitor:OnEnter(TransportEncounterStart)
  TransportMonitor:SetTriggerCountLimit(1)
  UpperMinesEncounterZone = thisLevel:GetGameObject("UpperMinesEncounterZone")
  UpperMinesMonitor = monitors.CreateEntityZoneMonitor(player, UpperMinesEncounterZone)
  UpperMinesMonitor:OnEnter(UpperMinesEncounterStart)
  UpperMinesMonitor:SetTriggerCountLimit(1)
  LowerMinesEncounterZone = thisLevel:GetGameObject("LowerMinesEncounterZone")
  LowerMinesMonitor = monitors.CreateEntityZoneMonitor(player, LowerMinesEncounterZone)
  LowerMinesMonitor:OnEnter(LowerMinesEncounterStart)
  LowerMinesMonitor:SetTriggerCountLimit(1)
  QuestRoomEncounterZone = thisLevel:GetGameObject("QuestRoomEncounterZone")
  QuestRoomMonitor = monitors.CreateEntityZoneMonitor(player, QuestRoomEncounterZone)
  QuestRoomMonitor:OnEnter(QuestRoomEncounterStart)
  QuestRoomMonitor:SetTriggerCountLimit(1)
  EntranceEncounter01 = EC.NewEncounter(thisLevel, "EntranceEncounter01")
  EntranceEncounter01:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Entrance_DraugrSpawn*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 1},
      spawnCooldown = {3, 6}
    }
  })
  EntranceEncounter01:OnComplete(EntranceEncounterComplete)
  TransportEncounter01 = EC.NewEncounter(thisLevel, "TransportEncounter01")
  TransportEncounter01:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Transport_DraugrSpawner*",
      initialSpawnAmount = 3,
      minActive = 2,
      maxActive = 3,
      totalSpawns = 4,
      initialSpawnCooldown = {0, 1},
      spawnCooldown = {3, 6}
    }
  })
  TransportEncounter01:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Transport_WitchSpawner*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {16, 16.5},
      spawnCooldown = {8, 8.5}
    },
    {
      spawners = "Transport_DualDraugrSpawner*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 0.5},
      spawnCooldown = {3, 4}
    },
    {
      spawners = "Transport_ShieldDraugrSpawner*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 0.5},
      spawnCooldown = {1, 2}
    }
  })
  TransportEncounter01:OnComplete(TransportEncounterComplete)
  LowerMinesEncounter01 = EC.NewEncounter(thisLevel, "LowerMinesEncounter01")
  LowerMinesEncounter01:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Lower_CrawlerSpawner*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0.25},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "Lower_CrawlerSpawner*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0.25},
      spawnCooldown = {3, 6}
    }
  })
  LowerMinesEncounter01:OnComplete(LowerMinesEncounterComplete)
  QuestRoomEncounter01 = EC.NewEncounter(thisLevel, "QuestRoomEncounter01")
  QuestRoomEncounter01:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "QR_TrollSpawner*",
      initialSpawnAmount = 1,
      minActive = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0.25},
      spawnCooldown = {3, 6}
    },
    {
      spawners = "QR_DraugrSpawner*",
      initialSpawnAmount = 3,
      minActive = 3,
      maxActive = 3,
      totalSpawns = 3,
      initialSpawnCooldown = {0, 0.25},
      spawnCooldown = {0.25, 0.5}
    }
  })
  QuestRoomEncounter01:OnComplete(QuestRoomEncounterComplete)
  QuestRoomEncounter02 = EC.NewEncounter(thisLevel, "QuestRoomEncounter02")
  QuestRoomEncounter02:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "QR_DraugrP2Spawner*",
      initialSpawnAmount = 2,
      minActive = 2,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 0.25},
      spawnCooldown = {0.25, 0.5}
    }
  })
  QuestRoomEncounter02:OnComplete(QuestRoomEncounter02Complete)
  QuestRoomEncounter03 = EC.NewEncounter(thisLevel, "QuestRoomEncounter03")
  QuestRoomEncounter03:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "QR_DraugrP3Spawner*",
      initialSpawnAmount = 1,
      minActive = 2,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 0.25},
      spawnCooldown = {0.25, 0.5}
    }
  })
  QuestRoomEncounter03:OnComplete(QuestRoomEncounter03Complete)
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save(),
    temp_EntranceEncounter01Complete = EntranceEncounter01Complete,
    temp_TransportEncounter01Complete = TransportEncounter01Complete,
    temp_UpperMinesEncounter01Complete = UpperMinesEncounter01Complete,
    temp_LowerMinesEncounter01Complete = LowerMinesEncounter01Complete,
    temp_QuestRoomEncounter01Complete = QuestRoomEncounter01Complete,
    GolemSeen = GolemSeen
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  EntranceEncounter01Complete = savedInfo.temp_EntranceEncounter01Complete
  TransportEncounter01Complete = savedInfo.temp_TransportEncounter01Complete
  UpperMinesEncounter01Complete = savedInfo.temp_UpperMinesEncounter01Complete
  LowerMinesEncounter01Complete = savedInfo.temp_LowerMinesEncounter01Complete
  QuestRoomEncounter01Complete = savedInfo.temp_QuestRoomEncounter01Complete
  GolemSeen = savedInfo.GolemSeen
end
function Area1Complete()
end
function Area2Complete()
end
function Area3Complete()
end
function Area4Complete()
end
function startPostGolemIntroFight()
  GameObjects.EntZnArea3Encounter1:Show()
  GolemSeen = true
  local thisAIA = LD.FindSingleAIByMarker("FakeGolem")
  LD.CallFunctionAfterDelay(function()
    thisAIA:ForceMove("BRA_SpawnToPatrol")
  end, 2)
end
function EntranceEncounterComplete()
  EntranceEncounter01Complete = true
end
function TransportEncounterStart()
  if TransportEncounter01Complete == false then
    TransportEncounter01:Start()
  end
end
function TransportEncounterComplete()
  TransportEncounter01Complete = true
  game.World.StoreCheckpoint()
end
function UpperMinesEncounterStart()
  if UpperMinesEncounter01Complete == false then
    UpperMinesEncounter01:Start()
  end
end
function UpperMinesEncounterComplete()
  UpperMinesEncounter01Complete = true
  game.World.StoreCheckpoint()
end
function LowerMinesEncounterStart()
  if LowerMinesEncounter01Complete == false then
    LD.CallFunctionAfterDelay(function()
      LowerMinesEncounter01:Start()
    end, 2)
  end
end
function LowerMinesEncounterComplete()
  LowerMinesEncounter01Complete = true
end
function QuestRoomEncounterStart()
  if QuestRoomEncounter01Complete == false then
    LD.CallFunctionAfterDelay(function()
      QuestRoomEncounter01:Start()
    end, 0.5)
  end
end
function QuestRoomEncounter02Start()
  QuestRoomEncounter02:Start()
end
function QuestRoomEncounter03Start()
  QuestRoomEncounter03:Start()
end
function QuestRoomEncounterComplete()
  QuestRoomEncounter01Complete = true
  game.World.StoreCheckpoint()
end
function QuestRoomEncounter02Complete()
end
function QuestRoomEncounter03Complete()
end
function CompleteQuestEarly()
  LD.CompleteQuest("Quest_Brok_Epic_01_Objective_03")
end
function CompleteObjective()
  LD.CompleteQuest("Quest_Brok_Epic_01_Objective_03")
  LD.CallFunctionAfterDelay(PlayPostFightBanter, 3)
end
function PlayPostFightBanter()
  game.Audio.PlayBanter("Brok1_PostGolemFight")
end
function SaveCheckPoint()
  game.World.StoreCheckpoint()
end
