local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local CWU = require("camera.camera_wakeup")
local uiCalls = require("ui.uicalls")
local EC = require("design.Encounter")
local CCEC = require("camera.camera_cineentercamera")
local checkpoint = require("level.checkpoint")
thisLevel = nil
local player, son
HuldraEntDoorUnlocked = false
local HuldraEntGem, camWakeUpLevel, camCineHandLookAt010
Transport_RopeSecret = nil
Transport_VibrateRocks = nil
ExitRoom_VibrateDetected = nil
Transport_VibrateDetected = false
local EntranceCP, EntranceMonitor, TransportCP, TransportMonitor, MineCP, MineMonitor, QuestRoomCP, QuestRoomMonitor, QuestRoom_RopeDetected, Crystals
local banterExteriorComplete = false
local bodyBanterComplete01 = false
local bodyBanterComplete02 = false
local bodyBanterComplete03 = false
local bodyBanterAltComplete = false
local banterObjective1Complete = false
local banterObjective2Complete = false
local banterObjective3Complete = false
local banterObjective5Complete = false
local banterReturnComplete = false
local huldraStoneDoor
local entranceBarrierBroken = false
local entranceBouldersBroken = false
local room1EncounterComplete = false
local room1CorpseLooted = false
local room1RopeDropped = false
local hallwayQuestCorpseLooted = false
local witchEncounterComplete = false
local room2QuestCorpseLooted = false
local room2GateLifted = false
local doorRune1Broken = false
local doorRune2Broken = false
local doorRune3Broken = false
local doorRunesBrokenCount = 0
local allDoorRunesBroken = false
local flagRoom2Top = false
local golemEncounterComplete = false
local questHandCollected = false
local questArenaRopeDropped = false
local questDwarvenRunesComplete = false
local lightTableA, lightTableB
local tableB_Broken = false
local xpl425
local huldraDoorOpened_xpl400 = false
local room1GateLifted = false
local lootDirtPatch02_Collected = false
local burnedHandLocation, golemHelpTextTimer, golemCreature
local golemHelpTextDelay = 50
local golemHealthCheckAmt = 100
local helpTextDisplayDuration = 10
local startupTimer = timer.StartLevelTimer(1)
startupTimer:Stop()
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  camWakeUpLevel = level
  camCineHandLookAt010 = CCEC.CineEnterCamera.New("PLYR_Nar_Golem_Hand_010", 9, nil)
  huldraStoneDoor = GameObjects.huldraStoneDoor
  lightTableA = GameObjects.CandleA_Light
  lightTableB = GameObjects.CandleB_Light
  SoundInit()
  game.Audio.StartMusicMaster("SND_MX_xpl400_start_master")
end
function OnFirstStart(level)
  GameObjects.Transport_LiftGate.Child.LuaObjectScript.Disable()
  local Breakable = GameObjects.DoorRune03:FindSingleGOByName("runic3_break")
  Breakable:HideCollision()
  Breakable:HideBehaviors()
  GameObjects.TraverseLink_QuestRoomRopeDrop:HideTraverseLink()
  GameObjects.Transport_RopeDrop.LuaObjectScript.DisablePlayerInteract()
end
function OnStart(level)
  SoundOnStart()
  SetGateways()
  local Zipline_TopPos = GameObjects.Zipline_Top
  local Zipline_BottomPos = GameObjects.Zipline_Bottom
  local Zipline = GameObjects.zipline_XPL400
  Zipline:SetZiplineStartAndEnd(Zipline_TopPos:GetWorldPosition(), Zipline_BottomPos:GetWorldPosition())
  print(burnedHandLocation)
  if burnedHandLocation ~= nil and game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_04") ~= "Complete" then
    local spawnArgs = {
      SpawnObject = "golootburnedhanddrop",
      OffsetPosition = burnedHandLocation,
      Level = game.Level.GetPermLevel()
    }
    Zipline:SpawnGameObject(spawnArgs)
  end
  if questArenaRopeDropped == true then
    GameObjects.CA_NavGuide_Forward_Up_Room3_RopeDrop.LuaObjectScript.Disable()
  end
end
function OnUpdate(level)
  if camCineHandLookAt010 ~= nil then
    camCineHandLookAt010:Update()
  end
end
function SetSonAvailability()
  local availabilityState = {
    Unoccupied = false,
    AvailableForCombat = false,
    AvailableForSync = false
  }
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function ClearSonAvailability()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  GameObjects.TraverseLink_QuestRoomRopeDrop:ShowTraverseLink()
end
function Xpl425LoadCheck()
  game.UI.LoadCheck("Xpl425_HuldraMinesLH")
end
function SetGateways()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_Return")
  if questState == "Complete" or questState == "Active" or questState == "Activate" then
    game.Compass.SetGatewayMarkerIsOpen("HM01_400_ChainDrop", true)
    game.Compass.SetGatewayMarkerIsOpen("HM01_Brok01_Obj04", false)
    game.Compass.SetGatewayMarkerIsOpen("HM01_Brok01_Obj05", false)
  else
    game.Compass.SetGatewayMarkerIsOpen("HM01_400_ChainDrop", false)
  end
  if questArenaRopeDropped or questState == "Complete" or questState == "Active" then
    game.Compass.SetGatewayMarkerIsOpen("HM01_400_ChainDrop_04", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HM01_400_ChainDrop_04", false)
  end
end
function BombHitGround_BreakGnome()
  local gnomeRef = GameObjects.DoorRune01
  local gnomeBreak = gnomeRef.Child:GetBreakable()
  if gnomeBreak ~= nil and gnomeBreak.Broken == false then
    gnomeBreak:Break()
  end
end
function Xpl425_HuldraDoorCA_Enable()
  local xpl425 = game.FindLevel("Xpl425_HuldraMinesLH")
  if xpl425 ~= nil then
    xpl425:CallScript("HuldraDoorCA_Enable")
  end
end
function UnlockHuldraEntDoor()
  GameObjects.huldraStoneDoor.Child:PlayAnimToEnd()
  PlayHuldraDoorSound()
  local xpl425 = game.FindLevel("Xpl425_HuldraMinesLH")
  if xpl425 ~= nil then
    xpl425:CallScript("HuldraDoorOpenedEvent")
  end
  GameObjects.huldraStoneDoor.Child:OnAnimDone(thisLevel, "HuldraEntranceLTW_Enable", "StopHuldraDoorSound")
  HuldraEntDoorUnlocked = true
  huldraDoorOpened_xpl400 = true
  LD.CallFunctionAfterDelay(function()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end, 7)
end
function SonBoostComplete()
end
function SonDropRope()
  GameObjects.QuestRoom_RopeDrop.LuaObjectScript.Enable()
end
function TransportRope_PlayerInteract()
  GameObjects.Transport_RopeDrop.LuaObjectScript.EnablePlayerInteract()
end
function Transport_SonDropRope()
  room1RopeDropped = true
  game.World.StoreCheckpoint()
  SetGateways()
end
function Transport_VibrateHit()
  Transport_VibrateRocks:PlayAnimToEnd()
  Transport_VibrateRocks:HideCollision()
  Transport_VibrateDetected = true
end
function ExitRoom_VibrateHit()
  ExitRoom_VibrateDetected = true
end
function SaveCheckPoint()
  game.World.StoreCheckpoint()
end
function CrystalExplode()
  Crystals:Hide()
end
function WakeClimbJumpFWD()
  CWU.WakeUpTheRecenterZones("RCenter_WakeGroup_JumpClimb_Fwd", camWakeUpLevel)
end
function EnableSonBoost()
  GameObjects.QuestRoom_SonBoost.LuaObjectScript:Enable()
  game.Compass.SetGatewayMarkerIsOpen("HM01_400_ChainDrop_04", true)
  game.Compass.SetGatewayMarkerIsOpen("HM01_400_ChainDrop", true)
  game.Compass.SetGatewayMarkerIsOpen("HM01_400_Helperv11", false)
end
function EnableLootChestRoomTwo()
  GameObjects.chest_common_tier4_xpl400_1.LuaObjectScript.Enable()
end
function HideCandle_TableA()
  lightTableA:Hide()
  GameObjects.CandleA_Geo:Hide()
  print("TableA Broken")
end
function HideCandle_TableB()
  lightTableB:Hide()
  GameObjects.CandleB_Geo:Hide()
  GameObjects.CA_Observe_Forward_Room1_Table.LuaObjectScript.Disable()
  tableB_Broken = true
  print("TableA Broken")
end
function SetRoom1CorpseLooted()
  room1CorpseLooted = true
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_Puzzled_HuldraEntrance.LuaObjectScript.Disable()
  end, 3)
end
function SetRuneRead02_Complete()
  xpl425 = game.FindLevel("Xpl425_HuldraMinesLH")
  if xpl425 ~= nil then
    xpl425:CallScript("RuneRead02Complete")
  end
end
function Xpl425_ShopCAInterrupt()
  xpl425 = game.FindLevel("Xpl425_HuldraMinesLH")
  xpl425:CallScript("ShopCA_Interrupt")
end
function SetLootDirtPatch02_Collected()
  lootDirtPatch02_Collected = true
end
function SetRoom1EncounterComplete()
  room1EncounterComplete = true
  GameObjects.Transport_LiftGate.Child.LuaObjectScript.Enable()
  GameObjects.ca_combat_turret_commndOnly_arena1.LuaObjectScript.Disable()
end
function SetWitchEncounterComplete()
  witchEncounterComplete = true
  Room2_TopCA_Enable()
end
function Room2GateLifted()
  room2GateLifted = true
  Room2_PitCA_Disable()
  local Breakable = GameObjects.DoorRune03:FindSingleGOByName("runic3_break")
  Breakable:ShowCollision()
  Breakable:ShowBehaviors()
end
function Room2QuestCorpseLooted()
  room2QuestCorpseLooted = true
  Room2_TopCA_Enable()
end
function SetDoorRune1Broken()
  doorRune1Broken = true
  SetDoorRunesBrokenCount()
end
function SetDoorRune2Broken()
  doorRune2Broken = true
  GameObjects.CA_Point_Up_Room2_DoorRune02.LuaObjectScript.Disable()
  SetDoorRunesBrokenCount()
end
function SetDoorRune3Broken()
  doorRune3Broken = true
  SetDoorRunesBrokenCount()
end
function SetDoorRunesBrokenCount()
  doorRunesBrokenCount = doorRunesBrokenCount + 1
  MusicFixForXpl400()
  if doorRunesBrokenCount == 3 then
    SetAllDoorRunesBroken()
  end
end
function SetAllDoorRunesBroken()
  allDoorRunesBroken = true
  if flagRoom2Top == true then
    GameObjects.LTW_Room2_Top_A.LuaObjectScript.Disable()
    GameObjects.LTW_Room2_Top_B.LuaObjectScript.Enable()
  end
end
function SetGolemEncounterComplete()
  golemEncounterComplete = true
end
function QuestArenaRopeDropped()
  questArenaRopeDropped = true
  SetGateways()
end
function QuestDwarvenRunesComplete()
  questDwarvenRunesComplete = true
end
function BreakSecretNookRocks()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Secret_Nook_Rock_Breakable_01)
    LD.BreakObject(GameObjects.Secret_Nook_Rock_Breakable_02)
    LD.BreakObject(GameObjects.Secret_Nook_Rock_Breakable_03)
    LD.BreakObject(GameObjects.Secret_Nook_Rock_Breakable_04)
  end, 0.1)
end
function Hide_GolemArenaBombBlocker_01()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Large_Rock_Breakable_ScriptOnly_01)
    GameObjects.GolemArenaBombBlocker_01:HideCollision()
  end, 0.1)
end
function Hide_GolemArenaBombBlocker_02()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Large_Rock_Breakable_ScriptOnly_06)
    LD.BreakObject(GameObjects.Large_Rock_Breakable_ScriptOnly_07)
    GameObjects.GolemArenaBombBlocker_02:HideCollision()
  end, 0.1)
end
function Hide_GolemArenaBombBlocker_03()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Large_Rock_Breakable_ScriptOnly_05)
    GameObjects.GolemArenaBombBlocker_03:HideCollision()
  end, 0.1)
end
function Hide_BalconyBombBlocker()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.RewardPathBoulder_01)
    LD.BreakObject(GameObjects.RewardPathBoulder_02)
    LD.BreakObject(GameObjects.RewardPathBoulder_03)
    LD.BreakObject(GameObjects.RewardPathBoulder_04)
    LD.BreakObject(GameObjects.RewardPathBoulder_05)
    GameObjects.BalconyBombBlocker:HideCollision()
  end, 0.1)
end
function Hide_GateBombBlocker()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Large_Rock_Breakable_ScriptOnly_03)
    LD.BreakObject(GameObjects.Large_Rock_Breakable_ScriptOnly_04)
    GameObjects.GateBombBlocker:HideCollision()
  end, 0.1)
end
local CleanUpGolemHelpTextTimer = function(level)
  if golemHelpTextTimer ~= nil then
    golemHelpTextTimer:Stop()
    golemHelpTextTimer = nil
  end
end
local GolemHelpTextCheck = function()
  if golemCreature ~= nil then
    local currentHealth = golemCreature.HitPoints
    if 0 < currentHealth and currentHealth >= golemHealthCheckAmt then
      uiCalls.SendSidebarDesignerMessage({
        Text = 40934,
        MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
        DisplayTime = helpTextDisplayDuration
      })
    elseif currentHealth <= 0 then
      CleanUpGolemHelpTextTimer()
    end
    CleanUpGolemHelpTextTimer()
  else
    CleanUpGolemHelpTextTimer()
  end
end
function LuaHook_StartGolemHelpTimer(level, creature)
  golemCreature = creature
  golemHelpTextTimer = StartLevelTimer(golemHelpTextDelay, GolemHelpTextCheck)
  golemHealthCheckAmt = golemCreature.HitPoints
  golemHelpTextTimer:Restart()
end
function LuaHook_StopGolemHelpTimer(level, creature)
  CleanUpGolemHelpTextTimer()
end
function PlayExteriorBanter(level)
  if banterExteriorComplete == false then
    game.Audio.PlayBanterNonCritical("Xpl425_RuneGraffiti")
    banterExteriorComplete = true
  end
end
function PlayBanterObjective01(level)
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_02")
  if questState == "Active" and not banterObjective1Complete then
    game.Audio.PlayBanter("Brok1_GoalReminder")
    banterObjective1Complete = true
  end
end
function CompleteObjective01(level)
  LD.CompleteQuest("Quest_Brok_Epic_01_Objective_01")
end
function PlayBanterObjective02(level)
  GameObjects.CA_NavForwardToGate.LuaObjectScript.Enable()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_02")
  if questState == "Active" and banterObjective2Complete == false then
    game.Audio.PlayBanter("Brok1_Sighting", CompleteObjective02)
    banterObjective2Complete = true
    local heroPuppeteer = game.Puppeteer.NewForce(GameObjects.Xpl400_Brok1_Sighting, "XPL400_Brok1_Sighting_Approach", player)
    local approachData = LD.GetGlobalApproachData()
    approachData.joint_name = "kratos_approachJoint"
    approachData.branch_name = "BRA_SetIdle"
    player:SetAccelerationOverride(approachData.acceleration_override)
    player:SetDecelerationOverride(approachData.deceleration_override)
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 5,
      YawRange = 360,
      PitchRange = 90,
      LockRecenter = 1
    })
    timer.StartLevelTimer(1, function()
      camCineHandLookAt010:Start()
    end)
    timer.StartLevelTimer(10, function()
      game.Camera.Recenter({
        TimeStart = 0,
        TimeDuration = 4.2,
        YawRange = 360,
        PitchRange = -1,
        TriggerUp = 0,
        TriggerDown = 0,
        ReturnUp = -7,
        ReturnDown = -8
      })
    end)
    approachData.speed = 1.5
    heroPuppeteer:Approach(approachData)
    heroPuppeteer:OnComplete(function()
      player:ClearFocus()
      player:ClearDecelerationOverride()
      player:ClearAccelerationOverride()
      Room2_PitCA_Enable()
      if heroPuppeteer ~= nil then
        heroPuppeteer:Sync("BRA_SetIdle", true, {}, "kratos_approachJoint")
        LD.CallFunctionAfterDelay(function()
          player:TriggerMoveEvent("kLEEndIdleSync")
          if heroPuppeteer ~= nil then
            heroPuppeteer:Clear()
            heroPuppeteer = nil
          end
        end, 4)
      end
    end)
  end
end
function CompleteObjective02(level)
  LD.CompleteQuest("Quest_Brok_Epic_01_Objective_02")
  GameObjects.CA_NavForwardToGate.LuaObjectScript.Disable()
  SaveCheckPoint()
end
function PlayBanterObjective03(level)
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Parent")
  local killedGolem = game.QuestManager.GetQuestState("Quest_Labor_AncientKills_Parent")
  if questState == "Active" and banterObjective3Complete == false then
    if killedGolem == "Inactive" then
      game.Audio.PlayBanter("Brok1_GateOpens")
    else
      game.Audio.PlayBanter("Brok1_GateOpens_Alt")
    end
    banterObjective3Complete = true
  end
end
function BanterPreGolemFightCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_03")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function PlayBanterObjective04(level)
  CompleteObjective04()
  game.Audio.PlayBanter("Brok1_SeveredHand")
end
function CompleteObjective04(level)
  LD.CompleteQuest("Quest_Brok_Epic_01_Objective_04")
  EnableSonBoost()
  SetGateways()
  game.World.StoreCheckpoint()
end
function PlayBanterObjective05(level)
  if banterObjective5Complete == false then
    game.Audio.PlayBanter("Xpl400_RuneGraffiti")
    banterObjective5Complete = true
    game.Audio.SetBanterFact("brok01RuneReadFound", "True")
  end
end
function Brok1_BodyBanter(level)
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_02")
  if questState ~= "Complete" then
    if bodyBanterComplete01 == false then
      game.Audio.PlayBanter("Brok1_FirstBody")
      bodyBanterComplete01 = true
    elseif bodyBanterComplete02 == false then
      game.Audio.PlayBanter("Brok1_SecondBody")
      bodyBanterComplete02 = true
    elseif bodyBanterComplete03 == false then
      game.Audio.PlayBanter("Brok1_ThirdBody")
      bodyBanterComplete03 = true
    end
  elseif questState == "Complete" and bodyBanterAltComplete == false then
    game.Audio.PlayBanter("Brok1_ThirdBody_RingFound")
    bodyBanterAltComplete = true
  end
end
function Brok1_BodyBanterReminder()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_02")
  if questState ~= "Complete" and bodyBanterComplete01 == false then
    game.Audio.PlayBanter("Brok 1_BodyReminder")
  end
end
function RecheckBrokGreeting()
  local player = game.Player.FindPlayer()
  local xpl400 = game.FindLevel("Xpl400_HuldraMines")
  local shop = xpl400:GetGameObject("SmallShop")
  local talkInteract = shop.Child:FindSingleGOByName("TalkInteract_SM")
  talkInteract.Child:CallScript("AttemptToTriggerGreeting")
  print("Attempting to trigger greeting with the child check")
end
function HuldraEntranceLTW_Enable()
  GameObjects.LTW_HuldraEntrance.LuaObjectScript.Enable()
end
function HuldraEntranceLTW_Disable()
  GameObjects.LTW_HuldraEntrance.LuaObjectScript.Disable()
end
function HuldraEntranceCA_Enable()
  if entranceBarrierBroken == false then
    GameObjects.CA_Observe_Forward_Entrance_01.LuaObjectScript.Enable()
  end
  if entranceBouldersBroken == false then
    GameObjects.CA_Idle_Entrance_Nook.LuaObjectScript.Enable()
  elseif entranceBouldersBroken == true and room1CorpseLooted == false then
    GameObjects.CA_Puzzled_HuldraEntrance.LuaObjectScript.Enable()
  end
end
function HuldraEntranceCA_Disable()
  GameObjects.CA_Observe_Forward_Entrance_01.LuaObjectScript.Disable()
  GameObjects.CA_Idle_Entrance_Nook.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_HuldraEntrance.LuaObjectScript.Disable()
end
function EntranceSideCaveCA_Enable()
  entranceBouldersBroken = true
  GameObjects.CA_Idle_Entrance_Nook.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_HuldraEntrance.LuaObjectScript.Enable()
end
function EntranceHallBarrierBroken()
  GameObjects.CA_Observe_Forward_Entrance_01.LuaObjectScript.Disable()
  entranceBarrierBroken = true
end
function Combat_CA_Enable()
  if room1EncounterComplete == false then
    GameObjects.ca_combat_turret_commndOnly_arena1.LuaObjectScript.Enable()
  end
end
function Combat_CA_Disable()
  GameObjects.ca_combat_turret_commndOnly_arena1.LuaObjectScript.Disable()
end
function Room1CA_Enable()
  GameObjects.CA_Observe_Forward_Up_Room1.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_Room1.LuaObjectScript.Enable()
  GameObjects.CA_PlayWithKnife_Room1.LuaObjectScript.Enable()
  if room1EncounterComplete == true then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  end
  if hallwayQuestCorpseLooted == false then
    GameObjects.CA_Puzzled_Room1.LuaObjectScript.Enable()
  end
  if tableB_Broken == false then
    GameObjects.CA_Observe_Forward_Room1_Table.LuaObjectScript.Enable()
  end
end
function Room1CA_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.CA_Observe_Forward_Up_Room1.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Room1.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_Room1.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room1_Table.LuaObjectScript.Disable()
  GameObjects.CA_PlayWithKnife_Room1.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room1_Gate.LuaObjectScript.Disable()
  GameObjects.ca_combat_turret_commndOnly_arena1.LuaObjectScript.Disable()
end
function HallwayQuestCorpseLooted()
  GameObjects.CA_Puzzled_Room1.LuaObjectScript.Disable()
  hallwayQuestCorpseLooted = true
end
function LiftGateCA_Enable()
  room1GateLifted = true
end
function Room2_TopCA_Enable()
  if allDoorRunesBroken == false then
    GameObjects.LTW_Room2_Top_A.LuaObjectScript.Enable()
  elseif allDoorRunesBroken == true then
    GameObjects.LTW_Room2_Top_B.LuaObjectScript.Enable()
    GameObjects.CA_Idle_Room2_RuneDoor.LuaObjectScript.Enable()
  end
  if witchEncounterComplete == true then
    GameObjects.CA_Observe_on_Alert_Room2.LuaObjectScript.Disable()
  end
  if room2QuestCorpseLooted == false then
    GameObjects.CA_Puzzled_Room2_QuestCorpse.LuaObjectScript.Enable()
  elseif room2QuestCorpseLooted == true then
    GameObjects.CA_Puzzled_Room2_QuestCorpse.LuaObjectScript.Disable()
  end
  flagRoom2Top = true
  GameObjects.CA_Observe_Forward_Up_Room2_01.LuaObjectScript.Enable()
end
function Room2_TopCA_Disable()
  GameObjects.LTW_Room2_Top_A.LuaObjectScript.Disable()
  GameObjects.LTW_Room2_Top_B.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Room2_01.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_Room2_QuestCorpse.LuaObjectScript.Disable()
  GameObjects.CA_Idle_Room2_RuneDoor.LuaObjectScript.Disable()
  flagRoom2Top = false
end
function Room2_SidepathCA_Enable()
  GameObjects.LTW_Room2_SidePath.LuaObjectScript.Enable()
end
function Room2_SidepathCA_Disable()
  GameObjects.LTW_Room2_SidePath.LuaObjectScript.Disable()
end
function Room2_PitCA_Enable()
  if doorRune2Broken == false then
    GameObjects.CA_Point_Up_Room2_DoorRune02.LuaObjectScript.Enable()
  elseif doorRune2Broken == true then
    GameObjects.CA_Point_Up_Room2_DoorRune02.LuaObjectScript.Disable()
  end
  if room2GateLifted == false then
    GameObjects.CA_Observe_Forward_Room2_Gate.LuaObjectScript.Enable()
    GameObjects.CA_TiredHandOnWall_Room2_Gate.LuaObjectScript.Enable()
    GameObjects.LTW_Room2_Bottom_A.LuaObjectScript.Enable()
  elseif room2GateLifted == true then
    GameObjects.CA_Observe_Forward_Room2_Gate.LuaObjectScript.Disable()
    GameObjects.LTW_Room2_Bottom_A.LuaObjectScript.Disable()
    GameObjects.LTW_Room2_Bottom_B.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Room2_PostGate.LuaObjectScript.Enable()
    if doorRune3Broken == false and doorRunesBrokenCount == 2 then
      GameObjects.CA_Observe_Forward_Room2_DoorRune03.LuaObjectScript.Enable()
    elseif doorRune3Broken == true then
      GameObjects.CA_Observe_Forward_Room2_DoorRune03.LuaObjectScript.Disable()
    end
  end
  GameObjects.CA_WarmHands_Room2.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Room2_Wheel.LuaObjectScript.Enable()
  GameObjects.CA_KickBody_Room2_QuestCorpse.LuaObjectScript.Enable()
  GameObjects.CA_Idle_Room2_RopeB_Top.LuaObjectScript.Interrupt()
  GameObjects.CA_Idle_Room2_RopeB_Top.LuaObjectScript.Disable()
end
function Room2_PitCA_Disable()
  GameObjects.LTW_Room2_Bottom_A.LuaObjectScript.Disable()
  GameObjects.LTW_Room2_Bottom_B.LuaObjectScript.Disable()
  GameObjects.CA_TiredHandOnWall_Room2_Gate.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room2_Gate.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room2_PostGate.LuaObjectScript.Disable()
  GameObjects.CA_WarmHands_Room2.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room2_Wheel.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_Room2_DoorRune02.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room2_DoorRune03.LuaObjectScript.Disable()
  GameObjects.CA_KickBody_Room2_QuestCorpse.LuaObjectScript.Disable()
  GameObjects.CA_NavForwardToGate.LuaObjectScript.Disable()
end
function Room3CA_Enable()
  GameObjects.LTW_Room3_Start.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Room3_Intro.LuaObjectScript.Enable()
end
function Room3CA_Disable()
  GameObjects.LTW_Room3_Start.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room3_Intro.LuaObjectScript.Disable()
end
function Room3BuddyDropExit()
  if golemEncounterComplete == false then
    GameObjects.CA_Observe_on_Alert_Room3_BuddyDrop_Bot.LuaObjectScript.Enable()
  elseif golemEncounterComplete == true then
    GameObjects.CA_Idle_Room3_BuddyDrop_Bot.LuaObjectScript.Enable()
  end
end
function Room3_PitCA_Enable()
  GameObjects.LTW_Room3_Main.LuaObjectScript.Enable()
  GameObjects.CA_PlayWithKnife_Room3.LuaObjectScript.Enable()
  GameObjects.CA_SitOnGround_Room3.LuaObjectScript.Enable()
  GameObjects.CA_KickBody_Room3.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Up_Room3.LuaObjectScript.Enable()
  if questArenaRopeDropped == false then
    GameObjects.CA_NavGuide_Forward_Up_Room3_RopeDrop.LuaObjectScript.Enable()
  elseif questArenaRopeDropped == true then
    GameObjects.CA_NavGuide_Forward_Up_Room3_RopeDrop.LuaObjectScript.Disable()
  end
end
function Room3_PitCA_Disable()
  GameObjects.LTW_Room3_Main.LuaObjectScript.Disable()
  GameObjects.CA_PlayWithKnife_Room3.LuaObjectScript.Disable()
  GameObjects.CA_SitOnGround_Room3.LuaObjectScript.Disable()
  GameObjects.CA_KickBody_Room3.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Room3.LuaObjectScript.Disable()
  GameObjects.CA_NavGuide_Forward_Up_Room3_RopeDrop.LuaObjectScript.Disable()
end
function RuneReadHallCA_Enable()
  GameObjects.LTW_RuneReadHall.LuaObjectScript.Enable()
  if questDwarvenRunesComplete == false then
    GameObjects.CA_Observe_Forward_RuneReadHall.LuaObjectScript.Enable()
  elseif questDwarvenRunesComplete == true then
    GameObjects.CA_Observe_Forward_RuneReadHall.LuaObjectScript.Disable()
  end
end
function RuneReadHallCA_Disable()
  GameObjects.LTW_RuneReadHall.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_RuneReadHall.LuaObjectScript.Disable()
end
function Room4CA_Enable()
  GameObjects.LTW_Room4_Main.LuaObjectScript.Enable()
  GameObjects.CA_PlayWithKnife_Room4.LuaObjectScript.Enable()
end
function Room4CA_Disable()
  GameObjects.LTW_Room4_Main.LuaObjectScript.Disable()
  GameObjects.CA_PlayWithKnife_Room4.LuaObjectScript.Disable()
end
function Room4SideCA_Enable()
  GameObjects.LTW_Room4_Side.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Room4Side.LuaObjectScript.Enable()
end
function Room4SideCA_Disable()
  GameObjects.LTW_Room4_Side.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room4Side.LuaObjectScript.Disable()
end
function Room4ExitHallCA_Enable()
  GameObjects.LTW_Room4_ExitHall.LuaObjectScript.Enable()
end
function Room4ExitHallCA_Disable()
  GameObjects.LTW_Room4_ExitHall.LuaObjectScript.Disable()
end
function FindBurnedHand()
  local findResults = game.World.FindGameObjectsByMarker("BurnedHand")
  if findResults[1] ~= nil and findResults[1].Parent ~= nil then
    return findResults[1].Parent:GetWorldPosition()
  end
end
function ReOpenHuldraDoor()
  if GameObjects.huldraStoneDoor.Child.AnimFrame == 0 and room1GateLifted == true then
    GameObjects.huldraStoneDoor.Child:PlayAnimToEnd()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    huldraStoneDoor = huldraStoneDoor,
    entranceBarrierBroken = entranceBarrierBroken,
    entranceBouldersBroken = entranceBouldersBroken,
    room1EncounterComplete = room1EncounterComplete,
    room1CorpseLooted = room1CorpseLooted,
    room1RopeDropped = room1RopeDropped,
    hallwayQuestCorpseLooted = hallwayQuestCorpseLooted,
    witchEncounterComplete = witchEncounterComplete,
    room2QuestCorpseLooted = room2QuestCorpseLooted,
    room2GateLifted = room2GateLifted,
    doorRune1Broken = doorRune1Broken,
    doorRune2Broken = doorRune2Broken,
    doorRune3Broken = doorRune3Broken,
    doorRunesBrokenCount = doorRunesBrokenCount,
    allDoorRunesBroken = allDoorRunesBroken,
    flagRoom2Top = flagRoom2Top,
    golemEncounterComplete = golemEncounterComplete,
    questHandCollected = questHandCollected,
    questArenaRopeDropped = questArenaRopeDropped,
    questDwarvenRunesComplete = questDwarvenRunesComplete,
    huldraDoorOpened_xpl400 = huldraDoorOpened_xpl400,
    tableB_Broken = tableB_Broken,
    room1GateLifted = room1GateLifted,
    lootDirtPatch02_Collected = lootDirtPatch02_Collected,
    bodyBanterComplete01 = bodyBanterComplete01,
    bodyBanterComplete02 = bodyBanterComplete02,
    bodyBanterComplete03 = bodyBanterComplete03,
    burnedHandLocation = FindBurnedHand(),
    banterObjective1Complete = banterObjective1Complete
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  huldraStoneDoor = savedInfo.huldraStoneDoor
  entranceBarrierBroken = savedInfo.entranceBarrierBroken
  entranceBouldersBroken = savedInfo.entranceBouldersBroken
  room1EncounterComplete = savedInfo.room1EncounterComplete
  room1CorpseLooted = savedInfo.room1CorpseLooted
  room1RopeDropped = savedInfo.room1RopeDropped
  hallwayQuestCorpseLooted = savedInfo.hallwayQuestCorpseLooted
  witchEncounterComplete = savedInfo.witchEncounterComplete
  room2QuestCorpseLooted = savedInfo.room2QuestCorpseLooted
  room2GateLifted = savedInfo.room2GateLifted
  doorRune1Broken = savedInfo.doorRune1Broken
  doorRune2Broken = savedInfo.doorRune2Broken
  doorRune3Broken = savedInfo.doorRune3Broken
  doorRunesBrokenCount = savedInfo.doorRunesBrokenCount
  allDoorRunesBroken = savedInfo.allDoorRunesBroken
  flagRoom2Top = savedInfo.flagRoom2Top
  golemEncounterComplete = savedInfo.golemEncounterComplete
  questHandCollected = savedInfo.questHandCollected
  questArenaRopeDropped = savedInfo.questArenaRopeDropped
  questDwarvenRunesComplete = savedInfo.questDwarvenRunesComplete
  huldraDoorOpened_xpl400 = savedInfo.huldraDoorOpened_xpl400
  tableB_Broken = savedInfo.tableB_Broken
  room1GateLifted = savedInfo.room1GateLifted
  lootDirtPatch02_Collected = savedInfo.lootDirtPatch02_Collected
  bodyBanterComplete01 = savedInfo.bodyBanterComplete01
  bodyBanterComplete02 = savedInfo.bodyBanterComplete02
  bodyBanterComplete03 = savedInfo.bodyBanterComplete03
  burnedHandLocation = savedInfo.burnedHandLocation
  banterObjective1Complete = savedInfo.banterObjective1Complete
end
local soundHuldraEntDoor, soundHuldraEntDoorLeft, soundHuldraEntDoorRight
local runeReadEntranceDoorOverrides = {EndFrame = 136}
local runeReadDwarvenRunesOverrides = {EndFrame = 136}
function SoundInit()
  soundHuldraEntDoor = huldraStoneDoor.Child:FindSingleSoundEmitterByName("SNDHuldra_Mine_Door")
  soundHuldraEntDoorLeft = huldraStoneDoor.Child:FindSingleSoundEmitterByName("SNDDoorLeft")
  soundHuldraEntDoorRight = huldraStoneDoor.Child:FindSingleSoundEmitterByName("SNDDoorRight")
end
function SoundOnStart()
  GameObjects.OutsideRuneRead:FindSingleGOByName("pSonReadRune").LuaObjectScript.SoundSetup(runeReadEntranceDoorOverrides)
  GameObjects.QuestDwarvenRunes:FindSingleGOByName("pSonReadRune").LuaObjectScript.SoundSetup(runeReadDwarvenRunesOverrides)
end
function PlayHuldraDoorSound()
  LD.PlaySound(soundHuldraEntDoor, "SND_DOOR_Stone_HuldraMine_Double_Door_Unlock")
  LD.PlaySoundOnFrame(soundHuldraEntDoorLeft, huldraStoneDoor.Child, "SND_DOOR_Stone_HuldraMine_Double_Door_Open_Seq_L", 120, "forward")
  LD.PlaySoundOnFrame(soundHuldraEntDoorRight, huldraStoneDoor.Child, "SND_DOOR_Stone_HuldraMine_Double_Door_Open_Seq_R", 120, "forward")
end
function StopHuldraDoorSound()
  LD.StopSound(soundHuldraEntDoor, "SND_DOOR_Stone_HuldraMine_Double_Door_Unlock")
end
function LeaveBossArenaMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL400_explore2_in")
end
function MusicFixForXpl400()
  timer.StartLevelTimer(1, MusicDelay)
end
function MusicDelay()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL400_explore1_in")
end
