local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local colElevatorLevelOne, colElevatorLevelTwo, colBeachLevelTwo, elevatorRope
local loreMarker01Complete = false
local runeRead02complete = false
local huldraDoorOpened_xpl425 = false
local son, xpl400
local lootDirtPatch01_Collected = false
local xpl400QuestMusic = false
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  colElevatorLevelOne = GameObjects.col_elevator_level_one
  colElevatorLevelTwo = GameObjects.col_elevator_level_two
  colBeachLevelTwo = GameObjects.col_beach_level_two
  elevatorRope = GameObjects.ElevatorRope_Geo
end
function OnFirstStart(level)
  colElevatorLevelOne:Show()
  elevatorRope:Hide()
  colElevatorLevelTwo:Hide()
  colBeachLevelTwo:Hide()
  GameObjects.ElevatorZone_JumpToBottom:Hide()
  GameObjects.ElevatorZone_JumpToTop:Hide()
end
function OnPreStart(level, obj)
  QuestStoneFixUp()
end
function OnStart(level)
  SoundOnStart()
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = LowerWaterLevel02,
    fn = LowerWaterLevel02
  })
  local switchInteractZones = GameObjects.xpl425_Elevator_SwitchWall.LuaObjectScript.GetInteractZoneTable()
  switchInteractZones[1]:SetEnableLineOfSightTest(true)
  switchInteractZones[1]:SetXZRange(1.5)
  switchInteractZones[1]:SetInteractFrontAngleWeight(0)
  switchInteractZones[1]:SetCameraFrontAngle(0, 100)
  switchInteractZones[1]:SetCameraFrontAngleWeight(1)
end
function LowerWaterLevel02()
  colElevatorLevelOne:Hide()
  colElevatorLevelTwo:Show()
  colBeachLevelTwo:Show()
  elevatorRope:Show()
end
function Cal100LoadCheck()
  game.UI.LoadCheck("Cal100_Hub")
end
function Cal200LoadCheck()
  game.UI.LoadCheck("Cal200_Shore")
end
function Xpl400LoadCheck()
  game.UI.LoadCheck("Xpl400_HuldraMines")
end
function QuestStoneFixUp()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_01")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneVolundr")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneVolundr", 1)
  end
end
function AreaAnnounceHuldra1()
  uiCalls.UI_Event_DiscoverLocation("HuldraMine01")
end
function LoreMarker01Complete()
  loreMarker01Complete = true
  GameObjects.LTW_Tunnel_01.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Lore_Marker.LuaObjectScript.Disable()
end
function RuneRead02Complete()
  runeRead02complete = true
  GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Interrupt()
  GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Disable()
end
function ApplyExploreIdleContext()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function ClearIdleContext()
  son:CallScript("ClearBehaviorContext")
end
function HuldraDoorOpenedEvent()
  print("callback from xpl400 received")
  huldraDoorOpened_xpl425 = true
  GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Disable()
  _G.StartLevelTimer(2.5, function()
    GameObjects.CA_BeckonToMe_HuldraDoorway.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_HuldraDoor.LuaObjectScript.Disable()
  end)
  HuldraDoorShakeRumble()
  MusicOnDoorOpen()
end
function HuldraDoorShakeRumble()
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_SMALL",
    Duration = 8,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 1}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 9,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5}
  })
  timers.StartLevelTimer(1.66, function()
    RumbleShakeHit(2)
  end)
  timers.StartLevelTimer(3.2, function()
    RumbleShakeHit(4)
  end)
  timers.StartLevelTimer(9, function()
    RumbleShakeHit(9)
  end)
end
function RumbleShakeHit(effectPriority)
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_STRONG",
    Duration = 0.5,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5},
    Priority = effectPriority
  })
end
function LootDirtPatch01_Collected()
  lootDirtPatch01_Collected = true
  GameObjects.CA_BeckonToMe_Beach01.LuaObjectScript.Interrupt()
  GameObjects.CA_BeckonToMe_Beach01.LuaObjectScript.Disable()
end
function OnElevatorMoveUp()
  GameObjects.ElevatorZone_JumpToBottom:Show()
  GameObjects.ElevatorZone_JumpToTop:Show()
  colElevatorLevelOne:Hide()
end
function OnElevatorMoveDown()
  colElevatorLevelOne:Show()
end
function OnJumpElevatorToBottom()
  GameObjects.xpl450_BasicElevator.LuaObjectScript.JumpToBottomFloor()
end
function OnJumpElevatorToTop()
  GameObjects.xpl450_BasicElevator.LuaObjectScript.JumpToTopFloor()
end
function Beach01CA_Enable()
  GameObjects.LTW_Beach01_A.LuaObjectScript.Enable()
  GameObjects.LTW_Beach01_B.LuaObjectScript.Enable()
  if lootDirtPatch01_Collected == false then
    GameObjects.CA_BeckonToMe_Beach01.LuaObjectScript.Enable()
  end
  print("Beach_01 CA Enabled")
end
function Beach01CA_Disable()
  GameObjects.LTW_Beach01_A.LuaObjectScript.Disable()
  GameObjects.LTW_Beach01_B.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_Beach01.LuaObjectScript.Disable()
  print("Beach_01 CA Disabled")
end
function ElevatorEntryTopCA_Enable()
  if game.Level.GetVariable("CalCurrentWaterLevel") == 2 then
    GameObjects.CA_NavGuide_Forward_ElevatorEntry_Top.LuaObjectScript.Enable()
  end
end
function Beach02CA_Enable()
  print("Beach_02 CA Enabled")
end
function Beach02CA_Disable()
  print("Beach_02 CA Disabled")
end
function CheckLoreMarkerStatus()
  if loreMarker01Complete == false then
    GameObjects.CA_Observe_Forward_Lore_Marker.LuaObjectScript.Enable()
  elseif loreMarker01Complete == true then
    GameObjects.LTW_Tunnel_01.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Lore_Marker.LuaObjectScript.Disable()
  end
end
function TunnelCA_Enable()
  CheckLoreMarkerStatus()
  print("Tunnel CA Enabled")
end
function TunnelCA_Disable()
  GameObjects.LTW_Tunnel_01.LuaObjectScript.Disable()
  print("Tunnel CA Disabled")
end
function Tunnel_LTW_Enable()
  GameObjects.LTW_Tunnel_01.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Lore_Marker.LuaObjectScript.Interrupt()
end
function HuldraDoorCA_Enable()
  print("Huldra Door CA Enabled")
  local xpl400 = game.FindLevel("Xpl400_HuldraMines")
  if xpl400 ~= nil then
    xpl400:CallScript("HuldraEntranceCA_Disable")
  end
  local questStateParent = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Parent")
  if questStateParent ~= "Active" and questStateParent ~= "Complete" then
    GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Enable()
  end
  local questStateObjective01 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_01")
  if questStateObjective01 == "Active" then
    GameObjects.CA_Observe_Forward_Up_HuldraDoor.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Disable()
  end
  local questStateObjective02 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_02")
  if questStateObjective02 == "Active" then
    GameObjects.CA_BeckonToMe_HuldraDoorway.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Disable()
  elseif questStateObjective02 == "Complete" then
    GameObjects.CA_BeckonToMe_HuldraDoorway.LuaObjectScript.Disable()
  end
end
function HuldraDoorCA_Disable()
  print("Huldra Door CA Disabled")
  GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_HuldraDoor.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_HuldraDoorway.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Shop.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Disable()
end
function xpl425_ShopCA_Enable()
  print("xpl425_Shop CA ENABLED")
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Parent")
  if questState ~= "Active" and questState ~= "Complete" then
    GameObjects.CA_IdleBehavior_Shop.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Interrupt()
    GameObjects.CA_Observe_Forward_Up_HuldraDoor.LuaObjectScript.Interrupt()
    GameObjects.CA_BeckonToMe_HuldraDoorway.LuaObjectScript.Interrupt()
  end
end
function xpl425_ShopCA_Disable()
  print("xpl425_Shop CA DISABLED")
  GameObjects.CA_IdleBehavior_Shop.LuaObjectScript.Interrupt()
  GameObjects.CA_IdleBehavior_Shop.LuaObjectScript.Disable()
end
function xpl425_RuneReadCA_Enable()
  if runeRead02complete == false then
    print("xpl425_RuneRead CA ENABLED")
    GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Enable()
    GameObjects.CA_IdleBehavior_HuldraDoor.LuaObjectScript.Interrupt()
    GameObjects.CA_Observe_Forward_Up_HuldraDoor.LuaObjectScript.Interrupt()
    GameObjects.CA_BeckonToMe_HuldraDoorway.LuaObjectScript.Interrupt()
  elseif runeRead02complete == true then
    print("xpl425_RuneRead Complete")
    GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Disable()
  end
end
function xpl425_RuneReadCA_Disable()
  print("xpl425_RuneRead CA DISABLED")
  GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Interrupt()
  GameObjects.CA_Observe_Forward_RuneRead02.LuaObjectScript.Disable()
end
function Huldra1LTW_Enable()
  if huldraDoorOpened_xpl425 == true then
    xpl400 = game.FindLevel("Xpl400_HuldraMines")
    if xpl400 ~= nil then
      xpl400:CallScript("HuldraEntranceLTW_Enable")
    end
  end
end
function Huldra1LTW_Disable()
  xpl400 = game.FindLevel("Xpl400_HuldraMines")
  if xpl400 ~= nil then
    xpl400:CallScript("HuldraEntranceLTW_Disable")
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    loreMarker01Complete = loreMarker01Complete,
    runeRead02complete = runeRead02complete,
    huldraDoorOpened_xpl425 = huldraDoorOpened_xpl425,
    lootDirtPatch01_Collected = lootDirtPatch01_Collected,
    xpl400QuestMusic = xpl400QuestMusic
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  loreMarker01Complete = savedInfo.loreMarker01Complete
  runeRead02complete = savedInfo.runeRead02complete
  huldraDoorOpened_xpl425 = savedInfo.huldraDoorOpened_xpl425
  lootDirtPatch01_Collected = savedInfo.lootDirtPatch01_Collected
  xpl400QuestMusic = savedInfo.xpl400QuestMusic
end
local elevatorSoundOverrides = {
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Wood_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Wood_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 0
}
function SoundOnStart()
  GameObjects.Xpl425_Elevator:FindSingleGOByName("xpl450_BasicElevator").LuaObjectScript.SoundSetup(elevatorSoundOverrides)
end
function MusicOnDoorOpen()
  game.Audio.StartMusic("SND_MX_XPL400_enter_mine")
  game.Audio.SetCheckpointedMusic("SND_MX_XPL400_explore1_in")
  xpl400QuestMusic = true
end
function MusicXpl400Idle()
  game.Audio.StartMusic("SND_MX_XPL400_idle")
end
function MusicRetriggerXpl400Explore()
  if xpl400QuestMusic == true then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL400_explore1_in")
  end
end
