LD = require("design.LevelDesignLibrary")
timers = require("level.timer")
EC = require("design.Encounter")
monitors = require("level.MonitorLibrary")
local thisLevel, Player
craneGate = nil
local craneFightEncounter, CraneFightZn, craneFightMonitor, craneSpawnMonitor, elevatorFallEncounter, beachFightEncounter, beachFightZn, beachFightMonitor, finalFightEncounter, finalFightCheckpoint, finalFightMonitor
local craneFightEncounterDone = false
local caveFightDone = false
local beachFightDone = false
local finalFightDone = false
local caveFightZn, caveFightMonitor, caveFightEncounter, tendrilSurprise, climbFightZn, climbFightMonitor, climbFightEncounter, entZnPostCartCol, postCartCol, postCartColEncounter, postCartColEncountwo, DespawnTDarkOnes, DespawnCrawler, backtrack_area5, backtrack_area3, Area_4_Encounter_1, E_HealthMonitor, EliteDarkOne_HealthMonitor, ZM_A3_E1_Start, Traveler_HealthMonitor, Repop_A1E1, Repop_A1E1_Monitor, Repop_A3E1, Repop_A5E1
function OnScriptLoaded(level, obj)
  Player = game.Player.FindPlayer()
  thisLevel = level
  craneGate = thisLevel:GetGameObject("LiftDoor_Gate_StaysOpen")
  caveFightZn = GameObjects.caveFightZn
  caveFightMonitor = monitors.CreateEntityZoneMonitor(Player, caveFightZn)
  caveFightMonitor:OnEnter(startCaveFight)
  caveFightMonitor:SetTriggerCountLimit(1)
  caveFightMonitor:Stop()
  beachFightZn = GameObjects.beachFightZn
  beachFightMonitor = monitors.CreateEntityZoneMonitor(Player, beachFightZn)
  beachFightMonitor:OnEnter(startBeachFight)
  beachFightMonitor:SetTriggerCountLimit(1)
  finalFightCheckpoint = GameObjects.finalFightCheckpoint
  finalFightMonitor = monitors.CreateEntityZoneMonitor(Player, finalFightCheckpoint)
  finalFightMonitor:OnEnter(checkpointFinalFight)
  finalFightMonitor:SetTriggerCountLimit(1)
  Area_1_Fight_1()
  Area_1_Fight_2()
  Area_2_Fight_1()
  Area_2_Fight_2()
  Area_3_Fight_1()
  Area_4_Fight_1()
  Area_5_Fight_1()
  Area_6_Fight_1()
  Backtrack_Area_1_Fight_3()
  Repop_Area_1_Fight_1()
  Repop_Area_3_Fight_1()
  Repop_Area_5_Fight_1()
end
function OnFirstStart(level)
  GameObjects.EntZn_EFall_Start:Hide()
  GameObjects.entZnPostCartCol:Hide()
  GameObjects.EntZnBacktrackArea5:Hide()
  GameObjects.beachFightReturnZn:Hide()
  GameObjects.DeathColGroup:HideCollision()
end
function OnStart()
  if elevatorFallEncounter:WasRunning() then
    elevatorFallEncounter:Start()
  end
  if postCartColEncounter:WasRunning() then
    postCartColEncounter:Start()
  end
  if beachFightEncounter:WasRunning() then
    beachFightEncounter:Start()
  end
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function startCraneFight()
  if craneFightEncounterDone == false then
    game.World.StoreCheckpoint()
    craneFightEncounter:Start()
  end
end
function startElevatorFallEncounter()
  GameObjects.EntZn_EFall_Start:Show()
  game.World.StoreCheckpoint()
end
function startCaveFight()
  if caveFightDone == false then
    caveFightEncounter:Start()
  end
end
function startBeachFight()
  if beachFightDone == false then
    beachFightEncounter:Start()
  end
end
function checkpointFinalFight()
  if finalFightDone == false then
    game.World.StoreCheckpoint()
  end
end
function craneFightEncounterComplete()
  local xpl450 = game.FindLevel("Xpl450_HuldraMines")
  craneFightEncounterDone = true
  LD.SetEntityVariable("QST_Brok02CraneFightComplete", true)
  if xpl450 ~= nil then
    xpl450:CallScript("Room1CA_Enable")
    xpl450:CallScript("SetRoom1EncounterAComplete")
    LD.CallFunctionAfterDelay(function()
      xpl450:CallScript("ActivateRm1BeckonCA")
    end, 40)
  end
  game.World.StoreCheckpoint()
end
function elevatorFallEncounterComplete()
  local xpl450 = game.FindLevel("Xpl450_HuldraMines")
  if xpl450 ~= nil then
    xpl450:CallScript("DeactivateRm1TurretCA")
  end
end
function caveFightEncounterComplete()
  caveFightDone = true
end
function beachFightEncounterComplete()
  beachFightDone = true
  game.World.StoreCheckpoint()
end
function finalFightEncounterStart()
  GameObjects.DeathColGroup:ShowCollision()
end
function finalFightEncounterComplete()
  finalFightDone = true
  game.World.StoreCheckpoint()
end
function startPostCartCol()
  GameObjects.entZnPostCartCol:Show()
  GameObjects.EntZnBacktrackArea5:Show()
  GameObjects.beachFightReturnZn:Show()
  postCartColEncounter:Start()
end
function Area_1_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  craneFightEncounter = EC.NewEncounter(thisLevel, "Encounter 1, Crane Fight", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl450_AI",
    LeashZone = "NavLeash_Area1B"
  })
  craneFightEncounter:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Crawler_N_Idle",
      spawnLocators = "A1_F1_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Crawler_N_Idle",
      spawnLocators = "A1_F1_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Crawler_N_Idle",
      spawnLocators = "A1_F1_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  craneFightEncounter:AddWave({
    requireSpawnersInRange = {3, 25},
    triggerWaveFromScript = true,
    powerLevel = powerLevel,
    {
      spawners = "Crawler_N_S",
      spawnLocators = "A1_F1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  craneFightEncounter:AddWave({
    requireSpawnersInRange = {3, 25},
    triggerWaveFromScript = true,
    powerLevel = powerLevel,
    {
      spawners = "T4_Crawler_N_S",
      spawnLocators = "A1_F1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  craneFightEncounter:OnEnemyDeath(function()
    craneFightEncounter:StartWave(2)
  end, {count = 2})
  craneFightEncounter:OnEnemyDeath(function()
    craneFightEncounter:StartWave(3)
  end, {count = 3})
  craneFightEncounter:OnComplete(craneFightEncounterComplete)
  craneFightEncounter:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Stinger")
  end)
  craneFightEncounter:SetStartZone(GameObjects.CraneSpawnZn)
  craneFightMonitor = monitors.CreateEntityZoneMonitor(Player, GameObjects.CraneFightZn)
  craneFightMonitor:OnEnter(function()
    craneFightEncounter:AlertEnemies()
  end)
  craneFightMonitor:SetTriggerCountLimit(1)
end
function Area_1_Fight_2()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  elevatorFallEncounter = EC.NewEncounter(thisLevel, "Encounter 1, Elevator Fall Fight", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl450_AI",
    LeashZone = "NavLeash_Area1B",
    StartMusic = "SND_MX_XPL450_darkelf_fight_in",
    StopMusic = "SND_MX_XPL450_darkelf_fight_out"
  })
  elevatorFallEncounter:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Darkone_Q_SBR",
      spawnLocators = "A1_F2_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Darkone_Q_SBF",
      spawnLocators = "A1_F2_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "Darkone_Q_SBL",
      spawnLocators = "A1_F2_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    }
  })
  elevatorFallEncounter:AddWave({
    powerLevel = powerLevel,
    {
      spawners = "Darkone_H_SBR",
      spawnLocators = "A1_F2_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Darkone_Q_SBL",
      spawnLocators = "A1_F2_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8
    }
  })
  elevatorFallEncounter:SetStartZone(GameObjects.EntZn_EFall_Start)
  elevatorFallEncounter:OnEnemyDeath(function()
    elevatorFallEncounter:StartWave(2)
  end, {count = 2})
  elevatorFallEncounter:OnStart(function()
    game.World.StoreCheckpoint()
  end)
  elevatorFallEncounter:OnComplete(elevatorFallEncounterComplete)
  elevatorFallEncounter:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl450_HuldraMines")
    thisLevel:CallScript("SetRoom1EncounterBComplete")
  end)
end
function Area_2_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  caveFightEncounter = EC.NewEncounter(thisLevel, "Encunter 2, Cave Fight", {CheckpointOnComplete = true, spawnWad = "Xpl450_AI"})
  caveFightEncounter:AddWave({
    {
      spawners = "Flyer_Bat",
      spawnLocators = "A2_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    },
    {
      spawners = "Flyer_Bat",
      spawnLocators = "A2_O_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = powerLevel
    }
  })
  caveFightEncounter:OnComplete(caveFightEncounterComplete)
  caveFightEncounter:OnComplete(function()
    _G.CheckBanter_Brok2_SilenceDaRing()
  end)
  caveFightEncounter:SetStartZone(GameObjects.caveFightZn)
end
function Area_2_Fight_2()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  tendrilSurprise = EC.NewEncounter(thisLevel, "Tendril Surprise", {CheckpointOnComplete = true, spawnWad = "Xpl450_AI"})
  tendrilSurprise:AddWave({
    {
      spawners = "Flyer_S",
      spawnLocators = "A2_O_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel
    }
  })
  tendrilSurprise:SetStartZone(GameObjects.EntZnTendrilFlyer)
end
function Area_3_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  beachFightEncounter = EC.NewEncounter(thisLevel, "Encounter 3, Traveler_Fight", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_Area7"
  })
  beachFightEncounter:AddWave({
    {
      spawners = "Traveler_SRC",
      markerID = "Traveler",
      spawnLocators = "A3_O_Loc_5",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl450_AI_02",
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  beachFightEncounter:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Flyer10_SAG",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl450_AI",
      spawnCooldown = 0,
      powerLevel = powerLevel
    },
    {
      spawners = "Flyer10_SAG",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl450_AI",
      spawnCooldown = 1.8,
      powerLevel = powerLevel
    }
  })
  beachFightEncounter:AddWave({
    prioritizeOnScreenSpawners = true,
    triggerWaveFromScript = true,
    {
      spawners = "Crawler_N_S",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl450_AI",
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    },
    {
      spawners = "Crawler_N_S",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl450_AI",
      totalSpawns = 1,
      spawnCooldown = 15,
      powerLevel = powerLevel
    }
  })
  beachFightEncounter:SetStartZone(GameObjects.Arena_Spawn3)
  beachFightEncounter:OnEnemySpawn(Traveler_Health_Encounter, {markerID = "Traveler"})
  ZM_A3_E1_Start = monitors.CreateEntityZoneMonitor(Player, GameObjects.beachFightZn)
  ZM_A3_E1_Start:OnEnter(function()
    beachFightEncounter:StartWave(2)
  end)
  beachFightEncounter:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Traveler")
    local thisLevel = game.FindLevel("Xpl450_HuldraMines")
    thisLevel:CallScript("SetRoom3EncounterComplete")
  end)
end
local Traveler_Next = function()
  beachFightEncounter:StartWave()
end
function Traveler_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Traveler_Health = Enemy:GetHitPoints()
    Traveler_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Traveler_Health * 0.65
    local Health_Phase_2 = Traveler_Health * 0.3
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_1, Traveler_Next)
    Traveler_HealthMonitor:OnHealthLessThan(Health_Phase_2, Traveler_Next)
  end
end
function Area_4_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "Encounter 4, Before Climb", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl450_AI",
    LeashZone = "NavLeash_Area4"
  })
  Area_4_Encounter_1:AddWave({
    timeBeforeNextWave = 2,
    {
      spawners = "LVL2_Darkone_H_SFGN",
      spawnLocators = "A4_E_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Darkone_H_SFGN",
      spawnLocators = "A4_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 1.5,
      powerLevel = powerLevel
    }
  })
  Area_4_Encounter_1:SetStartZone(GameObjects.EntZn_Area_4_Attack)
end
function Area_5_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  finalFightEncounter = EC.NewEncounter(thisLevel, "Encunter 5, Climb Fight", {CheckpointOnComplete = true, spawnWad = "Xpl450_AI"})
  finalFightEncounter:AddWave({
    {
      spawners = "E_Darkone_N_S",
      markerID = "E_DarkOne",
      spawnLocators = "A5_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
  finalFightEncounter:AddWave({
    prioritizeOnScreenSpawners = true,
    triggerWaveFromScript = true,
    {
      spawners = "Darkone_Q_SBF",
      spawnLocators = "A5_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    },
    {
      spawners = "Darkone_Q_SBF",
      spawnLocators = "A5_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = powerLevel
    }
  })
  finalFightEncounter:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Darkone_H_SBF",
      spawnLocators = "A5_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    },
    {
      spawners = "Darkone_H_SBF",
      spawnLocators = "A5_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = powerLevel
    }
  })
  finalFightEncounter:SetStartZone(GameObjects.EntZnFinalFight)
  finalFightEncounter:OnEnemyDeath(function()
    finalFightEncounter:StartWave(3)
  end, {count = 2})
  finalFightEncounter:OnStart(finalFightEncounterStart)
  finalFightEncounter:OnComplete(finalFightEncounterComplete)
  finalFightEncounter:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl450_HuldraMines")
    thisLevel:CallScript("SetRoom4EncounterComplete")
  end)
  finalFightEncounter:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Elite")
  end)
  finalFightEncounter:OnEnemySpawn(EliteDarkOne_Health_Encounter, {markerID = "E_DarkOne"})
end
local EliteDarkOne_A5EC1_Next = function()
  finalFightEncounter:StartWave(2)
end
function EliteDarkOne_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local E_DarkOneHealth = Enemy:GetHitPoints()
    EliteDarkOne_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = E_DarkOneHealth * 0.7
    EliteDarkOne_HealthMonitor:OnHealthLessThan(Health_Phase_1, EliteDarkOne_A5EC1_Next)
  end
end
function Area_6_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel = 4
  elseif 600 <= cineNumber then
    powerLevel = 5
  end
  postCartColEncounter = EC.NewEncounter(thisLevel, "Encounter 6, Post Cart Col Fight", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl450_AI",
    LeashZone = "NavLeash_Area6"
  })
  postCartColEncounter:AddWave({
    {
      spawners = "Crawler_N_S",
      spawnLocators = "A6_O_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel
    }
  })
  DespawnCrawler = monitors.CreateEntityZoneMonitor(Player, GameObjects.EntZn_CrawlerDespawner)
  DespawnCrawler:OnEnter(function()
    if postCartColEncounter:IsRunning() then
      postCartColEncounter:DespawnEnemies(1)
    end
  end)
end
function Backtrack_Area_1_Fight_3()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel = 5
  end
  postCartColEncountwo = EC.NewEncounter(thisLevel, "Encounter 7, Post Cart Col Fight2", {CheckpointOnComplete = true, spawnWad = "Xpl450_AI"})
  postCartColEncountwo:AddWave({
    requireOnScreenSpawners = true,
    {
      spawners = "LVL2_Darkone_Q_SFA",
      spawnLocators = "A1_F3_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.3,
      powerLevel = powerLevel
    },
    {
      spawners = "LVL2_Darkone_Q_SFA",
      spawnLocators = "A1_F3_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel
    }
  })
end
function Area_3_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Enemy_Health = Enemy:GetHitPoints()
    E_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Phase_1 = Enemy_Health * 0.65
    local Phase_2 = Enemy_Health * 0.3
    E_HealthMonitor:OnHealthLessThan(Phase_1, function()
      beachFightEncounter:StartWave()
    end)
    E_HealthMonitor:OnHealthLessThan(Phase_2, function()
      beachFightEncounter:StartWave()
    end)
  end
end
function Repop_Area_1_Fight_1()
  Repop_A1E1 = EC.NewEncounter(thisLevel, "Repop Encounter 1, Crane Fight", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl450_AI",
    LeashZone = "NavLeash_Area1B",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "Encounter 1, Crane Fight",
      "Encunter 5, Climb Fight"
    }
  })
  Repop_A1E1:AddWave({
    requireSpawnersInRange = {3, 30},
    {
      spawners = "T4_Flyer_S_SPG",
      spawnLocators = "A1_F1_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Flyer_S_SPG",
      spawnLocators = "A1_F3_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "T4_Flyer_S_SPG",
      spawnLocators = "A1_F1_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Repop_A1E1:SetStartZone(GameObjects.CraneFightZn)
end
function Repop_Area_3_Fight_1()
  Repop_A3E1 = EC.NewEncounter(thisLevel, "Repop Encounter 3, Beach Fight", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl450_AI",
    LeashZone = "NavLeash_Area7",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "Encounter 3, Traveler_Fight",
      "Encunter 5, Climb Fight"
    }
  })
  Repop_A3E1:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "T4_Crawler_N_S",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Crawler_N_S",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      totalSpawns = 1,
      spawnCooldown = 7
    },
    {
      spawners = "T4_Crawler_N_S",
      spawnLocators = "A3_O_Loc_*",
      useSpawnLocatorsOnly = true,
      totalSpawns = 1,
      spawnCooldown = 15
    }
  })
  Repop_A3E1:SetStartZone(GameObjects.beachFightReturnZn)
end
function Repop_Area_5_Fight_1()
  Repop_A5E1 = EC.NewEncounter(thisLevel, "Repop Encounter 5", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl450_AI",
    LeashZone = "NoGo_FinalFight",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "Encunter 5, Climb Fight"
    }
  })
  Repop_A5E1:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "T4_Darkone_Q_SFA",
      spawnLocators = "A5_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_Darkone_Q_SFA",
      spawnLocators = "A5_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "T4_Darkone_Q_SFA",
      spawnLocators = "A5_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Repop_A5E1:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "LVL2_Darkone_H_SBF",
      spawnLocators = "A5_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "LVL2_Darkone_H_SBF",
      spawnLocators = "A5_E_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Repop_A5E1:SetStartZone(GameObjects.Zn_Repop_A5E1)
  Repop_A5E1:OnEnemyDeath(function()
    Repop_A5E1:StartWave(2)
  end, {count = 2})
end
function OnSaveCheckpoint(level, obj)
  return {
    temp_craneFightEncounterDone = craneFightEncounterDone,
    temp_beachFightDone = beachFightDone,
    temp_finalFightDone = finalFightDone
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  craneFightEncounterDone = savedInfo.temp_craneFightEncounterDone
  beachFightDone = savedInfo.temp_beachFightDone
  finalFightDone = savedInfo.temp_finalFightDone
end
