local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local CSL = require("camera.shakelibrary")
local player, son, thisLevel, elevatorDropClimb, elevatorShaftPath, elevatorGonePath, elevatorBlockerPath, blockerMonitor, dropMonitor, elevatorDropCol, elevatorPitCol
local elevatorPathUnlocked = false
local vibratePathUnlocked = false
local secondPathUnlocked = false
local checkPointZn_waterfallRoom, checkPointZn_waterfallRoomMonitor, checkPointZn_treasureRoom, checkPointZn_treasureRoomMonitor, ropeDropMonitor, cart
local chestOpened = false
local colMineCart, rewardCaveTendrilCol, backCaveTendrilCol, squeezewayTendrilCol, navObstaclePitOne
local room1GateOpened = false
local room1EncounterAComplete = false
local room1EncounterBComplete = false
local squeezeTendrilsCleared = false
local rewardTendrilsCleared = false
local backCaveTendrilsCleared = false
local room3EncounterComplete = false
local room4BarrierBroken = false
local sonBoostGateOpened = false
local room4EncounterComplete = false
local bInteractedWithPushCart = false
local golemBodyBanterComplete = false
local HammerLooted = false
local sonNotAvailableForSync = false
local xpl450MusicEnter = false
local xpl450MusicExplore = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  thisLevel = level
  elevatorDropClimb = GameObjects.elevatorDropClimb
  elevatorShaftPath = GameObjects.elevatorShaftPath
  elevatorDropCol = GameObjects.elevatorDropCol
  elevatorPitCol = GameObjects.elevatorPitCol
  rewardCaveTendrilCol = GameObjects.Tendrils_RewardCave_Col
  backCaveTendrilCol = GameObjects.Tendrils_BackCave_Col
  squeezewayTendrilCol = GameObjects.Tendrils_Squeezeway_Col
  elevatorBlockerPath = GameObjects.elevatorBlockerPath
  elevatorGonePath = GameObjects.elevatorGonePath
  navObstaclePitOne = GameObjects.NavObstacle_Pit_01
  cart = GameObjects.cartBoom
  colMineCart = GameObjects.col_mine_cart
  SoundInit()
  game.Audio.StartMusicMaster("SND_MX_XPL450_start_master")
  local elevatorswitch = GameObjects.xpl450_DropLift_switch1
  if elevatorswitch ~= nil then
    elevatorswitch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Nar_XPL450_Elevator")
    elevatorswitch.LuaObjectScript.OverrideCameraSubmissionTime(2)
  end
end
function OnFirstStart(level)
  GameObjects.Elevator_BottomBlocker:Hide()
  elevatorPitCol:HideCollision()
  GameObjects.elevatorDropBuddyDrop:HideTraversePath()
  GameObjects.elevatorBuddyDropCol:HideCollision()
  elevatorDropClimb:HideTraversePath()
  elevatorShaftPath:HideTraversePath()
  elevatorGonePath:HideTraversePath()
  GameObjects.TraverseLink_SonOnly_01:HideTraverseLink()
  GameObjects.TraverseLink_5MDrop_DropBlock:HideTraverseLink()
  GameObjects.TraverseLink_MineCartRopeDrop:HideTraverseLink()
  SetGatewayMarker()
  GameObjects.sonRopeDrop450.LuaObjectScript.DisablePlayerInteract()
  GameObjects.ClearSonAvailabilityZone:HideEntityVolume()
  GameObjects.NavObstacle_DropBlock01:HideNavObstacle()
  GameObjects.NavObstacle_DropBlock02:HideNavObstacle()
end
function OnStart(level)
  if elevatorPathUnlocked == false then
    elevatorDropCol:HideCollision()
  elseif elevatorPathUnlocked == true then
    elevatorDropCol:ShowCollision()
  end
  if vibratePathUnlocked == false then
    LD.CallFunctionAfterDelay(function()
      ElevatorBifrostDisable()
    end, 2)
    navObstaclePitOne:HideNavObstacle()
  elseif vibratePathUnlocked == true then
    navObstaclePitOne:ShowNavObstacle()
  end
  if room4EncounterComplete == true and sonBoostGateOpened == false then
    GameObjects.finalFight_SonBoost.LuaObjectScript.Enable()
  end
  SoundOnStart()
  local ZiplineA_TopPos = GameObjects.ZiplineA_Top
  local ZiplineA_BottomPos = GameObjects.ZiplineA_Bottom
  local ZiplineA = GameObjects.zipline_Xpl450A
  ZiplineA:SetZiplineStartAndEnd(ZiplineA_TopPos:GetWorldPosition(), ZiplineA_BottomPos:GetWorldPosition())
  local ZiplineB_TopPos = GameObjects.ZiplineB_Top
  local ZiplineB_BottomPos = GameObjects.ZiplineB_Bottom
  local ZiplineB = GameObjects.zipline_Xpl450B
  ZiplineB:SetZiplineStartAndEnd(ZiplineB_TopPos:GetWorldPosition(), ZiplineB_BottomPos:GetWorldPosition())
  local chest = GameObjects.chest_common_tier2_xpl450_1.LuaObjectScript
  local chest_states = {
    ENABLED = 1,
    DISABLED = 2,
    LOCKED = 3,
    OPENED = 4
  }
  if GameObjects.barrier_rivPass_4wide_break3.Child:GetBreakable().Broken == true and chest.GetState() == chest_states.DISABLED then
    chest.Enable()
  end
end
function OnUpdate(level)
  if bInteractedWithPushCart == true and player:IsPlayingMove("MOV_SpartanKickHitSync") then
    bInteractedWithPushCart = false
    PlayCartShake()
  end
end
function Xpl475LoadCheck()
  game.UI.LoadCheck("Xpl475_HuldraMinesLH")
end
function ElevatorVibrateHit()
  PlaySoundVibrateHit()
  timer.StartLevelTimer(0.68, function()
    CSL.PlayShake("FSE_SHAKE_CRASH_MEDIUM", 2.6, 0, 0.69)
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_EXTREME",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5}
    })
  end)
  timer.StartLevelTimer(1.9, function()
    CSL.PlayShake("FSE_SHAKE_VERTICAL_LANDING", 0.86, 0, 0)
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5}
    })
  end)
  local elevatorbreakable = GameObjects.Xpl450_vibrate_crash_down_break.Child:GetBreakable()
  local vibratebreakable = GameObjects.Xpl450_vibrate_craneDrop.Child:GetBreakable()
  if elevatorbreakable.Broken == false then
    elevatorbreakable:Break()
  end
  if vibratebreakable.Broken == false then
    vibratebreakable:Break()
  end
  PlayBanter_Brok2_DidNotLike()
  GameObjects.xpl450_vibrate_crash_down_floor_brk:PlayAnimToFrame(120)
  StopSoundRopeCreak1()
  elevatorShaftPath:ShowTraversePath()
  vibratePathUnlocked = true
  SetGatewayMarker()
  elevatorPitCol:ShowCollision()
  navObstaclePitOne:ShowNavObstacle()
  GameObjects.elevatorDropBuddyDrop:HideTraversePath()
  GameObjects.elevatorBuddyDropCol:HideCollision()
  Room1CA_Enable()
  Room1LTW_Enable()
  GameObjects.CA_Combat_Turret_DropBlock.LuaObjectScript.Enable()
  GameObjects.TraverseLink_5MDrop_DropBlock:ShowTraverseLink()
  GameObjects.CA_Idle_Room1_DropBlock.LuaObjectScript.Disable()
  MusicFloorBreak()
end
function SetGatewayMarker()
  if vibratePathUnlocked then
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper4", true)
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper3", false)
  else
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper4", false)
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper3", true)
  end
  if secondPathUnlocked then
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper13", false)
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper22", false)
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper18", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper13", true)
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper22", true)
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper18", false)
  end
  if HammerLooted then
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper21", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("HM02_450_Helper21", false)
  end
end
function EnableElevatorPitCol()
  if vibratePathUnlocked ~= true then
    elevatorPitCol:ShowCollision()
  end
end
function DisableElevatorPitCol()
  timer.StartLevelTimer(2.25, function()
    if vibratePathUnlocked ~= true then
      elevatorPitCol:HideCollision()
    end
  end)
end
function ElevatorBlockerRemoved()
  elevatorBlockerPath:HideTraversePath()
  elevatorGonePath:ShowTraversePath()
  secondPathUnlocked = true
  SetGatewayMarker()
  game.World.StoreCheckpoint()
end
function ElevatorDropped()
  elevatorDropClimb:ShowTraversePath()
  elevatorDropCol:ShowCollision()
  elevatorPathUnlocked = true
  Room1CA_Enable()
  Room1LTW_Enable()
  GameObjects.NavObstacle_DropBlock01:ShowNavObstacle()
  GameObjects.NavObstacle_DropBlock02:ShowNavObstacle()
  LD.CallFunctionAfterDelay(function()
    game.World.StoreCheckpoint()
  end, 4)
end
function ElevatorBifrostEnable()
  if vibratePathUnlocked == false then
    GameObjects.bifrostvibrate_fractured.Child.Child:ShowCollision()
  end
end
function ElevatorBifrostDisable()
  if vibratePathUnlocked == false then
    GameObjects.bifrostvibrate_fractured.Child.Child:HideCollision()
  end
end
function DropRope()
  GameObjects.sonRopeDrop450.LuaObjectScript.Enable()
end
function xpl450ShortcutElevator_Toggle()
  if GameObjects.xpl450ShortcutElevator.AnimFrame == 0 then
    GameObjects.xpl450ShortcutElevator:PlayAnimToEnd(1)
  elseif GameObjects.xpl450ShortcutElevator.AnimFrame == GameObjects.xpl450ShortcutElevator.AnimLengthFrames then
    GameObjects.xpl450ShortcutElevator:PlayAnimToEnd(-1)
  end
end
function PlayCartShake()
  timer.StartLevelTimer(0, function()
    CSL.PlayShake("FSE_SHAKE_ROLLING_OBJECT_MEDIUM", 2.8, 0, 0.69)
  end)
  timer.StartLevelTimer(2.76, function()
    CSL.PlayShake("FSE_SHAKE_CRASH_IMMOVABLE", 2.3, 0.3, 2.6)
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_EXTREME",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5}
    })
  end)
end
function PushCart()
  bInteractedWithPushCart = true
  SetGatewayMarker()
  game.Audio.PlayBanter("Brok2_SomethingEvil_Contd")
  LD.PlaySingleSynchMove_KratosObject(GameObjects.cartBoom, "syncJoint", "Xpl450 Kick Cart", "BRA_SpartanKickHitSync", "")
  Room5_MineCartCA_Disable()
  GameObjects.CA_Observe_On_Alert_Room5.LuaObjectScript.Enable()
  timer.StartLevelTimer(3, function()
    GameObjects.ReactionStim_MineCart.LuaObjectScript.Trigger()
  end)
  cart:OnAnimDone(thisLevel, "HideMineCartCol")
  LD.CallFunctionAfterDelay(function()
    GameObjects.xpl450_huldramines_minecard.Child:PlayAnimToEnd()
  end, 0.75)
  PlaySoundCartPush()
end
function DropLift01()
  GameObjects.CA_Observe_Forward_Up_Room1.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Room1_DropBlock.LuaObjectScript.Disable()
  timer.StartLevelTimer(1.1, function()
    CSL.PlayShake("FSE_SHAKE_CRASH_MEDIUM", 1.6, 0, 0.69)
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_EXTREME",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5}
    })
  end)
  GameObjects.xpl450_crane_release_down_break.Child:PlayAnimToEnd()
  PlaySoundElevator1Drop()
  ElevatorDropped()
  StopSoundRopeCreak2()
  game.World.StoreCheckpoint()
  timer.StartLevelTimer(1, function()
    GameObjects.ReactionStim_DropBlock.LuaObjectScript.Trigger()
  end)
  timer.StartLevelTimer(2.5, function()
    GameObjects.CA_Idle_Room1_DropBlock.LuaObjectScript.Enable()
  end)
end
function DropLift02()
  timer.StartLevelTimer(0.75, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 6,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5}
    })
  end)
  timer.StartLevelTimer(6.75, function()
    game.Blender.Trigger({
      Priority = 10,
      Name = "FFB_GENERIC_RUMBLE_EXTREME",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5}
    })
  end)
  PlaySoundLiftMove()
  ElevatorBlockerRemoved()
  GameObjects.elevator_pathBlocker:PlayAnimToEnd()
  GameObjects.ReactionStim_DropLift02.LuaObjectScript.Trigger()
end
function HideMineCartCol()
  colMineCart:Hide()
  GameObjects.Xpl450_Encounters.LuaObjectScript:startPostCartCol()
  GameObjects.sonRopeDrop450.LuaObjectScript.EnablePlayerInteract()
  game.World.StoreCheckpoint()
end
function TendrilColOneDisable()
  rewardCaveTendrilCol:Hide()
  SetRewardTendrilsCleared()
  Room2CA_Enable()
end
function TendrilColBackCaveDisable()
  backCaveTendrilCol:Hide()
  SetBackCaveTendrilsCleared()
  Room3CA_Enable()
end
function TendrilColSqueezewayDisable()
  squeezewayTendrilCol:Hide()
  SetSqueezeTendrilsCleared()
end
function SqueezewayTendrilDecay()
  for _, v in pairs(GameObjects.RootsSqueezeway.Children) do
    if v.Child.LuaObjectScript then
      v.Child.LuaObjectScript.StartDecay()
    end
  end
end
function RewardCaveTendrilDecay()
  for _, v in pairs(GameObjects.RootsRewardCave.Children) do
    if v.Child.LuaObjectScript then
      v.Child.LuaObjectScript.StartDecay()
    end
  end
end
function BackCaveTendrilDecay()
  for _, v in pairs(GameObjects.RootsBackCave.Children) do
    if v.Child.LuaObjectScript then
      v.Child.LuaObjectScript.StartDecay()
      LD.CallFunctionAfterDelay(function()
        TendrilColBackCaveDisable()
      end, 2.5)
    end
  end
end
function EnableLootCoffinShaft()
  GameObjects.coffin_tier5_xpl450_1.LuaObjectScript.Enable()
end
function ShowMineCartRopeDropTraverseLink()
  GameObjects.TraverseLink_MineCartRopeDrop:ShowTraverseLink()
end
function SetRoom1GateOpened()
  room1GateOpened = true
end
function SetRoom1EncounterAComplete()
  room1EncounterAComplete = true
  GameObjects.CA_Post_Up_RunningEnter_Room1_CrawlExit.LuaObjectScript.Disable()
end
function SetRoom1EncounterBComplete()
  room1EncounterBComplete = true
  GameObjects.CA_Combat_Turret_DropBlock.LuaObjectScript.Disable()
  son:CallScript("ClearBehaviorContext")
end
function SetRewardTendrilsCleared()
  rewardTendrilsCleared = true
end
function SetSqueezeTendrilsCleared()
  squeezeTendrilsCleared = true
end
function SetBackCaveTendrilsCleared()
  backCaveTendrilsCleared = true
end
function SetRoom3EncounterComplete()
  room3EncounterComplete = true
  EnableGolemContextAction()
end
function SetRoom4BarrierBroken()
  room4BarrierBroken = true
  Room4CatwalkCA_Enable()
end
function SetRoom4EncounterComplete()
  room4EncounterComplete = true
  Room4ArenaCA_Enable()
end
function ShowSonTraverseLink()
  GameObjects.TraverseLink_SonOnly_01:ShowTraverseLink()
end
function SetSonBoostGateOpened()
  sonBoostGateOpened = true
  GameObjects.TraverseLink_SonOnly_01:HideTraverseLink()
  Room4ArenaCA_Enable()
end
function SetSonOccupied()
  local availabilityState = {Unoccupied = false}
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function SetSonUnoccupied()
  son:RemoveAvailabilityRequest("LevelDesignScript")
  sonNotAvailableForSync = false
  print("sonNotAvailableForSync false")
end
function SetSonNotAvailForSync()
  if room1EncounterBComplete == true then
    local availabilityState = {
      AvailableForSync = false,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = true
    }
    son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
    sonNotAvailableForSync = true
    print("sonNotAvailableForSync true")
  end
end
function EntranceCA_Enable()
  GameObjects.LTW_Entrance.LuaObjectScript.Enable()
end
function EntranceCA_Disable()
  GameObjects.LTW_Entrance.LuaObjectScript.Disable()
end
function Room1CrawlExitCA_Enable()
  if room1EncounterAComplete == false then
    GameObjects.CA_Post_Up_RunningEnter_Room1_CrawlExit.LuaObjectScript.Enable()
  elseif room1EncounterAComplete == true then
    GameObjects.CA_Sync_Room1_CrawlExit.LuaObjectScript.Enable()
    GameObjects.CA_Post_Up_RunningEnter_Room1_CrawlExit.LuaObjectScript.Disable()
  end
end
function Room1LTW_Enable()
  GameObjects.LTW_Room1E.LuaObjectScript.Enable()
  if elevatorPathUnlocked == false then
    GameObjects.LTW_Room1A.LuaObjectScript.Enable()
  elseif elevatorPathUnlocked == true then
    GameObjects.LTW_Room1A.LuaObjectScript.Disable()
    if room1GateOpened == false then
      GameObjects.LTW_Room1B.LuaObjectScript.Enable()
    elseif room1GateOpened == true then
      GameObjects.LTW_Room1C.LuaObjectScript.Enable()
      GameObjects.LTW_Room1B.LuaObjectScript.Disable()
    end
  end
end
function ActivateRm1BeckonCA()
  if elevatorPathUnlocked == false and room1EncounterBComplete == false then
    GameObjects.CA_BeckonToMe_Room1.LuaObjectScript.Enable()
    GameObjects.Rm1IdleContextZone.LuaObjectScript.Enable()
  end
end
function CombatTurretCheck()
  if room1EncounterBComplete == false then
    GameObjects.CA_Combat_Turret_DropBlock.LuaObjectScript.Enable()
  end
end
function DeactivateRm1TurretCA()
  GameObjects.CA_Combat_Turret_DropBlock.LuaObjectScript.Disable()
  GameObjects.Rm1IdleContextZone.LuaObjectScript.Disable()
  GameObjects.ClearSonAvailabilityZone:ShowEntityVolume()
  GameObjects.CA_IdleBehavior_PitTop.LuaObjectScript.Enable()
  SetSonOccupied()
end
function Room1LTW_Disable()
  GameObjects.LTW_Room1A.LuaObjectScript.Disable()
  GameObjects.LTW_Room1B.LuaObjectScript.Disable()
  GameObjects.LTW_Room1C.LuaObjectScript.Disable()
  GameObjects.LTW_Room1E.LuaObjectScript.Disable()
end
function Room1PostVibrateCA_Enable()
  print("NotAvailforSync")
  if vibratePathUnlocked == true and room1EncounterBComplete == true then
    GameObjects.CA_Idle_Room1_DropBlock_PostVibrate.LuaObjectScript.Enable()
  end
  SetSonNotAvailForSync()
end
function Room1PostVibrateCA_Disable()
  GameObjects.CA_Idle_Room1_DropBlock_PostVibrate.LuaObjectScript.Disable()
  SetSonUnoccupied()
end
function DropBlockClimbBottom_ExitCheck()
  if vibratePathUnlocked == false and sonNotAvailableForSync == false then
    GameObjects.CA_Idle_Room1_DropBlockClimbExit.LuaObjectScript.Enable()
  end
end
function Room1CA_Enable()
  if elevatorPathUnlocked == false and vibratePathUnlocked == false then
    GameObjects.CA_Observe_Forward_Up_Room1_DropBlock.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Room1.LuaObjectScript.Enable()
  elseif elevatorPathUnlocked == true and vibratePathUnlocked == false then
    GameObjects.CA_Idle_Room1_DropBlock.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Up_Room1_DropBlock.LuaObjectScript.Disable()
  elseif vibratePathUnlocked == true then
    GameObjects.CA_Observe_Forward_Up_Room1.LuaObjectScript.Disable()
    GameObjects.CA_Idle_Room1_DropBlock.LuaObjectScript.Disable()
  end
end
function Room1CA_Disable()
  GameObjects.CA_Observe_Forward_Up_Room1.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Room1_DropBlock.LuaObjectScript.Disable()
  GameObjects.CA_Idle_Room1_DropBlock.LuaObjectScript.Disable()
  GameObjects.CA_Block_BoostDrop.LuaObjectScript.Disable()
  GameObjects.CA_Post_Up_RunningEnter_Room1_CrawlExit.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_PitTop.LuaObjectScript.Disable()
  GameObjects.CA_Sync_Room1_CrawlExit.LuaObjectScript.Disable()
end
function Room2CA_Enable()
  GameObjects.LTW_Room2A.LuaObjectScript.Enable()
  if rewardTendrilsCleared == true then
    GameObjects.LTW_Room2C.LuaObjectScript.Enable()
  end
end
function Room2CA_Disable()
  GameObjects.LTW_Room2A.LuaObjectScript.Disable()
  GameObjects.LTW_Room2C.LuaObjectScript.Disable()
end
function Room2TunnelExitCheck()
  if squeezeTendrilsCleared == false then
    GameObjects.CA_Idle_Room2_ClimbB_ExitTop.LuaObjectScript.Enable()
  elseif squeezeTendrilsCleared == true then
    GameObjects.CA_Sync_Room2_ClimbB_ExitTop.LuaObjectScript.Enable()
  end
end
function WallPressExitCA_Enable()
  if room3EncounterComplete == false then
    GameObjects.CA_Observe_On_Alert_Room3_Combat.LuaObjectScript.Enable()
  elseif room3EncounterComplete == true then
    GameObjects.CA_Observe_Forward_Up_Room3_A.LuaObjectScript.Enable()
  end
end
function Room3CA_Enable()
  GameObjects.LTW_Room3B.LuaObjectScript.Enable()
  GameObjects.LTW_Room3D.LuaObjectScript.Enable()
  if backCaveTendrilsCleared == false then
    GameObjects.CA_LookUnderObject_Forward_Room3Tendrils.LuaObjectScript.Enable()
  elseif backCaveTendrilsCleared == true then
    GameObjects.LTW_Room3C.LuaObjectScript.Enable()
    GameObjects.CA_LookUnderObject_Forward_Room3Tendrils.LuaObjectScript.Disable()
  end
  if room3EncounterComplete == true then
    if golemBodyBanterComplete == false then
      GameObjects.CA_Observe_Forward_Brok2_ItsYourFault.LuaObjectScript.Enable()
    elseif golemBodyBanterComplete == true then
      GameObjects.CA_Observe_Forward_Brok2_ItsYourFault.LuaObjectScript.Disable()
    end
  end
end
function Room3CA_Disable()
  GameObjects.LTW_Room3B.LuaObjectScript.Disable()
  GameObjects.LTW_Room3C.LuaObjectScript.Disable()
  GameObjects.LTW_Room3D.LuaObjectScript.Disable()
  GameObjects.CA_Observe_On_Alert_Room3_Combat.LuaObjectScript.Disable()
  GameObjects.CA_LookUnderObject_Forward_Room3Tendrils.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Brok2_ItsYourFault.LuaObjectScript.Disable()
end
function Room4CA_Enable()
  GameObjects.LTW_Room4_Start.LuaObjectScript.Enable()
end
function Room4CA_Disable()
  GameObjects.LTW_Room4_Start.LuaObjectScript.Disable()
end
function Room4CatwalkCA_Enable()
  if room4BarrierBroken == false then
    GameObjects.LTW_Room4A.LuaObjectScript.Enable()
  elseif room4BarrierBroken == true then
    GameObjects.LTW_Room4A_BarrierGone.LuaObjectScript.Enable()
    GameObjects.LTW_Room4A.LuaObjectScript.Disable()
  end
end
function Room4CatwalkCA_Disable()
  GameObjects.LTW_Room4A.LuaObjectScript.Disable()
  GameObjects.LTW_Room4A_BarrierGone.LuaObjectScript.Disable()
end
function Room4CrackClimbTop_Enable()
  if room4EncounterComplete == false then
    GameObjects.CA_Observe_On_Alert_Room4_Arena.LuaObjectScript.Enable()
  elseif room4EncounterComplete == true and sonBoostGateOpened == false then
    GameObjects.CA_Idle_Room4_LedgeTopExit.LuaObjectScript.Enable()
  elseif room4EncounterComplete == true and sonBoostGateOpened == true then
    GameObjects.CA_Sync_Room4_LedgeTopExit.LuaObjectScript.Enable()
    GameObjects.CA_Observe_On_Alert_Room4_Arena.LuaObjectScript.Disable()
  end
end
function Room4ArenaCA_Enable()
  if sonBoostGateOpened == false then
    GameObjects.CA_Point_Forward_Room4_Chest.LuaObjectScript.Enable()
  elseif sonBoostGateOpened == true then
    GameObjects.LTW_Room5A.LuaObjectScript.Enable()
    GameObjects.CA_Point_Forward_Room4_Chest.LuaObjectScript.Disable()
  end
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" and chestOpened == false then
    GameObjects.CA_BeckonToMe_Room5_Chest.LuaObjectScript.Enable()
    GameObjects.CA_Observe_Forward_Room5_Chest.LuaObjectScript.Enable()
  elseif questState == "Active" and chestOpened == true then
    GameObjects.CA_BeckonToMe_Room5_Chest.LuaObjectScript.Disable()
    GameObjects.CA_Observe_Forward_Room5_Chest.LuaObjectScript.Disable()
  end
end
function Room4ArenaCA_Disable()
  GameObjects.CA_Point_Forward_Room4_Chest.LuaObjectScript.Disable()
  GameObjects.LTW_Room5A.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_Room5_Chest.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Room5_Chest.LuaObjectScript.Disable()
  GameObjects.CA_Point_Forward_Room4_Chest.LuaObjectScript.Disable()
  GameObjects.CA_Observe_On_Alert_Room4_Arena.LuaObjectScript.Disable()
  GameObjects.CA_Observe_On_Alert_Room5.LuaObjectScript.Disable()
end
function Room5Beckon_Enable()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" and chestOpened == false then
    timer.StartLevelTimer(1, function()
      GameObjects.CA_BeckonToMe_Room5_Chest.LuaObjectScript.Enable()
    end)
  elseif chestOpened == true then
    GameObjects.CA_BeckonToMe_Room5_Chest.LuaObjectScript.Disable()
  end
end
function Room5Beckon_Disable()
  GameObjects.CA_BeckonToMe_Room5_Chest.LuaObjectScript.Disable()
end
function Room5_MineCartCA_Enable()
  GameObjects.CA_Observe_Forward_Room5_MineCartPreStart.LuaObjectScript.Enable()
end
function Room5_MineCartCA_Disable()
  GameObjects.CA_Observe_Forward_Room5_MineCartPreStart.LuaObjectScript.Disable()
end
function CheckBanter_Brok2_IsntHappy()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function CheckBanter_Brok2_StopListening()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function PlayBanter_Brok2_DidNotLike()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    game.Audio.PlayBanter("Brok2_DidNotLike")
    StartElevatorEncounter()
  end
end
function StartElevatorEncounter()
  GameObjects.Xpl450_Encounters.LuaObjectScript:startElevatorFallEncounter()
end
function CheckBanter_Brok2_SilenceDaRing()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("Brok2_SilenceDaRing")
    end, 1)
  end
end
function CheckBanter_Brok2_SoulEater2()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function EnableGolemContextAction()
  GameObjects.CA_Observe_Forward_Brok2_ItsYourFault.LuaObjectScript.Enable()
end
function SetGolemBodyBanterComplete()
  golemBodyBanterComplete = true
end
function CheckBanter_Brok2_ItsYourFault()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    game.Audio.PlayBanter("Brok2_ItsYourFault", SetGolemBodyBanterComplete)
  end
end
function CheckBanter_Brok2_BunchATraps_Start()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" and chestOpened == false then
    GameObjects.coffin_tier3_xpl450_1.LuaObjectScript.Disable()
    game.Audio.PlayBanter("Brok2_BunchATraps_Start", function()
      GameObjects.coffin_tier3_xpl450_1.LuaObjectScript.Enable()
    end)
    return true
  else
    return false
  end
end
function PlayBanter_Brok2_BunchATraps_End()
  chestOpened = true
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    game.Audio.PlayBanter("Brok2_BunchATraps_End")
  end
  Room4ArenaCA_Enable()
end
function PlayBanter_Brok02_DontTrustRing()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    game.Audio.PlayBanter("Brok2_DontTrustRing")
  end
end
function PlayBanter_Brok2_SomethingEvil()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState == "Active" then
    if game.Audio.CanBanterConversationPlay("Brok2_SomethingEvil") then
      game.Audio.PlayBanter("Brok2_SomethingEvil", function()
        GameObjects.finalFight_SonBoost.LuaObjectScript.Enable()
      end)
    else
      GameObjects.finalFight_SonBoost.LuaObjectScript.Enable()
    end
  end
end
function CompleteObjective02()
  LD.CompleteQuest("Quest_Brok_Epic_02_Objective_02")
  game.Audio.PlayBanter("Brok2_ThankYou")
  HammerLooted = true
  SetGatewayMarker()
  Room4ArenaCA_Disable()
end
function OnElevatorMoveDown()
  GameObjects.Elevator_TopBlocker:Show()
  Room1LTW_Disable()
end
function OnElevatorMoveUp()
  GameObjects.Elevator_BottomBlocker:Show()
  Room2CA_Disable()
end
function OnElevatorReachBottomFloor()
  GameObjects.Elevator_BottomBlocker:Hide()
  Room1CA_Disable()
end
function OnElevatorReachTopFloor()
  GameObjects.Elevator_TopBlocker:Hide()
  Room1CA_Enable()
  Room1LTW_Enable()
end
function OnSaveCheckpoint(level)
  return {
    secondPathUnlocked = secondPathUnlocked,
    elevatorPathUnlocked = elevatorPathUnlocked,
    vibratePathUnlocked = vibratePathUnlocked,
    chestOpened = chestOpened,
    room1GateOpened = room1GateOpened,
    room1EncounterAComplete = room1EncounterAComplete,
    room1EncounterBComplete = room1EncounterBComplete,
    squeezeTendrilsCleared = squeezeTendrilsCleared,
    rewardTendrilsCleared = rewardTendrilsCleared,
    backCaveTendrilsCleared = backCaveTendrilsCleared,
    room3EncounterComplete = room3EncounterComplete,
    room4BarrierBroken = room4BarrierBroken,
    sonBoostGateOpened = sonBoostGateOpened,
    room4EncounterComplete = room4EncounterComplete,
    golemBodyBanterComplete = golemBodyBanterComplete,
    sonNotAvailableForSync = sonNotAvailableForSync,
    xpl450MusicEnter = xpl450MusicEnter,
    xpl450MusicExplore = xpl450MusicExplore,
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  room1GateOpened = savedInfo.room1GateOpened
  chestOpened = savedInfo.chestOpened
  room1EncounterAComplete = savedInfo.room1EncounterAComplete
  room1EncounterBComplete = savedInfo.room1EncounterBComplete
  squeezeTendrilsCleared = savedInfo.squeezeTendrilsCleared
  rewardTendrilsCleared = savedInfo.rewardTendrilsCleared
  backCaveTendrilsCleared = savedInfo.backCaveTendrilsCleared
  room3EncounterComplete = savedInfo.room3EncounterComplete
  room4BarrierBroken = savedInfo.room4BarrierBroken
  sonBoostGateOpened = savedInfo.sonBoostGateOpened
  room4EncounterComplete = savedInfo.room4EncounterComplete
  secondPathUnlocked = savedInfo.secondPathUnlocked
  elevatorPathUnlocked = savedInfo.elevatorPathUnlocked
  vibratePathUnlocked = savedInfo.vibratePathUnlocked
  golemBodyBanterComplete = savedInfo.golemBodyBanterComplete
  sonNotAvailableForSync = savedInfo.sonNotAvailableForSync
  xpl450MusicEnter = savedInfo.xpl450MusicEnter
  xpl450MusicExplore = savedInfo.xpl450MusicExplore
end
local SNDelevator1, SNDVibrateHit, SNDCart, SNDLift, SNDRopeCreak1, SNDRopeCreak2, SNDScaffoldingCreak, SNDplatformCrash
local soundEvents = {
  OnLine1Release = "SND_MECH_Pulley_Hoist_A_BRK_Line_Release_Xpl450",
  OnElevator1Drop = "SND_MECH_Pulley_Hoist_A_BRK_Ground_Impact_Xpl450",
  OnLine2Release = "SND_MECH_Pulley_Drops_Thru_Floor",
  OnVibrateHit = "SND_MECH_Pulley_Hoist_B_BRK_Floor_Collapse_Xpl450",
  OnHitFloor = "SND_MECH_Pulley_Hoist_B_BRK_Ground_Impact_Xpl450",
  OnLiftMove = "SND_MECH_Pulley_Cargo_Lift_Xpl450_LP",
  OnCartMove = "SND_MECH_Minecart_Move_Xpl450_LP",
  OnCartCrash = "SND_MECH_Minecart_Crash_Xpl450"
}
local shortcutElevatorSoundOverride = {
  SoundEmitter = nil,
  OnForward = "SND_MECH_Lift_Wood_Up_Xpl450_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Lift_Wood_Down_Xpl450_LP",
  AnimFrameOnBackward = 117,
  AnimFrameTopFloor = 117
}
function SoundInit()
  SNDelevator1 = GameObjects.SNDLineRelease1.SoundEmitters[1]
  SNDVibrateHit = GameObjects.SNDLineRelease2.SoundEmitters[1]
  SNDplatformCrash = GameObjects.Xpl450_vibrate_crash_down_break.Child:FindSingleSoundEmitterByName("SNDFloorBreak")
  SNDCart = cart:FindSingleSoundEmitterByName("SNDCart")
  SNDLift = GameObjects.SNDLift.SoundEmitters[1]
  SNDRopeCreak1 = GameObjects.SNDRopeCreak1.SoundEmitters[1]
  SNDRopeCreak2 = GameObjects.SNDRopeCreak2.SoundEmitters[1]
  SNDScaffoldingCreak = nil
  shortcutElevatorSoundOverride.SoundEmitter = GameObjects.xpl450ShortcutElevator:FindSingleSoundEmitterByName("SNDShortcutElevator")
end
function SoundOnStart()
  GameObjects.xpl450ShortcutElevator:FindSingleGOByName("xpl450_BasicElevator").LuaObjectScript.SoundSetup(shortcutElevatorSoundOverride)
  GameObjects.BoostDoor.LuaObjectScript.SoundSetup({EndFrame = 50})
end
function PlaySoundElevator1Drop()
  LD.PlaySoundOnFrame(SNDelevator1, GameObjects.xpl450_crane_release_down_break.Child, soundEvents.OnLine1Release, 1, "Forward")
  LD.PlaySoundOnFrame(SNDelevator1, GameObjects.xpl450_crane_release_down_break.Child, soundEvents.OnElevator1Drop, 29, "Forward")
end
function PlaySoundVibrateHit()
  LD.PlaySound(SNDVibrateHit, soundEvents.OnLine2Release)
  LD.PlaySoundOnFrame(SNDplatformCrash, GameObjects.Xpl450_vibrate_crash_down_break.Child, soundEvents.OnVibrateHit, 20, "Forward")
  LD.PlaySoundOnFrame(SNDplatformCrash, GameObjects.Xpl450_vibrate_crash_down_break.Child, soundEvents.OnHitFloor, 59, "Forward")
end
function PlaySoundLiftMove()
  LD.PlaySoundOnFrame(SNDLift, GameObjects.elevator_pathBlocker, soundEvents.OnLiftMove, 20, "Forward")
  LD.StopSoundOnFrame(SNDLift, GameObjects.elevator_pathBlocker, soundEvents.OnLiftMove, 200, "Forward")
end
function PlaySoundCartPush()
  LD.PlaySoundOnFrame(SNDCart, cart, soundEvents.OnCartMove, 1, "Forward")
  LD.StopSoundOnFrame(SNDCart, cart, soundEvents.OnCartMove, 70)
  LD.PlaySoundOnFrame(SNDCart, cart, soundEvents.OnCartCrash, 74.5, "Forward")
end
function StopSoundRopeCreak1()
  LD.StopSound(SNDRopeCreak1, "SND_MECH_Pulley_Hoist_Rope_Creak_LP_Xpl450")
end
function StopSoundRopeCreak2()
  LD.StopSound(SNDRopeCreak2, "SND_MECH_Pulley_Hoist_Rope_Creak_LP_Xpl450")
end
function StopSoundScaffoldingCreak()
  LD.StopSound(SNDScaffoldingCreak, "SND_AMB_EMIT_Wood_Scaffolding_Creak_LP_Xpl450")
end
function MusicXpl450Enter()
  if xpl450MusicEnter == false then
    game.Audio.StartMusic("SND_MX_XPL450_enter_mine")
    xpl450MusicEnter = true
  elseif xpl450MusicEnter == true and xpl450MusicExplore == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL450_explore1_in")
    xpl450MusicExplore = true
  end
end
function MusicXpl450Exit()
  if xpl450MusicExplore == true then
    game.Audio.StartMusic("SND_MX_XPL450_idle")
    xpl450MusicExplore = false
  end
end
function MusicXpl450Explore()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL450_explore2_in")
end
function MusicFloorBreak()
  game.Audio.StartMusic("SND_MX_XPL450_crash_floor")
end
