local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local timer = require("level.timer")
local thisObj, thisLevel, kraActor, sonActor, brokActor, ringProp, stoneProp, cameraCineEnter_BrokQuest2
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01") == "Active" then
    SetupActors()
    GameObjects.Smallshop.LuaObjectScript.DisableVendorInteract()
  end
  SetupProps()
end
function OnUpdate()
  if cameraCineEnter_BrokQuest2 ~= nil then
    cameraCineEnter_BrokQuest2:Update()
  end
end
function SpawnBrok()
  local brokRef = ND.FindBrok()
  if brokRef ~= nil then
    return brokRef
  else
    return ND.SpawnAIAtJoint(thisLevel, thisObj, "BrokQuest2_SynchJoint", "CRT_Brok00", "BRA_BrokShopIdle", "brok")
  end
end
function SetupActors()
  kraActor = actor.Actor.New("BROK QUEST 2: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("BROK QUEST 2: Son Actor", game.AI.FindSon)
  brokActor = actor.Actor.New("BROK QUEST 2: Brok Actor")
  brokActor:SetSpawnFunction(SpawnBrok)
end
function SetupProps()
  ringProp = thisObj:FindSingleGOByName("ringProp").Child
  stoneProp = thisObj:FindSingleGOByName("keyOrbProp").Child
  HideProps()
end
function HideProps()
  ringProp:Hide()
  stoneProp:Hide()
end
function ShowProps()
  ringProp:Show()
  stoneProp:Show()
end
function CompleteQuest()
  game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra2", 1)
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01")
  if questState == "Active" then
    game.QuestManager.ProposeQuestState("Quest_Brok_Epic_02_Objective_01", "Complete")
    _G.StartLevelTimer(1, Checkpoint)
  end
  GameObjects.Smallshop.LuaObjectScript.EnableVendorInteract()
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function SetupSeq()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "BrokQuest2")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = brokActor},
    {Obj = ringProp},
    {Obj = stoneProp}
  }
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_xpl450_start_master")
  seq:MarkAbleToSkip()
  seq:SpawnActorAndWait(brokActor)
  seq:WaitSeconds(0.2)
  seq:Do(function()
    brokActor:GetCreature():EndInteract()
  end)
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(StartCineEnter_BrokQuest2)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_BrokQuest2",
    ReferenceJoint = "BrokQuest2_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    foot = game.Creature.Foot.kRight,
    weapon_state = "bare"
  })
  seq:Do(ShowProps)
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_BrokQuest2",
    ReferenceJoint = "BrokQuest2_SynchJoint"
  })
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(HideProps)
  seq:Do(CompleteQuest)
  seq:StartSequence()
end
function StartCineEnter_BrokQuest2()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_BrokQuest2 = CCEC.CineEnterCamera.New("ENV_CineEnter_BrokQuest2", 8)
  cameraCineEnter_BrokQuest2:SetCallback(DestroyCineEnter_BrokQuest2)
  cameraCineEnter_BrokQuest2:Start()
end
function DestroyCineEnter_BrokQuest2()
  cameraCineEnter_BrokQuest2 = nil
  game.SubObject.Sleep(thisObj)
end
