local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
thisLevel = nil
local son, huldra2Door, smallShop, brokSpawnObject
local effectParams = {
  EffectName = "FSE_sway_earthquake_rumble_test",
  Duration = 4,
  TweenIn = 0.2,
  TweenOut = 0.3
}
local BrokIsSpawned
function OnScriptLoaded(level)
  thisLevel = level
  local huldra2Door = GameObjects.huldraDoor_mossFrame
  smallShop = GameObjects.SmallShop
  brokSpawnObject = smallShop.Child:FindSingleGOByName("VendorSpawner").Child
  SoundInit()
end
function NoKeyBanter()
  if game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra2") == -1 then
    game.Audio.PlayBanterNonCritical("Son_NoKey_Banter")
  end
end
function OnFirstStart(level)
  GameObjects.TraversePath4:HideTraversePath()
end
function OnPreStart(level, obj)
  QuestStoneFixUp()
  ShopFixUp()
end
function OnStart(level)
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01")
  if questState == "Inactive" then
    GameObjects.SmallShop.LuaObjectScript.DisableAllShop()
  elseif questState ~= "Inactive" then
    if BrokIsSpawned ~= true then
      brokSpawnObject.LuaObjectScript.SpawnEnemy()
      BrokIsSpawned = true
      if questState == "Active" then
        GameObjects.SmallShop.LuaObjectScript.StartCounterRequest(brokSpawnObject.LuaObjectScript.GetLastEnemy())
      end
    end
    GameObjects.SmallShop.LuaObjectScript.EnableAllShop()
  end
end
function LoadCheckCal200()
  game.UI.LoadCheck("Cal200_Shore")
end
function LoadCheckXpl450()
  game.UI.LoadCheck("Xpl450_HuldraMines")
end
function ShopFixUp()
  local questState02 = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  if questState02 ~= "Inactive" then
    LD.SetMarkerState("HM02_475_VendorLocation", 1)
    LD.ActivateAndIncrementQuest("RegionSummary_HM02_Vendor_Parent")
  end
end
function ShowSmallShop()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_01")
  if questState == "Inactive" then
    GameObjects.SmallShop.LuaObjectScript.DisableAllShop()
  elseif questState ~= "Inactive" then
    if BrokIsSpawned ~= true then
      brokSpawnObject.LuaObjectScript.SpawnEnemy()
      BrokIsSpawned = true
    end
    GameObjects.SmallShop.LuaObjectScript.EnableAllShop()
  end
end
function CheckBrok02Cine(level)
end
function DisableBrok02Cine()
end
function QuestStoneFixUp()
  local questState = game.QuestManager.GetQuestState("Quest_Brok_Epic_02_Objective_02")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneHuldra2")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneHuldra2", 1)
  end
end
function OpenHuldra2Door()
  GameObjects.huldraDoor_mossFrame.Child:PlayAnimToEnd()
  HuldraDoorShakeRumble()
  PlaySoundDoorUnlock()
  LD.AddScreenShake("FSE_sway_earthquake_rumble_test", game.FX.SubmitEffect(effectParams))
  LD.CallFunctionAfterDelay(function()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end, 7)
end
function HuldraDoorShakeRumble()
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_SMALL",
    Duration = 8,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 1}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 9,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5}
  })
  timers.StartLevelTimer(1.66, function()
    RumbleShakeHit(2)
  end)
  timers.StartLevelTimer(3.2, function()
    RumbleShakeHit(4)
  end)
  timers.StartLevelTimer(9, function()
    RumbleShakeHit(9)
  end)
end
function RumbleShakeHit(effectPriority)
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_STRONG",
    Duration = 0.5,
    TweenIn = {Time = 0.1},
    TweenOut = {Time = 0.5},
    Priority = effectPriority
  })
end
function AreaAnnounceHuldra2()
  uiCalls.UI_Event_DiscoverLocation("HuldraMine02")
end
function ShowWallPress()
  GameObjects.TraversePath4:ShowTraversePath()
end
function OnSaveCheckpoint(level)
  return {
    huldra2Door = huldra2Door,
    levelstate = checkpoint.Save
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  huldra2Door = savedInfo.huldra2Door
end
local SNDHuldraDoor, SNDDoorLeft, SNDDoorRight
function SoundInit()
  SNDHuldraDoor = GameObjects.huldraDoor_mossFrame.Child:FindSingleSoundEmitterByName("SNDHuldra_Mine_Door")
  SNDDoorLeft = GameObjects.huldraDoor_mossFrame.Child:FindSingleSoundEmitterByName("SNDDoorLeft")
  SNDDoorRight = GameObjects.huldraDoor_mossFrame.Child:FindSingleSoundEmitterByName("SNDDoorRight")
end
function PlaySoundDoorUnlock()
  LD.PlaySound(SNDHuldraDoor, "SND_DOOR_Stone_HuldraMine_Double_Door_Unlock")
  LD.PlaySoundOnFrame(SNDDoorLeft, GameObjects.huldraDoor_mossFrame.Child, "SND_DOOR_Stone_HuldraMine_Double_Door_Open_Seq_L", 120)
  LD.PlaySoundOnFrame(SNDDoorRight, GameObjects.huldraDoor_mossFrame.Child, "SND_DOOR_Stone_HuldraMine_Double_Door_Open_Seq_R", 120)
end
