local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local EC = require("design.Encounter")
local CCOS = require("camera.camera_oneshot")
local thisLevel, son, QueenEncounter, QueenEncounter_TriggerZone
local xpl600Music = false
local camOneShot_ThreeHeads
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
  QueenFlow_StartStart()
end
function OnFirstStart(level)
  GameObjects.coffin_tier3_xpl600_1.LuaObjectScript.Disable()
end
function OnPreStart(level)
  OnStartFixup_ValkyrieDeathFallThroughWorld()
end
function OnStart(level)
  GameObjects.QueenEncounter_TriggerZone:HideEntityVolume()
  GameObjects.Banter_ExitWithHelm:HideEntityVolume()
  LD.CallFunctionAfterDelay(CheckResetOnValkyrieBanter, 0.1)
  PatchQuestFixup()
  SoundOnStart()
end
function OnUpdate()
  if camOneShot_ThreeHeads ~= nil then
    camOneShot_ThreeHeads:Update()
  end
end
function CheckResetOnValkyrieBanter()
  local questState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Objective01")
  if questState ~= "Complete" then
    GameObjects.UpdateArriveObjective.Child.LuaObjectScript.Reset()
  end
end
function EnableCoffin()
  LD.BreakObject(GameObjects.LowerBeach_01_Blocker_01)
  LD.BreakObject(GameObjects.LowerBeach_01_Blocker_02)
  LD.BreakObject(GameObjects.LowerBeach_01_Blocker_03)
  LD.BreakObject(GameObjects.LowerBeach_01_Blocker_04)
  LD.BreakObject(GameObjects.LowerBeach_01_Blocker_05)
  GameObjects.coffin_tier3_xpl600_1.LuaObjectScript.Enable()
end
function OnStartFixup_ValkyrieDeathFallThroughWorld()
  if QueenEncounter:IsComplete() and game.Wallets.GetResourceValue("HERO", "ValkyrieLootQueen") == -1 then
    QueenEncounter:Reset()
    GameObjects.QueenCombatRift.LuaObjectScript.SetCombatIntiatesFromInteract()
    GameObjects.QueenCombatRift.LuaObjectScript.SetIsCombatRift()
    game.QuestManager.ProposeQuestState("Quest_Valkyrie_Queen_Parent", "Inactive")
    game.QuestManager.ProposeQuestState("Quest_Valkyrie_Queen_Kill", "Inactive")
  end
end
function CheckCouncilObjective01()
  local questState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Objective01")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function LookAt_ThreeHeads()
  camOneShot_ThreeHeads = CCOS.OneShotCamera.New("PLYR_NAR_AreaAnnounce_Xpl600", 4.2, nil)
  camOneShot_ThreeHeads:SetCallback(DestroyCamera_ThreeHeads)
  camOneShot_ThreeHeads:Start()
end
function DestroyCamera_ThreeHeads()
  camOneShot_ThreeHeads = nil
  DisableAreaAnnounceZone()
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("MasonTrail")
  game.Level.SetVariable("BeenToValkyrieCouncil", true)
  game.World.StoreCheckpoint()
  LookAt_ThreeHeads()
  local announceCamera = thisLevel:GetGameObject("CamZone_Announce_Xpl600")
  announceCamera:ShowCameraVolume()
end
function ArrivalInactive_Banter()
  local questState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Objective01")
  if questState == "Inactive" then
    return true
  else
    return false
  end
end
function CouncilBanterStart()
  game.Interact.DisableTags("NotInBanter")
end
function PatchQuestFixup()
  local killedQuestState = game.QuestManager.GetQuestState("Quest_Valkyrie_Sisters_Parent")
  local deliverQuestState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Objective02")
  if killedQuestState == "Complete" and deliverQuestState == "Active" then
    local helmsTurnedIn = 0
    for i = 1, 8 do
      if game.Wallets.GetResourceValue("HERO", "ValkyrieLoot0" .. i) == 0 then
        helmsTurnedIn = helmsTurnedIn + 1
      end
    end
    local _, councilProgress = game.QuestManager.GetQuestProgressAndGoal("Quest_Valkyrie_Council_Objective02")
    if helmsTurnedIn > councilProgress then
      local mismatchTotal = helmsTurnedIn - councilProgress
      game.QuestManager.IncrementQuestProgress("Quest_Valkyrie_Council_Objective02", mismatchTotal)
      deliverQuestState = game.QuestManager.GetQuestState("Quest_Valkyrie_Council_Objective02")
      if deliverQuestState == "Complete" then
        GameObjects.QueenCombatRift.LuaObjectScript.Enable()
      end
    end
  end
end
function CouncilBanterComplete()
  LD.CompleteQuest("Quest_Valkyrie_Council_Objective01")
  game.Interact.EnableTags("NotInBanter")
  timers.StartLevelTimer(20, function()
    PlaceHelm_Hint_Banter()
  end)
end
function PlaceHelm_Hint_Banter()
  local _, councilProgress = game.QuestManager.GetQuestProgressAndGoal("Quest_Valkyrie_Council_Objective02")
  if councilProgress == 0 then
    game.Audio.PlayBanter("MT_CouncilRoom_PlaceHelm_Hint")
  end
end
function ExitWithHelm_Banter()
  game.Audio.PlayBanter("MT_CouncilRoom_ExitWithHelm")
end
function EnterBehaviorContext_WAIT_AND_EXPLORE()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function ClearBehaviorContext()
  son:CallScript("ClearBehaviorContext")
end
function QueenFlow_StartStart()
  QueenEncounter = EC.NewEncounter(thisLevel, "Queen Valkyrie Fight", {CheckpointOnComplete = false})
  QueenEncounter:AddWave({
    {
      spawners = "QueenValkyrie_Spawner",
      spawnLocators = "QueenValkyrie_Spawner",
      disableSpawnerPostSpawn = true,
      spawnPattern = "Random",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  QueenEncounter:OnEnemySpawn(function()
    GameObjects.QueenCombatRift.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
    CalderaMirrors_Hide()
    game.Audio.InterruptBanterOnCharacter("Mimir's Head")
  end)
  QueenEncounter:OnComplete(QueenFlow_CompleteQuest)
  QueenEncounter:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_XPL600_valkyrie_fight_in")
  end)
end
function CalderaMirrors_Hide()
  local Cal200_Level = game.FindLevel("Cal200_Shore")
  if Cal200_Level ~= nil then
    Cal200_Level:CallScript("CalderaMirrors_Hide")
  end
end
function CalderaMirrors_Show()
  local Cal200_Level = game.FindLevel("Cal200_Shore")
  if Cal200_Level ~= nil then
    Cal200_Level:CallScript("CalderaMirrors_Show")
  end
end
function StopQueenRift()
  timers.StartLevelTimer(0.1, function()
    QueenEncounter:Start()
  end)
  timers.StartLevelTimer(2, function()
    LD.ActivateQuest("Quest_Valkyrie_Queen_Parent")
  end)
  LD.ActivateQuest("RegionSummary_Valkryie_Queen_Parent")
  LD.SetMarkerState("MT_600_ValkQueen", 1)
  timers.StartLevelTimer(1, function()
    GameObjects.QueenCombatRift.LuaObjectScript.StopCombatState()
  end)
end
function QueenFlow_CompleteQuest()
  CalderaMirrors_Show()
end
function DisableAreaAnnounceZone()
  local announceCamera = thisLevel:GetGameObject("CamZone_Announce_Xpl600")
  announceCamera:HideCameraVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function SoundOnStart()
  MusicSetupValkyrieSwitch()
end
function MusicSetupValkyrieSwitch()
  local player = game.Player.FindPlayer()
  local valkyriesKilled = game.Level.GetVariable("ValkyriesDefeated")
  if valkyriesKilled ~= nil and 0 < valkyriesKilled and valkyriesKilled <= 8 then
    game.Audio.SetWwiseMusicSwitch("MX_VAL_helmets", "helmet_0" .. tostring(valkyriesKilled))
  else
    game.Audio.SetWwiseMusicSwitch("MX_VAL_helmets", "helmet_00")
  end
end
function xpl600ArenaEnter()
  if not IsValkyrieQueenDead() and xpl600Music == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL600_arena_enter")
    xpl600Music = true
  end
end
function xpl600ArenaExit()
  if not IsValkyrieQueenDead() and xpl600Music == true then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL600_arena_exit")
    xpl600Music = false
  end
end
function IsValkyrieQueenDead()
  return game.QuestManager.GetQuestState("Quest_Valkyrie_Queen_Kill") == "Complete"
end
