local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, player, A1_ZM_1, A2_ZM_1, A2_ZM_2, A2_ZM_3, A2_Golem_ZM_1, A3_ZM_1, A4_ZM_1, A5_ZM_1, A5_ZM_Entrance, A5_ZM_Orb, A6_ZM_1, A7_ZM_1, A8_ZM_1, A9_ZM_1, A10_ZM_1, Area_0_Encounter_1, Area_2_Encounter_1, Area_2_PopulationFill_1, Area_2_PopulationFill_2, Area_2_Encounter_3, Area_2_Encounter_4, A2_Golem_HealthMonitor, Enc_Area_2_Draugr_Path, Enc_Area_2_Draugr_repop, Area_5_Encounter_1, Area_6_Encounter_1, Area_7_Encounter_1, Area_7_Encounter_2, Area_8_Encounter_1, Area_8_Encounter_2, Area_9_Encounter_1, Area_10_Encounter_1, Enemy_HealthMonitor
local once = true
local A8_Witch_HealthMonitor, A8_WitchHealth
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  Area_2_Fight_1()
  Area_2_Golem_Fight_1()
  Area_2_Golem_Fight_2()
  Fnc_Area_2_Draugr_Path()
  Fnc_Area_2_Draugr_repop()
  Area_5_Fight_1()
  Area_6_Fight_1()
  Area_7_Fight_1()
  Area_7_Fight_2()
  Area_8_Fight_1()
  Area_9_Fight_1()
  Area_10_Fight_1()
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Area_Spawn__7:HideEntityVolume()
  GameObjects.EntZn_Area_Spawn_B__7:HideEntityVolume()
  GameObjects.EntZnGrp_Area_ReturnSpawn_Golem:HideEntityVolume()
  GameObjects.EntZn_CheckPoint_Return:HideEntityVolume()
end
function OnStart(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Area_2_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber then
    powerLevel = 4
  end
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC1: Entrance XPL850", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl850_AI_Exterior01",
    LeashZone = "LshZn_A2_02"
  })
  A2_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_Attack__2)
  A2_ZM_1:SetTriggerCountLimit(1)
  A2_ZM_1:OnEnter(function()
    Area_2_Encounter_1:AlertEnemies(1)
    Area_2_PopulationFill_1:Start()
  end)
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Draugr_P_SUL",
      spawnLocators = "A2_U_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      markerID = "PL1",
      powerLevel = powerLevel
    },
    {
      spawners = "U_Draugr_PT_SUL",
      spawnLocators = "A2_U_Loc_02",
      spawnWad = "Xpl850_AI_Exterior01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      markerID = "PL1",
      powerLevel = powerLevel
    },
    {
      spawners = "U_Draugr_PT_SUL",
      spawnLocators = "A2_U_Loc_03",
      spawnWad = "Xpl850_AI_Exterior01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      markerID = "PL1",
      powerLevel = powerLevel
    },
    {
      spawners = "Draugr_N_Patrol2",
      initialSpawnAmount = 1,
      spawnWad = "Xpl850_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {1, 2},
      markerID = "PL1",
      powerLevel = powerLevel
    }
  })
  Area_2_PopulationFill_1 = EC.NewEncounter(thisLevel, "[Area 2]EC2: XPL850 Pop Fill", {
    LeashZone = "LshZn_A2_02"
  })
  Area_2_PopulationFill_1:AddWave({
    {
      spawners = "Flyer_N_SH",
      spawnLocators = "A2_U_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl850_AI_Exterior01",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {5, 10}
    }
  })
  Area_2_PopulationFill_2 = EC.NewEncounter(thisLevel, "[Area 2]EC2: XPL850 Pop Fill 2", {
    LeashZone = "LshZn_A2_02"
  })
  Area_2_PopulationFill_2:AddWave({
    {
      spawners = "Flyer_N_SH",
      spawnLocators = "A3_O_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl850_AI_Exterior01",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {5, 10}
    }
  })
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:AlertEnemies()
  end)
  Area_2_PopulationFill_1:SetAlertZone(GameObjects.EntZn_A2_PopFill_Alert__01)
  Area_2_PopulationFill_2:SetAlertZone(GameObjects.EntZn_A2_PopFill_Alert__02)
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZnGrp_Area2)
  Area_2_PopulationFill_2:SetStartZone(GameObjects.EntZnGrp_Area2)
  Area_2_PopulationFill_2:SetStartZone(GameObjects.EntZnGrp_Area2)
  Area_2_Encounter_1:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetForestEncounterComplete")
    game.Audio.SetCheckpointedMusic("SND_MX_XPL850_explore1_in")
  end)
end
function Area_2_Golem_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber then
    powerLevel = 5
  end
  Area_2_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 2]EC3: Golem XPL850", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl850_AI_Exterior01",
    LeashZone = "LshZn_A2_01",
    AutoResetOnReload = true
  })
  Area_2_Encounter_3:AddWave({
    {
      spawners = "Golem_10_SWA",
      spawnLocators = "A2_U_Loc_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      spawnWad = "Xpl850_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {2, 5},
      markerID = "A2_Golem",
      powerLevel = powerLevel
    }
  })
  Area_2_Encounter_3:SetStartZone(GameObjects.EntZnGrp_Area_ReturnSpawn_Golem)
  Area_2_Encounter_3:OnStart(function()
    LD.SetMarkerState("XPL_850_AncientFight", 1)
  end)
  Area_2_Encounter_3:OnComplete(function()
    LD.SetMarkerState("XPL_850_AncientFight", 0)
  end)
  Area_2_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_Forest")
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetGolemEncounterComplete")
  end)
  Area_2_Encounter_3:OnEnemySpawn(Area_2_Golem_Health_Encounter, {markerID = "A2_Golem"})
end
function Area_2_Golem_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local A2_GolemHealth = Enemy:GetHitPoints()
    A2_Golem_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = A2_GolemHealth * 0.75
    A2_Golem_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_2_Encounter_3:StartWave(2)
    end)
  end
end
function Area_2_Golem_Fight_2()
  Area_2_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 2]EC3: Golem Support XPL850", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl850_AI_Exterior01",
    LeashZone = "LshZn_A2_02"
  })
  Area_2_Encounter_4:AddWave({
    {
      spawners = "H_Draugr_L4_Legs_SFG",
      spawnLocators = "A2_L_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "H_Draugr_L4_Legs_SFG",
      spawnLocators = "A2_L_Loc_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.2
    }
  })
end
function Area_2_Golem_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local A2_GolemHealth = Enemy:GetHitPoints()
    A2_Golem_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = A2_GolemHealth * 0.75
    A2_Golem_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_2_Encounter_4:Start()
    end)
  end
end
function Fnc_Area_2_Draugr_Path()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber then
    powerLevel = 4
  end
  Enc_Area_2_Draugr_Path = EC.NewEncounter(thisLevel, "[Area 2]EC: XPL850 Draugr Pathers", {
    spawnWad = "Xpl850_AI_Exterior01",
    LeashZone = "LshZn_A2_02"
  })
  Enc_Area_2_Draugr_Path:AddWave({
    {
      spawners = "Draugr_L2_N_Wander",
      spawnLocators = "A2_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      markerID = "PL2",
      powerLevel = powerLevel
    },
    {
      spawners = "Draugr_L2_N_Patrol3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      markerID = "PL2",
      powerLevel = powerLevel
    }
  })
  Enc_Area_2_Draugr_Path:SetStartZone(GameObjects.EntZnGrp_Area2)
end
function Fnc_Area_2_Draugr_repop()
  local powerLevelPL1, powerLevelPL2
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevelPL1 = 3
    powerLevelPL2 = 4
  elseif 375 <= cineNumber then
    powerLevelPL1 = 5
    powerLevelPL2 = 6
  end
  Enc_Area_2_Draugr_repop = EC.NewEncounter(thisLevel, "[Area 2]EC: XPL850 Draugr Repop", {
    spawnWad = "Xpl850_AI_Exterior01",
    LeashZone = "LshZn_A2_02",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 2]EC3: Golem XPL850"
    }
  })
  Enc_Area_2_Draugr_repop:AddWave({
    {
      spawners = "Draugr_L2_N_Wander",
      spawnLocators = "A2_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      markerID = "PL2",
      powerLevel = powerLevelPL2
    },
    {
      spawners = "Draugr_L2_N_Patrol3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      markerID = "PL2",
      powerLevel = powerLevelPL2
    },
    {
      spawners = "Draugr_N_Patrol2",
      initialSpawnAmount = 1,
      spawnWad = "Xpl850_AI_Exterior01",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {1, 2},
      markerID = "PL1",
      powerLevel = powerLevelPL1
    }
  })
  Enc_Area_2_Draugr_repop:SetStartZone(GameObjects.EntZnGrp_Area2)
  Enc_Area_2_Draugr_repop:SetAlertZone(GameObjects.EntZn_Area2_AmbushSpawn__1)
end
function Area_5_Fight_1()
  local powerLevelPL4, powerLevelPL5
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevelPL4 = 4
    powerLevelPL5 = 5
  elseif 375 <= cineNumber then
    powerLevelPL4 = 5
    powerLevelPL5 = 6
  end
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 5]EC:Room 1 XPL850", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl850_AI_Interior01",
    StartMusic = "SND_MX_XPL850_dungeon_fight1_in",
    StopMusic = "SND_MX_XPL850_dungeon_fight1_out"
  })
  Area_5_Encounter_1:AddWave({
    {
      spawners = "H_Draugr_L4_N_SFG",
      spawnLocators = "A5_O_Loc_01",
      spawnWad = "Xpl850_AI_Interior01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2,
      markerID = "PL4",
      powerLevel = powerLevelPL4
    },
    {
      spawners = "H_Draugr_L5_N_SFG",
      spawnLocators = "A5_O_Loc_02",
      spawnWad = "Xpl850_AI_Interior01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.2,
      markerID = "PL5",
      powerLevel = powerLevelPL5
    }
  })
  Area_5_Encounter_1:SetStartZone(GameObjects.EntZn_Area_Spawn__5)
  Area_5_Encounter_1:OnComplete(function()
    _G.PlayBanterEncounter01()
  end)
  Area_5_Encounter_1:OnComplete(function()
    GameObjects.EntZn_Area_Spawn__7:ShowEntityVolume()
    GameObjects.EntZn_A5_EntranceFireTrigger:HideEntityVolume()
    GameObjects.EntZn_A5_OrbFireTrigger:HideEntityVolume()
  end)
  Area_5_Encounter_1:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetRoom1EncounterComplete")
  end)
end
function StartRoom3Fight()
  Area_6_Encounter_1:Start()
end
function Area_6_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 6
  elseif 375 <= cineNumber then
    powerLevel = 7
  end
  Area_6_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 6]EC:Room 2 XPL850", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_Room2.Child,
    spawnWad = "Xpl850_AI_Interior01",
    StartMusic = "SND_MX_XPL850_dungeon_fight2_in",
    StopMusic = "SND_MX_XPL850_dungeon_fight2_out"
  })
  Area_6_Encounter_1:AddWave({
    {
      spawners = "Brawler_Siedre_SPA",
      spawnLocators = "A6_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0,
      markerID = "PL6",
      powerLevel = powerLevel
    },
    {
      spawners = "Banditr_Siedre_Ground",
      spawnLocators = "A6_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 2
    },
    {
      spawners = "Banditr_Siedre_Ground",
      spawnLocators = "A6_O_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3
    }
  })
  Area_6_Encounter_1:OnComplete(function()
    _G.PlayBanterEncounter02()
  end)
  Area_6_Encounter_1:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetRoom2EncounterComplete")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Brawler")
  end)
end
function Area_7_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber then
    powerLevel = 4
  end
  Area_7_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 7]EC1:Room Center XPL850", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_DungeonCenter.Child,
    spawnWad = "Xpl850_AI_Interior01"
  })
  Area_7_Encounter_1:AddWave({
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A7_O_Loc_01",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.3,
      markerID = "PL1",
      powerLevel = powerLevel
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "A7_O_Loc_02",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.3,
      markerID = "PL1",
      powerLevel = powerLevel
    }
  })
  Area_7_Encounter_1:OnStart(Area_7_Fight_1_PreFight_Banter)
  Area_7_Encounter_1:OnStart(function()
    GameObjects.CA_Center_Turret.LuaObjectScript.Enable()
    GameObjects.Availability_Zone01:HideEntityVolume()
    GameObjects.Availability_Zone02:HideEntityVolume()
    GameObjects.Availability_Zone03:HideEntityVolume()
    GameObjects.Availability_Zone04:HideEntityVolume()
  end)
  Area_7_Encounter_1:OnComplete(function()
    GameObjects.CA_Center_Turret.LuaObjectScript.Disable()
    GameObjects.EntZn_Area_Spawn_B__7:HideEntityVolume()
    GameObjects.Availability_Zone01:ShowEntityVolume()
    GameObjects.Availability_Zone02:ShowEntityVolume()
    GameObjects.Availability_Zone03:ShowEntityVolume()
    GameObjects.Availability_Zone04:ShowEntityVolume()
  end)
  Area_7_Encounter_1:OnComplete(Area_7_Fight_1_PostFight_Banter)
  Area_7_Encounter_1:SetStartZone(GameObjects.EntZn_Area_Spawn__7)
end
function Area_7_Fight_1_PreFight_Banter()
  game.Audio.PlayBanter("Sindri1_NightmareSurprise_PreFight")
end
function Area_7_Fight_1_PostFight_Banter()
  game.Audio.PlayBanter("Sindri1_NightmareSurprise_PostFight")
end
function Area_7_Fight_2()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 3
  elseif 375 <= cineNumber then
    powerLevel = 4
  end
  Area_7_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 7]EC2:Room Center XPL850", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_DungeonCenter.Child,
    spawnWad = "Xpl850_AI_Interior01"
  })
  Area_7_Encounter_2:AddWave({
    {
      spawners = "U_Draugr_PT_SFG",
      spawnLocators = "A7_O_Loc_04",
      markerID = "LookAt_ProjectileDraugr",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2,
      markerID = "PL1",
      powerLevel = powerLevel
    },
    {
      spawners = "U_Draugr_PT_SFG",
      spawnLocators = "A7_O_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 3,
      markerID = "PL1",
      powerLevel = powerLevel
    }
  })
  Area_7_Encounter_2:SetStartZone(GameObjects.EntZn_Area_Spawn_B__7)
  Area_7_Encounter_2:OnStart(function()
    GameObjects.CA_Center_Turret.LuaObjectScript.Enable()
    GameObjects.Availability_Zone01:HideEntityVolume()
    GameObjects.Availability_Zone02:HideEntityVolume()
    GameObjects.Availability_Zone03:HideEntityVolume()
    GameObjects.Availability_Zone04:HideEntityVolume()
  end)
  Area_7_Encounter_2:OnComplete(function()
    GameObjects.CA_Center_Turret.LuaObjectScript.Disable()
    GameObjects.EntZn_Area_Spawn_B__7:HideEntityVolume()
    GameObjects.Availability_Zone01:ShowEntityVolume()
    GameObjects.Availability_Zone02:ShowEntityVolume()
    GameObjects.Availability_Zone03:ShowEntityVolume()
    GameObjects.Availability_Zone04:ShowEntityVolume()
  end)
  Area_7_Encounter_2:OnComplete(Area_7_Fight_2_PostFight_Banter)
end
function Area_7_Fight_2_PostFight_Banter()
  game.Audio.PlayBanter("Sindri1_NightmareSurprise2_PostFight")
end
function Area_8_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 5
  elseif 375 <= cineNumber then
    powerLevel = 6
  end
  Area_8_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 8]EC1:Room 3 XPL850", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl850_AI_Interior01",
    StartMusic = "SND_MX_XPL850_dungeon_fight3_in",
    StopMusic = "SND_MX_XPL850_dungeon_fight3_out"
  })
  A8_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_Attack__8)
  A8_ZM_1:SetTriggerCountLimit(1)
  A8_ZM_1:OnEnter(function()
    Area_8_Encounter_1:AlertEnemies()
  end)
  Area_8_Encounter_1:AddWave({
    {
      spawners = "Witch_P_SFG",
      spawnLocators = "A8_O_Loc_01",
      markerID = "A8_Witch",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0.2,
      powerLevel = powerLevel
    },
    {
      spawners = "Witch_P_SFG",
      spawnLocators = "A8_O_Loc_",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 10.2,
      powerLevel = powerLevel
    }
  })
  Area_8_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 8]EC2:Room 3 XPL850", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl850_AI_Interior01"
  })
  Area_8_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A8_O_Loc_04",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {1, 2},
      spawnCooldown = {2, 5}
    }
  })
  Area_8_Encounter_1:SetStartZone(GameObjects.EntZn_Area_Spawn__8)
  Area_8_Encounter_1:OnComplete(function()
    _G.PlayBanterEncounter03()
  end)
  Area_8_Encounter_1:OnComplete(function()
  end)
  Area_8_Encounter_1:OnComplete(function()
    GameObjects.EntZn_Area_Attack__8:HideEntityVolume()
    GameObjects.EntZn_Area_Spawn_B__7:ShowEntityVolume()
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetRoom3EncounterComplete")
  end)
  Area_8_Encounter_1:SetStartZone(GameObjects.EntZn_Area_Spawn__8)
end
function Area_8_Witch_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local A8_WitchHealth = Enemy:GetHitPoints()
    A8_Witch_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = A8_WitchHealth * 0.65
    local Health_Phase_2 = A8_WitchHealth * 0.2
    A8_Witch_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_8_Encounter_2:Start()
    end)
    A8_Witch_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_8_Encounter_2:Restart()
    end)
  end
end
function Area_8_Witch_Health_Encounter_Death()
  if player:PickupIsAcquired("Debuff_Hero_Cursed") then
    player:PickupRelinquish("Debuff_Hero_Cursed")
  end
end
function StartRoom4Fight()
  Area_9_Encounter_1:Start()
  timers.StartLevelTimer(2, function()
    Area_9_Encounter_1:AlertEnemies()
  end)
end
function Area_9_Fight_1()
  local powerLevel
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel = 5
  elseif 375 <= cineNumber then
    powerLevel = 6
  end
  Area_9_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 9]EC:Room 4 XPL850", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl850_AI_Interior01",
    StartMusic = "SND_MX_XPL850_dungeon_fight4_in",
    StopMusic = "SND_MX_XPL850_dungeon_fight4_out"
  })
  Area_9_Encounter_1:AddWave({
    {
      spawners = "Wolf_P_Alpha_PL6_SECU",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      markerID = "PL5",
      powerLevel = powerLevel
    },
    {
      spawners = "Wolf_Blck_PL5_SLU",
      spawnLocators = "A9_U_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.5
    },
    {
      spawners = "Wolf_Blck_PL4_SRFC",
      spawnLocators = "A9_U_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7.2
    },
    {
      spawners = "Wolf_Blck_PL4_SRFC",
      spawnLocators = "A9_U_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.5
    }
  })
  Area_9_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Wolf_Blck_PL5_SLU",
      spawnLocators = "A9_U_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    },
    {
      spawners = "Wolf_Blck_PL4_SRFC",
      spawnLocators = "A9_U_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7.2
    }
  })
  Area_9_Encounter_1:OnEnemyDeath(function()
    Area_9_Encounter_1:StartWave(2)
  end, {count = 2})
  Area_9_Encounter_1:OnComplete(function()
    _G.PlayBanterEncounter04()
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetRoom4EncounterComplete")
  end)
end
function A10_Start_Boss()
  Area_10_Encounter_1:Start()
end
function Area_10_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 374 then
    powerLevel01 = 4
    powerLevel02 = 3
  elseif 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 5
    powerLevel02 = 3
  elseif 600 <= cineNumber then
    powerLevel01 = 6
    powerLevel02 = 4
  end
  Area_10_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 10]EC: Final Room XPL850", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl850_AI_FinalFight",
    AutoResetOnReload = true,
    StartMusic = "SND_MX_XPL850_dungeon_fight5_in",
    StopMusic = "SND_MX_XPL850_dungeon_fight5_out"
  })
  Area_10_Encounter_1:AddWave({
    {
      spawners = "Jotunn_N_PL2_SFA",
      spawnLocators = "A10_U_Loc_01",
      useSpawnLocatorsOnly = true,
      markerID = "Jotunn01",
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawnLocators = "A10_U_Loc_02",
      spawners = "Jotunn_N_SRD",
      useSpawnLocatorsOnly = true,
      markerID = "Jotunn02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5,
      powerLevel = powerLevel02
    }
  })
  Area_10_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A10_O_Loc_0*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2, 3},
      spawnCooldown = {7, 15}
    }
  })
  Area_10_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A10_O_Loc_0*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2, 3},
      spawnCooldown = {7, 15}
    }
  })
  Area_10_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A10_O_Loc_0*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2, 3},
      spawnCooldown = {7, 15}
    }
  })
  Area_10_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Flyer_N_SFG",
      spawnLocators = "A10_O_Loc_0*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {2, 3},
      spawnCooldown = {7, 15}
    }
  })
  Area_10_Encounter_1:OnEnemySpawn(Jotunn_Health_Monitor01, {markerID = "Jotunn01"})
  Area_10_Encounter_1:OnEnemySpawn(Jotunn_Health_Monitor02, {markerID = "Jotunn02"})
  Area_10_Encounter_1:OnComplete(function()
    game.Audio.SetCheckpointedMusic("SND_MX_XPL850_explore2_in")
    GameObjects.EntZnGrp_Area_ReturnSpawn_Golem:ShowEntityVolume()
  end)
  Area_10_Encounter_1:OnComplete(function()
    GameObjects.EntZn_CheckPoint_Return:ShowEntityVolume()
  end)
  Area_10_Encounter_1:OnComplete(function()
    local thisLevel = game.FindLevel("Xpl850_DungeonForest")
    thisLevel:CallScript("SetBossRoomComplete")
  end)
end
function Jotunn_Health_Monitor01(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.89
    local Health_Phase_2 = EnemyHealth * 0.55
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_10_Encounter_1:StartWave(2)
    end)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_10_Encounter_1:StartWave(3)
    end)
  end
end
function Jotunn_Health_Monitor02(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.75
    local Health_Phase_2 = EnemyHealth * 0.45
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_10_Encounter_1:StartWave(4)
    end)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_10_Encounter_1:StartWave(5)
    end)
  end
end
