local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, knifeProp
local playedCine = false
local cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  SetupProps()
  if not playedCine then
    SetupActors()
  else
    GameObjects.NoGo_SindriQuest1:Hide()
    GameObjects.collision_Approach:HideCollision()
    HideProps()
  end
  game.SubObject.Sleep(obj)
end
function SetupProps()
  knifeProp = thisObj:FindSingleGOByName("sigilDaggerProp").Child
  knifeProp:StartAnimation({
    Animation = "narCalSindriQuest1000CineScene"
  })
  knifeProp:JumpAnimationToFrame(0)
  knifeProp:PauseAnimation()
end
function HideProps()
  knifeProp:Hide()
end
function ShowProps()
  knifeProp:Show()
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  return {played = playedCine}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedCine = savedInfo.played
end
function SetupActors()
  kraActor = actor.Actor.New("SINDRI QUEST I: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SINDRI QUEST I: Son Actor", game.AI.FindSon)
end
function SetupCineSeq()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "SindriQuest1")
  local slaveTab = {
    {Actor = sonActor},
    {Obj = knifeProp}
  }
  local questObj = GameObjects.Xpl850_QuestObjective_DeadBandit.Child
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_XPL850_start_master")
  seq:MarkAbleToSkip()
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(StartCineEnter_SindriQuest1)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_SindriQuest1",
    ReferenceJoint = "SindriQuest1_SynchJoint",
    speed = ND.KraRunSpeed,
    stop = true,
    prevent_path_eval = true,
    foot = game.Creature.Foot.kRight,
    radius = ND.RunArrivalRadius,
    weapon_state = "bare"
  })
  seq:Do(function()
    GameObjects.NoGo_SindriQuest1:Hide()
    GameObjects.collision_Approach:HideCollision()
  end)
  seq:Do(ShowProps)
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_SindriQuest1",
    ReferenceJoint = "SindriQuest1_SynchJoint"
  })
  seq:Do(AnimateGhost)
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(HideProps)
  seq:Do(function()
    playedCine = true
  end)
  seq:Do(function()
    if questObj ~= nil then
      questObj.LuaObjectScript:CompleteSindri01Objective()
    end
  end)
  seq:StartSequence()
end
function AnimateGhost()
  GameObjects.fallenWarrior00:TriggerMoveEvent("PlaySindriQuest1")
end
function StartCineEnter_SindriQuest1()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_SindriQuest1", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_SindriQuest1)
  cameraCineEnter:Start()
end
function DestroyCineEnter_SindriQuest1()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
