local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local CSL = require("camera.shakelibrary")
local son, thisLevel, movingBlocks01, movingBlocks02, movingBlocks03, movingBlocks04, movingBlocks05, bridgeColOne, bridgeColTwo, bridgeColThree, bridgeColFour, bridgeColFive, guideRunes01, guideRunes02, guideRunes03, guideRunes04, guideRunes05, guideRunes01Activated, guideRunes02Activated, guideRunes03Activated, guideRunes04Activated, guideRunes05Activated
local forestEncounterComplete = false
local golemEncounterComplete = false
local room1EncounterComplete = false
local room2EncounterComplete = false
local room3EncounterComplete = false
local room4EncounterComplete = false
local bossRoomComplete = false
local frontDoorLocked = true
local meadowIntroComplete = false
local forestTripleChestOpened = false
local forestCoffinOpened = false
local dirtLootPatchCollected = false
local raven1Collected = false
local raven2Collected = false
local raven3Collected = false
local dungeonIntroComplete = false
local zoneMonitorCaveMusic, zoneMonitorWaterfallMusic, zoneMonitorBossRoomMusic
local forestEntered = false
local musicXpl850 = false
local musicXpl850Ped = false
local bridgecounter = 0
local keyorbcounter = 0
local friendliesInZone = 0
local banterObjective02Played = false
local effectParams = {
  EffectName = "FSE_sway_earthquake_rumble_test",
  Duration = 4.5,
  TweenIn = 0.2,
  TweenOut = 0.3
}
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  thisLevel = level
  movingBlocks01 = GameObjects.movingBlocks01
  movingBlocks02 = GameObjects.movingBlocks02
  movingBlocks03 = GameObjects.movingBlocks03
  movingBlocks04 = GameObjects.movingBlocks04
  movingBlocks05 = GameObjects.movingBlocks05
  bridgeColOne = GameObjects.col_bridge_one
  bridgeColTwo = GameObjects.col_bridge_two
  bridgeColThree = GameObjects.col_bridge_three
  bridgeColFour = GameObjects.col_bridge_four
  bridgeColFive = GameObjects.col_bridge_five
  SoundInit()
  game.Audio.StartMusicMaster("SND_MX_XPL850_start_master")
end
function OnFirstStart()
  SoundOnStart()
  GameObjects.guideRunes01:JumpAnimToFrame(0)
  GameObjects.guideRunes01:PauseAnim()
  GameObjects.guideRunes02:JumpAnimToFrame(0)
  GameObjects.guideRunes02:PauseAnim()
  GameObjects.guideRunes03:JumpAnimToFrame(0)
  GameObjects.guideRunes03:PauseAnim()
  GameObjects.guideRunes04:JumpAnimToFrame(0)
  GameObjects.guideRunes04:PauseAnim()
  GameObjects.guideRunes05:JumpAnimToFrame(0)
  GameObjects.guideRunes05:PauseAnim()
  GameObjects.FrontDoor.LuaObjectScript.Lock()
end
function OnStart()
  GameObjects.NavObstacle_Center01:HideNavObstacle()
  GameObjects.NavObstacle_Center02:HideNavObstacle()
  GameObjects.NavObstacle_Center03:HideNavObstacle()
  GameObjects.NavObstacle_Center04:HideNavObstacle()
  GameObjects.NavObstacle_Center05:HideNavObstacle()
  GameObjects.NavObstacle_Center06:HideNavObstacle()
  GameObjects.NavObstacle_Center07:HideNavObstacle()
  GameObjects.NavObstacle_Center08:HideNavObstacle()
  PatchQuestFixup()
end
function PatchQuestFixup()
  local fatherSonScroll = game.Wallets.GetResourceValue("HERO", "Sindri02_FatherSon_Lore")
  local fatherSonQuest = game.QuestManager.GetQuestState("Quest_SecretBusiness02_Parent")
  if fatherSonScroll == 1 and fatherSonQuest == "Inactive" then
    LD.ActivateQuest("Quest_SecretBusiness02_Parent")
    local uiCalls = require("ui.uicalls")
    uiCalls.UI_Event_SendMsgToQuestLog({
      Category = 13956,
      Header = 13957,
      Body = 13959,
      MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
      Quest = "Quest_SecretBusiness02_Objective01"
    })
  end
end
function LoadCheckXpl850AIExterior()
  game.UI.LoadCheck("Xpl850_AI_Exterior01")
end
function LoadCheckXpl875()
  game.UI.LoadCheck("Xpl875_DungeonForest")
end
function PlayShakes_BridgeForming()
  timer.StartLevelTimer(1, function()
    CSL.PlayDefaultShake("ElevatorMovement", 4.2, 0.3, 0.8)
  end)
  timer.StartLevelTimer(3, function()
    CSL.PlayDefaultShake("ShakeRumbleSmall", 0.59)
  end)
  timer.StartLevelTimer(3.8, function()
    CSL.PlayDefaultShake("ShakeRumbleSmall", 0.59)
  end)
  timer.StartLevelTimer(5.43, function()
    CSL.PlayDefaultShake("ShakeRumbleSmall", 0.59, 0, 0.8)
  end)
end
function PlayShakes_BridgeDeform()
  CSL.PlayDefaultShake("ElevatorMovement_Light", 3.2, 0.3, 0.3)
end
function SetPathRoom1()
  PlayBanterObjective02()
  HideCenterNavObstacles()
  CompleteObjective02()
  pedistalMusic()
  PlayPillar1Sound()
  movingBlocks01:PlayAnimToEnd()
  movingBlocks01:OnAnimDone(thisLevel, "HideBridgeOneCol")
  GameObjects.guideRunes04:PlayAnimToEnd()
  if bossRoomComplete == false then
    timer.StartLevelTimer(1, function()
      PlayShakes_BridgeForming()
    end)
    timer.StartLevelTimer(1, function()
      GameObjects.Reaction_Interest_Low_Path1.LuaObjectScript.Trigger()
    end)
    timer.StartLevelTimer(3, function()
      GameObjects.CA_Observe_Forward_01.LuaObjectScript.Enable()
    end)
    bridgecounter = bridgecounter + 1
  end
end
function SetPathRoom2()
  PlayPillar2Sound()
  movingBlocks02:PlayAnimToEnd()
  movingBlocks02:OnAnimDone(thisLevel, "HideBridgeTwoCol")
  GameObjects.guideRunes01:PlayAnimToEnd()
  if bossRoomComplete == false then
    movingBlocks01:PlayAnimToEnd(-1)
    PlayShakes_BridgeDeform()
    timer.StartLevelTimer(1, function()
      PlayShakes_BridgeForming()
    end)
    timer.StartLevelTimer(1.5, function()
      GameObjects.Reaction_Interest_Low_Path2.LuaObjectScript.Trigger()
    end)
    bridgecounter = bridgecounter + 1
    GameObjects.LTW_Room2_In.LuaObjectScript.Enable()
    GameObjects.LTW_Room1_Out.LuaObjectScript.Disable()
    GameObjects.guideRunes04:JumpAnimToFrame(0)
    GameObjects.guideRunes04:PauseAnim()
  end
end
function SetPathRoom3()
  PlayPillar3Sound()
  movingBlocks03:PlayAnimToEnd()
  movingBlocks03:OnAnimDone(thisLevel, "HideBridgeThreeCol")
  GameObjects.guideRunes05:PlayAnimToEnd()
  if bossRoomComplete == false then
    movingBlocks02:PlayAnimToEnd(-1)
    PlayShakes_BridgeDeform()
    timer.StartLevelTimer(1, function()
      PlayShakes_BridgeForming()
    end)
    timer.StartLevelTimer(1.5, function()
      GameObjects.Reaction_Interest_Low_Path3.LuaObjectScript.Trigger()
    end)
    game.Audio.PlayBanter("Sindri01_Room03_Open")
    bridgecounter = bridgecounter + 1
    GameObjects.LTW_Room3_In.LuaObjectScript.Enable()
    GameObjects.LTW_Room2_Out.LuaObjectScript.Disable()
    GameObjects.guideRunes01:JumpAnimToFrame(0)
    GameObjects.guideRunes01:PauseAnim()
  end
end
function SetPathRoom4()
  PlayPillar4Sound()
  movingBlocks04:PlayAnimToEnd()
  movingBlocks04:OnAnimDone(thisLevel, "HideBridgeFourCol")
  GameObjects.guideRunes02:PlayAnimToEnd()
  if bossRoomComplete == false then
    movingBlocks03:PlayAnimToEnd(-1)
    PlayShakes_BridgeDeform()
    timer.StartLevelTimer(1, function()
      PlayShakes_BridgeForming()
    end)
    timer.StartLevelTimer(1.5, function()
      GameObjects.Reaction_Interest_Low_Path4.LuaObjectScript.Trigger()
    end)
    bridgecounter = bridgecounter + 1
    GameObjects.LTW_Room4_In.LuaObjectScript.Enable()
    GameObjects.LTW_Room3_Out.LuaObjectScript.Disable()
    GameObjects.guideRunes05:JumpAnimToFrame(0)
    GameObjects.guideRunes05:PauseAnim()
  end
end
function SetPathRoom5()
  PlayPillar5Sound()
  movingBlocks05:PlayAnimToEnd()
  movingBlocks05:OnAnimDone(thisLevel, "HideBridgeFiveCol")
  GameObjects.guideRunes03:PlayAnimToEnd()
  if bossRoomComplete == false then
    movingBlocks04:PlayAnimToEnd(-1)
    PlayShakes_BridgeDeform()
    timer.StartLevelTimer(1, function()
      PlayShakes_BridgeForming()
    end)
    timer.StartLevelTimer(1.5, function()
      GameObjects.Reaction_Interest_Low_Path5.LuaObjectScript.Trigger()
    end)
    bridgecounter = bridgecounter + 1
    GameObjects.LTW_Room5_In.LuaObjectScript.Enable()
    GameObjects.LTW_Room4_Out.LuaObjectScript.Disable()
    GameObjects.guideRunes02:JumpAnimToFrame(0)
    GameObjects.guideRunes02:PauseAnim()
  end
end
function EnableFrontDoor()
  GameObjects.FrontDoor.LuaObjectScript.Enable()
end
function HideBridgeOneCol()
  timer.StartLevelTimer(0.5, function()
    bridgeColOne:HideCollision()
    DungeonLTW_Enable()
    DungeonCenterIn()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end)
end
function HideBridgeTwoCol()
  timer.StartLevelTimer(0.5, function()
    bridgeColTwo:HideCollision()
    DungeonLTW_Enable()
    DungeonCenterIn()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end)
end
function HideBridgeThreeCol()
  timer.StartLevelTimer(0.5, function()
    bridgeColThree:HideCollision()
    DungeonLTW_Enable()
    DungeonCenterIn()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end)
end
function HideBridgeFourCol()
  timer.StartLevelTimer(0.5, function()
    bridgeColFour:HideCollision()
    DungeonLTW_Enable()
    DungeonCenterIn()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
  end)
end
function HideBridgeFiveCol()
  timer.StartLevelTimer(0.5, function()
    bridgeColFive:HideCollision()
    DungeonLTW_Enable()
    DungeonCenterIn()
    GameObjects.StonePedestal.LuaObjectScript.FinishPedestalInteraction()
    if bossRoomComplete == false then
      GameObjects.Reaction_Celebrate_Path5.LuaObjectScript.Trigger()
    end
  end)
end
function ShowBridgeOneCol()
  bridgeColOne:ShowCollision()
end
function ShowBridgeTwoCol()
  bridgeColTwo:ShowCollision()
end
function ShowBridgeThreeCol()
  bridgeColThree:ShowCollision()
end
function ShowBridgeFourCol()
  bridgeColFour:ShowCollision()
end
function ShowBridgeFiveCol()
  bridgeColFive:ShowCollision()
end
function SetMeadowIntroComplete()
  meadowIntroComplete = true
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.CA_Observe_Forward_Up_ForestA02_01.LuaObjectScript.Disable()
  GameObjects.CA_KickBody_ForestA02.LuaObjectScript.Disable()
  GameObjects.CA_LookUnderObject_Forward_ForestA02_01.LuaObjectScript.Disable()
end
function SetRaven1Collected()
  raven1Collected = true
  GameObjects.CA_Point_Up_ForestA_Raven1.LuaObjectScript.Interrupt()
  GameObjects.CA_Point_Up_ForestA_Raven1.LuaObjectScript.Disable()
end
function SetRaven2Collected()
  raven2Collected = true
  GameObjects.CA_Point_Up_ForestB_Raven2.LuaObjectScript.Interrupt()
  GameObjects.CA_Point_Up_ForestB_Raven2.LuaObjectScript.Disable()
end
function SetRaven3Collected()
  raven3Collected = true
end
function SetDirtLootPatchCollected()
  dirtLootPatchCollected = true
  GameObjects.CA_InvestigateGround_ForestA02_01.LuaObjectScript.Interrupt()
  GameObjects.CA_InvestigateGround_ForestA02_01.LuaObjectScript.Disable()
end
function SetTripleChestOpened()
  forestTripleChestOpened = true
  GameObjects.CA_Point_Up_ForestB_TripleChest.LuaObjectScript.Disable()
end
function SetForestCoffinOpened()
  forestCoffinOpened = true
  GameObjects.CA_Observe_Forward_Up_ForestB_Nook.LuaObjectScript.Disable()
end
function SetForestEncounterComplete()
  forestEncounterComplete = true
  print("Forest Encounter Complete")
end
function SetGolemEncounterComplete()
  golemEncounterComplete = true
  print("Golem Encounter Complete")
end
function SetDungeonIntroComplete()
  dungeonIntroComplete = true
  DungeonCenterIn()
end
function SetRoom1EncounterComplete()
  room1EncounterComplete = true
  print("Room 1 Encounter Complete")
end
function SetRoom2EncounterComplete()
  room2EncounterComplete = true
  print("Room 2 Encounter Complete")
end
function SetRoom3EncounterComplete()
  room3EncounterComplete = true
  print("Room 3 Encounter Complete")
end
function SetRoom4EncounterComplete()
  room4EncounterComplete = true
  print("Room 4 Encounter Complete")
end
function SetBossRoomComplete()
  bossRoomComplete = true
  game.Audio.SetCheckpointedMusic("SND_MX_XPL850_explore2_in")
  print("Boss Room Complete")
end
function IncreaseKeyorbCount()
  keyorbcounter = keyorbcounter + 1
  print("keyorb count increased")
  game.World.StoreCheckpoint()
end
function SetAllPathsOpen()
  if bossRoomComplete == true then
    SetPathRoom1()
    SetPathRoom2()
    SetPathRoom3()
    SetPathRoom4()
  end
end
function FrontDoorUnlock()
  frontDoorLocked = false
  GameObjects.FrontDoor.LuaObjectScript.Unlock()
  game.Audio.SetBanterFact("FrontDoorLocked", "False")
end
function WarpSonToCenter()
  GameObjects.NavObstacle_Center01:ShowNavObstacle()
  GameObjects.NavObstacle_Center02:ShowNavObstacle()
  GameObjects.NavObstacle_Center03:ShowNavObstacle()
  GameObjects.NavObstacle_Center04:ShowNavObstacle()
  GameObjects.NavObstacle_Center05:ShowNavObstacle()
  GameObjects.NavObstacle_Center06:ShowNavObstacle()
  GameObjects.NavObstacle_Center07:ShowNavObstacle()
  GameObjects.NavObstacle_Center08:ShowNavObstacle()
  GameObjects.SonWarpSafe_Center.LuaObjectScript.WarpSon()
end
function HideCenterNavObstacles()
  _G.StartLevelTimer(5, function()
    GameObjects.NavObstacle_Center01:HideNavObstacle()
    GameObjects.NavObstacle_Center02:HideNavObstacle()
    GameObjects.NavObstacle_Center03:HideNavObstacle()
    GameObjects.NavObstacle_Center04:HideNavObstacle()
    GameObjects.NavObstacle_Center05:HideNavObstacle()
    GameObjects.NavObstacle_Center06:HideNavObstacle()
    GameObjects.NavObstacle_Center07:HideNavObstacle()
    GameObjects.NavObstacle_Center08:HideNavObstacle()
  end)
end
function SonUnavailableForCombat()
  local availabilityState = {
    AvailableInLevel = true,
    AvailableForBanter = true,
    AvailableForSync = true,
    AvailableForCombat = false,
    Unoccupied = true
  }
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function SonAvailableForCombat()
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function SonAvailabilityCheck()
  if bridgecounter == 1 then
    if keyorbcounter == 1 then
      SonUnavailableForCombat()
    end
  elseif bridgecounter == 2 then
    if keyorbcounter == 2 then
      SonUnavailableForCombat()
    end
  elseif bridgecounter == 3 then
    if keyorbcounter == 3 then
      SonUnavailableForCombat()
    end
  elseif bridgecounter == 4 and keyorbcounter == 4 then
    SonUnavailableForCombat()
  end
end
function OnFriendlyEnterZone()
  friendliesInZone = friendliesInZone + 1
end
function OnFriendlyExitZone()
  friendliesInZone = friendliesInZone - 1
end
function ForestA01_CA_Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.LTW_ForestA_01.LuaObjectScript.Enable()
end
function ForestA01_CA_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_ForestA_01.LuaObjectScript.Disable()
end
function ForestA02_CA_Enable()
  GameObjects.LTW_ForestA_02.LuaObjectScript.Enable()
  if meadowIntroComplete == false then
    GameObjects.CA_Observe_Forward_Up_ForestA02_01.LuaObjectScript.Enable()
    GameObjects.CA_KickBody_ForestA02.LuaObjectScript.Enable()
    GameObjects.CA_LookUnderObject_Forward_ForestA02_01.LuaObjectScript.Enable()
  elseif meadowIntroComplete == true then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_Observe_Forward_Up_ForestA02_01.LuaObjectScript.Disable()
    GameObjects.CA_KickBody_ForestA02.LuaObjectScript.Disable()
    GameObjects.CA_LookUnderObject_Forward_ForestA02_01.LuaObjectScript.Disable()
  end
  if forestEncounterComplete == false then
    GameObjects.CA_BeckonToMe_ForestB.LuaObjectScript.Enable()
  end
  if dirtLootPatchCollected == false then
    GameObjects.CA_InvestigateGround_ForestA02_01.LuaObjectScript.Enable()
  end
  if raven1Collected == false then
    GameObjects.CA_Point_Up_ForestA_Raven1.LuaObjectScript.Enable()
  end
end
function ForestA02_CA_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_ForestA_02.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_ForestA02_01.LuaObjectScript.Disable()
  GameObjects.CA_InvestigateGround_ForestA02_01.LuaObjectScript.Disable()
  GameObjects.CA_KickBody_ForestA02.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_ForestB.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_ForestA_Raven1.LuaObjectScript.Disable()
  GameObjects.CA_LookUnderObject_Forward_ForestA02_01.LuaObjectScript.Disable()
end
function ForestB_CA_Enable()
  GameObjects.LTW_ForestB_01.LuaObjectScript.Enable()
  GameObjects.LTW_ForestB_02.LuaObjectScript.Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.CA_Observe_Forward_Up_TempleFacade.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Up_Waterfall.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Down_ForestB_01.LuaObjectScript.Enable()
  GameObjects.CA_LookUnderObject_Forward_ForestB_01.LuaObjectScript.Enable()
  GameObjects.CA_PlayWithKnife_ForestB_01.LuaObjectScript.Enable()
  GameObjects.CA_NewEnvironment_ForestB_01.LuaObjectScript.Enable()
  GameObjects.CA_DustOff_ForestB_01.LuaObjectScript.Enable()
  if frontDoorLocked == true then
    GameObjects.CA_BeckonToMe_ForestB_Waterfall.LuaObjectScript.Enable()
  end
  if forestTripleChestOpened == false then
    GameObjects.CA_Point_Up_ForestB_TripleChest.LuaObjectScript.Enable()
    GameObjects.CA_Puzzled_ForestB_TripleChest.LuaObjectScript.Enable()
  end
  if forestCoffinOpened == false then
    GameObjects.CA_Observe_Forward_Up_ForestB_Nook.LuaObjectScript.Enable()
  end
  if raven2Collected == false then
    GameObjects.CA_Point_Up_ForestB_Raven2.LuaObjectScript.Enable()
  end
end
function ForestB_CA_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_ForestB_01.LuaObjectScript.Disable()
  GameObjects.LTW_ForestB_02.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_ForestB_TripleChest.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_TempleFacade.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_ForestB_Waterfall.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Down_ForestB_01.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_ForestB_Nook.LuaObjectScript.Disable()
  GameObjects.CA_Point_Up_ForestB_Raven2.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Waterfall.LuaObjectScript.Disable()
  GameObjects.CA_LookUnderObject_Forward_ForestB_01.LuaObjectScript.Disable()
  GameObjects.CA_Puzzled_ForestB_TripleChest.LuaObjectScript.Disable()
  GameObjects.CA_PlayWithKnife_ForestB_01.LuaObjectScript.Disable()
  GameObjects.CA_NewEnvironment_ForestB_01.LuaObjectScript.Disable()
  GameObjects.CA_DustOff_ForestB_01.LuaObjectScript.Disable()
end
function MantleAExitCheck()
  if forestEncounterComplete == false then
    GameObjects.CA_BeckonToMe_ForestB.LuaObjectScript.Interrupt()
  end
  if meadowIntroComplete == false then
    SetMeadowIntroComplete()
  end
end
function DungeonFrontDoorExitCheck()
  GameObjects.CA_Sync_Dungeon_FrontDoor_B.LuaObjectScript.Enable()
end
function NookCA_Enable()
  GameObjects.CA_LeanOnWall_ForestB_01.LuaObjectScript.Enable()
end
function NookCA_Disable()
  GameObjects.CA_LeanOnWall_ForestB_01.LuaObjectScript.Disable()
end
function ForestTunnelCA_Enable()
  print("Forest Tunnel CA Enabled")
  GameObjects.LTW_ForestTunnel.LuaObjectScript.Enable()
  GameObjects.CA_ObserveFar_Forward_DungeonIntro.LuaObjectScript.Enable()
end
function ForestTunnelCA_Disable()
  GameObjects.LTW_ForestTunnel.LuaObjectScript.Disable()
  GameObjects.CA_ObserveFar_Forward_DungeonIntro.LuaObjectScript.Disable()
end
function DungeonLTW_Enable()
  print("Dungeon LTW Enabled")
  if bridgecounter == 0 then
    GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Enable()
    GameObjects.CA_BeckonToMe_DungeonCenter_01.LuaObjectScript.Enable()
  elseif bridgecounter == 1 then
    GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Enable()
    if keyorbcounter == 0 then
      GameObjects.LTW_Room1_In.LuaObjectScript.Enable()
    elseif keyorbcounter == 1 then
      GameObjects.LTW_Room1_Out.LuaObjectScript.Enable()
      GameObjects.LTW_Room1_In.LuaObjectScript.Disable()
    end
  elseif bridgecounter == 2 then
    GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Enable()
    if keyorbcounter == 1 then
      GameObjects.LTW_Room2_In.LuaObjectScript.Enable()
    elseif keyorbcounter == 2 then
      GameObjects.LTW_Room2_Out.LuaObjectScript.Enable()
      GameObjects.LTW_Room2_In.LuaObjectScript.Disable()
    end
  elseif bridgecounter == 3 then
    GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Enable()
    if keyorbcounter == 2 then
      GameObjects.LTW_Room3_In.LuaObjectScript.Enable()
    elseif keyorbcounter == 3 then
      GameObjects.LTW_Room3_Out.LuaObjectScript.Enable()
      GameObjects.LTW_Room3_In.LuaObjectScript.Disable()
    end
  elseif bridgecounter == 4 then
    GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Enable()
    if keyorbcounter == 3 then
      GameObjects.LTW_Room4_In.LuaObjectScript.Enable()
    elseif keyorbcounter == 4 then
      GameObjects.LTW_Room4_Out.LuaObjectScript.Enable()
      GameObjects.LTW_Room4_In.LuaObjectScript.Disable()
    end
  elseif bridgecounter == 5 then
    if bossRoomComplete == false then
      GameObjects.LTW_Room5_In.LuaObjectScript.Enable()
      GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Enable()
    elseif bossRoomComplete == true then
      GameObjects.LTW_DungeonEnt_Out.LuaObjectScript.Enable()
      GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Disable()
      GameObjects.LTW_Room5_In.LuaObjectScript.Disable()
    end
  end
end
function DungeonCenterIn()
  print("Dungeon Center In")
  SonAvailableForCombat()
  if bridgecounter == 0 then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    if dungeonIntroComplete == false then
      GameObjects.CA_NewEnvironment_DungeonCenter_01.LuaObjectScript.Enable()
    end
    GameObjects.CA_IdleBehavior_DungeonCenter_01.LuaObjectScript.Enable()
    GameObjects.CA_BeckonToMe_DungeonCenter_01.LuaObjectScript.Disable()
  elseif bridgecounter == 1 then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_IdleBehavior_DungeonCenter_01.LuaObjectScript.Disable()
    if keyorbcounter == 1 then
      GameObjects.CA_IdleBehavior_DungeonCenter_02.LuaObjectScript.Enable()
    end
  elseif bridgecounter == 2 then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_IdleBehavior_DungeonCenter_02.LuaObjectScript.Disable()
    if keyorbcounter == 2 then
      GameObjects.CA_IdleBehavior_DungeonCenter_03.LuaObjectScript.Enable()
    end
  elseif bridgecounter == 3 then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_IdleBehavior_DungeonCenter_03.LuaObjectScript.Disable()
    if keyorbcounter == 3 then
      GameObjects.CA_IdleBehavior_DungeonCenter_04.LuaObjectScript.Enable()
    end
  elseif bridgecounter == 4 then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_IdleBehavior_DungeonCenter_04.LuaObjectScript.Disable()
    if keyorbcounter == 4 then
      GameObjects.CA_IdleBehavior_DungeonCenter_05.LuaObjectScript.Enable()
    end
  end
end
function DungeonCenterOut()
  print("Dungeon Center Out")
  if dungeonIntroComplete == false then
    GameObjects.CA_BeckonToMe_DungeonCenter_01.LuaObjectScript.Enable()
  elseif dungeonIntroComplete == true then
    son:CallScript("ClearBehaviorContext")
    GameObjects.CA_NewEnvironment_DungeonCenter_01.LuaObjectScript.Disable()
  end
  GameObjects.CA_Observe_Forward_01.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_DungeonCenter_01.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_DungeonCenter_02.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_DungeonCenter_03.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_DungeonCenter_04.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_DungeonCenter_05.LuaObjectScript.Disable()
end
function DungeonLTW_Disable()
  print("Dungeon LTW Disabled")
  GameObjects.LTW_DungeonEnt_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room1_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room1_Out.LuaObjectScript.Disable()
  GameObjects.LTW_Room2_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room2_Out.LuaObjectScript.Disable()
  GameObjects.LTW_Room3_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room3_Out.LuaObjectScript.Disable()
  GameObjects.LTW_Room4_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room4_Out.LuaObjectScript.Disable()
  GameObjects.LTW_Room5_In.LuaObjectScript.Disable()
  GameObjects.LTW_DungeonEnt_Out.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_DungeonCenter_01.LuaObjectScript.Disable()
end
function Room1LTW_Enable()
  print("Room1 Interior LTW Enabled")
  if keyorbcounter == 0 then
    GameObjects.LTW_Room1Interior_In.LuaObjectScript.Enable()
    GameObjects.CA_BeckonToMe_Room01.LuaObjectScript.Enable()
  elseif keyorbcounter == 1 then
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    GameObjects.CA_BeckonToMe_Room01.LuaObjectScript.Disable()
    GameObjects.LTW_Room1Interior_In.LuaObjectScript.Disable()
    GameObjects.LTW_Room1Interior_Out.LuaObjectScript.Enable()
  end
  if room1EncounterComplete == false then
    GameObjects.CA_IdleBehavior_Room01.LuaObjectScript.Enable()
  elseif room1EncounterComplete == true then
    GameObjects.CA_IdleBehavior_Room01.LuaObjectScript.Disable()
  end
end
function Room1LTW_Disable()
  print("Room1 Interior LTW Disabled")
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_Room1Interior_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room1Interior_Out.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Room01.LuaObjectScript.Disable()
  GameObjects.CA_BeckonToMe_Room01.LuaObjectScript.Disable()
end
function Room2LTW_Enable()
  print("Room2 Interior LTW Enabled")
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  if keyorbcounter == 1 then
    GameObjects.LTW_Room2Interior_In.LuaObjectScript.Enable()
  elseif keyorbcounter == 2 then
    GameObjects.LTW_Room2Interior_In.LuaObjectScript.Disable()
    GameObjects.LTW_Room2Interior_Out.LuaObjectScript.Enable()
  end
end
function Room2LTW_Disable()
  print("Room2 Interior LTW Disabled")
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_Room2Interior_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room2Interior_Out.LuaObjectScript.Disable()
end
function Room3LTW_Enable()
  print("Room3 Interior LTW Enabled")
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  if keyorbcounter == 2 then
    GameObjects.LTW_Room3Interior_In.LuaObjectScript.Enable()
  elseif keyorbcounter == 3 then
    GameObjects.LTW_Room3Interior_In.LuaObjectScript.Disable()
    GameObjects.LTW_Room3Interior_Out.LuaObjectScript.Enable()
  end
end
function Room3LTW_Disable()
  print("Room3 Interior LTW Disabled")
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_Room3Interior_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room3Interior_Out.LuaObjectScript.Disable()
end
function Room4LTW_Enable()
  print("Room4 Interior LTW Enabled")
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  if keyorbcounter == 3 then
    GameObjects.LTW_Room4Interior_In.LuaObjectScript.Enable()
  elseif keyorbcounter == 4 then
    GameObjects.LTW_Room4Interior_In.LuaObjectScript.Disable()
    GameObjects.LTW_Room4Interior_Out.LuaObjectScript.Enable()
  end
end
function Room4LTW_Disable()
  print("Room4 Interior LTW Disabled")
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_Room4Interior_In.LuaObjectScript.Disable()
  GameObjects.LTW_Room4Interior_Out.LuaObjectScript.Disable()
end
function BossRoomLTW_Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  print("Boss Room LTW Enabled")
  if keyorbcounter == 4 then
    GameObjects.LTW_BossRoom_In_01.LuaObjectScript.Enable()
    GameObjects.LTW_BossRoom_In_02.LuaObjectScript.Enable()
    GameObjects.LTW_BossRoom_In_03.LuaObjectScript.Enable()
  elseif keyorbcounter == 5 then
    GameObjects.LTW_BossRoom_In_01.LuaObjectScript.Enable()
    GameObjects.LTW_BossRoom_In_02.LuaObjectScript.Enable()
    GameObjects.LTW_BossRoom_In_03.LuaObjectScript.Enable()
  end
end
function BossRoomLTW_Disable()
  print("Boss Room LTW Disabled")
  son:CallScript("ClearBehaviorContext")
  GameObjects.LTW_BossRoom_In_01.LuaObjectScript.Disable()
  GameObjects.LTW_BossRoom_In_02.LuaObjectScript.Disable()
  GameObjects.LTW_BossRoom_In_03.LuaObjectScript.Disable()
  GameObjects.LTW_BossRoom_In_01.LuaObjectScript.Disable()
  GameObjects.LTW_BossRoom_In_02.LuaObjectScript.Disable()
  GameObjects.LTW_BossRoom_In_03.LuaObjectScript.Disable()
end
function BanterDungeonEntranceCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_01")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function BanterDoorLockedCheck()
  if frontDoorLocked == true then
    game.Audio.PlayBanter("Sindri01_Dungeon_Locked")
  end
end
function BanterObjective01Check()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_01")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function CompleteObjective01()
  LD.CompleteQuest("Quest_Sindri_Epic_01_Objective_01")
end
function PlayBanterEncounter01()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_03")
  if questState == "Active" then
    game.Audio.PlayBanter("Sindri01_Room01_Complete")
  end
end
function PlayBanterEncounter02()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_03")
  if questState == "Active" then
    game.Audio.PlayBanter("Sindri01_Room02_Complete")
  end
end
function PlayBanterEncounter03()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_03")
  if questState == "Active" then
    game.Audio.PlayBanter("Sindri01_Room03_Complete")
  end
end
function PlayBanterEncounter04()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_03")
  if questState == "Active" then
    game.Audio.PlayBanter("Sindri01_Room04_Complete")
  end
end
function PlayBanterObjective02()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_02")
  if questState == "Active" and banterObjective02Played == false then
    game.Audio.PlayBanter("Sindri01_KeyOrb")
    banterObjective02Played = true
  end
end
function CompleteObjective02()
  LD.CompleteQuest("Quest_Sindri_Epic_01_Objective_02")
end
function BanterDungeonExitCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_Return")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function Xpl850_SpawnGoblin()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    bridgecounter = bridgecounter,
    keyorbcounter = keyorbcounter,
    bossRoomComplete = bossRoomComplete,
    forestEncounterComplete = forestEncounterComplete,
    golemEncounterComplete = golemEncounterComplete,
    room1EncounterComplete = room1EncounterComplete,
    room2EncounterComplete = room2EncounterComplete,
    room3EncounterComplete = room3EncounterComplete,
    room4EncounterComplete = room4EncounterComplete,
    meadowIntroComplete = meadowIntroComplete,
    forestTripleChestOpened = forestTripleChestOpened,
    forestCoffinOpened = forestCoffinOpened,
    dirtLootPatchCollected = dirtLootPatchCollected,
    raven1Collected = raven1Collected,
    raven2Collected = raven2Collected,
    raven3Collected = raven3Collected,
    frontDoorLocked = frontDoorLocked,
    dungeonIntroComplete = dungeonIntroComplete,
    forestEntered = forestEntered,
    musicXpl850Ped = musicXpl850Ped
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bridgecounter = savedInfo.bridgecounter
  keyorbcounter = savedInfo.keyorbcounter
  bossRoomComplete = savedInfo.bossRoomComplete
  forestEncounterComplete = savedInfo.forestEncounterComplete
  golemEncounterComplete = savedInfo.golemEncounterComplete
  room1EncounterComplete = savedInfo.room1EncounterComplete
  room2EncounterComplete = savedInfo.room2EncounterComplete
  room3EncounterComplete = savedInfo.room3EncounterComplete
  room4EncounterComplete = savedInfo.room4EncounterComplete
  meadowIntroComplete = savedInfo.meadowIntroComplete
  forestTripleChestOpened = savedInfo.forestTripleChestOpened
  forestCoffinOpened = savedInfo.forestCoffinOpened
  dirtLootPatchCollected = savedInfo.dirtLootPatchCollected
  raven1Collected = savedInfo.raven1Collected
  raven2Collected = savedInfo.raven2Collected
  raven3Collected = savedInfo.raven3Collected
  frontDoorLocked = savedInfo.frontDoorLocked
  dungeonIntroComplete = savedInfo.dungeonIntroComplete
  forestEntered = savedInfo.forestEntered
  musicXpl850Ped = savedInfo.musicXpl850Ped
end
function CaveInZoneMusic()
  if musicXpl850 == false then
    if not forestEntered then
      game.Audio.StartMusic("SND_MX_XPL850_enter_forest")
      game.Audio.SetCheckpointedMusic("SND_MX_XPL850_explore1_in")
      forestEntered = true
    else
      game.Audio.StartCheckpointedMusic("SND_MX_XPL850_explore1_in")
    end
    musicXpl850 = true
  end
end
function WaterfallEnterMusic()
  game.Audio.StartMusic("SND_MX_XPL850_waterfall")
end
function pedistalMusic()
  if musicXpl850Ped == false then
    game.Audio.StartMusic("SND_MX_XPL850_pedestal_1")
    game.Audio.SetCheckpointedMusic("SND_MX_XPL850_explore2_in")
    musicXpl850Ped = true
  end
end
function BossRoomEnterMusic()
  game.Audio.StartMusic("SND_MX_XPL850_dungeon_room5_in")
end
function xpl850ExitMusic()
  if musicXpl850 == true then
    game.Audio.StartMusic("SND_MX_XPL850_idle")
    musicXpl850 = false
  end
end
local SNDpillar1_1, SNDpillar1_2, SNDpillar1_3, SNDrune1, SNDBridgeRumble1, SNDBridgeMech1, SNDpillar2_1, SNDpillar2_2, SNDpillar2_3, SNDrune2, SNDBridgeRumble2, SNDBridgeMech2, SNDpillar3_1, SNDpillar3_2, SNDpillar3_3, SNDBridgeMech3, SNDrune3, SNDBridgeRumble3, SNDpillar4_1, SNDpillar4_2, SNDpillar4_3, SNDBridgeMech4, SNDrune4, SNDBridgeRumble4, SNDpillar5_1, SNDpillar5_2, SNDpillar5_3, SNDBridgeMech5, SNDrune5, SNDBridgeRumble5
local keystoneSoundOverrides = {
  soundPedestal = "SND_MECH_Keystone_Activate",
  soundPedestalLoop = "SND_MECH_Keystone_Activate_LP",
  soundKeyPlace = "SND_MECH_Keystone_Activate_Key_Insert"
}
function SoundInit()
  SNDpillar1_1 = movingBlocks01:FindSingleSoundEmitterByName("SNDpillar1_1")
  SNDpillar1_2 = movingBlocks01:FindSingleSoundEmitterByName("SNDpillar1_2")
  SNDpillar1_3 = movingBlocks01:FindSingleSoundEmitterByName("SNDpillar1_3")
  SNDrune1 = GameObjects.SNDrune1Grp.SoundEmitters[1]
  SNDBridgeMech1 = movingBlocks01:FindSingleSoundEmitterByName("SNDBridgeMech1")
  SNDBridgeRumble1 = GameObjects.SNDBridgeRumble1Grp.SoundEmitters[1]
  SNDpillar2_1 = movingBlocks02:FindSingleSoundEmitterByName("SNDpillar2_1")
  SNDpillar2_2 = movingBlocks02:FindSingleSoundEmitterByName("SNDpillar2_2")
  SNDpillar2_3 = movingBlocks02:FindSingleSoundEmitterByName("SNDpillar2_3")
  SNDrune2 = GameObjects.SNDrune2Grp.SoundEmitters[1]
  SNDBridgeMech2 = movingBlocks02:FindSingleSoundEmitterByName("SNDBridgeMech2")
  SNDBridgeRumble2 = GameObjects.SNDBridgeRumble2Grp.SoundEmitters[1]
  SNDpillar3_1 = movingBlocks03:FindSingleSoundEmitterByName("SNDpillar3_1")
  SNDpillar3_2 = movingBlocks03:FindSingleSoundEmitterByName("SNDpillar3_2")
  SNDpillar3_3 = movingBlocks03:FindSingleSoundEmitterByName("SNDpillar3_3")
  SNDBridgeMech3 = movingBlocks03:FindSingleSoundEmitterByName("SNDBridgeMech3")
  SNDrune3 = GameObjects.SNDrune3Grp.SoundEmitters[1]
  SNDBridgeRumble3 = GameObjects.SNDBridgeRumble3Grp.SoundEmitters[1]
  SNDpillar4_1 = movingBlocks04:FindSingleSoundEmitterByName("SNDpillar4_1")
  SNDpillar4_2 = movingBlocks04:FindSingleSoundEmitterByName("SNDpillar4_2")
  SNDpillar4_3 = movingBlocks04:FindSingleSoundEmitterByName("SNDpillar4_3")
  SNDBridgeMech4 = movingBlocks04:FindSingleSoundEmitterByName("SNDBridgeMech4")
  SNDrune4 = GameObjects.SNDrune4Grp.SoundEmitters[1]
  SNDBridgeRumble4 = GameObjects.SNDBridgeRumble4Grp.SoundEmitters[1]
  SNDpillar5_1 = movingBlocks05:FindSingleSoundEmitterByName("SNDpillar5_1")
  SNDpillar5_2 = movingBlocks05:FindSingleSoundEmitterByName("SNDpillar5_2")
  SNDpillar5_3 = movingBlocks05:FindSingleSoundEmitterByName("SNDpillar5_3")
  SNDBridgeMech5 = movingBlocks05:FindSingleSoundEmitterByName("SNDBridgeMech4")
  SNDrune5 = GameObjects.SNDrune5Grp.SoundEmitters[1]
  SNDBridgeRumble5 = GameObjects.SNDBridgeRumble5Grp.SoundEmitters[1]
end
function PlayPillar1Sound()
  PlayPillarForwardSounds(SNDpillar1_1, SNDpillar1_2, SNDpillar1_3, movingBlocks01)
  LD.PlaySoundOnFrame(SNDBridgeRumble1, movingBlocks01, "SND_MECH_DungeonForest_Bridge_Stone_Start", 0, "Forward")
  LD.PlaySoundOnFrame(SNDrune1, movingBlocks01, "SND_MECH_DungeonForest_Bridge_Stone_Light", 10, "Forward")
  LD.PlaySoundOnFrame(SNDBridgeMech1, movingBlocks01, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 10, "Forward")
end
function PlayPillar2Sound()
  PlayPillarForwardSounds(SNDpillar2_1, SNDpillar2_2, SNDpillar2_3, movingBlocks02)
  LD.PlaySoundOnFrame(SNDBridgeRumble2, movingBlocks02, "SND_MECH_DungeonForest_Bridge_Stone_Start", 0, "Forward")
  LD.PlaySoundOnFrame(SNDrune2, movingBlocks02, "SND_MECH_DungeonForest_Bridge_Stone_Light", 10, "Forward")
  LD.PlaySoundOnFrame(SNDBridgeMech2, movingBlocks02, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 10, "Forward")
  PlayPillarBackwardSounds(SNDpillar1_1, SNDpillar1_2, SNDpillar1_3, movingBlocks01)
  LD.PlaySoundOnFrame(SNDBridgeRumble1, movingBlocks01, "SND_MECH_DungeonForest_Bridge_Stone_Start", 195, "Backward")
  LD.PlaySoundOnFrame(SNDBridgeMech1, movingBlocks01, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 190, "Backward")
end
function PlayPillar3Sound()
  PlayPillarForwardSounds(SNDpillar3_1, SNDpillar3_2, SNDpillar3_3, movingBlocks03)
  LD.PlaySoundOnFrame(SNDBridgeRumble3, movingBlocks03, "SND_MECH_DungeonForest_Bridge_Stone_Start", 0, "Forward")
  LD.PlaySoundOnFrame(SNDrune3, movingBlocks03, "SND_MECH_DungeonForest_Bridge_Stone_Light", 10, "Forward")
  LD.PlaySoundOnFrame(SNDBridgeMech3, movingBlocks03, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 10, "Forward")
  PlayPillarBackwardSounds(SNDpillar2_1, SNDpillar2_2, SNDpillar2_3, movingBlocks02)
  LD.PlaySoundOnFrame(SNDBridgeRumble2, movingBlocks02, "SND_MECH_DungeonForest_Bridge_Stone_Start", 195, "Backward")
  LD.PlaySoundOnFrame(SNDBridgeMech2, movingBlocks02, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 190, "Backward")
end
function PlayPillar4Sound()
  PlayPillarForwardSounds(SNDpillar4_1, SNDpillar4_2, SNDpillar4_3, movingBlocks04)
  LD.PlaySoundOnFrame(SNDBridgeRumble4, movingBlocks04, "SND_MECH_DungeonForest_Bridge_Stone_Start", 0, "Forward")
  LD.PlaySoundOnFrame(SNDrune4, movingBlocks04, "SND_MECH_DungeonForest_Bridge_Stone_Light", 10, "Forward")
  LD.PlaySoundOnFrame(SNDBridgeMech4, movingBlocks04, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 10, "Forward")
  PlayPillarBackwardSounds(SNDpillar3_1, SNDpillar3_2, SNDpillar3_3, movingBlocks03)
  LD.PlaySoundOnFrame(SNDBridgeRumble3, movingBlocks03, "SND_MECH_DungeonForest_Bridge_Stone_Start", 195, "Backward")
  LD.PlaySoundOnFrame(SNDBridgeMech3, movingBlocks03, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 190, "Backward")
end
function PlayPillar5Sound()
  PlayPillarForwardSounds(SNDpillar5_1, SNDpillar5_2, SNDpillar5_3, movingBlocks05)
  LD.PlaySoundOnFrame(SNDBridgeRumble5, movingBlocks05, "SND_MECH_DungeonForest_Bridge_Stone_Start", 0, "Forward")
  LD.PlaySoundOnFrame(SNDrune5, movingBlocks05, "SND_MECH_DungeonForest_Bridge_Stone_Light", 10, "Forward")
  LD.PlaySoundOnFrame(SNDBridgeMech5, movingBlocks05, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 10, "Forward")
  PlayPillarBackwardSounds(SNDpillar4_1, SNDpillar4_2, SNDpillar4_3, movingBlocks04)
  LD.PlaySoundOnFrame(SNDBridgeRumble4, movingBlocks04, "SND_MECH_DungeonForest_Bridge_Stone_Start", 195, "Backward")
  LD.PlaySoundOnFrame(SNDBridgeMech4, movingBlocks04, "SND_MECH_DungeonForest_Bridge_Stone_Mech", 190, "Backward")
end
function PlayPillarForwardSounds(soundEmitter1, soundEmitter2, soundEmitter3, animName)
  LD.PlaySoundOnFrame(soundEmitter1, animName, "SND_MECH_DungeonForest_Bridge_Stone_Pillar1", 110, "Forward")
  LD.PlaySoundOnFrame(soundEmitter2, animName, "SND_MECH_DungeonForest_Bridge_Stone_Pillar2", 133, "Forward")
  LD.PlaySoundOnFrame(soundEmitter3, animName, "SND_MECH_DungeonForest_Bridge_Stone_Pillar3", 166, "Forward")
end
function PlayPillarBackwardSounds(soundEmitter1, soundEmitter2, soundEmitter3, animName)
  LD.PlaySoundOnFrame(soundEmitter1, animName, "SND_MECH_DungeonForest_Bridge_Stone_Pillar1", 60, "Backward")
  LD.PlaySoundOnFrame(soundEmitter2, animName, "SND_MECH_DungeonForest_Bridge_Stone_Pillar2", 80, "Backward")
  LD.PlaySoundOnFrame(soundEmitter3, animName, "SND_MECH_DungeonForest_Bridge_Stone_Pillar3", 98, "Backward")
end
function SoundOnStart()
  GameObjects.StonePedestal.LuaObjectScript.SoundSetup(keystoneSoundOverrides)
end
