local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local son, colElevatorLevelOne, elevatorRope, lightBridgeBlocker
local bifrostBridgeOn = false
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  colElevatorLevelOne = GameObjects.col_elevator_level_one
  elevatorRope = GameObjects.elevator_rope
  lightBridgeBlocker = GameObjects.xpl875BridgeCol
end
function OnFirstStart(level)
  colElevatorLevelOne:Show()
  elevatorRope:Hide()
  GameObjects.ElevatorZone_JumpToBottom:Hide()
  GameObjects.ElevatorZone_JumpToTop:Hide()
end
function OnPreStart(level, obj)
  QuestStoneFixUp()
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = LowerWaterLevel02,
    fn = LowerWaterLevel02
  })
  local switchInteractZones = GameObjects.SwitchWall_Elevator.LuaObjectScript.GetInteractZoneTable()
  switchInteractZones[1]:SetEnableLineOfSightTest(true)
  switchInteractZones[1]:SetXZRange(1.5)
  switchInteractZones[1]:SetInteractFrontAngleWeight(0)
  switchInteractZones[1]:SetCameraFrontAngle(0, 120)
  switchInteractZones[1]:SetCameraFrontAngleWeight(1)
  GameObjects.SwitchWall_Elevator.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_Elevator_Xpl875")
  GameObjects.SwitchWall_Elevator.LuaObjectScript.OverrideDefaultCameraYaw(true, -30)
  SoundOnStart()
end
function LowerWaterLevel02()
  elevatorRope:Show()
end
function QuestStoneFixUp()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_02")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneForestDungeon")
  print("quest state", entryStone, questState)
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneForestDungeon", 1)
  end
end
function AreaAnnounceForestDungeon()
  uiCalls.UI_Event_DiscoverLocation("ForestDungeon")
  game.Level.SetVariable("QST_RuneMarker_Quest_02", true)
  timers.StartLevelTimer(3, CompleteQuest)
end
function CompleteQuest()
  local questState = game.QuestManager.GetQuestState("Quest_FHRuneMarker02")
  if questState == "Active" then
    LD.CompleteQuest("Quest_FHRuneMarker02")
  end
end
function HideLightBridgeCol()
  LD.CallFunctionAfterDelay(function()
    lightBridgeBlocker:Hide()
    game.World.StoreCheckpoint()
  end, 1.5)
end
function EnableHiddenLootChest()
  GameObjects.chest_common_tier4_xpl875_1.LuaObjectScript.Enable()
end
function SetBridgeOn()
  bifrostBridgeOn = true
  GameObjects.CA_ObserveFar_Forward_BifrostBridge.LuaObjectScript.Disable()
end
function CA_Beach1_Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.CA_LookUnderObject_Forward_Beach1.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_Beach1.LuaObjectScript.Enable()
end
function CA_Beach1_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.CA_LookUnderObject_Forward_Beach1.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Beach1.LuaObjectScript.Disable()
end
function LTW_Beach1_Enable()
  GameObjects.LTW_Beach1.LuaObjectScript.Enable()
end
function LTW_Beach1_Disable()
  GameObjects.LTW_Beach1.LuaObjectScript.Disable()
end
function CA_Beach2_Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.CA_ObserveFar_Forward_Beach2_01.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Up_Beach2_01.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_Beach2_01.LuaObjectScript.Enable()
end
function CA_Beach2_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.CA_ObserveFar_Forward_Beach2_01.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up_Beach2_01.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_Beach2_01.LuaObjectScript.Disable()
end
function LTW_ShopClearing_Enable()
  GameObjects.LTW_ShopClearing.LuaObjectScript.Enable()
end
function LTW_ShopClearing_Disable()
  GameObjects.LTW_ShopClearing.LuaObjectScript.Disable()
end
function CA_ShopClearing_Enable()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.CA_Puzzled_Shop_Clearing.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_ShopClearing.LuaObjectScript.Enable()
  GameObjects.CA_IdleBehavior_ShopClearing.LuaObjectScript.Enable()
end
function CA_ShopClearing_Disable()
  son:CallScript("ClearBehaviorContext")
  GameObjects.CA_Puzzled_Shop_Clearing.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_ShopClearing.LuaObjectScript.Disable()
  GameObjects.CA_IdleBehavior_ShopClearing.LuaObjectScript.Disable()
end
function CA_BifrostEvent_Enable()
  if bifrostBridgeOn == false then
    GameObjects.CA_ObserveFar_Forward_BifrostBridge.LuaObjectScript.Enable()
    LTW_ShopClearing_Enable()
  elseif bifrostBridgeOn == true then
    GameObjects.CA_ObserveFar_Forward_BifrostBridge.LuaObjectScript.Disable()
    LTW_ShopClearing_Enable()
    CA_ShopClearing_Enable()
  end
end
function BanterForestEntranceCheck()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_01")
  if questState == "Active" then
    return true
  else
    return false
  end
end
function CheckMimirFollowUp()
  if game.Level.GetVariable("CompletedCineNumber") >= 330 then
    game.Audio.PlayBanter("Sindri01_Forest_Entrance_Contd")
  end
end
function OnElevatorMoveUp()
  GameObjects.ElevatorZone_JumpToTop:Show()
  GameObjects.ElevatorZone_JumpToBottom:Show()
  colElevatorLevelOne:Hide()
end
function OnElevatorMoveDown()
  colElevatorLevelOne:Show()
end
function OnJumpElevatorToBottom()
  GameObjects.xpl450_BasicElevator.LuaObjectScript.JumpToBottomFloor()
end
function OnJumpElevatorToTop()
  GameObjects.xpl450_BasicElevator.LuaObjectScript.JumpToTopFloor()
end
function LoadCheckCal100Hub()
  game.UI.LoadCheck("Cal100_Hub")
end
function LoadCheckCal200Shore()
  game.UI.LoadCheck("Cal200_Shore")
end
function LoadCheckXpl850()
  game.UI.LoadCheck("Xpl850_DungeonForest")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    lightBridgeBlocker = lightBridgeBlocker,
    bifrostBridgeOn = bifrostBridgeOn
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  lightBridgeBlocker = savedInfo.lightBridgeBlocker
  bifrostBridgeOn = savedInfo.bifrostBridgeOn
end
local shortcutElevatorSoundOverride = {
  SoundEmitter = nil,
  OnForward = "SND_MECH_Elevator_Wood_LP",
  OnBackward = "SND_MECH_Elevator_Wood_LP"
}
function SoundOnStart()
  shortcutElevatorSoundOverride.SoundEmitter = GameObjects.xpl450ShortcutElevator:FindSingleSoundEmitterByName("SNDShortcutElevator")
  GameObjects.xpl450ShortcutElevator:FindSingleGOByName("xpl450_BasicElevator").LuaObjectScript.SoundSetup(shortcutElevatorSoundOverride)
end
