local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, Area_0_Encounter_1, Area_1_Encounter_1, Arch_Draugr_Attack_Monitor
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_0_Fight_1()
    Area_1_Fight_1_Repop()
  end
end
function Area_0_Fight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC: Draugr Patrols Water Level 2 XPL900", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl900",
    LoadCheck = false
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Draugr_5_ENCH_PATROL01",
      spawnLocators = "A0_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_6_ENCH_PATROL02",
      spawnLocators = "A0_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "H_Draugr_5_SLEEP",
      spawnLocators = "A0_O_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    },
    {
      spawners = "Draugr_6_SH_IDLE",
      spawnLocators = "A0_O_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.6
    }
  })
  Area_0_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_0)
  Area_0_Encounter_1:SetAlertZone(GameObjects.EntZn_Arena_Attack_0)
  Area_0_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Weapon")
  end)
end
function Area_1_Fight_1_Repop()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC: Draugr Patrols Repopulation XPL900", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl900",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 0]EC: Draugr Patrols Water Level 2 XPL900"
    },
    LoadCheck = false
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_7_ENCH_PATROL01",
      spawnLocators = "A0_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    },
    {
      spawners = "Draugr_8_ENCH_PATROL02",
      spawnLocators = "A0_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Traveler_Patrol_*",
      spawnLocators = "A0_O_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl900_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_0)
  Area_1_Encounter_1:SetAlertZone(GameObjects.EntZn_Arena_Attack_0)
end
