local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local openDoor = false
local announceTriggered = false
local cameraChainRecenter = {
  TimeStart = 0,
  RotationSpace = 1,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 37,
  ReturnLeft = 32,
  ReturnRight = 32,
  TriggerRight = 27,
  PitchRange = -1,
  TriggerUp = 28,
  ReturnUp = 17,
  ReturnDown = 17,
  TriggerDown = 14
}
function OnScriptLoaded(level)
  SoundInit()
  local goChainPull = GameObjects.Bell_03_ChainPull
  if goChainPull ~= nil and goChainPull.LuaObjectScript ~= nil then
    goChainPull.LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraChainRecenter)
    goChainPull.LuaObjectScript.OverrideDefaultCameraPitch(true, 17)
    goChainPull.LuaObjectScript.OverrideDefaultCameraYaw(true, 32)
  end
  local cal200 = game.FindLevel("Cal200_Shore")
  goChainPull.LuaObjectScript.RegisterForwardPullCallback(function()
    cal200:CallScript("Xpl900_GateDown")
  end)
  goChainPull.LuaObjectScript.RegisterBackwardPullCallback(function()
    cal200:CallScript("Xpl900_GateUp")
  end)
end
function OnFirstStart(level)
  Disable_SonCAVolume_AtRunicDoor()
  GameObjects.Bell_03:FindSingleGOByName("BellTargetBack"):HideCollision()
  GameObjects.Bell_03:FindSingleGOByName("BellTargetFront"):HideCollision()
  SetAmbience()
end
function OnStart(level)
  GameObjects.Bell_03_ChainPull.LuaObjectScript.Enable()
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = SetAmbience,
    fn = SetAmbience
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = SetAmbience,
    fn = SetAmbience
  })
  GameObjects.spreadDoor.LuaObjectScript.SetAllowSyncWithSonNotAvailable(true)
  SoundOnStart()
end
function AreaAnnounce()
  print("no")
end
function AreaAnnounceNEW()
  if announceTriggered == false and game.IsPaused() == false then
    local uiCalls = require("ui.uicalls")
    uiCalls.UI_Event_DiscoverLocation("IslandArch")
    LD.CallFunctionAfterDelay(TrophyCheck, 1)
    announceTriggered = true
  end
end
function Disable_ChainPull()
  GameObjects.Bell_03_ChainPull.LuaObjectScript.RemovePlayerImmediate()
  GameObjects.Bell_03_ChainPull.LuaObjectScript.Disable()
  LD.CallFunctionAfterDelay(Enable_ChainPull, 7.5)
end
function Enable_ChainPull()
  GameObjects.Bell_03_ChainPull.LuaObjectScript.Enable()
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function Disable_SonCAVolume_AtRunicDoor()
  GameObjects.RunicDoorUnlocked_Zone:HideEntityVolume()
  GameObjects.Bell_03:FindSingleGOByName("BellTargetBack"):HideCollision()
  GameObjects.Bell_03:FindSingleGOByName("BellTargetFront"):HideCollision()
end
function Enable_SonCAVolume_AtRunicDoor()
  if openDoor == false then
    GameObjects.RunicDoorUnlocked_Zone:ShowEntityVolume()
  end
  GameObjects.Bell_03:FindSingleGOByName("BellTargetBack"):ShowCollision()
  GameObjects.Bell_03:FindSingleGOByName("BellTargetFront"):ShowCollision()
end
function onComplete_SonCAVolume_AtRunicDoor()
  openDoor = true
  Disable_SonCAVolume_AtRunicDoor()
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save(),
    openDoor = openDoor
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  openDoor = savedInfo.openDoor
end
local waterLevel = {
  Bottom = 2,
  Medium = 1,
  Top = 0
}
local bottomWaterAmbience, mediumWaterAmbience, SNDGrpEntXpl900, SNDGrpEntXpl900TreasureIn
local bellSoundOverrides = {
  OnHit = "SND_MECH_Bell_Puzzle_Hit_Oneshot_Broken_Ground"
}
local chainCrankGateDrivenObjectOverrides = {
  SoundEmitter = nil,
  UseInvertedEndPoints = true,
  OnStart = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Down",
  OnStartFrame = 1,
  OnReturnToStart = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling",
  OnForward = "SND_DOOR_Metal_Lift_Gate_Forest_LP",
  OnBackward = "SND_DOOR_Metal_Lift_Gate_Forest_LP",
  OnStartFromEnd = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up",
  OnStartFromEndFrame = 89,
  OnEnd = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ground"
}
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  SNDGrpEntXpl900 = GameObjects.SNDGrpEntXpl900
  SNDGrpEntXpl900TreasureIn = GameObjects.SNDGrpEntXpl900TreasureIn
end
function SoundOnStart()
  GameObjects.Bell_02.LuaObjectScript.SoundSetup(bellSoundOverrides)
  chainCrankGateDrivenObjectOverrides.SoundEmitter = GameObjects.Bell_LiftGate:FindSingleSoundEmitterByName("SNDBellGate")
  GameObjects.Bell_LiftGate:FindSingleGOByName("Bell_03_ChainPull").LuaObjectScript.DrivenObjectSoundSetup(chainCrankGateDrivenObjectOverrides)
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
    SNDGrpEntXpl900:Show()
    SNDGrpEntXpl900TreasureIn:Show()
  elseif newWaterLevel == waterLevel.Medium then
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
    SNDGrpEntXpl900:Hide()
    SNDGrpEntXpl900TreasureIn:Hide()
  elseif newWaterLevel == waterLevel.Top then
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
    SNDGrpEntXpl900:Hide()
    SNDGrpEntXpl900TreasureIn:Hide()
  end
end
function HideAllAmbience()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
function EnterTreasureRoomXpl900Music()
  game.Audio.StartMusic("SND_MX_XPL900_storeroom")
end
local musicXpl900 = false
function Xpl900OnMusic()
  if musicXpl900 == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL900_explore1_in")
    musicXpl900 = true
  end
end
function Xpl900OffMusic()
  if musicXpl900 == true then
    game.Audio.StartMusic("SND_MX_XPL900_idle")
    musicXpl900 = false
  end
end
