local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, Area_0_Encounter_0, Area_0_Encounter_1, Area_0_Encounter_2, Area_0_Encounter_3, Area_1_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_2, DespawnMonitor910
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") <= 339 then
    Area_0_QuestFight_1()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_0_QuestFight_2()
    Area_1_Fight_1()
    Area_2_Fight_1()
    Area_2_Fight_Repop()
  end
end
function OnFirstStart(level)
  GameObjects.EntZn_Arena_5_Quest_Spawn:HideEntityVolume()
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") >= 340 and Area_2_Encounter_1:WasRunning() then
    Area_2_Encounter_1:Start()
  end
  if GameObjects.LakeOfNine_QuestGiver.LuaObjectScript.IsGhostInteractEnabled() ~= true then
    GameObjects.LakeOfNine_LightBeacon:FindSingleGOByName("pSonInteractRune").LuaObjectScript.Enable()
  end
end
function IslandShipQuestEncounter()
  if LD.GetCurrentWaterLevel() == 1 then
    Area_0_Encounter_2:Start()
  end
  if LD.GetCurrentWaterLevel() == 2 then
    Area_0_Encounter_3:Start()
    GameObjects.EntZn_Arena_5_Quest_Spawn:ShowEntityVolume()
  end
end
function EnableQuestGiverIslandShip()
  local QuestGiver = thisLevel:GetGameObject("LakeOfNine_QuestGiver")
  QuestGiver.LuaObjectScript.EnableLakeOfNine()
end
function IslandShip_DF_Complete()
  game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness04_Objective_01", 1)
  LD.CompleteQuest("Quest_UnfinishedBusiness04_Objective_01_SpotC")
  _G.StartLevelTimer(2, QuestBanter)
  GameObjects.EntZn_Arena_4_Encounter_Fake:ShowEntityVolume()
end
function QuestBanter()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness04_Objective_01")
  if progress == 1 then
    game.Audio.PlayBanter("UB4_DF_FirstBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Objective_01")
  elseif progress == 2 then
    game.Audio.PlayBanter("UB4_DF_SecondBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Objective_01")
  elseif progress == 3 then
    game.Audio.PlayBanter("UB4_DF_ThirdBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Return")
  end
end
function Area_0_QuestFight_1()
  Area_0_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL1 Lake of Nine Quest Hel Fanatics XPL910", {
    CheckpointOnComplete = false,
    LoadCheck = true,
    LeashZone = "LeashZoneXpl910_2",
    LodLow = 30,
    LodHigh = 35,
    StartMusic = "SND_MX_XPL910_brazier_fight_in",
    StopMusic = "SND_MX_XPL910_brazier_fight_out"
  })
  Area_0_Encounter_2:AddWave({
    {
      spawners = "Fanatic_SHIELD",
      spawnLocators = "A4_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "Fanatic_SHIELD",
      spawnLocators = "A4_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Fanatic_SHIELD",
      spawnLocators = "A4_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Fanatic_SHIELD",
      spawnLocators = "A4_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_0_Encounter_2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Fanatic_SHIELD",
      spawnLocators = "A4_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Fanatic_SHIELD",
      spawnLocators = "A4_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_0_Encounter_2:OnComplete(EnableQuestGiverIslandShip)
  Area_0_Encounter_2:OnEnemyDeath(function()
    Area_0_Encounter_2:StartWave(2)
  end, {count = 2})
  Area_0_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Bomber")
  end)
end
function Area_0_QuestFight_2()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_0_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 WL2 Lake of Nine Quest Hel Fanatics XPL910", {
    CheckpointOnComplete = false,
    LoadCheck = true,
    LeashZone = "LeashZoneXpl910_2",
    LodLow = 30,
    LodHigh = 35,
    StartMusic = "SND_MX_XPL910_brazier_fight_in",
    StopMusic = "SND_MX_XPL910_brazier_fight_out"
  })
  Area_0_Encounter_3:AddWave({
    {
      spawners = "Fanatic_4_SHIELD",
      spawnLocators = "A4_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3,
      powerLevel = powerLevel02
    },
    {
      spawners = "Fanatic_4_SHIELD",
      spawnLocators = "A4_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = powerLevel02
    },
    {
      spawners = "Fanatic_4_SHIELD",
      spawnLocators = "A4_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = powerLevel02
    },
    {
      spawners = "Fanatic_3_SHIELD",
      spawnLocators = "A4_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    }
  })
  Area_0_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Fanatic_3_SHIELD",
      spawnLocators = "A4_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel01
    },
    {
      spawners = "Fanatic_4_SHIELD",
      spawnLocators = "A4_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3,
      powerLevel = powerLevel02
    }
  })
  Area_0_Encounter_3:SetStartZone(GameObjects.EntZn_Arena_5_Quest_Spawn)
  Area_0_Encounter_3:OnComplete(EnableQuestGiverIslandShip)
  Area_0_Encounter_3:OnEnemyDeath(function()
    Area_0_Encounter_3:StartWave(2)
  end, {count = 2})
  Area_0_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Bomber")
  end)
end
function Area_1_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Dead Freight Helwalker Ambush XPL910 ", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl910_1",
    LoadCheck = true
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Brawler00_4_RISING",
      spawnLocators = "A2_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "Fanatic_AMBUSH",
      spawnLocators = "A2_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5,
      powerLevel = powerLevel02
    },
    {
      spawners = "Fanatic_AMBUSH",
      spawnLocators = "A2_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8,
      powerLevel = powerLevel01
    },
    {
      spawners = "Fanatic_AMBUSH",
      spawnLocators = "A2_Loc_5",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4,
      powerLevel = powerLevel01
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_2_Encounter_Start)
  Area_1_Encounter_1:OnComplete(IslandShip_DF_Complete)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Witch Patrol XPL910", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl910_1",
    LoadCheck = false
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Witch_L4_PATROL",
      spawnLocators = "A2_Loc_6",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Witch_L3_IDLE",
      spawnLocators = "A2_Loc_7",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_4_Encounter_Fake)
end
function Area_2_Fight_Repop()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Witch Repopulation XPL910", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl910_1",
    LoadCheck = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:1 Witch Patrol XPL910"
    }
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Witch_L7_PATROL",
      spawnLocators = "A2_Loc_6",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Witch_L6_IDLE",
      spawnLocators = "A2_Loc_8",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl910_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_2_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_4_Encounter_Fake)
end
