local thisObj, thisLevel, ZipLift_01, ZipLift_02, Zipline_Rig, ZipLift_RigPOS_1, ZipLift_RigPOS_2, Zipline_1_1, Zipline_1_2, Zipline_1_3, Zipline_2_1, Zipline_2_2, Zipline_2_3, Zipline_3_1, Zipline_3_2, Zipline_3_3
local Ziplines = {}
local IsAnyZipliftMoving = function()
  return (not ZipLift_01 or not ZipLift_01.LuaObjectScript.IsMoving()) and ZipLift_02 and ZipLift_02.LuaObjectScript.IsMoving()
end
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  local scratch = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_Rig"))
  Zipline_Rig = scratch:FindSingleGOByName("zipline")
  local Attachpoint_01_String = obj:GetLuaTableAttribute("Zipline_Rig_AttachPoint_01")
  local Attachpoint_02_String = obj:GetLuaTableAttribute("Zipline_Rig_AttachPoint_02")
  if obj:GetLuaTableAttribute("ZipToFixedPoint") ~= 1 then
    ZipLift_01 = level:GetGameObject(obj:GetLuaTableAttribute("ZipLift_01"))
    ZipLift_RigPOS_1 = ZipLift_01:FindSingleGOByName(Attachpoint_01_String)
  else
    ZipLift_RigPOS_1 = level:GetGameObject(Attachpoint_01_String)
  end
  if obj:GetLuaTableAttribute("ZipToFixedPoint") ~= 2 then
    ZipLift_02 = level:GetGameObject(obj:GetLuaTableAttribute("ZipLift_02"))
    ZipLift_RigPOS_2 = ZipLift_02:FindSingleGOByName(Attachpoint_02_String)
  else
    ZipLift_RigPOS_2 = level:GetGameObject(Attachpoint_02_String)
  end
  if Zipline_Rig ~= nil then
    Zipline_Rig:SetZiplineStartAndEnd(ZipLift_RigPOS_1:GetWorldPosition(), ZipLift_RigPOS_2:GetWorldPosition())
  end
  if obj:GetLuaTableAttribute("Zipline_1_1") ~= "" then
    Zipline_1_1 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_1_1"))
  end
  if obj:GetLuaTableAttribute("Zipline_1_2") ~= "" then
    Zipline_1_2 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_1_2"))
  end
  if obj:GetLuaTableAttribute("Zipline_1_3") ~= "" then
    Zipline_1_3 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_1_3"))
  end
  if obj:GetLuaTableAttribute("Zipline_2_1") ~= "" then
    Zipline_2_1 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_2_1"))
  end
  if obj:GetLuaTableAttribute("Zipline_2_2") ~= "" then
    Zipline_2_2 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_2_2"))
  end
  if obj:GetLuaTableAttribute("Zipline_2_3") ~= "" then
    Zipline_2_3 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_2_3"))
  end
  if obj:GetLuaTableAttribute("Zipline_3_1") ~= "" then
    Zipline_3_1 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_3_1"))
  end
  if obj:GetLuaTableAttribute("Zipline_3_2") ~= "" then
    Zipline_3_2 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_3_2"))
  end
  if obj:GetLuaTableAttribute("Zipline_3_3") ~= "" then
    Zipline_3_3 = level:GetGameObject(obj:GetLuaTableAttribute("Zipline_3_3"))
  end
  table.insert(Ziplines, Zipline_1_1)
  table.insert(Ziplines, Zipline_1_2)
  table.insert(Ziplines, Zipline_1_3)
  table.insert(Ziplines, Zipline_2_1)
  table.insert(Ziplines, Zipline_2_2)
  table.insert(Ziplines, Zipline_2_3)
  table.insert(Ziplines, Zipline_3_1)
  table.insert(Ziplines, Zipline_3_2)
  table.insert(Ziplines, Zipline_3_3)
  HideLines()
end
function OnUpdate(level, obj)
  if IsAnyZipliftMoving() == true and Zipline_Rig ~= nil then
    Zipline_Rig:SetZiplineStartAndEnd(ZipLift_RigPOS_1:GetWorldPosition(), ZipLift_RigPOS_2:GetWorldPosition())
  end
end
function HideLines()
  for Zipline in pairs(Ziplines) do
    Ziplines[Zipline]:HideTraverseLink()
  end
end
function UpdateLines()
  HideLines()
  local Lift1_Level = 1
  if thisObj:GetLuaTableAttribute("ZipToFixedPoint") ~= 1 then
    Lift1_Level = ZipLift_01.LuaObjectScript.getLevel()
  end
  local Lift2_Level = 1
  if thisObj:GetLuaTableAttribute("ZipToFixedPoint") ~= 2 then
    Lift2_Level = ZipLift_02.LuaObjectScript.getLevel()
  end
  if Lift1_Level ~= 0 and Lift2_Level ~= 0 then
    local ActiveZipString = "Zipline_" .. tostring(Lift1_Level) .. "_" .. tostring(Lift2_Level)
    if thisObj:GetLuaTableAttribute(ActiveZipString) ~= "" then
      local ActiveZip = thisLevel:GetGameObject(thisObj:GetLuaTableAttribute(ActiveZipString))
      if ActiveZip ~= nil then
        ActiveZip:ShowTraverseLink()
        if Zipline_Rig ~= nil then
          Zipline_Rig:Unparent()
          ActiveZip:AddChild(Zipline_Rig)
        else
          Zipline_Rig = ActiveZip:FindSingleGOByName("zipline")
        end
      end
      print(ActiveZipString)
      print(ActiveZip)
    end
  end
end
function LiftMoving()
  if IsAnyZipliftMoving() == true then
    if ZipLift_01 ~= nil then
      ZipLift_01.LuaObjectScript.LiftSwitch_Disable()
    end
    if ZipLift_02 ~= nil then
      ZipLift_02.LuaObjectScript.LiftSwitch_Disable()
    end
    game.SubObject.Wake(thisObj)
  end
end
function LiftStopped()
  if IsAnyZipliftMoving() == false then
    if ZipLift_01 ~= nil then
      ZipLift_01.LuaObjectScript.LiftSwitch_Enable()
    end
    if ZipLift_02 ~= nil then
      ZipLift_02.LuaObjectScript.LiftSwitch_Enable()
    end
    if Zipline_Rig ~= nil then
      Zipline_Rig:SetZiplineStartAndEnd(ZipLift_RigPOS_1:GetWorldPosition(), ZipLift_RigPOS_2:GetWorldPosition())
    end
    game.SubObject.Sleep(thisObj)
  end
end
