local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local dfQuest910 = false
local currentWaterLevel = 0
local BeaconLit = false
function OnScriptLoaded(level, obj)
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.FastTravel_IslandShipwreck.LuaObjectScript.LockFastTravelPoint()
  GameObjects.EntZn_Arena_2_Encounter_Start:HideEntityVolume()
  GameObjects.Lower_entrySplineZone:HideEntityVolume()
  GameObjects.GapJump_fromZipline:HideTraverseLink()
  GameObjects.Climb_toUpperShip:HideTraversePath()
  GameObjects.coffin_tier3_xpl910_4.LuaObjectScript.Disable()
  GameObjects.coffin_tier3_xpl910_2.LuaObjectScript.Disable()
  GameObjects.coffin_tier3_xpl910_1.LuaObjectScript.Disable()
  GameObjects.PrecisionChallenge_Raven_Perch:Hide()
  game.Compass.SetGatewayMarkerIsOpen("ISW_910_Helper8", false)
  Disable_GapBlocker_Bomb()
  UpdateWaterLevel()
end
function OnStart(level)
  local Zipline_TopPOS = GameObjects.Zipline_Top
  local Zipline_BottomPOS = GameObjects.Zipline_Bottom
  local Zipline_fromShipVis = GameObjects.zipline_Xpl910A.Child
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
  GameObjects.CA_UpperShipExit_Zone:HideEntityVolume()
  GameObjects.CA_UpperShipExit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_01_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_01_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_02_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_02_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_03_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_03_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_04_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_04_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_05_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_05_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_06_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_06_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Zipline_01_Exit.LuaObjectScript.Disable()
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01()
      SetAmbience()
      UpdateWaterLevel()
    end,
    fn = function()
      LowerWater_Level01()
      SetAmbience()
      UpdateWaterLevel()
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      LowerWater_Level02()
      SetAmbience()
      UpdateWaterLevel()
    end,
    fn = function()
      LowerWater_Level02()
      SetAmbience()
      UpdateWaterLevel()
    end
  })
end
function LowerWater_Level01()
  GameObjects.Zipline_toBeach:HideTraverseLink()
  GameObjects.Climb_toLevel2:HideTraversePath()
  GameObjects.Climb_toLowerLedge:HideTraversePath()
  GameObjects.____atWaterLevel1:Show()
  GameObjects.____atWaterLevel1:ShowCollision()
  GameObjects.____atWaterLeve2:Hide()
  GameObjects.PrecisionChallenge_Raven_Perch:Hide()
end
function LowerWater_Level02()
  GameObjects.Zipline_toBeach:ShowTraverseLink()
  GameObjects.Climb_toLevel2:ShowTraversePath()
  GameObjects.Climb_toLowerLedge:ShowTraversePath()
  GameObjects.____atWaterLevel1:Hide()
  GameObjects.____atWaterLevel1:HideCollision()
  GameObjects.____atWaterLeve2:Show()
  GameObjects.FastTravel_IslandShipwreck.LuaObjectScript.UnlockFastTravelPoint()
  GameObjects.PrecisionChallenge_Raven_Perch:Show()
end
function Collected_Shipwreck_LoreScroll()
  game.Audio.SetBanterFact("HasShipwreckScroll", "True")
end
function Enable_CAforLakeofNine_Banter()
  GameObjects.LakeOfNineBanterCheckCave:ShowEntityVolume()
end
function Disable_CAforLakeofNine_Banter()
  BeaconLit = true
  GameObjects.LakeOfNineBanterCheckCave:HideEntityVolume()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter_Enter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 2 and lo9Banter02Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 3 and lo9Banter03Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
    end
  end
end
function QuestLakeOfNineBanter_Exit()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier2")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed01", true)
      elseif progress == 2 and lo9Banter02Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier3")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed02", true)
      elseif progress == 3 and lo9Banter03Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier4")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed03", true)
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier1")
      LD.SetEntityVariable("QST_UB_Lo9_BanterPlayed00", true)
    end
  end
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("IslandShipwreck")
  LD.CallFunctionAfterDelay(TrophyCheck, 1)
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function Destroy_EntryBlocker()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.EntryBlocker_01_Blocker_01)
    LD.BreakObject(GameObjects.EntryBlocker_01_Blocker_02)
    LD.BreakObject(GameObjects.EntryBlocker_01_Blocker_03)
    LD.BreakObject(GameObjects.EntryBlocker_01_Blocker_04)
    LD.BreakObject(GameObjects.EntryBlocker_01_Blocker_05)
  end, 0.1)
  GameObjects.EntryBlocker_Barrier:Hide()
  GameObjects.Lower_entrySplineZone:ShowEntityVolume()
end
function Destroy_GapBlocker()
  LD.BreakObject(GameObjects.GapBlocker_Blocker_02)
  LD.BreakObject(GameObjects.GapBlocker_Blocker_04)
  LD.BreakObject(GameObjects.GapBlocker_Blocker_06)
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.GapBlocker_Blocker_01)
    LD.BreakObject(GameObjects.GapBlocker_Blocker_03)
    LD.BreakObject(GameObjects.GapBlocker_Blocker_05)
    LD.BreakObject(GameObjects.GapBlocker_Blocker_07)
  end, 0.2)
  GameObjects.GapBlocker_Barrier:Hide()
  GameObjects.GapJump_fromZipline:ShowTraverseLink()
end
function Enable_GapBlocker_Bomb()
  local BombScratch = GameObjects.GapBlocker_01_Bomb
  local Bomb = BombScratch:FindSingleGOByName("bombBag")
  Bomb:ShowBehaviors()
  Bomb:ShowCollision()
end
function Disable_GapBlocker_Bomb()
  local BombScratch = GameObjects.GapBlocker_01_Bomb
  local Bomb = BombScratch:FindSingleGOByName("bombBag")
  Bomb:HideBehaviors()
  Bomb:HideCollision()
end
function Enable_BeachChest()
  LD.BreakObject(GameObjects.ExtraBombs_01)
  LD.BreakObject(GameObjects.ExtraBombs_02)
  LD.BreakObject(GameObjects.OnBeach_Blocks_01)
  LD.BreakObject(GameObjects.OnBeach_Blocks_02)
  LD.BreakObject(GameObjects.OnBeach_Blocks_03)
  LD.BreakObject(GameObjects.OnBeach_Blocks_04)
  LD.BreakObject(GameObjects.OnBeach_Blocks_05)
  LD.BreakObject(GameObjects.OnBeach_Blocks_06)
  LD.BreakObject(GameObjects.OnBeach_Blocks_07)
  GameObjects.BombsOnBeach_Barrier:Hide()
  GameObjects.coffin_tier3_xpl910_4.LuaObjectScript.Enable()
end
function Enable_CaveCoffin()
  LD.BreakObject(GameObjects.ScornStone_inCave_Blocker_01)
  LD.BreakObject(GameObjects.ScornStone_inCave_Blocker_02)
  LD.BreakObject(GameObjects.ScornStone_inCave_Blocker_03)
  LD.BreakObject(GameObjects.ScornStone_inCave)
  GameObjects.coffin_tier3_xpl910_2.LuaObjectScript.Enable()
end
function Enable_ClimbToUpperShip()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Blocker_atUpperShip_01)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_01)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_02)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_03)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_04)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_05)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_06)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_07)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_08)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_09)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_10)
    LD.BreakObject(GameObjects.Blocker_atUpperShip_11)
  end, 0.1)
  GameObjects.Climb_toUpperShip:ShowTraversePath()
  GameObjects.atUpperShip_Barrier:Hide()
end
function Enable_AtCrane()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Blocker_atCrane_01)
    LD.BreakObject(GameObjects.Blocker_atCrane_02)
    LD.BreakObject(GameObjects.Blocker_atCrane_03)
    LD.BreakObject(GameObjects.Blocker_atCrane_04)
    LD.BreakObject(GameObjects.Blocker_atCrane_05)
    LD.BreakObject(GameObjects.Blocker_atCrane_06)
    LD.BreakObject(GameObjects.Blocker_atCrane_07)
  end, 0.1)
  GameObjects.atCrane_Barrier:Hide()
  GameObjects.ArtifactShipHead_inUpperArena.LuaObjectScript.Enable()
end
function Trigger_GoodieBlocker_01()
  timer.StartLevelTimer(1.5, Destroy_GoodieBlocker_01)
end
function DelayedTrigger_GoodieBlocker_01()
  timer.StartLevelTimer(2, Destroy_GoodieBlocker_01)
end
function Destroy_GoodieBlocker_01()
  local BombScratch = GameObjects.ScornStone_Arena_Bomb_Hanging
  local Bomb = BombScratch:FindSingleGOByName("bombBag")
  if Bomb.Broken == false then
    Bomb:Break()
  end
  LD.BreakObject(GameObjects.ScornStone_Arena)
  LD.BreakObject(GameObjects.ScornStone_Arena_Bomb)
  GameObjects.coffin_tier3_xpl910_1.LuaObjectScript.Enable()
end
function IslandShip_DF_TurnOnZones()
  if game.Level.GetVariable("CAL_DeadFreightEncounters") == true and dfQuest910 == false then
    dfQuest910 = true
    GameObjects.EntZn_Arena_2_Encounter_Start:ShowEntityVolume()
    GameObjects.EntZn_Arena_4_Encounter_Fake:HideEntityVolume()
  end
end
function CA_UpperShipExit_Enable()
  GameObjects.CA_UpperShipExit.LuaObjectScript.Enable()
  GameObjects.CA_Climb_02_Exit.LuaObjectScript.Disable()
  GameObjects.CA_UpperShipExit_Zone:HideEntityVolume()
end
function CA_UpperShipExit_EnableTrigger()
  GameObjects.CA_UpperShipExit_Zone:ShowEntityVolume()
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    currentWaterLevel = currentWaterLevel,
    BeaconLit = BeaconLit,
    dfQuest910 = dfQuest910
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  currentWaterLevel = savedInfo.currentWaterLevel
  BeaconLit = savedInfo.BeaconLit
  dfQuest910 = savedInfo.dfQuest910
end
function UpdateWaterLevel()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if currentWaterLevel ~= newWaterLevel then
    currentWaterLevel = newWaterLevel
    if newWaterLevel < 2 then
      GameObjects.Zipline_toBeach:HideTraverseLink()
      GameObjects.Climb_toLevel2:HideTraversePath()
      GameObjects.Climb_toLowerLedge:HideTraversePath()
    elseif newWaterLevel == 2 then
      GameObjects.Zipline_toBeach:ShowTraverseLink()
      GameObjects.Climb_toLevel2:ShowTraversePath()
      GameObjects.Climb_toLowerLedge:ShowTraversePath()
    end
  end
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience, mediumWaterAmbienceNH, boatSRG, cave1SRG, cave2SRG
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  topWaterAmbience = GameObjects.TopWaterAmbience
  mediumWaterAmbienceNH = GameObjects.MediumWaterAmbienceNoHide
  boatSRG = GameObjects.SNDBoatCliffInterior910
  cave1SRG = GameObjects.SNDCaveOpenAirLP910_01
  cave2SRG = GameObjects.SNDCaveOpenAirLP910_02
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
    mediumWaterAmbienceNH:Show()
    boatSRG:Show()
    cave1SRG:Show()
    cave2SRG:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
    mediumWaterAmbienceNH:Show()
    boatSRG:Show()
    cave1SRG:Show()
    cave2SRG:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
    mediumWaterAmbienceNH:Hide()
    boatSRG:Hide()
    cave1SRG:Hide()
    cave2SRG:Hide()
  end
  print(topWaterAmbience)
  print(mediumWaterAmbience)
  print(bottomWaterAmbience)
  print(mediumWaterAmbienceNH)
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
  mediumWaterAmbienceNH:Hide()
end
local xpl910Mus = false
function xpl910EnterMus()
  if xpl910Mus == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL910_explore1_in")
    xpl910Mus = true
  end
end
function xpl910FastTravelMus()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL910_explore1_in")
  xpl910Mus = true
end
function xpl910ExitMus()
  if xpl910Mus == true then
    game.Audio.StartMusic("SND_MX_XPL910_idle")
    xpl910Mus = false
  end
end
