local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timers = require("level.timer")
local thisLevel, son
local uiCalls = require("ui.uicalls")
local Area_0_Encounter_1, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, Area_1_Encounter_4, Area_1_Encounter_5, Area_1_Encounter_6, Area_1_Encounter_7, Area_1_Encounter_8, Area_1_Encounter_9
local Rift_Challenge_Duration = 10
local Challenge_Started = false
local ecTimer, ec_TimeRequirement, hudTimeRemaining
local delayDestruction = false
local delayDestruction_T = {}
function OnUpdate(level)
  UpdateCreatureDestruction()
  if Challenge_Started then
    Encounter_Timer()
  end
end
function OnScriptLoaded(level, obj)
  thisLevel = level
  son = game.AI.FindSon()
  if game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_0_Fight_1()
    Area_1_Fight_1()
    Area_1_Fight_2()
    Area_1_Fight_3()
    Area_1_Fight_4()
    Area_1_Fight_5()
    if game.GetNewGamePlus() then
      New_Game_Plus_Area_1_Fight_6()
    else
      Area_1_Fight_6()
    end
    Area_1_Fight_7()
    Area_1_Fight_8_Repop()
    Area_1_Fight_9()
  end
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") >= 340 then
    if Area_1_Encounter_1:WasRunning() then
      Area_1_Encounter_1:Start()
    end
    if Area_1_Encounter_3:WasRunning() then
      Area_1_Encounter_3:Start()
    end
    if Area_1_Encounter_4:WasRunning() then
      Area_1_Encounter_4:Start()
    end
    if Area_1_Encounter_5:WasRunning() then
      Area_1_Encounter_5:Start()
    end
    if Area_1_Encounter_6:WasRunning() then
      Area_1_Encounter_6:Start()
    end
    if Area_1_Encounter_7:WasRunning() then
      Area_1_Encounter_7:Start()
    end
  end
end
function Area_0_Fight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC: Fake Fanatics Patrol XPL920", {CheckpointOnComplete = false, LoadCheck = false})
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Fanatic_F_Patrol_01",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_F_Patrol_02",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_F_Patrol_03",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "JOTUNN_CAGE",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_0_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_Fake_1)
end
function Area0DespawnZoneTriggered()
  Area_0_Encounter_1:DespawnEnemies()
  Area_0_Encounter_1:SetComplete()
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC: Beach Fight Jotunn XPL920", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl920_1",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL920_beach_fight_in",
    StopMusic = "SND_MX_XPL920_beach_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "JOTUNN_EAT",
      spawnLocators = "A1_O_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_1)
  Area_1_Encounter_1:OnStart(function()
    son:CallScript("EnterBehaviorContext", "ALERT_BEHAVIOR_CONTEXT_CONFIG")
  end)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ogre_Charger")
  end)
end
function GetArea1_Encounter()
  return Area_1_Encounter_1
end
function Area_1_Fight_7()
  Area_1_Encounter_7 = EC.NewEncounter(thisLevel, "[Area 0]EC: Beach Fight Turrets XPL920", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl920_3",
    LoadCheck = false,
    StartMusic = "SND_MX_XPL920_beach_fight_in",
    StopMusic = "SND_MX_XPL920_beach_fight_out"
  })
  Area_1_Encounter_7:AddWave({
    {
      spawners = "Fanatic_TURRET",
      spawnLocators = "A1_U_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.6
    },
    {
      spawners = "Fanatic_SFG",
      spawnLocators = "A1_R_Loc_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Fanatic_SFG",
      spawnLocators = "A1_R_Loc_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    }
  })
  Area_1_Encounter_7:SetStartZone(GameObjects.EntZn_Arena_Spawn_7)
  Area_1_Encounter_7:OnComplete(xpl920MusicVariable)
  Area_1_Encounter_7:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Fanatic_Bomber")
  end)
  Area_1_Encounter_7:OnComplete(Area_1_Encounter_7_Complete)
end
function Area_1_Encounter_7_Complete()
  son:CallScript("EnterBehaviorContext", "ClearBehaviorContext")
end
function Area_1_Fight_8_Repop()
  Area_1_Encounter_8 = EC.NewEncounter(thisLevel, "[Area 0]EC: Beach Bandit Helwalker Repopulation XPL920", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl920_3",
    LoadCheck = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 0]EC: Beach Fight Jotunn XPL920",
      "[Area 0]EC: Fanatic Light Bridge 2 Fight XPL920"
    }
  })
  Area_1_Encounter_8:AddWave({
    {
      spawners = "SH_Bandit_7_Spawn_7",
      spawnLocators = "A1_O_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "SH_Bandit_8_Spawn_8",
      spawnLocators = "A1_O_Loc_07",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "H_Bandit_L7_SSA",
      spawnLocators = "A1_O_Loc_06",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_1_Encounter_8:SetStartZone(GameObjects.EntZn_Arena_Spawn_Repop_1)
end
function StartFightBrawler()
  timers.StartLevelTimer(3, function()
    Area_1_Encounter_2:Start()
  end)
  timers.StartLevelTimer(4, function()
    GameObjects.LootPocketRift920.LuaObjectScript.SpawningDone()
  end)
end
function PlaySoundEnemySpawnFightBrawler()
  GameObjects.LootPocketRift920.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function TurnOn920Rift2Marker()
  LD.SetMarkerState("CAL_100_IslClimbFight2", 1)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 0]EC: Brawler Surprise Fight XPL920", {
    CheckpointOnComplete = true,
    LoadCheck = false,
    StartMusic = "SND_MX_XPL920_rift_fight_in",
    StopMusic = "SND_MX_XPL920_rift_fight_out"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "BRAWLER_L4_SURPRISE",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_Spawn_2)
end
function Area_1_Fight_3()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 0]EC: Fanatic Light Bridge 1 Fight XPL920", {CheckpointOnComplete = true, LoadCheck = false})
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Fanatic_SFG",
      spawnLocators = "A3_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_SFG",
      spawnLocators = "A3_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_1_Encounter_3:SetStartZone(GameObjects.EntZn_Arena_Spawn_3)
end
function Area_1_Fight_4()
  Area_1_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 0]EC: Fanatic Light Bridge 2 Fight XPL920", {CheckpointOnComplete = true, LoadCheck = false})
  Area_1_Encounter_4:AddWave({
    {
      spawners = "Fanatic_SFG",
      spawnLocators = "A4_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_SFG",
      spawnLocators = "A4_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_1_Encounter_4:SetStartZone(GameObjects.EntZn_Arena_Spawn_4)
  Area_1_Encounter_4:OnComplete(Area_1_Encounter_4_Complete)
end
function Area_1_Encounter_4_Complete()
  GameObjects.CA_InvestigateCrystal_04.LuaObjectScript.Enable()
end
function Area_1_Fight_5()
  Area_1_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 0]EC: Fanatics Upper Area Fight XPL920", {
    CheckpointOnComplete = true,
    LoadCheck = false,
    LeashZone = "LeashZoneXpl920_2"
  })
  Area_1_Encounter_5:AddWave({
    {
      spawners = "Fanatic_PT_SFG",
      spawnLocators = "A5_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "Fanatic_PT_SFG",
      spawnLocators = "A5_O_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.7
    }
  })
  Area_1_Encounter_5:SetStartZone(GameObjects.EntZn_Arena_Spawn_5)
end
function Area_1_Fight_9()
  Area_1_Encounter_9 = EC.NewEncounter(thisLevel, "[Area 0]EC: Shield Seidr Upper Area Fight XPL920", {CheckpointOnComplete = false, LoadCheck = false})
  Area_1_Encounter_9:AddWave({
    {
      spawners = "SH_Bandit_3_Spawn_1",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "SH_Bandit_2_Spawn_2",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_1_Encounter_9:OnStart(function()
    GameObjects.CA_Level04_Turret.LuaObjectScript.Enable()
  end)
  Area_1_Encounter_9:OnComplete(function()
    GameObjects.CA_Level04_Turret.LuaObjectScript.Disable()
  end)
  Area_1_Encounter_9:SetStartZone(GameObjects.EntZn_Arena_Spawn_5)
end
function Start920TowerRift()
  timers.StartLevelTimer(3, function()
    Area_1_Encounter_6:Start()
  end)
  timers.StartLevelTimer(8, function()
    GameObjects.PocketRift_Loot.LuaObjectScript.SpawningDone()
  end)
end
function Stop920TowerRift()
  local xpl920 = game.FindLevel("Xpl920_IslandClimb")
  xpl920:CallScript("SetFightVarComplete")
  GameObjects.PocketRift_Loot.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawn920TowerRift()
  GameObjects.PocketRift_Loot.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function Area_1_Fight_6()
  Area_1_Encounter_6 = EC.NewEncounter(thisLevel, "[Area 0]EC: Shield Helwalkers Final Rift Fight XPL920", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL920_rift2_fight_in",
    StopMusic = "SND_MX_XPL920_rift2_fight_out"
  })
  Area_1_Encounter_6:AddWave({
    {
      spawners = "SH_Bandit_3_Spawn_3",
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "BRAWLER_L7_RIFT",
      spawnLocators = "A2_O_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "BRAWLER_L7_RIFT",
      spawnLocators = "A5_O_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.4
    }
  })
  Area_1_Encounter_6:OnComplete(Stop920TowerRift)
  Area_1_Encounter_6:OnEnemySpawn(PlaySoundEnemySpawn920TowerRift)
  Area_1_Encounter_6:OnComplete(function()
    LD.SetMarkerState("CAL_100_IslClimbFight2", 0)
  end)
  Area_1_Encounter_6:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Brawler")
  end)
end
function New_Game_Plus_Area_1_Fight_6()
  Area_1_Encounter_6 = EC.NewEncounter(thisLevel, "[Area 0]EC: NPlus Shield Helwalkers Final Rift Fight XPL920", {
    CheckpointOnComplete = true,
    LoadCheck = true,
    StartMusic = "SND_MX_XPL920_rift2_fight_in",
    StopMusic = "SND_MX_XPL920_rift2_fight_out"
  })
  Area_1_Encounter_6:AddWave({
    {
      spawners = "SH_Bandit_3_Spawn_3",
      spawnWad = "Xpl920_AI_02",
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0
    },
    {
      spawners = "BRAWLER_L7_RIFT",
      spawnLocators = "A2_O_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "BRAWLER_L7_RIFT",
      spawnLocators = "A5_O_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl920_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.4
    }
  })
  Area_1_Encounter_6:OnStart(function()
    Set_Encounter_Timer(60, Area_1_Encounter_6)
    Start_Timer()
  end)
  Area_1_Encounter_6:OnComplete(Event_Complete)
  Area_1_Encounter_6:OnComplete(Stop920TowerRift)
  Area_1_Encounter_6:OnEnemySpawn(PlaySoundEnemySpawn920TowerRift)
  Area_1_Encounter_6:OnComplete(function()
    LD.SetMarkerState("CAL_100_IslClimbFight2", 0)
  end)
  Area_1_Encounter_6:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Brawler")
  end)
end
function xpl920MusicVariable()
  local xpl920
  xpl920 = game.FindLevel("Xpl920_IslandClimb")
  xpl920:CallScript("xpl920MusVarChange")
end
function Set_Encounter_Timer(timeRequirement, encounter)
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, function()
    EventFailed_TimeElapsed(encounter)
  end)
  ecTimer:Stop()
end
function Start_Timer()
  local startDelay = 1
  Challenge_Started = true
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = ec_TimeRequirement % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function Encounter_Timer()
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = hudTimeRemaining % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37906, {minutes, seconds})
end
function EventFailed_TimeElapsed(encounter)
  local seconds = Rift_Challenge_Duration % 60
  local minutes = Rift_Challenge_Duration / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.DisableMechanicText()
  Despawn_Enemy_VFX(encounter)
  encounter:Reset()
  encounter:Stop()
  ResetRift_Callback(encounter)
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Event_Complete()
  uiCalls.DisableMechanicText()
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Despawn_Enemy_VFX(encounter)
  local minTime = 0.01
  local maxTime = 0.3
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies = encounter:GetActiveEnemies()
  for _, enemy in pairs(enemies) do
    if enemy ~= nil and enemy:IsDoingSyncMove() == false then
      timers.StartLevelTimer(randomFn(), function()
        if enemy ~= nil then
          SpawnFXAtCreatureLocation(enemy)
          enemy:Destroy()
        end
      end)
      CreatureInSyncMove_DelayDestruction(enemy)
    end
  end
  encounter:ResetLivingEnemiesCount()
  encounter:ReportWaveDespawned(nil)
end
function SpawnFXAtCreatureLocation(creature)
  local fx = game.FX.Spawn("Body_Fire_Explode", nil, {
    AutoDelete = true,
    EffectCreator = creature,
    Scale = 1.5
  })
  local lastEnemyPos = creature:GetWorldJointPosition(creature:GetJointIndex("JOPelvis1"))
  fx:SetWorldPosition(lastEnemyPos)
end
function CreatureInSyncMove_DelayDestruction(creature)
  delayDestruction = true
  delayDestruction_T[creature] = true
end
function UpdateCreatureDestruction()
  if delayDestruction == true then
    local remaining = 0
    for creature, _ in pairs(delayDestruction_T) do
      if creature ~= nil and delayDestruction_T[creature] == true then
        if creature:IsDoingSyncMove() == false then
          SpawnFXAtCreatureLocation(creature)
          creature:Destroy()
          delayDestruction_T[creature] = nil
        else
          remaining = remaining + 1
        end
      end
    end
    if remaining == 0 then
      delayDestruction = false
      delayDestruction_T = {}
    end
  end
end
function ResetRift_Callback(encounter)
  GameObjects.PocketRift_Loot.LuaObjectScript.ResetCombatState()
end
