local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local LitCrystalCount = 0
local CarryCrystalLit = false
local BridgeOn_02_Active = false
local BridgeOn_06_Active = false
local legendaryChestLooted = false
local observeGateTriggered = false
local riftFight920Complete = false
function PocketRift_CrystalLit()
  LitCrystalCount = LitCrystalCount + 1
  if LitCrystalCount == 3 and riftFight920Complete == false then
    GameObjects.PocketRift_Loot.LuaObjectScript.Enable()
    GameObjects.Stim_PocketRift.LuaObjectScript.Trigger()
    GameObjects.CA_PocketRiftAlert.LuaObjectScript.Enable()
    LD.SetMarkerState("CAL_100_IslClimbFight2", 1)
    game.World.StoreCheckpoint()
  else
    LD.SetMarkerState("CAL_100_IslClimbFight2", 0)
  end
end
function OnScriptLoaded(level)
  SoundInit()
end
function OnFirstStart(level)
  SetAmbience()
  GameObjects.Jump_CoL07:Show()
  GameObjects.Jump_CoL05:Show()
  GameObjects.Jump_CoL04:Show()
  GameObjects.Jump_CoL03:Show()
  GameObjects.Jump_CoL01:Show()
  GameObjects.PocketRift_Loot.LuaObjectScript.Disable()
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level01()
      SetAmbience()
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      LowerWater_Level02()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level02()
      SetAmbience()
    end
  })
  SoundOnStart()
  GameObjects.LiftDoor_Gate_StaysOpen4.LuaObjectScript.ExcludeSon()
  GameObjects.LiftDoor_Gate_StaysOpen3.LuaObjectScript.ExcludeSon()
  GameObjects.LiftDoor_Gate_StaysOpen2.LuaObjectScript.ExcludeSon()
end
function SetFightVarComplete()
  riftFight920Complete = true
end
function LowerWater_Level01()
  GameObjects.xpl920_Blockingrocks_Lvl01:Show()
  GameObjects.TraversePath17:HideTraversePath()
  GameObjects.BifrostTemporal_Intact_xx_00_xx.LuaObjectScript.Disable()
  GameObjects.BifrostTemporal_Intact_xx_02_xx.LuaObjectScript.Disable()
  game.Compass.SetGatewayMarkerIsOpen("IC_920_Helpervv", true)
end
function LowerWater_Level02()
  GameObjects.xpl920_Blockingrocks_Lvl01:Hide()
  GameObjects.TraversePath17:ShowTraversePath()
  GameObjects.BifrostTemporal_Intact_xx_00_xx.LuaObjectScript.Enable()
  GameObjects.BifrostTemporal_Intact_xx_02_xx.LuaObjectScript.Enable()
  game.Compass.SetGatewayMarkerIsOpen("IC_920_Helpervv", false)
end
function Check_Bridge_06()
  if BridgeOn_06_Active == false then
    GameObjects.CA_Bridge_06_LedgeRun.LuaObjectScript.Enable()
  end
end
function Check_Bridge_02()
  if BridgeOn_02_Active == false then
    GameObjects.CA_InvestigateCrystal_04.LuaObjectScript.Enable()
  end
end
function Toggle_Bridge_02()
  if BridgeOn_02_Active == false then
    BridgeOn_02_Active = true
  end
end
function EnableLGDChestCA()
  if legendaryChestLooted == false then
    GameObjects.CA_Observe_Forward_03.LuaObjectScript.Enable()
  end
end
function DisableFakeCA()
end
function EnableFakeCA()
end
function LightBridge_01_CheckpointComplete()
  game.World.StoreCheckpoint()
end
function Jump_CoL01_Hide()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Jump_CoL01:Hide()
  end, 1)
  BridgeOn_06_Active = true
end
function Jump_CoL03_Hide()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Jump_CoL03:Hide()
  end, 1)
end
function Jump_CoL03_Show()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Jump_CoL03:Show()
  end, 1)
end
function Jump_CoL04_Hide()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Jump_CoL04:Hide()
  end, 1)
end
function Jump_CoL05_Hide()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Jump_CoL05:Hide()
  end, 1)
end
function Jump_CoL07_Hide()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Jump_CoL07:Hide()
  end, 1)
end
function Nav_Jump01_Hide()
  GameObjects.Nav_Jump01:Hide()
end
function Nav_Jump01_Show()
  GameObjects.Nav_Jump01:Show()
end
function AreaAnnounce_IslandClimb()
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_DiscoverLocation("IslandClimb")
  LD.CallFunctionAfterDelay(TrophyCheck, 1)
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function Traversal_Path_Hide_WaterLvL_01_Show()
  GameObjects.Traversal_Path_Hide_WaterLvL_01:Show()
end
function Enable_Observe_Gate()
  if observeGateTriggered == false then
    GameObjects.CA_Observe_Forward_Gate.LuaObjectScript.Enable()
    observeGateTriggered = true
  end
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  topWaterAmbience = GameObjects.TopWaterAmbience
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    LitCrystalCount = LitCrystalCount,
    CarryCrystalLit = CarryCrystalLit,
    BridgeOn_06_Active = BridgeOn_06_Active,
    observeGateTriggered = observeGateTriggered,
    riftFight920Complete = riftFight920Complete,
    xpl920Music = xpl920Music
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  LitCrystalCount = savedInfo.LitCrystalCount
  CarryCrystalLit = savedInfo.CarryCrystalLit
  BridgeOn_06_Active = savedInfo.BridgeOn_06_Active
  observeGateTriggered = savedInfo.observeGateTriggered
  local riftsRegionComplete = game.QuestManager.GetQuestState("RegionSummary_ICL_PocketRift_Parent") == "Complete"
  riftFight920Complete = savedInfo.riftFight920Complete or riftsRegionComplete
  xpl920Music = savedInfo.xpl920Music
  if xpl920Music == true then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL920_explore1_in")
  end
end
xpl920Music = false
local chainCrankGateOverrides = {
  OnStart = "SND_DOOR_Gate_Metal_Lift_Start",
  OnForward = "SND_DOOR_Gate_Metal_Lift_Scrape_LP",
  OnBackward = "SND_DOOR_Gate_Metal_Lift_Scrape_LP",
  OnFastForward = "SND_DOOR_Gate_Metal_Lift_Scrape_LP",
  OnRewind = "SND_DOOR_Gate_Metal_Lift_Scrape_LP"
}
function SoundOnStart()
  GameObjects.ChainPullOfficial_xx01.Child.LuaObjectScript.DrivenObjectSoundSetup(chainCrankGateOverrides)
end
function xpl920MusVarChange()
  xpl920Music = true
end
function xpl920ExitMusic()
  if xpl920Music == true then
    game.Audio.StartMusic("SND_MX_XPL920_idle")
    xpl920Music = false
  end
end
