local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, Area_0_Encounter_1, A0_ZM_1, Golem
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_0_Fight_1()
  end
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") >= 340 and Area_0_Encounter_1:WasRunning() then
    Area_0_Encounter_1:Start()
  end
end
function Area_0_Fight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC: Golem Fight XPL930", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl930",
    LoadCheck = false,
    StartMusic = "SND_MX_XPL930_golem_fight_in",
    StopMusic = "SND_MX_XPL930_golem_fight_out"
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Golem_PATROL",
      spawnLocators = "A0_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl930_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_0_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_0)
  Area_0_Encounter_1:OnStart(function()
    LD.SetMarkerState("CAL_100_BeachRuinsFight", 1)
  end)
  Area_0_Encounter_1:OnComplete(function()
    LD.SetMarkerState("CAL_100_BeachRuinsFight", 0)
  end)
  Area_0_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_DarkSoulEater")
  end)
  Area_0_Encounter_1:OnComplete(Area_0_Encounter_1_Complete)
  Area_0_Encounter_1:OnEnemySpawn(storeGolemReference)
  Area_0_Encounter_1:OnEnemyDeath(function()
    Golem = nil
  end)
end
function storeGolemReference(enemy)
  Golem = enemy
  print(Golem)
end
function GetGolem()
  return Golem
end
function Area_0_Encounter_1_Complete()
  GameObjects.LTW_AvoidGolem.LuaObjectScript.Disable()
  GameObjects.CA_Golem_OnAlert.LuaObjectScript.Disable()
end
